/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetGroupAssetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ASSET_GROUP_ID_ASSET_ID_FIELD_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/assetGroupAssets/{asset_group_id}~{asset_id}~{field_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String assetGroupId;
    private final String assetId;
    private final String fieldType;

    @Deprecated
    protected AssetGroupAssetName() {
        this.customerId = null;
        this.assetGroupId = null;
        this.assetId = null;
        this.fieldType = null;
    }

    private AssetGroupAssetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.assetGroupId = (String)Preconditions.checkNotNull((Object)builder.getAssetGroupId());
        this.assetId = (String)Preconditions.checkNotNull((Object)builder.getAssetId());
        this.fieldType = (String)Preconditions.checkNotNull((Object)builder.getFieldType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAssetGroupId() {
        return this.assetGroupId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetGroupAssetName of(String customerId, String assetGroupId, String assetId, String fieldType) {
        return AssetGroupAssetName.newBuilder().setCustomerId(customerId).setAssetGroupId(assetGroupId).setAssetId(assetId).setFieldType(fieldType).build();
    }

    public static String format(String customerId, String assetGroupId, String assetId, String fieldType) {
        return AssetGroupAssetName.newBuilder().setCustomerId(customerId).setAssetGroupId(assetGroupId).setAssetId(assetId).setFieldType(fieldType).build().toString();
    }

    public static AssetGroupAssetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ASSET_GROUP_ID_ASSET_ID_FIELD_TYPE.validatedMatch(formattedString, "AssetGroupAssetName.parse: formattedString not in valid format");
        return AssetGroupAssetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("asset_group_id"), (String)matchMap.get("asset_id"), (String)matchMap.get("field_type"));
    }

    public static List<AssetGroupAssetName> parseList(List<String> formattedStrings) {
        ArrayList<AssetGroupAssetName> list = new ArrayList<AssetGroupAssetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetGroupAssetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetGroupAssetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetGroupAssetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ASSET_GROUP_ID_ASSET_ID_FIELD_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetGroupAssetName assetGroupAssetName = this;
            synchronized (assetGroupAssetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.assetGroupId != null) {
                        fieldMapBuilder.put((Object)"asset_group_id", (Object)this.assetGroupId);
                    }
                    if (this.assetId != null) {
                        fieldMapBuilder.put((Object)"asset_id", (Object)this.assetId);
                    }
                    if (this.fieldType != null) {
                        fieldMapBuilder.put((Object)"field_type", (Object)this.fieldType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ASSET_GROUP_ID_ASSET_ID_FIELD_TYPE.instantiate(new String[]{"customer_id", this.customerId, "asset_group_id", this.assetGroupId, "asset_id", this.assetId, "field_type", this.fieldType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AssetGroupAssetName that = (AssetGroupAssetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.assetGroupId, that.assetGroupId) && Objects.equals(this.assetId, that.assetId) && Objects.equals(this.fieldType, that.fieldType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetGroupId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.fieldType);
    }

    public static class Builder {
        private String customerId;
        private String assetGroupId;
        private String assetId;
        private String fieldType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAssetGroupId() {
            return this.assetGroupId;
        }

        public String getAssetId() {
            return this.assetId;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAssetGroupId(String assetGroupId) {
            this.assetGroupId = assetGroupId;
            return this;
        }

        public Builder setAssetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder setFieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        private Builder(AssetGroupAssetName assetGroupAssetName) {
            this.customerId = assetGroupAssetName.customerId;
            this.assetGroupId = assetGroupAssetName.assetGroupId;
            this.assetId = assetGroupAssetName.assetId;
            this.fieldType = assetGroupAssetName.fieldType;
        }

        public AssetGroupAssetName build() {
            return new AssetGroupAssetName(this);
        }
    }
}

