/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetSetTypeViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ASSET_SET_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/assetSetTypeViews/{asset_set_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String assetSetType;

    @Deprecated
    protected AssetSetTypeViewName() {
        this.customerId = null;
        this.assetSetType = null;
    }

    private AssetSetTypeViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.assetSetType = (String)Preconditions.checkNotNull((Object)builder.getAssetSetType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAssetSetType() {
        return this.assetSetType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetSetTypeViewName of(String customerId, String assetSetType) {
        return AssetSetTypeViewName.newBuilder().setCustomerId(customerId).setAssetSetType(assetSetType).build();
    }

    public static String format(String customerId, String assetSetType) {
        return AssetSetTypeViewName.newBuilder().setCustomerId(customerId).setAssetSetType(assetSetType).build().toString();
    }

    public static AssetSetTypeViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ASSET_SET_TYPE.validatedMatch(formattedString, "AssetSetTypeViewName.parse: formattedString not in valid format");
        return AssetSetTypeViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("asset_set_type"));
    }

    public static List<AssetSetTypeViewName> parseList(List<String> formattedStrings) {
        ArrayList<AssetSetTypeViewName> list = new ArrayList<AssetSetTypeViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetSetTypeViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetSetTypeViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetSetTypeViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ASSET_SET_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetSetTypeViewName assetSetTypeViewName = this;
            synchronized (assetSetTypeViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.assetSetType != null) {
                        fieldMapBuilder.put((Object)"asset_set_type", (Object)this.assetSetType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ASSET_SET_TYPE.instantiate(new String[]{"customer_id", this.customerId, "asset_set_type", this.assetSetType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AssetSetTypeViewName that = (AssetSetTypeViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.assetSetType, that.assetSetType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assetSetType);
    }

    public static class Builder {
        private String customerId;
        private String assetSetType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAssetSetType() {
            return this.assetSetType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAssetSetType(String assetSetType) {
            this.assetSetType = assetSetType;
            return this;
        }

        private Builder(AssetSetTypeViewName assetSetTypeViewName) {
            this.customerId = assetSetTypeViewName.customerId;
            this.assetSetType = assetSetTypeViewName.assetSetType;
        }

        public AssetSetTypeViewName build() {
            return new AssetSetTypeViewName(this);
        }
    }
}

