/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.resources;

import com.google.ads.googleads.v17.common.PolicyTopicEntry;
import com.google.ads.googleads.v17.common.PolicyTopicEntryOrBuilder;
import com.google.ads.googleads.v17.enums.FeedItemQualityApprovalStatusEnum;
import com.google.ads.googleads.v17.enums.FeedItemQualityDisapprovalReasonEnum;
import com.google.ads.googleads.v17.enums.FeedItemValidationStatusEnum;
import com.google.ads.googleads.v17.enums.PlaceholderTypeEnum;
import com.google.ads.googleads.v17.enums.PolicyApprovalStatusEnum;
import com.google.ads.googleads.v17.enums.PolicyReviewStatusEnum;
import com.google.ads.googleads.v17.resources.FeedItemPlaceholderPolicyInfoOrBuilder;
import com.google.ads.googleads.v17.resources.FeedItemProto;
import com.google.ads.googleads.v17.resources.FeedItemValidationError;
import com.google.ads.googleads.v17.resources.FeedItemValidationErrorOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FeedItemPlaceholderPolicyInfo
extends GeneratedMessageV3
implements FeedItemPlaceholderPolicyInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int PLACEHOLDER_TYPE_ENUM_FIELD_NUMBER = 10;
    private int placeholderTypeEnum_ = 0;
    public static final int FEED_MAPPING_RESOURCE_NAME_FIELD_NUMBER = 11;
    private volatile Object feedMappingResourceName_ = "";
    public static final int REVIEW_STATUS_FIELD_NUMBER = 3;
    private int reviewStatus_ = 0;
    public static final int APPROVAL_STATUS_FIELD_NUMBER = 4;
    private int approvalStatus_ = 0;
    public static final int POLICY_TOPIC_ENTRIES_FIELD_NUMBER = 5;
    private List<PolicyTopicEntry> policyTopicEntries_;
    public static final int VALIDATION_STATUS_FIELD_NUMBER = 6;
    private int validationStatus_ = 0;
    public static final int VALIDATION_ERRORS_FIELD_NUMBER = 7;
    private List<FeedItemValidationError> validationErrors_;
    public static final int QUALITY_APPROVAL_STATUS_FIELD_NUMBER = 8;
    private int qualityApprovalStatus_ = 0;
    public static final int QUALITY_DISAPPROVAL_REASONS_FIELD_NUMBER = 9;
    private List<Integer> qualityDisapprovalReasons_;
    private static final Internal.ListAdapter.Converter<Integer, FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason> qualityDisapprovalReasons_converter_ = new Internal.ListAdapter.Converter<Integer, FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason>(){

        public FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason convert(Integer from) {
            FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason result = FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason.forNumber(from);
            return result == null ? FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason.UNRECOGNIZED : result;
        }
    };
    private int qualityDisapprovalReasonsMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final FeedItemPlaceholderPolicyInfo DEFAULT_INSTANCE = new FeedItemPlaceholderPolicyInfo();
    private static final Parser<FeedItemPlaceholderPolicyInfo> PARSER = new AbstractParser<FeedItemPlaceholderPolicyInfo>(){

        public FeedItemPlaceholderPolicyInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = FeedItemPlaceholderPolicyInfo.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private FeedItemPlaceholderPolicyInfo(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private FeedItemPlaceholderPolicyInfo() {
        this.placeholderTypeEnum_ = 0;
        this.feedMappingResourceName_ = "";
        this.reviewStatus_ = 0;
        this.approvalStatus_ = 0;
        this.policyTopicEntries_ = Collections.emptyList();
        this.validationStatus_ = 0;
        this.validationErrors_ = Collections.emptyList();
        this.qualityApprovalStatus_ = 0;
        this.qualityDisapprovalReasons_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new FeedItemPlaceholderPolicyInfo();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return FeedItemProto.internal_static_google_ads_googleads_v17_resources_FeedItemPlaceholderPolicyInfo_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return FeedItemProto.internal_static_google_ads_googleads_v17_resources_FeedItemPlaceholderPolicyInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(FeedItemPlaceholderPolicyInfo.class, Builder.class);
    }

    @Override
    public int getPlaceholderTypeEnumValue() {
        return this.placeholderTypeEnum_;
    }

    @Override
    public PlaceholderTypeEnum.PlaceholderType getPlaceholderTypeEnum() {
        PlaceholderTypeEnum.PlaceholderType result = PlaceholderTypeEnum.PlaceholderType.forNumber(this.placeholderTypeEnum_);
        return result == null ? PlaceholderTypeEnum.PlaceholderType.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasFeedMappingResourceName() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getFeedMappingResourceName() {
        Object ref = this.feedMappingResourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.feedMappingResourceName_ = s;
        return s;
    }

    @Override
    public ByteString getFeedMappingResourceNameBytes() {
        Object ref = this.feedMappingResourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.feedMappingResourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getReviewStatusValue() {
        return this.reviewStatus_;
    }

    @Override
    public PolicyReviewStatusEnum.PolicyReviewStatus getReviewStatus() {
        PolicyReviewStatusEnum.PolicyReviewStatus result = PolicyReviewStatusEnum.PolicyReviewStatus.forNumber(this.reviewStatus_);
        return result == null ? PolicyReviewStatusEnum.PolicyReviewStatus.UNRECOGNIZED : result;
    }

    @Override
    public int getApprovalStatusValue() {
        return this.approvalStatus_;
    }

    @Override
    public PolicyApprovalStatusEnum.PolicyApprovalStatus getApprovalStatus() {
        PolicyApprovalStatusEnum.PolicyApprovalStatus result = PolicyApprovalStatusEnum.PolicyApprovalStatus.forNumber(this.approvalStatus_);
        return result == null ? PolicyApprovalStatusEnum.PolicyApprovalStatus.UNRECOGNIZED : result;
    }

    @Override
    public List<PolicyTopicEntry> getPolicyTopicEntriesList() {
        return this.policyTopicEntries_;
    }

    @Override
    public List<? extends PolicyTopicEntryOrBuilder> getPolicyTopicEntriesOrBuilderList() {
        return this.policyTopicEntries_;
    }

    @Override
    public int getPolicyTopicEntriesCount() {
        return this.policyTopicEntries_.size();
    }

    @Override
    public PolicyTopicEntry getPolicyTopicEntries(int index) {
        return this.policyTopicEntries_.get(index);
    }

    @Override
    public PolicyTopicEntryOrBuilder getPolicyTopicEntriesOrBuilder(int index) {
        return this.policyTopicEntries_.get(index);
    }

    @Override
    public int getValidationStatusValue() {
        return this.validationStatus_;
    }

    @Override
    public FeedItemValidationStatusEnum.FeedItemValidationStatus getValidationStatus() {
        FeedItemValidationStatusEnum.FeedItemValidationStatus result = FeedItemValidationStatusEnum.FeedItemValidationStatus.forNumber(this.validationStatus_);
        return result == null ? FeedItemValidationStatusEnum.FeedItemValidationStatus.UNRECOGNIZED : result;
    }

    @Override
    public List<FeedItemValidationError> getValidationErrorsList() {
        return this.validationErrors_;
    }

    @Override
    public List<? extends FeedItemValidationErrorOrBuilder> getValidationErrorsOrBuilderList() {
        return this.validationErrors_;
    }

    @Override
    public int getValidationErrorsCount() {
        return this.validationErrors_.size();
    }

    @Override
    public FeedItemValidationError getValidationErrors(int index) {
        return this.validationErrors_.get(index);
    }

    @Override
    public FeedItemValidationErrorOrBuilder getValidationErrorsOrBuilder(int index) {
        return this.validationErrors_.get(index);
    }

    @Override
    public int getQualityApprovalStatusValue() {
        return this.qualityApprovalStatus_;
    }

    @Override
    public FeedItemQualityApprovalStatusEnum.FeedItemQualityApprovalStatus getQualityApprovalStatus() {
        FeedItemQualityApprovalStatusEnum.FeedItemQualityApprovalStatus result = FeedItemQualityApprovalStatusEnum.FeedItemQualityApprovalStatus.forNumber(this.qualityApprovalStatus_);
        return result == null ? FeedItemQualityApprovalStatusEnum.FeedItemQualityApprovalStatus.UNRECOGNIZED : result;
    }

    @Override
    public List<FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason> getQualityDisapprovalReasonsList() {
        return new Internal.ListAdapter(this.qualityDisapprovalReasons_, qualityDisapprovalReasons_converter_);
    }

    @Override
    public int getQualityDisapprovalReasonsCount() {
        return this.qualityDisapprovalReasons_.size();
    }

    @Override
    public FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason getQualityDisapprovalReasons(int index) {
        return (FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason)((Object)qualityDisapprovalReasons_converter_.convert((Object)this.qualityDisapprovalReasons_.get(index)));
    }

    @Override
    public List<Integer> getQualityDisapprovalReasonsValueList() {
        return this.qualityDisapprovalReasons_;
    }

    @Override
    public int getQualityDisapprovalReasonsValue(int index) {
        return this.qualityDisapprovalReasons_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (this.reviewStatus_ != PolicyReviewStatusEnum.PolicyReviewStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.reviewStatus_);
        }
        if (this.approvalStatus_ != PolicyApprovalStatusEnum.PolicyApprovalStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(4, this.approvalStatus_);
        }
        for (i = 0; i < this.policyTopicEntries_.size(); ++i) {
            output.writeMessage(5, (MessageLite)this.policyTopicEntries_.get(i));
        }
        if (this.validationStatus_ != FeedItemValidationStatusEnum.FeedItemValidationStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.validationStatus_);
        }
        for (i = 0; i < this.validationErrors_.size(); ++i) {
            output.writeMessage(7, (MessageLite)this.validationErrors_.get(i));
        }
        if (this.qualityApprovalStatus_ != FeedItemQualityApprovalStatusEnum.FeedItemQualityApprovalStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(8, this.qualityApprovalStatus_);
        }
        if (this.getQualityDisapprovalReasonsList().size() > 0) {
            output.writeUInt32NoTag(74);
            output.writeUInt32NoTag(this.qualityDisapprovalReasonsMemoizedSerializedSize);
        }
        for (i = 0; i < this.qualityDisapprovalReasons_.size(); ++i) {
            output.writeEnumNoTag(this.qualityDisapprovalReasons_.get(i).intValue());
        }
        if (this.placeholderTypeEnum_ != PlaceholderTypeEnum.PlaceholderType.UNSPECIFIED.getNumber()) {
            output.writeEnum(10, this.placeholderTypeEnum_);
        }
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.feedMappingResourceName_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.reviewStatus_ != PolicyReviewStatusEnum.PolicyReviewStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.reviewStatus_);
        }
        if (this.approvalStatus_ != PolicyApprovalStatusEnum.PolicyApprovalStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.approvalStatus_);
        }
        for (i = 0; i < this.policyTopicEntries_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((MessageLite)this.policyTopicEntries_.get(i)));
        }
        if (this.validationStatus_ != FeedItemValidationStatusEnum.FeedItemValidationStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.validationStatus_);
        }
        for (i = 0; i < this.validationErrors_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)((MessageLite)this.validationErrors_.get(i)));
        }
        if (this.qualityApprovalStatus_ != FeedItemQualityApprovalStatusEnum.FeedItemQualityApprovalStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)8, (int)this.qualityApprovalStatus_);
        }
        int dataSize = 0;
        for (int i2 = 0; i2 < this.qualityDisapprovalReasons_.size(); ++i2) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.qualityDisapprovalReasons_.get(i2));
        }
        size += dataSize;
        if (!this.getQualityDisapprovalReasonsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.qualityDisapprovalReasonsMemoizedSerializedSize = dataSize;
        if (this.placeholderTypeEnum_ != PlaceholderTypeEnum.PlaceholderType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)10, (int)this.placeholderTypeEnum_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)11, (Object)this.feedMappingResourceName_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FeedItemPlaceholderPolicyInfo)) {
            return super.equals(obj);
        }
        FeedItemPlaceholderPolicyInfo other = (FeedItemPlaceholderPolicyInfo)obj;
        if (this.placeholderTypeEnum_ != other.placeholderTypeEnum_) {
            return false;
        }
        if (this.hasFeedMappingResourceName() != other.hasFeedMappingResourceName()) {
            return false;
        }
        if (this.hasFeedMappingResourceName() && !this.getFeedMappingResourceName().equals(other.getFeedMappingResourceName())) {
            return false;
        }
        if (this.reviewStatus_ != other.reviewStatus_) {
            return false;
        }
        if (this.approvalStatus_ != other.approvalStatus_) {
            return false;
        }
        if (!this.getPolicyTopicEntriesList().equals(other.getPolicyTopicEntriesList())) {
            return false;
        }
        if (this.validationStatus_ != other.validationStatus_) {
            return false;
        }
        if (!this.getValidationErrorsList().equals(other.getValidationErrorsList())) {
            return false;
        }
        if (this.qualityApprovalStatus_ != other.qualityApprovalStatus_) {
            return false;
        }
        if (!this.qualityDisapprovalReasons_.equals(other.qualityDisapprovalReasons_)) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + FeedItemPlaceholderPolicyInfo.getDescriptor().hashCode();
        hash = 37 * hash + 10;
        hash = 53 * hash + this.placeholderTypeEnum_;
        if (this.hasFeedMappingResourceName()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getFeedMappingResourceName().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.reviewStatus_;
        hash = 37 * hash + 4;
        hash = 53 * hash + this.approvalStatus_;
        if (this.getPolicyTopicEntriesCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getPolicyTopicEntriesList().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.validationStatus_;
        if (this.getValidationErrorsCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getValidationErrorsList().hashCode();
        }
        hash = 37 * hash + 8;
        hash = 53 * hash + this.qualityApprovalStatus_;
        if (this.getQualityDisapprovalReasonsCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.qualityDisapprovalReasons_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static FeedItemPlaceholderPolicyInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (FeedItemPlaceholderPolicyInfo)PARSER.parseFrom(data);
    }

    public static FeedItemPlaceholderPolicyInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (FeedItemPlaceholderPolicyInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static FeedItemPlaceholderPolicyInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (FeedItemPlaceholderPolicyInfo)PARSER.parseFrom(data);
    }

    public static FeedItemPlaceholderPolicyInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (FeedItemPlaceholderPolicyInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static FeedItemPlaceholderPolicyInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (FeedItemPlaceholderPolicyInfo)PARSER.parseFrom(data);
    }

    public static FeedItemPlaceholderPolicyInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (FeedItemPlaceholderPolicyInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static FeedItemPlaceholderPolicyInfo parseFrom(InputStream input) throws IOException {
        return (FeedItemPlaceholderPolicyInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static FeedItemPlaceholderPolicyInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (FeedItemPlaceholderPolicyInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static FeedItemPlaceholderPolicyInfo parseDelimitedFrom(InputStream input) throws IOException {
        return (FeedItemPlaceholderPolicyInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static FeedItemPlaceholderPolicyInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (FeedItemPlaceholderPolicyInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static FeedItemPlaceholderPolicyInfo parseFrom(CodedInputStream input) throws IOException {
        return (FeedItemPlaceholderPolicyInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static FeedItemPlaceholderPolicyInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (FeedItemPlaceholderPolicyInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return FeedItemPlaceholderPolicyInfo.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(FeedItemPlaceholderPolicyInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static FeedItemPlaceholderPolicyInfo getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<FeedItemPlaceholderPolicyInfo> parser() {
        return PARSER;
    }

    public Parser<FeedItemPlaceholderPolicyInfo> getParserForType() {
        return PARSER;
    }

    public FeedItemPlaceholderPolicyInfo getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements FeedItemPlaceholderPolicyInfoOrBuilder {
        private int bitField0_;
        private int placeholderTypeEnum_ = 0;
        private Object feedMappingResourceName_ = "";
        private int reviewStatus_ = 0;
        private int approvalStatus_ = 0;
        private List<PolicyTopicEntry> policyTopicEntries_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<PolicyTopicEntry, PolicyTopicEntry.Builder, PolicyTopicEntryOrBuilder> policyTopicEntriesBuilder_;
        private int validationStatus_ = 0;
        private List<FeedItemValidationError> validationErrors_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<FeedItemValidationError, FeedItemValidationError.Builder, FeedItemValidationErrorOrBuilder> validationErrorsBuilder_;
        private int qualityApprovalStatus_ = 0;
        private List<Integer> qualityDisapprovalReasons_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return FeedItemProto.internal_static_google_ads_googleads_v17_resources_FeedItemPlaceholderPolicyInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FeedItemProto.internal_static_google_ads_googleads_v17_resources_FeedItemPlaceholderPolicyInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(FeedItemPlaceholderPolicyInfo.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.placeholderTypeEnum_ = 0;
            this.feedMappingResourceName_ = "";
            this.reviewStatus_ = 0;
            this.approvalStatus_ = 0;
            if (this.policyTopicEntriesBuilder_ == null) {
                this.policyTopicEntries_ = Collections.emptyList();
            } else {
                this.policyTopicEntries_ = null;
                this.policyTopicEntriesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFEF;
            this.validationStatus_ = 0;
            if (this.validationErrorsBuilder_ == null) {
                this.validationErrors_ = Collections.emptyList();
            } else {
                this.validationErrors_ = null;
                this.validationErrorsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFBF;
            this.qualityApprovalStatus_ = 0;
            this.qualityDisapprovalReasons_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return FeedItemProto.internal_static_google_ads_googleads_v17_resources_FeedItemPlaceholderPolicyInfo_descriptor;
        }

        public FeedItemPlaceholderPolicyInfo getDefaultInstanceForType() {
            return FeedItemPlaceholderPolicyInfo.getDefaultInstance();
        }

        public FeedItemPlaceholderPolicyInfo build() {
            FeedItemPlaceholderPolicyInfo result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public FeedItemPlaceholderPolicyInfo buildPartial() {
            FeedItemPlaceholderPolicyInfo result = new FeedItemPlaceholderPolicyInfo(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(FeedItemPlaceholderPolicyInfo result) {
            if (this.policyTopicEntriesBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0) {
                    this.policyTopicEntries_ = Collections.unmodifiableList(this.policyTopicEntries_);
                    this.bitField0_ &= 0xFFFFFFEF;
                }
                result.policyTopicEntries_ = this.policyTopicEntries_;
            } else {
                result.policyTopicEntries_ = this.policyTopicEntriesBuilder_.build();
            }
            if (this.validationErrorsBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0) {
                    this.validationErrors_ = Collections.unmodifiableList(this.validationErrors_);
                    this.bitField0_ &= 0xFFFFFFBF;
                }
                result.validationErrors_ = this.validationErrors_;
            } else {
                result.validationErrors_ = this.validationErrorsBuilder_.build();
            }
            if ((this.bitField0_ & 0x100) != 0) {
                this.qualityDisapprovalReasons_ = Collections.unmodifiableList(this.qualityDisapprovalReasons_);
                this.bitField0_ &= 0xFFFFFEFF;
            }
            result.qualityDisapprovalReasons_ = this.qualityDisapprovalReasons_;
        }

        private void buildPartial0(FeedItemPlaceholderPolicyInfo result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.placeholderTypeEnum_ = this.placeholderTypeEnum_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.feedMappingResourceName_ = this.feedMappingResourceName_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.reviewStatus_ = this.reviewStatus_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.approvalStatus_ = this.approvalStatus_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.validationStatus_ = this.validationStatus_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.qualityApprovalStatus_ = this.qualityApprovalStatus_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof FeedItemPlaceholderPolicyInfo) {
                return this.mergeFrom((FeedItemPlaceholderPolicyInfo)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(FeedItemPlaceholderPolicyInfo other) {
            if (other == FeedItemPlaceholderPolicyInfo.getDefaultInstance()) {
                return this;
            }
            if (other.placeholderTypeEnum_ != 0) {
                this.setPlaceholderTypeEnumValue(other.getPlaceholderTypeEnumValue());
            }
            if (other.hasFeedMappingResourceName()) {
                this.feedMappingResourceName_ = other.feedMappingResourceName_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.reviewStatus_ != 0) {
                this.setReviewStatusValue(other.getReviewStatusValue());
            }
            if (other.approvalStatus_ != 0) {
                this.setApprovalStatusValue(other.getApprovalStatusValue());
            }
            if (this.policyTopicEntriesBuilder_ == null) {
                if (!other.policyTopicEntries_.isEmpty()) {
                    if (this.policyTopicEntries_.isEmpty()) {
                        this.policyTopicEntries_ = other.policyTopicEntries_;
                        this.bitField0_ &= 0xFFFFFFEF;
                    } else {
                        this.ensurePolicyTopicEntriesIsMutable();
                        this.policyTopicEntries_.addAll(other.policyTopicEntries_);
                    }
                    this.onChanged();
                }
            } else if (!other.policyTopicEntries_.isEmpty()) {
                if (this.policyTopicEntriesBuilder_.isEmpty()) {
                    this.policyTopicEntriesBuilder_.dispose();
                    this.policyTopicEntriesBuilder_ = null;
                    this.policyTopicEntries_ = other.policyTopicEntries_;
                    this.bitField0_ &= 0xFFFFFFEF;
                    this.policyTopicEntriesBuilder_ = alwaysUseFieldBuilders ? this.getPolicyTopicEntriesFieldBuilder() : null;
                } else {
                    this.policyTopicEntriesBuilder_.addAllMessages((Iterable)other.policyTopicEntries_);
                }
            }
            if (other.validationStatus_ != 0) {
                this.setValidationStatusValue(other.getValidationStatusValue());
            }
            if (this.validationErrorsBuilder_ == null) {
                if (!other.validationErrors_.isEmpty()) {
                    if (this.validationErrors_.isEmpty()) {
                        this.validationErrors_ = other.validationErrors_;
                        this.bitField0_ &= 0xFFFFFFBF;
                    } else {
                        this.ensureValidationErrorsIsMutable();
                        this.validationErrors_.addAll(other.validationErrors_);
                    }
                    this.onChanged();
                }
            } else if (!other.validationErrors_.isEmpty()) {
                if (this.validationErrorsBuilder_.isEmpty()) {
                    this.validationErrorsBuilder_.dispose();
                    this.validationErrorsBuilder_ = null;
                    this.validationErrors_ = other.validationErrors_;
                    this.bitField0_ &= 0xFFFFFFBF;
                    this.validationErrorsBuilder_ = alwaysUseFieldBuilders ? this.getValidationErrorsFieldBuilder() : null;
                } else {
                    this.validationErrorsBuilder_.addAllMessages((Iterable)other.validationErrors_);
                }
            }
            if (other.qualityApprovalStatus_ != 0) {
                this.setQualityApprovalStatusValue(other.getQualityApprovalStatusValue());
            }
            if (!other.qualityDisapprovalReasons_.isEmpty()) {
                if (this.qualityDisapprovalReasons_.isEmpty()) {
                    this.qualityDisapprovalReasons_ = other.qualityDisapprovalReasons_;
                    this.bitField0_ &= 0xFFFFFEFF;
                } else {
                    this.ensureQualityDisapprovalReasonsIsMutable();
                    this.qualityDisapprovalReasons_.addAll(other.qualityDisapprovalReasons_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block18: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block18;
                        }
                        case 24: {
                            this.reviewStatus_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block18;
                        }
                        case 32: {
                            this.approvalStatus_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block18;
                        }
                        case 42: {
                            PolicyTopicEntry m = (PolicyTopicEntry)input.readMessage(PolicyTopicEntry.parser(), extensionRegistry);
                            if (this.policyTopicEntriesBuilder_ == null) {
                                this.ensurePolicyTopicEntriesIsMutable();
                                this.policyTopicEntries_.add(m);
                                continue block18;
                            }
                            this.policyTopicEntriesBuilder_.addMessage((AbstractMessage)m);
                            continue block18;
                        }
                        case 48: {
                            this.validationStatus_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block18;
                        }
                        case 58: {
                            FeedItemValidationError m = (FeedItemValidationError)input.readMessage(FeedItemValidationError.parser(), extensionRegistry);
                            if (this.validationErrorsBuilder_ == null) {
                                this.ensureValidationErrorsIsMutable();
                                this.validationErrors_.add(m);
                                continue block18;
                            }
                            this.validationErrorsBuilder_.addMessage((AbstractMessage)m);
                            continue block18;
                        }
                        case 64: {
                            this.qualityApprovalStatus_ = input.readEnum();
                            this.bitField0_ |= 0x80;
                            continue block18;
                        }
                        case 72: {
                            int tmpRaw = input.readEnum();
                            this.ensureQualityDisapprovalReasonsIsMutable();
                            this.qualityDisapprovalReasons_.add(tmpRaw);
                            continue block18;
                        }
                        case 74: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureQualityDisapprovalReasonsIsMutable();
                                this.qualityDisapprovalReasons_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block18;
                        }
                        case 80: {
                            this.placeholderTypeEnum_ = input.readEnum();
                            this.bitField0_ |= 1;
                            continue block18;
                        }
                        case 90: {
                            this.feedMappingResourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block18;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public int getPlaceholderTypeEnumValue() {
            return this.placeholderTypeEnum_;
        }

        public Builder setPlaceholderTypeEnumValue(int value) {
            this.placeholderTypeEnum_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public PlaceholderTypeEnum.PlaceholderType getPlaceholderTypeEnum() {
            PlaceholderTypeEnum.PlaceholderType result = PlaceholderTypeEnum.PlaceholderType.forNumber(this.placeholderTypeEnum_);
            return result == null ? PlaceholderTypeEnum.PlaceholderType.UNRECOGNIZED : result;
        }

        public Builder setPlaceholderTypeEnum(PlaceholderTypeEnum.PlaceholderType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 1;
            this.placeholderTypeEnum_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPlaceholderTypeEnum() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.placeholderTypeEnum_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasFeedMappingResourceName() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public String getFeedMappingResourceName() {
            Object ref = this.feedMappingResourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.feedMappingResourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFeedMappingResourceNameBytes() {
            Object ref = this.feedMappingResourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.feedMappingResourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFeedMappingResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.feedMappingResourceName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearFeedMappingResourceName() {
            this.feedMappingResourceName_ = FeedItemPlaceholderPolicyInfo.getDefaultInstance().getFeedMappingResourceName();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setFeedMappingResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            FeedItemPlaceholderPolicyInfo.checkByteStringIsUtf8((ByteString)value);
            this.feedMappingResourceName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public int getReviewStatusValue() {
            return this.reviewStatus_;
        }

        public Builder setReviewStatusValue(int value) {
            this.reviewStatus_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public PolicyReviewStatusEnum.PolicyReviewStatus getReviewStatus() {
            PolicyReviewStatusEnum.PolicyReviewStatus result = PolicyReviewStatusEnum.PolicyReviewStatus.forNumber(this.reviewStatus_);
            return result == null ? PolicyReviewStatusEnum.PolicyReviewStatus.UNRECOGNIZED : result;
        }

        public Builder setReviewStatus(PolicyReviewStatusEnum.PolicyReviewStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.reviewStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearReviewStatus() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.reviewStatus_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getApprovalStatusValue() {
            return this.approvalStatus_;
        }

        public Builder setApprovalStatusValue(int value) {
            this.approvalStatus_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public PolicyApprovalStatusEnum.PolicyApprovalStatus getApprovalStatus() {
            PolicyApprovalStatusEnum.PolicyApprovalStatus result = PolicyApprovalStatusEnum.PolicyApprovalStatus.forNumber(this.approvalStatus_);
            return result == null ? PolicyApprovalStatusEnum.PolicyApprovalStatus.UNRECOGNIZED : result;
        }

        public Builder setApprovalStatus(PolicyApprovalStatusEnum.PolicyApprovalStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.approvalStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearApprovalStatus() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.approvalStatus_ = 0;
            this.onChanged();
            return this;
        }

        private void ensurePolicyTopicEntriesIsMutable() {
            if ((this.bitField0_ & 0x10) == 0) {
                this.policyTopicEntries_ = new ArrayList<PolicyTopicEntry>(this.policyTopicEntries_);
                this.bitField0_ |= 0x10;
            }
        }

        @Override
        public List<PolicyTopicEntry> getPolicyTopicEntriesList() {
            if (this.policyTopicEntriesBuilder_ == null) {
                return Collections.unmodifiableList(this.policyTopicEntries_);
            }
            return this.policyTopicEntriesBuilder_.getMessageList();
        }

        @Override
        public int getPolicyTopicEntriesCount() {
            if (this.policyTopicEntriesBuilder_ == null) {
                return this.policyTopicEntries_.size();
            }
            return this.policyTopicEntriesBuilder_.getCount();
        }

        @Override
        public PolicyTopicEntry getPolicyTopicEntries(int index) {
            if (this.policyTopicEntriesBuilder_ == null) {
                return this.policyTopicEntries_.get(index);
            }
            return (PolicyTopicEntry)this.policyTopicEntriesBuilder_.getMessage(index);
        }

        public Builder setPolicyTopicEntries(int index, PolicyTopicEntry value) {
            if (this.policyTopicEntriesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.set(index, value);
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPolicyTopicEntries(int index, PolicyTopicEntry.Builder builderForValue) {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPolicyTopicEntries(PolicyTopicEntry value) {
            if (this.policyTopicEntriesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.add(value);
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPolicyTopicEntries(int index, PolicyTopicEntry value) {
            if (this.policyTopicEntriesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.add(index, value);
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPolicyTopicEntries(PolicyTopicEntry.Builder builderForValue) {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPolicyTopicEntries(int index, PolicyTopicEntry.Builder builderForValue) {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPolicyTopicEntries(Iterable<? extends PolicyTopicEntry> values) {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.ensurePolicyTopicEntriesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.policyTopicEntries_);
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPolicyTopicEntries() {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.policyTopicEntries_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.clear();
            }
            return this;
        }

        public Builder removePolicyTopicEntries(int index) {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.remove(index);
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.remove(index);
            }
            return this;
        }

        public PolicyTopicEntry.Builder getPolicyTopicEntriesBuilder(int index) {
            return (PolicyTopicEntry.Builder)this.getPolicyTopicEntriesFieldBuilder().getBuilder(index);
        }

        @Override
        public PolicyTopicEntryOrBuilder getPolicyTopicEntriesOrBuilder(int index) {
            if (this.policyTopicEntriesBuilder_ == null) {
                return this.policyTopicEntries_.get(index);
            }
            return (PolicyTopicEntryOrBuilder)this.policyTopicEntriesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends PolicyTopicEntryOrBuilder> getPolicyTopicEntriesOrBuilderList() {
            if (this.policyTopicEntriesBuilder_ != null) {
                return this.policyTopicEntriesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.policyTopicEntries_);
        }

        public PolicyTopicEntry.Builder addPolicyTopicEntriesBuilder() {
            return (PolicyTopicEntry.Builder)this.getPolicyTopicEntriesFieldBuilder().addBuilder((AbstractMessage)PolicyTopicEntry.getDefaultInstance());
        }

        public PolicyTopicEntry.Builder addPolicyTopicEntriesBuilder(int index) {
            return (PolicyTopicEntry.Builder)this.getPolicyTopicEntriesFieldBuilder().addBuilder(index, (AbstractMessage)PolicyTopicEntry.getDefaultInstance());
        }

        public List<PolicyTopicEntry.Builder> getPolicyTopicEntriesBuilderList() {
            return this.getPolicyTopicEntriesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<PolicyTopicEntry, PolicyTopicEntry.Builder, PolicyTopicEntryOrBuilder> getPolicyTopicEntriesFieldBuilder() {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.policyTopicEntriesBuilder_ = new RepeatedFieldBuilderV3(this.policyTopicEntries_, (this.bitField0_ & 0x10) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.policyTopicEntries_ = null;
            }
            return this.policyTopicEntriesBuilder_;
        }

        @Override
        public int getValidationStatusValue() {
            return this.validationStatus_;
        }

        public Builder setValidationStatusValue(int value) {
            this.validationStatus_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public FeedItemValidationStatusEnum.FeedItemValidationStatus getValidationStatus() {
            FeedItemValidationStatusEnum.FeedItemValidationStatus result = FeedItemValidationStatusEnum.FeedItemValidationStatus.forNumber(this.validationStatus_);
            return result == null ? FeedItemValidationStatusEnum.FeedItemValidationStatus.UNRECOGNIZED : result;
        }

        public Builder setValidationStatus(FeedItemValidationStatusEnum.FeedItemValidationStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.validationStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearValidationStatus() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.validationStatus_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureValidationErrorsIsMutable() {
            if ((this.bitField0_ & 0x40) == 0) {
                this.validationErrors_ = new ArrayList<FeedItemValidationError>(this.validationErrors_);
                this.bitField0_ |= 0x40;
            }
        }

        @Override
        public List<FeedItemValidationError> getValidationErrorsList() {
            if (this.validationErrorsBuilder_ == null) {
                return Collections.unmodifiableList(this.validationErrors_);
            }
            return this.validationErrorsBuilder_.getMessageList();
        }

        @Override
        public int getValidationErrorsCount() {
            if (this.validationErrorsBuilder_ == null) {
                return this.validationErrors_.size();
            }
            return this.validationErrorsBuilder_.getCount();
        }

        @Override
        public FeedItemValidationError getValidationErrors(int index) {
            if (this.validationErrorsBuilder_ == null) {
                return this.validationErrors_.get(index);
            }
            return (FeedItemValidationError)this.validationErrorsBuilder_.getMessage(index);
        }

        public Builder setValidationErrors(int index, FeedItemValidationError value) {
            if (this.validationErrorsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureValidationErrorsIsMutable();
                this.validationErrors_.set(index, value);
                this.onChanged();
            } else {
                this.validationErrorsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setValidationErrors(int index, FeedItemValidationError.Builder builderForValue) {
            if (this.validationErrorsBuilder_ == null) {
                this.ensureValidationErrorsIsMutable();
                this.validationErrors_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.validationErrorsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addValidationErrors(FeedItemValidationError value) {
            if (this.validationErrorsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureValidationErrorsIsMutable();
                this.validationErrors_.add(value);
                this.onChanged();
            } else {
                this.validationErrorsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addValidationErrors(int index, FeedItemValidationError value) {
            if (this.validationErrorsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureValidationErrorsIsMutable();
                this.validationErrors_.add(index, value);
                this.onChanged();
            } else {
                this.validationErrorsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addValidationErrors(FeedItemValidationError.Builder builderForValue) {
            if (this.validationErrorsBuilder_ == null) {
                this.ensureValidationErrorsIsMutable();
                this.validationErrors_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.validationErrorsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addValidationErrors(int index, FeedItemValidationError.Builder builderForValue) {
            if (this.validationErrorsBuilder_ == null) {
                this.ensureValidationErrorsIsMutable();
                this.validationErrors_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.validationErrorsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllValidationErrors(Iterable<? extends FeedItemValidationError> values) {
            if (this.validationErrorsBuilder_ == null) {
                this.ensureValidationErrorsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.validationErrors_);
                this.onChanged();
            } else {
                this.validationErrorsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearValidationErrors() {
            if (this.validationErrorsBuilder_ == null) {
                this.validationErrors_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFBF;
                this.onChanged();
            } else {
                this.validationErrorsBuilder_.clear();
            }
            return this;
        }

        public Builder removeValidationErrors(int index) {
            if (this.validationErrorsBuilder_ == null) {
                this.ensureValidationErrorsIsMutable();
                this.validationErrors_.remove(index);
                this.onChanged();
            } else {
                this.validationErrorsBuilder_.remove(index);
            }
            return this;
        }

        public FeedItemValidationError.Builder getValidationErrorsBuilder(int index) {
            return (FeedItemValidationError.Builder)this.getValidationErrorsFieldBuilder().getBuilder(index);
        }

        @Override
        public FeedItemValidationErrorOrBuilder getValidationErrorsOrBuilder(int index) {
            if (this.validationErrorsBuilder_ == null) {
                return this.validationErrors_.get(index);
            }
            return (FeedItemValidationErrorOrBuilder)this.validationErrorsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends FeedItemValidationErrorOrBuilder> getValidationErrorsOrBuilderList() {
            if (this.validationErrorsBuilder_ != null) {
                return this.validationErrorsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.validationErrors_);
        }

        public FeedItemValidationError.Builder addValidationErrorsBuilder() {
            return (FeedItemValidationError.Builder)this.getValidationErrorsFieldBuilder().addBuilder((AbstractMessage)FeedItemValidationError.getDefaultInstance());
        }

        public FeedItemValidationError.Builder addValidationErrorsBuilder(int index) {
            return (FeedItemValidationError.Builder)this.getValidationErrorsFieldBuilder().addBuilder(index, (AbstractMessage)FeedItemValidationError.getDefaultInstance());
        }

        public List<FeedItemValidationError.Builder> getValidationErrorsBuilderList() {
            return this.getValidationErrorsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<FeedItemValidationError, FeedItemValidationError.Builder, FeedItemValidationErrorOrBuilder> getValidationErrorsFieldBuilder() {
            if (this.validationErrorsBuilder_ == null) {
                this.validationErrorsBuilder_ = new RepeatedFieldBuilderV3(this.validationErrors_, (this.bitField0_ & 0x40) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.validationErrors_ = null;
            }
            return this.validationErrorsBuilder_;
        }

        @Override
        public int getQualityApprovalStatusValue() {
            return this.qualityApprovalStatus_;
        }

        public Builder setQualityApprovalStatusValue(int value) {
            this.qualityApprovalStatus_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public FeedItemQualityApprovalStatusEnum.FeedItemQualityApprovalStatus getQualityApprovalStatus() {
            FeedItemQualityApprovalStatusEnum.FeedItemQualityApprovalStatus result = FeedItemQualityApprovalStatusEnum.FeedItemQualityApprovalStatus.forNumber(this.qualityApprovalStatus_);
            return result == null ? FeedItemQualityApprovalStatusEnum.FeedItemQualityApprovalStatus.UNRECOGNIZED : result;
        }

        public Builder setQualityApprovalStatus(FeedItemQualityApprovalStatusEnum.FeedItemQualityApprovalStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x80;
            this.qualityApprovalStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearQualityApprovalStatus() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.qualityApprovalStatus_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureQualityDisapprovalReasonsIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.qualityDisapprovalReasons_ = new ArrayList<Integer>(this.qualityDisapprovalReasons_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason> getQualityDisapprovalReasonsList() {
            return new Internal.ListAdapter(this.qualityDisapprovalReasons_, qualityDisapprovalReasons_converter_);
        }

        @Override
        public int getQualityDisapprovalReasonsCount() {
            return this.qualityDisapprovalReasons_.size();
        }

        @Override
        public FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason getQualityDisapprovalReasons(int index) {
            return (FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason)((Object)qualityDisapprovalReasons_converter_.convert((Object)this.qualityDisapprovalReasons_.get(index)));
        }

        public Builder setQualityDisapprovalReasons(int index, FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureQualityDisapprovalReasonsIsMutable();
            this.qualityDisapprovalReasons_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addQualityDisapprovalReasons(FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureQualityDisapprovalReasonsIsMutable();
            this.qualityDisapprovalReasons_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllQualityDisapprovalReasons(Iterable<? extends FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason> values) {
            this.ensureQualityDisapprovalReasonsIsMutable();
            for (FeedItemQualityDisapprovalReasonEnum.FeedItemQualityDisapprovalReason feedItemQualityDisapprovalReason : values) {
                this.qualityDisapprovalReasons_.add(feedItemQualityDisapprovalReason.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearQualityDisapprovalReasons() {
            this.qualityDisapprovalReasons_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getQualityDisapprovalReasonsValueList() {
            return Collections.unmodifiableList(this.qualityDisapprovalReasons_);
        }

        @Override
        public int getQualityDisapprovalReasonsValue(int index) {
            return this.qualityDisapprovalReasons_.get(index);
        }

        public Builder setQualityDisapprovalReasonsValue(int index, int value) {
            this.ensureQualityDisapprovalReasonsIsMutable();
            this.qualityDisapprovalReasons_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addQualityDisapprovalReasonsValue(int value) {
            this.ensureQualityDisapprovalReasonsIsMutable();
            this.qualityDisapprovalReasons_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllQualityDisapprovalReasonsValue(Iterable<Integer> values) {
            this.ensureQualityDisapprovalReasonsIsMutable();
            for (int value : values) {
                this.qualityDisapprovalReasons_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

