/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v17.services;

import com.google.ads.googleads.v17.services.AdGroupFeedOperation;
import com.google.ads.googleads.v17.services.AdGroupFeedServiceSettings;
import com.google.ads.googleads.v17.services.MutateAdGroupFeedsRequest;
import com.google.ads.googleads.v17.services.MutateAdGroupFeedsResponse;
import com.google.ads.googleads.v17.services.stub.AdGroupFeedServiceStub;
import com.google.ads.googleads.v17.services.stub.AdGroupFeedServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdGroupFeedServiceClient
implements BackgroundResource {
    private final AdGroupFeedServiceSettings settings;
    private final AdGroupFeedServiceStub stub;

    public static final AdGroupFeedServiceClient create() throws IOException {
        return AdGroupFeedServiceClient.create(AdGroupFeedServiceSettings.newBuilder().build());
    }

    public static final AdGroupFeedServiceClient create(AdGroupFeedServiceSettings settings) throws IOException {
        return new AdGroupFeedServiceClient(settings);
    }

    public static final AdGroupFeedServiceClient create(AdGroupFeedServiceStub stub) {
        return new AdGroupFeedServiceClient(stub);
    }

    protected AdGroupFeedServiceClient(AdGroupFeedServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupFeedServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdGroupFeedServiceClient(AdGroupFeedServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupFeedServiceSettings getSettings() {
        return this.settings;
    }

    public AdGroupFeedServiceStub getStub() {
        return this.stub;
    }

    public final MutateAdGroupFeedsResponse mutateAdGroupFeeds(String customerId, List<AdGroupFeedOperation> operations) {
        MutateAdGroupFeedsRequest request = MutateAdGroupFeedsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroupFeeds(request);
    }

    public final MutateAdGroupFeedsResponse mutateAdGroupFeeds(MutateAdGroupFeedsRequest request) {
        return (MutateAdGroupFeedsResponse)this.mutateAdGroupFeedsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupFeedsRequest, MutateAdGroupFeedsResponse> mutateAdGroupFeedsCallable() {
        return this.stub.mutateAdGroupFeedsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

