// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v18/resources/product_link.proto

// Protobuf Java Version: 3.25.3
package com.google.ads.googleads.v18.resources;

/**
 * <pre>
 * Represents the data sharing connection between  a Google
 * Ads customer and another product.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v18.resources.ProductLink}
 */
public final class ProductLink extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v18.resources.ProductLink)
    ProductLinkOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ProductLink.newBuilder() to construct.
  private ProductLink(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ProductLink() {
    resourceName_ = "";
    type_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new ProductLink();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v18.resources.ProductLinkProto.internal_static_google_ads_googleads_v18_resources_ProductLink_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v18.resources.ProductLinkProto.internal_static_google_ads_googleads_v18_resources_ProductLink_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v18.resources.ProductLink.class, com.google.ads.googleads.v18.resources.ProductLink.Builder.class);
  }

  private int bitField0_;
  private int linkedProductCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object linkedProduct_;
  public enum LinkedProductCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DATA_PARTNER(4),
    GOOGLE_ADS(5),
    MERCHANT_CENTER(12),
    ADVERTISING_PARTNER(13),
    LINKEDPRODUCT_NOT_SET(0);
    private final int value;
    private LinkedProductCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LinkedProductCase valueOf(int value) {
      return forNumber(value);
    }

    public static LinkedProductCase forNumber(int value) {
      switch (value) {
        case 4: return DATA_PARTNER;
        case 5: return GOOGLE_ADS;
        case 12: return MERCHANT_CENTER;
        case 13: return ADVERTISING_PARTNER;
        case 0: return LINKEDPRODUCT_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public LinkedProductCase
  getLinkedProductCase() {
    return LinkedProductCase.forNumber(
        linkedProductCase_);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Immutable. Resource name of the product link.
   * ProductLink resource names have the form:
   *
   * `customers/{customer_id}/productLinks/{product_link_id} `
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. Resource name of the product link.
   * ProductLink resource names have the form:
   *
   * `customers/{customer_id}/productLinks/{product_link_id} `
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCT_LINK_ID_FIELD_NUMBER = 2;
  private long productLinkId_ = 0L;
  /**
   * <pre>
   * Output only. The ID of the link.
   * This field is read only.
   * </pre>
   *
   * <code>optional int64 product_link_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the productLinkId field is set.
   */
  @java.lang.Override
  public boolean hasProductLinkId() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Output only. The ID of the link.
   * This field is read only.
   * </pre>
   *
   * <code>optional int64 product_link_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The productLinkId.
   */
  @java.lang.Override
  public long getProductLinkId() {
    return productLinkId_;
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private int type_ = 0;
  /**
   * <pre>
   * Output only. The type of the linked product.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Output only. The type of the linked product.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The type.
   */
  @java.lang.Override public com.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType getType() {
    com.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType result = com.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType.forNumber(type_);
    return result == null ? com.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType.UNRECOGNIZED : result;
  }

  public static final int DATA_PARTNER_FIELD_NUMBER = 4;
  /**
   * <pre>
   * Immutable. Data partner link.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.resources.DataPartnerIdentifier data_partner = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return Whether the dataPartner field is set.
   */
  @java.lang.Override
  public boolean hasDataPartner() {
    return linkedProductCase_ == 4;
  }
  /**
   * <pre>
   * Immutable. Data partner link.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.resources.DataPartnerIdentifier data_partner = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The dataPartner.
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.resources.DataPartnerIdentifier getDataPartner() {
    if (linkedProductCase_ == 4) {
       return (com.google.ads.googleads.v18.resources.DataPartnerIdentifier) linkedProduct_;
    }
    return com.google.ads.googleads.v18.resources.DataPartnerIdentifier.getDefaultInstance();
  }
  /**
   * <pre>
   * Immutable. Data partner link.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.resources.DataPartnerIdentifier data_partner = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.resources.DataPartnerIdentifierOrBuilder getDataPartnerOrBuilder() {
    if (linkedProductCase_ == 4) {
       return (com.google.ads.googleads.v18.resources.DataPartnerIdentifier) linkedProduct_;
    }
    return com.google.ads.googleads.v18.resources.DataPartnerIdentifier.getDefaultInstance();
  }

  public static final int GOOGLE_ADS_FIELD_NUMBER = 5;
  /**
   * <pre>
   * Immutable. Google Ads link.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.resources.GoogleAdsIdentifier google_ads = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return Whether the googleAds field is set.
   */
  @java.lang.Override
  public boolean hasGoogleAds() {
    return linkedProductCase_ == 5;
  }
  /**
   * <pre>
   * Immutable. Google Ads link.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.resources.GoogleAdsIdentifier google_ads = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The googleAds.
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.resources.GoogleAdsIdentifier getGoogleAds() {
    if (linkedProductCase_ == 5) {
       return (com.google.ads.googleads.v18.resources.GoogleAdsIdentifier) linkedProduct_;
    }
    return com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.getDefaultInstance();
  }
  /**
   * <pre>
   * Immutable. Google Ads link.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.resources.GoogleAdsIdentifier google_ads = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.resources.GoogleAdsIdentifierOrBuilder getGoogleAdsOrBuilder() {
    if (linkedProductCase_ == 5) {
       return (com.google.ads.googleads.v18.resources.GoogleAdsIdentifier) linkedProduct_;
    }
    return com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.getDefaultInstance();
  }

  public static final int MERCHANT_CENTER_FIELD_NUMBER = 12;
  /**
   * <pre>
   * Immutable. Google Merchant Center link.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.resources.MerchantCenterIdentifier merchant_center = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return Whether the merchantCenter field is set.
   */
  @java.lang.Override
  public boolean hasMerchantCenter() {
    return linkedProductCase_ == 12;
  }
  /**
   * <pre>
   * Immutable. Google Merchant Center link.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.resources.MerchantCenterIdentifier merchant_center = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The merchantCenter.
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.resources.MerchantCenterIdentifier getMerchantCenter() {
    if (linkedProductCase_ == 12) {
       return (com.google.ads.googleads.v18.resources.MerchantCenterIdentifier) linkedProduct_;
    }
    return com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.getDefaultInstance();
  }
  /**
   * <pre>
   * Immutable. Google Merchant Center link.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.resources.MerchantCenterIdentifier merchant_center = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.resources.MerchantCenterIdentifierOrBuilder getMerchantCenterOrBuilder() {
    if (linkedProductCase_ == 12) {
       return (com.google.ads.googleads.v18.resources.MerchantCenterIdentifier) linkedProduct_;
    }
    return com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.getDefaultInstance();
  }

  public static final int ADVERTISING_PARTNER_FIELD_NUMBER = 13;
  /**
   * <pre>
   * Output only. Advertising Partner link.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier advertising_partner = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the advertisingPartner field is set.
   */
  @java.lang.Override
  public boolean hasAdvertisingPartner() {
    return linkedProductCase_ == 13;
  }
  /**
   * <pre>
   * Output only. Advertising Partner link.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier advertising_partner = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The advertisingPartner.
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier getAdvertisingPartner() {
    if (linkedProductCase_ == 13) {
       return (com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier) linkedProduct_;
    }
    return com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Advertising Partner link.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier advertising_partner = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifierOrBuilder getAdvertisingPartnerOrBuilder() {
    if (linkedProductCase_ == 13) {
       return (com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier) linkedProduct_;
    }
    return com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(2, productLinkId_);
    }
    if (type_ != com.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType.UNSPECIFIED.getNumber()) {
      output.writeEnum(3, type_);
    }
    if (linkedProductCase_ == 4) {
      output.writeMessage(4, (com.google.ads.googleads.v18.resources.DataPartnerIdentifier) linkedProduct_);
    }
    if (linkedProductCase_ == 5) {
      output.writeMessage(5, (com.google.ads.googleads.v18.resources.GoogleAdsIdentifier) linkedProduct_);
    }
    if (linkedProductCase_ == 12) {
      output.writeMessage(12, (com.google.ads.googleads.v18.resources.MerchantCenterIdentifier) linkedProduct_);
    }
    if (linkedProductCase_ == 13) {
      output.writeMessage(13, (com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier) linkedProduct_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(2, productLinkId_);
    }
    if (type_ != com.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, type_);
    }
    if (linkedProductCase_ == 4) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, (com.google.ads.googleads.v18.resources.DataPartnerIdentifier) linkedProduct_);
    }
    if (linkedProductCase_ == 5) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, (com.google.ads.googleads.v18.resources.GoogleAdsIdentifier) linkedProduct_);
    }
    if (linkedProductCase_ == 12) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(12, (com.google.ads.googleads.v18.resources.MerchantCenterIdentifier) linkedProduct_);
    }
    if (linkedProductCase_ == 13) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(13, (com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier) linkedProduct_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v18.resources.ProductLink)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v18.resources.ProductLink other = (com.google.ads.googleads.v18.resources.ProductLink) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (hasProductLinkId() != other.hasProductLinkId()) return false;
    if (hasProductLinkId()) {
      if (getProductLinkId()
          != other.getProductLinkId()) return false;
    }
    if (type_ != other.type_) return false;
    if (!getLinkedProductCase().equals(other.getLinkedProductCase())) return false;
    switch (linkedProductCase_) {
      case 4:
        if (!getDataPartner()
            .equals(other.getDataPartner())) return false;
        break;
      case 5:
        if (!getGoogleAds()
            .equals(other.getGoogleAds())) return false;
        break;
      case 12:
        if (!getMerchantCenter()
            .equals(other.getMerchantCenter())) return false;
        break;
      case 13:
        if (!getAdvertisingPartner()
            .equals(other.getAdvertisingPartner())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    if (hasProductLinkId()) {
      hash = (37 * hash) + PRODUCT_LINK_ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getProductLinkId());
    }
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    switch (linkedProductCase_) {
      case 4:
        hash = (37 * hash) + DATA_PARTNER_FIELD_NUMBER;
        hash = (53 * hash) + getDataPartner().hashCode();
        break;
      case 5:
        hash = (37 * hash) + GOOGLE_ADS_FIELD_NUMBER;
        hash = (53 * hash) + getGoogleAds().hashCode();
        break;
      case 12:
        hash = (37 * hash) + MERCHANT_CENTER_FIELD_NUMBER;
        hash = (53 * hash) + getMerchantCenter().hashCode();
        break;
      case 13:
        hash = (37 * hash) + ADVERTISING_PARTNER_FIELD_NUMBER;
        hash = (53 * hash) + getAdvertisingPartner().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v18.resources.ProductLink parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v18.resources.ProductLink parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.ProductLink parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v18.resources.ProductLink parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.ProductLink parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v18.resources.ProductLink parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.ProductLink parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v18.resources.ProductLink parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v18.resources.ProductLink parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v18.resources.ProductLink parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.ProductLink parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v18.resources.ProductLink parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v18.resources.ProductLink prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents the data sharing connection between  a Google
   * Ads customer and another product.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v18.resources.ProductLink}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v18.resources.ProductLink)
      com.google.ads.googleads.v18.resources.ProductLinkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v18.resources.ProductLinkProto.internal_static_google_ads_googleads_v18_resources_ProductLink_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v18.resources.ProductLinkProto.internal_static_google_ads_googleads_v18_resources_ProductLink_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v18.resources.ProductLink.class, com.google.ads.googleads.v18.resources.ProductLink.Builder.class);
    }

    // Construct using com.google.ads.googleads.v18.resources.ProductLink.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      productLinkId_ = 0L;
      type_ = 0;
      if (dataPartnerBuilder_ != null) {
        dataPartnerBuilder_.clear();
      }
      if (googleAdsBuilder_ != null) {
        googleAdsBuilder_.clear();
      }
      if (merchantCenterBuilder_ != null) {
        merchantCenterBuilder_.clear();
      }
      if (advertisingPartnerBuilder_ != null) {
        advertisingPartnerBuilder_.clear();
      }
      linkedProductCase_ = 0;
      linkedProduct_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v18.resources.ProductLinkProto.internal_static_google_ads_googleads_v18_resources_ProductLink_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.ProductLink getDefaultInstanceForType() {
      return com.google.ads.googleads.v18.resources.ProductLink.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.ProductLink build() {
      com.google.ads.googleads.v18.resources.ProductLink result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.ProductLink buildPartial() {
      com.google.ads.googleads.v18.resources.ProductLink result = new com.google.ads.googleads.v18.resources.ProductLink(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ads.googleads.v18.resources.ProductLink result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.productLinkId_ = productLinkId_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.ads.googleads.v18.resources.ProductLink result) {
      result.linkedProductCase_ = linkedProductCase_;
      result.linkedProduct_ = this.linkedProduct_;
      if (linkedProductCase_ == 4 &&
          dataPartnerBuilder_ != null) {
        result.linkedProduct_ = dataPartnerBuilder_.build();
      }
      if (linkedProductCase_ == 5 &&
          googleAdsBuilder_ != null) {
        result.linkedProduct_ = googleAdsBuilder_.build();
      }
      if (linkedProductCase_ == 12 &&
          merchantCenterBuilder_ != null) {
        result.linkedProduct_ = merchantCenterBuilder_.build();
      }
      if (linkedProductCase_ == 13 &&
          advertisingPartnerBuilder_ != null) {
        result.linkedProduct_ = advertisingPartnerBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v18.resources.ProductLink) {
        return mergeFrom((com.google.ads.googleads.v18.resources.ProductLink)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v18.resources.ProductLink other) {
      if (other == com.google.ads.googleads.v18.resources.ProductLink.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasProductLinkId()) {
        setProductLinkId(other.getProductLinkId());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      switch (other.getLinkedProductCase()) {
        case DATA_PARTNER: {
          mergeDataPartner(other.getDataPartner());
          break;
        }
        case GOOGLE_ADS: {
          mergeGoogleAds(other.getGoogleAds());
          break;
        }
        case MERCHANT_CENTER: {
          mergeMerchantCenter(other.getMerchantCenter());
          break;
        }
        case ADVERTISING_PARTNER: {
          mergeAdvertisingPartner(other.getAdvertisingPartner());
          break;
        }
        case LINKEDPRODUCT_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 16: {
              productLinkId_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 16
            case 24: {
              type_ = input.readEnum();
              bitField0_ |= 0x00000004;
              break;
            } // case 24
            case 34: {
              input.readMessage(
                  getDataPartnerFieldBuilder().getBuilder(),
                  extensionRegistry);
              linkedProductCase_ = 4;
              break;
            } // case 34
            case 42: {
              input.readMessage(
                  getGoogleAdsFieldBuilder().getBuilder(),
                  extensionRegistry);
              linkedProductCase_ = 5;
              break;
            } // case 42
            case 98: {
              input.readMessage(
                  getMerchantCenterFieldBuilder().getBuilder(),
                  extensionRegistry);
              linkedProductCase_ = 12;
              break;
            } // case 98
            case 106: {
              input.readMessage(
                  getAdvertisingPartnerFieldBuilder().getBuilder(),
                  extensionRegistry);
              linkedProductCase_ = 13;
              break;
            } // case 106
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int linkedProductCase_ = 0;
    private java.lang.Object linkedProduct_;
    public LinkedProductCase
        getLinkedProductCase() {
      return LinkedProductCase.forNumber(
          linkedProductCase_);
    }

    public Builder clearLinkedProduct() {
      linkedProductCase_ = 0;
      linkedProduct_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Immutable. Resource name of the product link.
     * ProductLink resource names have the form:
     *
     * `customers/{customer_id}/productLinks/{product_link_id} `
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. Resource name of the product link.
     * ProductLink resource names have the form:
     *
     * `customers/{customer_id}/productLinks/{product_link_id} `
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. Resource name of the product link.
     * ProductLink resource names have the form:
     *
     * `customers/{customer_id}/productLinks/{product_link_id} `
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. Resource name of the product link.
     * ProductLink resource names have the form:
     *
     * `customers/{customer_id}/productLinks/{product_link_id} `
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. Resource name of the product link.
     * ProductLink resource names have the form:
     *
     * `customers/{customer_id}/productLinks/{product_link_id} `
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long productLinkId_ ;
    /**
     * <pre>
     * Output only. The ID of the link.
     * This field is read only.
     * </pre>
     *
     * <code>optional int64 product_link_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the productLinkId field is set.
     */
    @java.lang.Override
    public boolean hasProductLinkId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Output only. The ID of the link.
     * This field is read only.
     * </pre>
     *
     * <code>optional int64 product_link_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The productLinkId.
     */
    @java.lang.Override
    public long getProductLinkId() {
      return productLinkId_;
    }
    /**
     * <pre>
     * Output only. The ID of the link.
     * This field is read only.
     * </pre>
     *
     * <code>optional int64 product_link_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The productLinkId to set.
     * @return This builder for chaining.
     */
    public Builder setProductLinkId(long value) {

      productLinkId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The ID of the link.
     * This field is read only.
     * </pre>
     *
     * <code>optional int64 product_link_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearProductLinkId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      productLinkId_ = 0L;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Output only. The type of the linked product.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Output only. The type of the linked product.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The type of the linked product.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The type.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType getType() {
      com.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType result = com.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType.forNumber(type_);
      return result == null ? com.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The type of the linked product.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The type of the linked product.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.LinkedProductTypeEnum.LinkedProductType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v18.resources.DataPartnerIdentifier, com.google.ads.googleads.v18.resources.DataPartnerIdentifier.Builder, com.google.ads.googleads.v18.resources.DataPartnerIdentifierOrBuilder> dataPartnerBuilder_;
    /**
     * <pre>
     * Immutable. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.DataPartnerIdentifier data_partner = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return Whether the dataPartner field is set.
     */
    @java.lang.Override
    public boolean hasDataPartner() {
      return linkedProductCase_ == 4;
    }
    /**
     * <pre>
     * Immutable. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.DataPartnerIdentifier data_partner = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The dataPartner.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.resources.DataPartnerIdentifier getDataPartner() {
      if (dataPartnerBuilder_ == null) {
        if (linkedProductCase_ == 4) {
          return (com.google.ads.googleads.v18.resources.DataPartnerIdentifier) linkedProduct_;
        }
        return com.google.ads.googleads.v18.resources.DataPartnerIdentifier.getDefaultInstance();
      } else {
        if (linkedProductCase_ == 4) {
          return dataPartnerBuilder_.getMessage();
        }
        return com.google.ads.googleads.v18.resources.DataPartnerIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.DataPartnerIdentifier data_partner = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setDataPartner(com.google.ads.googleads.v18.resources.DataPartnerIdentifier value) {
      if (dataPartnerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedProduct_ = value;
        onChanged();
      } else {
        dataPartnerBuilder_.setMessage(value);
      }
      linkedProductCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * Immutable. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.DataPartnerIdentifier data_partner = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setDataPartner(
        com.google.ads.googleads.v18.resources.DataPartnerIdentifier.Builder builderForValue) {
      if (dataPartnerBuilder_ == null) {
        linkedProduct_ = builderForValue.build();
        onChanged();
      } else {
        dataPartnerBuilder_.setMessage(builderForValue.build());
      }
      linkedProductCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * Immutable. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.DataPartnerIdentifier data_partner = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder mergeDataPartner(com.google.ads.googleads.v18.resources.DataPartnerIdentifier value) {
      if (dataPartnerBuilder_ == null) {
        if (linkedProductCase_ == 4 &&
            linkedProduct_ != com.google.ads.googleads.v18.resources.DataPartnerIdentifier.getDefaultInstance()) {
          linkedProduct_ = com.google.ads.googleads.v18.resources.DataPartnerIdentifier.newBuilder((com.google.ads.googleads.v18.resources.DataPartnerIdentifier) linkedProduct_)
              .mergeFrom(value).buildPartial();
        } else {
          linkedProduct_ = value;
        }
        onChanged();
      } else {
        if (linkedProductCase_ == 4) {
          dataPartnerBuilder_.mergeFrom(value);
        } else {
          dataPartnerBuilder_.setMessage(value);
        }
      }
      linkedProductCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * Immutable. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.DataPartnerIdentifier data_partner = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder clearDataPartner() {
      if (dataPartnerBuilder_ == null) {
        if (linkedProductCase_ == 4) {
          linkedProductCase_ = 0;
          linkedProduct_ = null;
          onChanged();
        }
      } else {
        if (linkedProductCase_ == 4) {
          linkedProductCase_ = 0;
          linkedProduct_ = null;
        }
        dataPartnerBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Immutable. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.DataPartnerIdentifier data_partner = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public com.google.ads.googleads.v18.resources.DataPartnerIdentifier.Builder getDataPartnerBuilder() {
      return getDataPartnerFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Immutable. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.DataPartnerIdentifier data_partner = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.resources.DataPartnerIdentifierOrBuilder getDataPartnerOrBuilder() {
      if ((linkedProductCase_ == 4) && (dataPartnerBuilder_ != null)) {
        return dataPartnerBuilder_.getMessageOrBuilder();
      } else {
        if (linkedProductCase_ == 4) {
          return (com.google.ads.googleads.v18.resources.DataPartnerIdentifier) linkedProduct_;
        }
        return com.google.ads.googleads.v18.resources.DataPartnerIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.DataPartnerIdentifier data_partner = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v18.resources.DataPartnerIdentifier, com.google.ads.googleads.v18.resources.DataPartnerIdentifier.Builder, com.google.ads.googleads.v18.resources.DataPartnerIdentifierOrBuilder> 
        getDataPartnerFieldBuilder() {
      if (dataPartnerBuilder_ == null) {
        if (!(linkedProductCase_ == 4)) {
          linkedProduct_ = com.google.ads.googleads.v18.resources.DataPartnerIdentifier.getDefaultInstance();
        }
        dataPartnerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v18.resources.DataPartnerIdentifier, com.google.ads.googleads.v18.resources.DataPartnerIdentifier.Builder, com.google.ads.googleads.v18.resources.DataPartnerIdentifierOrBuilder>(
                (com.google.ads.googleads.v18.resources.DataPartnerIdentifier) linkedProduct_,
                getParentForChildren(),
                isClean());
        linkedProduct_ = null;
      }
      linkedProductCase_ = 4;
      onChanged();
      return dataPartnerBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v18.resources.GoogleAdsIdentifier, com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.Builder, com.google.ads.googleads.v18.resources.GoogleAdsIdentifierOrBuilder> googleAdsBuilder_;
    /**
     * <pre>
     * Immutable. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.GoogleAdsIdentifier google_ads = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return Whether the googleAds field is set.
     */
    @java.lang.Override
    public boolean hasGoogleAds() {
      return linkedProductCase_ == 5;
    }
    /**
     * <pre>
     * Immutable. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.GoogleAdsIdentifier google_ads = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The googleAds.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.resources.GoogleAdsIdentifier getGoogleAds() {
      if (googleAdsBuilder_ == null) {
        if (linkedProductCase_ == 5) {
          return (com.google.ads.googleads.v18.resources.GoogleAdsIdentifier) linkedProduct_;
        }
        return com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.getDefaultInstance();
      } else {
        if (linkedProductCase_ == 5) {
          return googleAdsBuilder_.getMessage();
        }
        return com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.GoogleAdsIdentifier google_ads = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setGoogleAds(com.google.ads.googleads.v18.resources.GoogleAdsIdentifier value) {
      if (googleAdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedProduct_ = value;
        onChanged();
      } else {
        googleAdsBuilder_.setMessage(value);
      }
      linkedProductCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Immutable. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.GoogleAdsIdentifier google_ads = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setGoogleAds(
        com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.Builder builderForValue) {
      if (googleAdsBuilder_ == null) {
        linkedProduct_ = builderForValue.build();
        onChanged();
      } else {
        googleAdsBuilder_.setMessage(builderForValue.build());
      }
      linkedProductCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Immutable. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.GoogleAdsIdentifier google_ads = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder mergeGoogleAds(com.google.ads.googleads.v18.resources.GoogleAdsIdentifier value) {
      if (googleAdsBuilder_ == null) {
        if (linkedProductCase_ == 5 &&
            linkedProduct_ != com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.getDefaultInstance()) {
          linkedProduct_ = com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.newBuilder((com.google.ads.googleads.v18.resources.GoogleAdsIdentifier) linkedProduct_)
              .mergeFrom(value).buildPartial();
        } else {
          linkedProduct_ = value;
        }
        onChanged();
      } else {
        if (linkedProductCase_ == 5) {
          googleAdsBuilder_.mergeFrom(value);
        } else {
          googleAdsBuilder_.setMessage(value);
        }
      }
      linkedProductCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Immutable. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.GoogleAdsIdentifier google_ads = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder clearGoogleAds() {
      if (googleAdsBuilder_ == null) {
        if (linkedProductCase_ == 5) {
          linkedProductCase_ = 0;
          linkedProduct_ = null;
          onChanged();
        }
      } else {
        if (linkedProductCase_ == 5) {
          linkedProductCase_ = 0;
          linkedProduct_ = null;
        }
        googleAdsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Immutable. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.GoogleAdsIdentifier google_ads = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.Builder getGoogleAdsBuilder() {
      return getGoogleAdsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Immutable. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.GoogleAdsIdentifier google_ads = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.resources.GoogleAdsIdentifierOrBuilder getGoogleAdsOrBuilder() {
      if ((linkedProductCase_ == 5) && (googleAdsBuilder_ != null)) {
        return googleAdsBuilder_.getMessageOrBuilder();
      } else {
        if (linkedProductCase_ == 5) {
          return (com.google.ads.googleads.v18.resources.GoogleAdsIdentifier) linkedProduct_;
        }
        return com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.GoogleAdsIdentifier google_ads = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v18.resources.GoogleAdsIdentifier, com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.Builder, com.google.ads.googleads.v18.resources.GoogleAdsIdentifierOrBuilder> 
        getGoogleAdsFieldBuilder() {
      if (googleAdsBuilder_ == null) {
        if (!(linkedProductCase_ == 5)) {
          linkedProduct_ = com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.getDefaultInstance();
        }
        googleAdsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v18.resources.GoogleAdsIdentifier, com.google.ads.googleads.v18.resources.GoogleAdsIdentifier.Builder, com.google.ads.googleads.v18.resources.GoogleAdsIdentifierOrBuilder>(
                (com.google.ads.googleads.v18.resources.GoogleAdsIdentifier) linkedProduct_,
                getParentForChildren(),
                isClean());
        linkedProduct_ = null;
      }
      linkedProductCase_ = 5;
      onChanged();
      return googleAdsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v18.resources.MerchantCenterIdentifier, com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.Builder, com.google.ads.googleads.v18.resources.MerchantCenterIdentifierOrBuilder> merchantCenterBuilder_;
    /**
     * <pre>
     * Immutable. Google Merchant Center link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.MerchantCenterIdentifier merchant_center = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return Whether the merchantCenter field is set.
     */
    @java.lang.Override
    public boolean hasMerchantCenter() {
      return linkedProductCase_ == 12;
    }
    /**
     * <pre>
     * Immutable. Google Merchant Center link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.MerchantCenterIdentifier merchant_center = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The merchantCenter.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.resources.MerchantCenterIdentifier getMerchantCenter() {
      if (merchantCenterBuilder_ == null) {
        if (linkedProductCase_ == 12) {
          return (com.google.ads.googleads.v18.resources.MerchantCenterIdentifier) linkedProduct_;
        }
        return com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.getDefaultInstance();
      } else {
        if (linkedProductCase_ == 12) {
          return merchantCenterBuilder_.getMessage();
        }
        return com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. Google Merchant Center link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.MerchantCenterIdentifier merchant_center = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setMerchantCenter(com.google.ads.googleads.v18.resources.MerchantCenterIdentifier value) {
      if (merchantCenterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedProduct_ = value;
        onChanged();
      } else {
        merchantCenterBuilder_.setMessage(value);
      }
      linkedProductCase_ = 12;
      return this;
    }
    /**
     * <pre>
     * Immutable. Google Merchant Center link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.MerchantCenterIdentifier merchant_center = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setMerchantCenter(
        com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.Builder builderForValue) {
      if (merchantCenterBuilder_ == null) {
        linkedProduct_ = builderForValue.build();
        onChanged();
      } else {
        merchantCenterBuilder_.setMessage(builderForValue.build());
      }
      linkedProductCase_ = 12;
      return this;
    }
    /**
     * <pre>
     * Immutable. Google Merchant Center link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.MerchantCenterIdentifier merchant_center = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder mergeMerchantCenter(com.google.ads.googleads.v18.resources.MerchantCenterIdentifier value) {
      if (merchantCenterBuilder_ == null) {
        if (linkedProductCase_ == 12 &&
            linkedProduct_ != com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.getDefaultInstance()) {
          linkedProduct_ = com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.newBuilder((com.google.ads.googleads.v18.resources.MerchantCenterIdentifier) linkedProduct_)
              .mergeFrom(value).buildPartial();
        } else {
          linkedProduct_ = value;
        }
        onChanged();
      } else {
        if (linkedProductCase_ == 12) {
          merchantCenterBuilder_.mergeFrom(value);
        } else {
          merchantCenterBuilder_.setMessage(value);
        }
      }
      linkedProductCase_ = 12;
      return this;
    }
    /**
     * <pre>
     * Immutable. Google Merchant Center link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.MerchantCenterIdentifier merchant_center = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder clearMerchantCenter() {
      if (merchantCenterBuilder_ == null) {
        if (linkedProductCase_ == 12) {
          linkedProductCase_ = 0;
          linkedProduct_ = null;
          onChanged();
        }
      } else {
        if (linkedProductCase_ == 12) {
          linkedProductCase_ = 0;
          linkedProduct_ = null;
        }
        merchantCenterBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Immutable. Google Merchant Center link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.MerchantCenterIdentifier merchant_center = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.Builder getMerchantCenterBuilder() {
      return getMerchantCenterFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Immutable. Google Merchant Center link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.MerchantCenterIdentifier merchant_center = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.resources.MerchantCenterIdentifierOrBuilder getMerchantCenterOrBuilder() {
      if ((linkedProductCase_ == 12) && (merchantCenterBuilder_ != null)) {
        return merchantCenterBuilder_.getMessageOrBuilder();
      } else {
        if (linkedProductCase_ == 12) {
          return (com.google.ads.googleads.v18.resources.MerchantCenterIdentifier) linkedProduct_;
        }
        return com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. Google Merchant Center link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.MerchantCenterIdentifier merchant_center = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v18.resources.MerchantCenterIdentifier, com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.Builder, com.google.ads.googleads.v18.resources.MerchantCenterIdentifierOrBuilder> 
        getMerchantCenterFieldBuilder() {
      if (merchantCenterBuilder_ == null) {
        if (!(linkedProductCase_ == 12)) {
          linkedProduct_ = com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.getDefaultInstance();
        }
        merchantCenterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v18.resources.MerchantCenterIdentifier, com.google.ads.googleads.v18.resources.MerchantCenterIdentifier.Builder, com.google.ads.googleads.v18.resources.MerchantCenterIdentifierOrBuilder>(
                (com.google.ads.googleads.v18.resources.MerchantCenterIdentifier) linkedProduct_,
                getParentForChildren(),
                isClean());
        linkedProduct_ = null;
      }
      linkedProductCase_ = 12;
      onChanged();
      return merchantCenterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier, com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.Builder, com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifierOrBuilder> advertisingPartnerBuilder_;
    /**
     * <pre>
     * Output only. Advertising Partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier advertising_partner = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the advertisingPartner field is set.
     */
    @java.lang.Override
    public boolean hasAdvertisingPartner() {
      return linkedProductCase_ == 13;
    }
    /**
     * <pre>
     * Output only. Advertising Partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier advertising_partner = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The advertisingPartner.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier getAdvertisingPartner() {
      if (advertisingPartnerBuilder_ == null) {
        if (linkedProductCase_ == 13) {
          return (com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier) linkedProduct_;
        }
        return com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.getDefaultInstance();
      } else {
        if (linkedProductCase_ == 13) {
          return advertisingPartnerBuilder_.getMessage();
        }
        return com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Advertising Partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier advertising_partner = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setAdvertisingPartner(com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier value) {
      if (advertisingPartnerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedProduct_ = value;
        onChanged();
      } else {
        advertisingPartnerBuilder_.setMessage(value);
      }
      linkedProductCase_ = 13;
      return this;
    }
    /**
     * <pre>
     * Output only. Advertising Partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier advertising_partner = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setAdvertisingPartner(
        com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.Builder builderForValue) {
      if (advertisingPartnerBuilder_ == null) {
        linkedProduct_ = builderForValue.build();
        onChanged();
      } else {
        advertisingPartnerBuilder_.setMessage(builderForValue.build());
      }
      linkedProductCase_ = 13;
      return this;
    }
    /**
     * <pre>
     * Output only. Advertising Partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier advertising_partner = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeAdvertisingPartner(com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier value) {
      if (advertisingPartnerBuilder_ == null) {
        if (linkedProductCase_ == 13 &&
            linkedProduct_ != com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.getDefaultInstance()) {
          linkedProduct_ = com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.newBuilder((com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier) linkedProduct_)
              .mergeFrom(value).buildPartial();
        } else {
          linkedProduct_ = value;
        }
        onChanged();
      } else {
        if (linkedProductCase_ == 13) {
          advertisingPartnerBuilder_.mergeFrom(value);
        } else {
          advertisingPartnerBuilder_.setMessage(value);
        }
      }
      linkedProductCase_ = 13;
      return this;
    }
    /**
     * <pre>
     * Output only. Advertising Partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier advertising_partner = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearAdvertisingPartner() {
      if (advertisingPartnerBuilder_ == null) {
        if (linkedProductCase_ == 13) {
          linkedProductCase_ = 0;
          linkedProduct_ = null;
          onChanged();
        }
      } else {
        if (linkedProductCase_ == 13) {
          linkedProductCase_ = 0;
          linkedProduct_ = null;
        }
        advertisingPartnerBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Advertising Partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier advertising_partner = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.Builder getAdvertisingPartnerBuilder() {
      return getAdvertisingPartnerFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Advertising Partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier advertising_partner = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifierOrBuilder getAdvertisingPartnerOrBuilder() {
      if ((linkedProductCase_ == 13) && (advertisingPartnerBuilder_ != null)) {
        return advertisingPartnerBuilder_.getMessageOrBuilder();
      } else {
        if (linkedProductCase_ == 13) {
          return (com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier) linkedProduct_;
        }
        return com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Advertising Partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier advertising_partner = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier, com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.Builder, com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifierOrBuilder> 
        getAdvertisingPartnerFieldBuilder() {
      if (advertisingPartnerBuilder_ == null) {
        if (!(linkedProductCase_ == 13)) {
          linkedProduct_ = com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.getDefaultInstance();
        }
        advertisingPartnerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier, com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier.Builder, com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifierOrBuilder>(
                (com.google.ads.googleads.v18.resources.AdvertisingPartnerIdentifier) linkedProduct_,
                getParentForChildren(),
                isClean());
        linkedProduct_ = null;
      }
      linkedProductCase_ = 13;
      onChanged();
      return advertisingPartnerBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v18.resources.ProductLink)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v18.resources.ProductLink)
  private static final com.google.ads.googleads.v18.resources.ProductLink DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v18.resources.ProductLink();
  }

  public static com.google.ads.googleads.v18.resources.ProductLink getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProductLink>
      PARSER = new com.google.protobuf.AbstractParser<ProductLink>() {
    @java.lang.Override
    public ProductLink parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<ProductLink> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProductLink> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v18.resources.ProductLink getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

