/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignBudgetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_BUDGET_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignBudgets/{campaign_budget_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignBudgetId;

    @Deprecated
    protected CampaignBudgetName() {
        this.customerId = null;
        this.campaignBudgetId = null;
    }

    private CampaignBudgetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignBudgetId = (String)Preconditions.checkNotNull((Object)builder.getCampaignBudgetId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignBudgetId() {
        return this.campaignBudgetId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignBudgetName of(String customerId, String campaignBudgetId) {
        return CampaignBudgetName.newBuilder().setCustomerId(customerId).setCampaignBudgetId(campaignBudgetId).build();
    }

    public static String format(String customerId, String campaignBudgetId) {
        return CampaignBudgetName.newBuilder().setCustomerId(customerId).setCampaignBudgetId(campaignBudgetId).build().toString();
    }

    public static CampaignBudgetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_BUDGET_ID.validatedMatch(formattedString, "CampaignBudgetName.parse: formattedString not in valid format");
        return CampaignBudgetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_budget_id"));
    }

    public static List<CampaignBudgetName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignBudgetName> list = new ArrayList<CampaignBudgetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignBudgetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignBudgetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignBudgetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_BUDGET_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignBudgetName campaignBudgetName = this;
            synchronized (campaignBudgetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignBudgetId != null) {
                        fieldMapBuilder.put((Object)"campaign_budget_id", (Object)this.campaignBudgetId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_BUDGET_ID.instantiate(new String[]{"customer_id", this.customerId, "campaign_budget_id", this.campaignBudgetId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CampaignBudgetName that = (CampaignBudgetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignBudgetId, that.campaignBudgetId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.campaignBudgetId);
    }

    public static class Builder {
        private String customerId;
        private String campaignBudgetId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignBudgetId() {
            return this.campaignBudgetId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignBudgetId(String campaignBudgetId) {
            this.campaignBudgetId = campaignBudgetId;
            return this;
        }

        private Builder(CampaignBudgetName campaignBudgetName) {
            this.customerId = campaignBudgetName.customerId;
            this.campaignBudgetId = campaignBudgetName.campaignBudgetId;
        }

        public CampaignBudgetName build() {
            return new CampaignBudgetName(this);
        }
    }
}

