/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProductLinkName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_PRODUCT_LINK_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/productLinks/{product_link_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String productLinkId;

    @Deprecated
    protected ProductLinkName() {
        this.customerId = null;
        this.productLinkId = null;
    }

    private ProductLinkName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.productLinkId = (String)Preconditions.checkNotNull((Object)builder.getProductLinkId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getProductLinkId() {
        return this.productLinkId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProductLinkName of(String customerId, String productLinkId) {
        return ProductLinkName.newBuilder().setCustomerId(customerId).setProductLinkId(productLinkId).build();
    }

    public static String format(String customerId, String productLinkId) {
        return ProductLinkName.newBuilder().setCustomerId(customerId).setProductLinkId(productLinkId).build().toString();
    }

    public static ProductLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_PRODUCT_LINK_ID.validatedMatch(formattedString, "ProductLinkName.parse: formattedString not in valid format");
        return ProductLinkName.of((String)matchMap.get("customer_id"), (String)matchMap.get("product_link_id"));
    }

    public static List<ProductLinkName> parseList(List<String> formattedStrings) {
        ArrayList<ProductLinkName> list = new ArrayList<ProductLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProductLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProductLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProductLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_PRODUCT_LINK_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProductLinkName productLinkName = this;
            synchronized (productLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.productLinkId != null) {
                        fieldMapBuilder.put((Object)"product_link_id", (Object)this.productLinkId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_PRODUCT_LINK_ID.instantiate(new String[]{"customer_id", this.customerId, "product_link_id", this.productLinkId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ProductLinkName that = (ProductLinkName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.productLinkId, that.productLinkId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.productLinkId);
    }

    public static class Builder {
        private String customerId;
        private String productLinkId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getProductLinkId() {
            return this.productLinkId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setProductLinkId(String productLinkId) {
            this.productLinkId = productLinkId;
            return this;
        }

        private Builder(ProductLinkName productLinkName) {
            this.customerId = productLinkName.customerId;
            this.productLinkId = productLinkName.productLinkId;
        }

        public ProductLinkName build() {
            return new ProductLinkName(this);
        }
    }
}

