/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaigns/{campaign_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;

    @Deprecated
    protected CampaignName() {
        this.customerId = null;
        this.campaignId = null;
    }

    private CampaignName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignName of(String customerId, String campaignId) {
        return CampaignName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).build();
    }

    public static String format(String customerId, String campaignId) {
        return CampaignName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).build().toString();
    }

    public static CampaignName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID.validatedMatch(formattedString, "CampaignName.parse: formattedString not in valid format");
        return CampaignName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"));
    }

    public static List<CampaignName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignName> list = new ArrayList<CampaignName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignName campaignName = this;
            synchronized (campaignName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CampaignName that = (CampaignName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.campaignId);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        private Builder(CampaignName campaignName) {
            this.customerId = campaignName.customerId;
            this.campaignId = campaignName.campaignId;
        }

        public CampaignName build() {
            return new CampaignName(this);
        }
    }
}

