/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CurrencyConstantName
implements ResourceName {
    private static final PathTemplate CODE = PathTemplate.createWithoutUrlEncoding((String)"currencyConstants/{code}");
    private volatile Map<String, String> fieldValuesMap;
    private final String code;

    @Deprecated
    protected CurrencyConstantName() {
        this.code = null;
    }

    private CurrencyConstantName(Builder builder) {
        this.code = (String)Preconditions.checkNotNull((Object)builder.getCode());
    }

    public String getCode() {
        return this.code;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CurrencyConstantName of(String code) {
        return CurrencyConstantName.newBuilder().setCode(code).build();
    }

    public static String format(String code) {
        return CurrencyConstantName.newBuilder().setCode(code).build().toString();
    }

    public static CurrencyConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CODE.validatedMatch(formattedString, "CurrencyConstantName.parse: formattedString not in valid format");
        return CurrencyConstantName.of((String)matchMap.get("code"));
    }

    public static List<CurrencyConstantName> parseList(List<String> formattedStrings) {
        ArrayList<CurrencyConstantName> list = new ArrayList<CurrencyConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CurrencyConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CurrencyConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CurrencyConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CODE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CurrencyConstantName currencyConstantName = this;
            synchronized (currencyConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.code != null) {
                        fieldMapBuilder.put((Object)"code", (Object)this.code);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CODE.instantiate(new String[]{"code", this.code});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CurrencyConstantName that = (CurrencyConstantName)o;
            return Objects.equals(this.code, that.code);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.code);
    }

    public static class Builder {
        private String code;

        protected Builder() {
        }

        public String getCode() {
            return this.code;
        }

        public Builder setCode(String code) {
            this.code = code;
            return this;
        }

        private Builder(CurrencyConstantName currencyConstantName) {
            this.code = currencyConstantName.code;
        }

        public CurrencyConstantName build() {
            return new CurrencyConstantName(this);
        }
    }
}

