/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MediaFileName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_MEDIA_FILE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/mediaFiles/{media_file_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String mediaFileId;

    @Deprecated
    protected MediaFileName() {
        this.customerId = null;
        this.mediaFileId = null;
    }

    private MediaFileName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.mediaFileId = (String)Preconditions.checkNotNull((Object)builder.getMediaFileId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getMediaFileId() {
        return this.mediaFileId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MediaFileName of(String customerId, String mediaFileId) {
        return MediaFileName.newBuilder().setCustomerId(customerId).setMediaFileId(mediaFileId).build();
    }

    public static String format(String customerId, String mediaFileId) {
        return MediaFileName.newBuilder().setCustomerId(customerId).setMediaFileId(mediaFileId).build().toString();
    }

    public static MediaFileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_MEDIA_FILE_ID.validatedMatch(formattedString, "MediaFileName.parse: formattedString not in valid format");
        return MediaFileName.of((String)matchMap.get("customer_id"), (String)matchMap.get("media_file_id"));
    }

    public static List<MediaFileName> parseList(List<String> formattedStrings) {
        ArrayList<MediaFileName> list = new ArrayList<MediaFileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MediaFileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MediaFileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MediaFileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_MEDIA_FILE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MediaFileName mediaFileName = this;
            synchronized (mediaFileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.mediaFileId != null) {
                        fieldMapBuilder.put((Object)"media_file_id", (Object)this.mediaFileId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_MEDIA_FILE_ID.instantiate(new String[]{"customer_id", this.customerId, "media_file_id", this.mediaFileId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MediaFileName that = (MediaFileName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.mediaFileId, that.mediaFileId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.mediaFileId);
    }

    public static class Builder {
        private String customerId;
        private String mediaFileId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getMediaFileId() {
            return this.mediaFileId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setMediaFileId(String mediaFileId) {
            this.mediaFileId = mediaFileId;
            return this;
        }

        private Builder(MediaFileName mediaFileName) {
            this.customerId = mediaFileName.customerId;
            this.mediaFileId = mediaFileName.mediaFileId;
        }

        public MediaFileName build() {
            return new MediaFileName(this);
        }
    }
}

