/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserListCustomerTypeName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_USER_LIST_ID_SEMANTIC_LABEL = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/userListCustomerTypes/{user_list_id}~{semantic_label}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String userListId;
    private final String semanticLabel;

    @Deprecated
    protected UserListCustomerTypeName() {
        this.customerId = null;
        this.userListId = null;
        this.semanticLabel = null;
    }

    private UserListCustomerTypeName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.userListId = (String)Preconditions.checkNotNull((Object)builder.getUserListId());
        this.semanticLabel = (String)Preconditions.checkNotNull((Object)builder.getSemanticLabel());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getUserListId() {
        return this.userListId;
    }

    public String getSemanticLabel() {
        return this.semanticLabel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UserListCustomerTypeName of(String customerId, String userListId, String semanticLabel) {
        return UserListCustomerTypeName.newBuilder().setCustomerId(customerId).setUserListId(userListId).setSemanticLabel(semanticLabel).build();
    }

    public static String format(String customerId, String userListId, String semanticLabel) {
        return UserListCustomerTypeName.newBuilder().setCustomerId(customerId).setUserListId(userListId).setSemanticLabel(semanticLabel).build().toString();
    }

    public static UserListCustomerTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_USER_LIST_ID_SEMANTIC_LABEL.validatedMatch(formattedString, "UserListCustomerTypeName.parse: formattedString not in valid format");
        return UserListCustomerTypeName.of((String)matchMap.get("customer_id"), (String)matchMap.get("user_list_id"), (String)matchMap.get("semantic_label"));
    }

    public static List<UserListCustomerTypeName> parseList(List<String> formattedStrings) {
        ArrayList<UserListCustomerTypeName> list = new ArrayList<UserListCustomerTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserListCustomerTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserListCustomerTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserListCustomerTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_USER_LIST_ID_SEMANTIC_LABEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserListCustomerTypeName userListCustomerTypeName = this;
            synchronized (userListCustomerTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.userListId != null) {
                        fieldMapBuilder.put((Object)"user_list_id", (Object)this.userListId);
                    }
                    if (this.semanticLabel != null) {
                        fieldMapBuilder.put((Object)"semantic_label", (Object)this.semanticLabel);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_USER_LIST_ID_SEMANTIC_LABEL.instantiate(new String[]{"customer_id", this.customerId, "user_list_id", this.userListId, "semantic_label", this.semanticLabel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UserListCustomerTypeName that = (UserListCustomerTypeName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.userListId, that.userListId) && Objects.equals(this.semanticLabel, that.semanticLabel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.userListId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.semanticLabel);
    }

    public static class Builder {
        private String customerId;
        private String userListId;
        private String semanticLabel;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getUserListId() {
            return this.userListId;
        }

        public String getSemanticLabel() {
            return this.semanticLabel;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setUserListId(String userListId) {
            this.userListId = userListId;
            return this;
        }

        public Builder setSemanticLabel(String semanticLabel) {
            this.semanticLabel = semanticLabel;
            return this;
        }

        private Builder(UserListCustomerTypeName userListCustomerTypeName) {
            this.customerId = userListCustomerTypeName.customerId;
            this.userListId = userListCustomerTypeName.userListId;
            this.semanticLabel = userListCustomerTypeName.semanticLabel;
        }

        public UserListCustomerTypeName build() {
            return new UserListCustomerTypeName(this);
        }
    }
}

