/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LifeEventName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_LIFE_EVENT_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/lifeEvents/{life_event_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String lifeEventId;

    @Deprecated
    protected LifeEventName() {
        this.customerId = null;
        this.lifeEventId = null;
    }

    private LifeEventName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.lifeEventId = (String)Preconditions.checkNotNull((Object)builder.getLifeEventId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getLifeEventId() {
        return this.lifeEventId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LifeEventName of(String customerId, String lifeEventId) {
        return LifeEventName.newBuilder().setCustomerId(customerId).setLifeEventId(lifeEventId).build();
    }

    public static String format(String customerId, String lifeEventId) {
        return LifeEventName.newBuilder().setCustomerId(customerId).setLifeEventId(lifeEventId).build().toString();
    }

    public static LifeEventName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_LIFE_EVENT_ID.validatedMatch(formattedString, "LifeEventName.parse: formattedString not in valid format");
        return LifeEventName.of((String)matchMap.get("customer_id"), (String)matchMap.get("life_event_id"));
    }

    public static List<LifeEventName> parseList(List<String> formattedStrings) {
        ArrayList<LifeEventName> list = new ArrayList<LifeEventName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LifeEventName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LifeEventName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LifeEventName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_LIFE_EVENT_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LifeEventName lifeEventName = this;
            synchronized (lifeEventName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.lifeEventId != null) {
                        fieldMapBuilder.put((Object)"life_event_id", (Object)this.lifeEventId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_LIFE_EVENT_ID.instantiate(new String[]{"customer_id", this.customerId, "life_event_id", this.lifeEventId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LifeEventName that = (LifeEventName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.lifeEventId, that.lifeEventId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.lifeEventId);
    }

    public static class Builder {
        private String customerId;
        private String lifeEventId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getLifeEventId() {
            return this.lifeEventId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setLifeEventId(String lifeEventId) {
            this.lifeEventId = lifeEventId;
            return this;
        }

        private Builder(LifeEventName lifeEventName) {
            this.customerId = lifeEventName.customerId;
            this.lifeEventId = lifeEventName.lifeEventId;
        }

        public LifeEventName build() {
            return new LifeEventName(this);
        }
    }
}

