/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.services;

import com.google.ads.googleads.v18.services.FeedOperation;
import com.google.ads.googleads.v18.services.FeedServiceSettings;
import com.google.ads.googleads.v18.services.MutateFeedsRequest;
import com.google.ads.googleads.v18.services.MutateFeedsResponse;
import com.google.ads.googleads.v18.services.stub.FeedServiceStub;
import com.google.ads.googleads.v18.services.stub.FeedServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FeedServiceClient
implements BackgroundResource {
    private final FeedServiceSettings settings;
    private final FeedServiceStub stub;

    public static final FeedServiceClient create() throws IOException {
        return FeedServiceClient.create(FeedServiceSettings.newBuilder().build());
    }

    public static final FeedServiceClient create(FeedServiceSettings settings) throws IOException {
        return new FeedServiceClient(settings);
    }

    public static final FeedServiceClient create(FeedServiceStub stub) {
        return new FeedServiceClient(stub);
    }

    protected FeedServiceClient(FeedServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FeedServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected FeedServiceClient(FeedServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FeedServiceSettings getSettings() {
        return this.settings;
    }

    public FeedServiceStub getStub() {
        return this.stub;
    }

    public final MutateFeedsResponse mutateFeeds(String customerId, List<FeedOperation> operations) {
        MutateFeedsRequest request = MutateFeedsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateFeeds(request);
    }

    public final MutateFeedsResponse mutateFeeds(MutateFeedsRequest request) {
        return (MutateFeedsResponse)this.mutateFeedsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateFeedsRequest, MutateFeedsResponse> mutateFeedsCallable() {
        return this.stub.mutateFeedsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

