/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ASSET_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/assets/{asset_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String assetId;

    @Deprecated
    protected AssetName() {
        this.customerId = null;
        this.assetId = null;
    }

    private AssetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.assetId = (String)Preconditions.checkNotNull((Object)builder.getAssetId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetName of(String customerId, String assetId) {
        return AssetName.newBuilder().setCustomerId(customerId).setAssetId(assetId).build();
    }

    public static String format(String customerId, String assetId) {
        return AssetName.newBuilder().setCustomerId(customerId).setAssetId(assetId).build().toString();
    }

    public static AssetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ASSET_ID.validatedMatch(formattedString, "AssetName.parse: formattedString not in valid format");
        return AssetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("asset_id"));
    }

    public static List<AssetName> parseList(List<String> formattedStrings) {
        ArrayList<AssetName> list = new ArrayList<AssetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ASSET_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetName assetName = this;
            synchronized (assetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.assetId != null) {
                        fieldMapBuilder.put((Object)"asset_id", (Object)this.assetId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ASSET_ID.instantiate(new String[]{"customer_id", this.customerId, "asset_id", this.assetId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AssetName that = (AssetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.assetId, that.assetId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assetId);
    }

    public static class Builder {
        private String customerId;
        private String assetId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAssetId() {
            return this.assetId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAssetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        private Builder(AssetName assetName) {
            this.customerId = assetName.customerId;
            this.assetId = assetName.assetId;
        }

        public AssetName build() {
            return new AssetName(this);
        }
    }
}

