/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OfflineConversionUploadConversionActionSummaryName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CONVERSION_TYPE_ID_CLIENT = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/offlineConversionUploadConversionActionSummaries/{conversion_type_id}~{client}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String conversionTypeId;
    private final String client;

    @Deprecated
    protected OfflineConversionUploadConversionActionSummaryName() {
        this.customerId = null;
        this.conversionTypeId = null;
        this.client = null;
    }

    private OfflineConversionUploadConversionActionSummaryName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.conversionTypeId = (String)Preconditions.checkNotNull((Object)builder.getConversionTypeId());
        this.client = (String)Preconditions.checkNotNull((Object)builder.getClient());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getConversionTypeId() {
        return this.conversionTypeId;
    }

    public String getClient() {
        return this.client;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OfflineConversionUploadConversionActionSummaryName of(String customerId, String conversionTypeId, String client) {
        return OfflineConversionUploadConversionActionSummaryName.newBuilder().setCustomerId(customerId).setConversionTypeId(conversionTypeId).setClient(client).build();
    }

    public static String format(String customerId, String conversionTypeId, String client) {
        return OfflineConversionUploadConversionActionSummaryName.newBuilder().setCustomerId(customerId).setConversionTypeId(conversionTypeId).setClient(client).build().toString();
    }

    public static OfflineConversionUploadConversionActionSummaryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CONVERSION_TYPE_ID_CLIENT.validatedMatch(formattedString, "OfflineConversionUploadConversionActionSummaryName.parse: formattedString not in valid format");
        return OfflineConversionUploadConversionActionSummaryName.of((String)matchMap.get("customer_id"), (String)matchMap.get("conversion_type_id"), (String)matchMap.get("client"));
    }

    public static List<OfflineConversionUploadConversionActionSummaryName> parseList(List<String> formattedStrings) {
        ArrayList<OfflineConversionUploadConversionActionSummaryName> list = new ArrayList<OfflineConversionUploadConversionActionSummaryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OfflineConversionUploadConversionActionSummaryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OfflineConversionUploadConversionActionSummaryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OfflineConversionUploadConversionActionSummaryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CONVERSION_TYPE_ID_CLIENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OfflineConversionUploadConversionActionSummaryName offlineConversionUploadConversionActionSummaryName = this;
            synchronized (offlineConversionUploadConversionActionSummaryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.conversionTypeId != null) {
                        fieldMapBuilder.put((Object)"conversion_type_id", (Object)this.conversionTypeId);
                    }
                    if (this.client != null) {
                        fieldMapBuilder.put((Object)"client", (Object)this.client);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CONVERSION_TYPE_ID_CLIENT.instantiate(new String[]{"customer_id", this.customerId, "conversion_type_id", this.conversionTypeId, "client", this.client});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OfflineConversionUploadConversionActionSummaryName that = (OfflineConversionUploadConversionActionSummaryName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.conversionTypeId, that.conversionTypeId) && Objects.equals(this.client, that.client);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversionTypeId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.client);
    }

    public static class Builder {
        private String customerId;
        private String conversionTypeId;
        private String client;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getConversionTypeId() {
            return this.conversionTypeId;
        }

        public String getClient() {
            return this.client;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setConversionTypeId(String conversionTypeId) {
            this.conversionTypeId = conversionTypeId;
            return this;
        }

        public Builder setClient(String client) {
            this.client = client;
            return this;
        }

        private Builder(OfflineConversionUploadConversionActionSummaryName offlineConversionUploadConversionActionSummaryName) {
            this.customerId = offlineConversionUploadConversionActionSummaryName.customerId;
            this.conversionTypeId = offlineConversionUploadConversionActionSummaryName.conversionTypeId;
            this.client = offlineConversionUploadConversionActionSummaryName.client;
        }

        public OfflineConversionUploadConversionActionSummaryName build() {
            return new OfflineConversionUploadConversionActionSummaryName(this);
        }
    }
}

