/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.services;

import com.google.ads.googleads.v18.common.HistoricalMetricsOptions;
import com.google.ads.googleads.v18.common.HistoricalMetricsOptionsOrBuilder;
import com.google.ads.googleads.v18.common.KeywordPlanAggregateMetrics;
import com.google.ads.googleads.v18.common.KeywordPlanAggregateMetricsOrBuilder;
import com.google.ads.googleads.v18.enums.KeywordPlanNetworkEnum;
import com.google.ads.googleads.v18.services.GenerateKeywordHistoricalMetricsRequestOrBuilder;
import com.google.ads.googleads.v18.services.KeywordPlanIdeaServiceProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public final class GenerateKeywordHistoricalMetricsRequest
extends GeneratedMessageV3
implements GenerateKeywordHistoricalMetricsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int CUSTOMER_ID_FIELD_NUMBER = 1;
    private volatile Object customerId_ = "";
    public static final int KEYWORDS_FIELD_NUMBER = 2;
    private LazyStringArrayList keywords_ = LazyStringArrayList.emptyList();
    public static final int LANGUAGE_FIELD_NUMBER = 4;
    private volatile Object language_ = "";
    public static final int INCLUDE_ADULT_KEYWORDS_FIELD_NUMBER = 5;
    private boolean includeAdultKeywords_ = false;
    public static final int GEO_TARGET_CONSTANTS_FIELD_NUMBER = 6;
    private LazyStringArrayList geoTargetConstants_ = LazyStringArrayList.emptyList();
    public static final int KEYWORD_PLAN_NETWORK_FIELD_NUMBER = 7;
    private int keywordPlanNetwork_ = 0;
    public static final int AGGREGATE_METRICS_FIELD_NUMBER = 8;
    private KeywordPlanAggregateMetrics aggregateMetrics_;
    public static final int HISTORICAL_METRICS_OPTIONS_FIELD_NUMBER = 3;
    private HistoricalMetricsOptions historicalMetricsOptions_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final GenerateKeywordHistoricalMetricsRequest DEFAULT_INSTANCE = new GenerateKeywordHistoricalMetricsRequest();
    private static final Parser<GenerateKeywordHistoricalMetricsRequest> PARSER = new AbstractParser<GenerateKeywordHistoricalMetricsRequest>(){

        public GenerateKeywordHistoricalMetricsRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = GenerateKeywordHistoricalMetricsRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private GenerateKeywordHistoricalMetricsRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private GenerateKeywordHistoricalMetricsRequest() {
        this.customerId_ = "";
        this.keywords_ = LazyStringArrayList.emptyList();
        this.language_ = "";
        this.geoTargetConstants_ = LazyStringArrayList.emptyList();
        this.keywordPlanNetwork_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new GenerateKeywordHistoricalMetricsRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return KeywordPlanIdeaServiceProto.internal_static_google_ads_googleads_v18_services_GenerateKeywordHistoricalMetricsRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return KeywordPlanIdeaServiceProto.internal_static_google_ads_googleads_v18_services_GenerateKeywordHistoricalMetricsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateKeywordHistoricalMetricsRequest.class, Builder.class);
    }

    @Override
    public String getCustomerId() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.customerId_ = s;
        return s;
    }

    @Override
    public ByteString getCustomerIdBytes() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.customerId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getKeywordsList() {
        return this.keywords_;
    }

    @Override
    public int getKeywordsCount() {
        return this.keywords_.size();
    }

    @Override
    public String getKeywords(int index) {
        return this.keywords_.get(index);
    }

    @Override
    public ByteString getKeywordsBytes(int index) {
        return this.keywords_.getByteString(index);
    }

    @Override
    public boolean hasLanguage() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getLanguage() {
        Object ref = this.language_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.language_ = s;
        return s;
    }

    @Override
    public ByteString getLanguageBytes() {
        Object ref = this.language_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.language_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean getIncludeAdultKeywords() {
        return this.includeAdultKeywords_;
    }

    public ProtocolStringList getGeoTargetConstantsList() {
        return this.geoTargetConstants_;
    }

    @Override
    public int getGeoTargetConstantsCount() {
        return this.geoTargetConstants_.size();
    }

    @Override
    public String getGeoTargetConstants(int index) {
        return this.geoTargetConstants_.get(index);
    }

    @Override
    public ByteString getGeoTargetConstantsBytes(int index) {
        return this.geoTargetConstants_.getByteString(index);
    }

    @Override
    public int getKeywordPlanNetworkValue() {
        return this.keywordPlanNetwork_;
    }

    @Override
    public KeywordPlanNetworkEnum.KeywordPlanNetwork getKeywordPlanNetwork() {
        KeywordPlanNetworkEnum.KeywordPlanNetwork result = KeywordPlanNetworkEnum.KeywordPlanNetwork.forNumber(this.keywordPlanNetwork_);
        return result == null ? KeywordPlanNetworkEnum.KeywordPlanNetwork.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasAggregateMetrics() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public KeywordPlanAggregateMetrics getAggregateMetrics() {
        return this.aggregateMetrics_ == null ? KeywordPlanAggregateMetrics.getDefaultInstance() : this.aggregateMetrics_;
    }

    @Override
    public KeywordPlanAggregateMetricsOrBuilder getAggregateMetricsOrBuilder() {
        return this.aggregateMetrics_ == null ? KeywordPlanAggregateMetrics.getDefaultInstance() : this.aggregateMetrics_;
    }

    @Override
    public boolean hasHistoricalMetricsOptions() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public HistoricalMetricsOptions getHistoricalMetricsOptions() {
        return this.historicalMetricsOptions_ == null ? HistoricalMetricsOptions.getDefaultInstance() : this.historicalMetricsOptions_;
    }

    @Override
    public HistoricalMetricsOptionsOrBuilder getHistoricalMetricsOptionsOrBuilder() {
        return this.historicalMetricsOptions_ == null ? HistoricalMetricsOptions.getDefaultInstance() : this.historicalMetricsOptions_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.customerId_);
        }
        for (i = 0; i < this.keywords_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.keywords_.getRaw(i));
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(3, (MessageLite)this.getHistoricalMetricsOptions());
        }
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.language_);
        }
        if (this.includeAdultKeywords_) {
            output.writeBool(5, this.includeAdultKeywords_);
        }
        for (i = 0; i < this.geoTargetConstants_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.geoTargetConstants_.getRaw(i));
        }
        if (this.keywordPlanNetwork_ != KeywordPlanNetworkEnum.KeywordPlanNetwork.UNSPECIFIED.getNumber()) {
            output.writeEnum(7, this.keywordPlanNetwork_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(8, (MessageLite)this.getAggregateMetrics());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.customerId_);
        }
        int dataSize = 0;
        for (i = 0; i < this.keywords_.size(); ++i) {
            dataSize += GenerateKeywordHistoricalMetricsRequest.computeStringSizeNoTag((Object)this.keywords_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getKeywordsList().size();
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getHistoricalMetricsOptions());
        }
        if ((this.bitField0_ & 1) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.language_);
        }
        if (this.includeAdultKeywords_) {
            size += CodedOutputStream.computeBoolSize((int)5, (boolean)this.includeAdultKeywords_);
        }
        dataSize = 0;
        for (i = 0; i < this.geoTargetConstants_.size(); ++i) {
            dataSize += GenerateKeywordHistoricalMetricsRequest.computeStringSizeNoTag((Object)this.geoTargetConstants_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getGeoTargetConstantsList().size();
        if (this.keywordPlanNetwork_ != KeywordPlanNetworkEnum.KeywordPlanNetwork.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)7, (int)this.keywordPlanNetwork_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getAggregateMetrics());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GenerateKeywordHistoricalMetricsRequest)) {
            return super.equals(obj);
        }
        GenerateKeywordHistoricalMetricsRequest other = (GenerateKeywordHistoricalMetricsRequest)obj;
        if (!this.getCustomerId().equals(other.getCustomerId())) {
            return false;
        }
        if (!this.getKeywordsList().equals(other.getKeywordsList())) {
            return false;
        }
        if (this.hasLanguage() != other.hasLanguage()) {
            return false;
        }
        if (this.hasLanguage() && !this.getLanguage().equals(other.getLanguage())) {
            return false;
        }
        if (this.getIncludeAdultKeywords() != other.getIncludeAdultKeywords()) {
            return false;
        }
        if (!this.getGeoTargetConstantsList().equals(other.getGeoTargetConstantsList())) {
            return false;
        }
        if (this.keywordPlanNetwork_ != other.keywordPlanNetwork_) {
            return false;
        }
        if (this.hasAggregateMetrics() != other.hasAggregateMetrics()) {
            return false;
        }
        if (this.hasAggregateMetrics() && !this.getAggregateMetrics().equals(other.getAggregateMetrics())) {
            return false;
        }
        if (this.hasHistoricalMetricsOptions() != other.hasHistoricalMetricsOptions()) {
            return false;
        }
        if (this.hasHistoricalMetricsOptions() && !this.getHistoricalMetricsOptions().equals(other.getHistoricalMetricsOptions())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + GenerateKeywordHistoricalMetricsRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCustomerId().hashCode();
        if (this.getKeywordsCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getKeywordsList().hashCode();
        }
        if (this.hasLanguage()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getLanguage().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIncludeAdultKeywords());
        if (this.getGeoTargetConstantsCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getGeoTargetConstantsList().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + this.keywordPlanNetwork_;
        if (this.hasAggregateMetrics()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getAggregateMetrics().hashCode();
        }
        if (this.hasHistoricalMetricsOptions()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getHistoricalMetricsOptions().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static GenerateKeywordHistoricalMetricsRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (GenerateKeywordHistoricalMetricsRequest)PARSER.parseFrom(data);
    }

    public static GenerateKeywordHistoricalMetricsRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateKeywordHistoricalMetricsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateKeywordHistoricalMetricsRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (GenerateKeywordHistoricalMetricsRequest)PARSER.parseFrom(data);
    }

    public static GenerateKeywordHistoricalMetricsRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateKeywordHistoricalMetricsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateKeywordHistoricalMetricsRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (GenerateKeywordHistoricalMetricsRequest)PARSER.parseFrom(data);
    }

    public static GenerateKeywordHistoricalMetricsRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateKeywordHistoricalMetricsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateKeywordHistoricalMetricsRequest parseFrom(InputStream input) throws IOException {
        return (GenerateKeywordHistoricalMetricsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateKeywordHistoricalMetricsRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateKeywordHistoricalMetricsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateKeywordHistoricalMetricsRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (GenerateKeywordHistoricalMetricsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateKeywordHistoricalMetricsRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateKeywordHistoricalMetricsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateKeywordHistoricalMetricsRequest parseFrom(CodedInputStream input) throws IOException {
        return (GenerateKeywordHistoricalMetricsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static GenerateKeywordHistoricalMetricsRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateKeywordHistoricalMetricsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return GenerateKeywordHistoricalMetricsRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GenerateKeywordHistoricalMetricsRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static GenerateKeywordHistoricalMetricsRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<GenerateKeywordHistoricalMetricsRequest> parser() {
        return PARSER;
    }

    public Parser<GenerateKeywordHistoricalMetricsRequest> getParserForType() {
        return PARSER;
    }

    public GenerateKeywordHistoricalMetricsRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements GenerateKeywordHistoricalMetricsRequestOrBuilder {
        private int bitField0_;
        private Object customerId_ = "";
        private LazyStringArrayList keywords_ = LazyStringArrayList.emptyList();
        private Object language_ = "";
        private boolean includeAdultKeywords_;
        private LazyStringArrayList geoTargetConstants_ = LazyStringArrayList.emptyList();
        private int keywordPlanNetwork_ = 0;
        private KeywordPlanAggregateMetrics aggregateMetrics_;
        private SingleFieldBuilderV3<KeywordPlanAggregateMetrics, KeywordPlanAggregateMetrics.Builder, KeywordPlanAggregateMetricsOrBuilder> aggregateMetricsBuilder_;
        private HistoricalMetricsOptions historicalMetricsOptions_;
        private SingleFieldBuilderV3<HistoricalMetricsOptions, HistoricalMetricsOptions.Builder, HistoricalMetricsOptionsOrBuilder> historicalMetricsOptionsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return KeywordPlanIdeaServiceProto.internal_static_google_ads_googleads_v18_services_GenerateKeywordHistoricalMetricsRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return KeywordPlanIdeaServiceProto.internal_static_google_ads_googleads_v18_services_GenerateKeywordHistoricalMetricsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateKeywordHistoricalMetricsRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getAggregateMetricsFieldBuilder();
                this.getHistoricalMetricsOptionsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.customerId_ = "";
            this.keywords_ = LazyStringArrayList.emptyList();
            this.language_ = "";
            this.includeAdultKeywords_ = false;
            this.geoTargetConstants_ = LazyStringArrayList.emptyList();
            this.keywordPlanNetwork_ = 0;
            this.aggregateMetrics_ = null;
            if (this.aggregateMetricsBuilder_ != null) {
                this.aggregateMetricsBuilder_.dispose();
                this.aggregateMetricsBuilder_ = null;
            }
            this.historicalMetricsOptions_ = null;
            if (this.historicalMetricsOptionsBuilder_ != null) {
                this.historicalMetricsOptionsBuilder_.dispose();
                this.historicalMetricsOptionsBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return KeywordPlanIdeaServiceProto.internal_static_google_ads_googleads_v18_services_GenerateKeywordHistoricalMetricsRequest_descriptor;
        }

        public GenerateKeywordHistoricalMetricsRequest getDefaultInstanceForType() {
            return GenerateKeywordHistoricalMetricsRequest.getDefaultInstance();
        }

        public GenerateKeywordHistoricalMetricsRequest build() {
            GenerateKeywordHistoricalMetricsRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public GenerateKeywordHistoricalMetricsRequest buildPartial() {
            GenerateKeywordHistoricalMetricsRequest result = new GenerateKeywordHistoricalMetricsRequest(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(GenerateKeywordHistoricalMetricsRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.customerId_ = this.customerId_;
            }
            if ((from_bitField0_ & 2) != 0) {
                this.keywords_.makeImmutable();
                result.keywords_ = this.keywords_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 4) != 0) {
                result.language_ = this.language_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.includeAdultKeywords_ = this.includeAdultKeywords_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                this.geoTargetConstants_.makeImmutable();
                result.geoTargetConstants_ = this.geoTargetConstants_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.keywordPlanNetwork_ = this.keywordPlanNetwork_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.aggregateMetrics_ = this.aggregateMetricsBuilder_ == null ? this.aggregateMetrics_ : (KeywordPlanAggregateMetrics)this.aggregateMetricsBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.historicalMetricsOptions_ = this.historicalMetricsOptionsBuilder_ == null ? this.historicalMetricsOptions_ : (HistoricalMetricsOptions)this.historicalMetricsOptionsBuilder_.build();
                to_bitField0_ |= 4;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof GenerateKeywordHistoricalMetricsRequest) {
                return this.mergeFrom((GenerateKeywordHistoricalMetricsRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(GenerateKeywordHistoricalMetricsRequest other) {
            if (other == GenerateKeywordHistoricalMetricsRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getCustomerId().isEmpty()) {
                this.customerId_ = other.customerId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.keywords_.isEmpty()) {
                if (this.keywords_.isEmpty()) {
                    this.keywords_ = other.keywords_;
                    this.bitField0_ |= 2;
                } else {
                    this.ensureKeywordsIsMutable();
                    this.keywords_.addAll((Collection)other.keywords_);
                }
                this.onChanged();
            }
            if (other.hasLanguage()) {
                this.language_ = other.language_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (other.getIncludeAdultKeywords()) {
                this.setIncludeAdultKeywords(other.getIncludeAdultKeywords());
            }
            if (!other.geoTargetConstants_.isEmpty()) {
                if (this.geoTargetConstants_.isEmpty()) {
                    this.geoTargetConstants_ = other.geoTargetConstants_;
                    this.bitField0_ |= 0x10;
                } else {
                    this.ensureGeoTargetConstantsIsMutable();
                    this.geoTargetConstants_.addAll((Collection)other.geoTargetConstants_);
                }
                this.onChanged();
            }
            if (other.keywordPlanNetwork_ != 0) {
                this.setKeywordPlanNetworkValue(other.getKeywordPlanNetworkValue());
            }
            if (other.hasAggregateMetrics()) {
                this.mergeAggregateMetrics(other.getAggregateMetrics());
            }
            if (other.hasHistoricalMetricsOptions()) {
                this.mergeHistoricalMetricsOptions(other.getHistoricalMetricsOptions());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block16: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block16;
                        }
                        case 10: {
                            this.customerId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block16;
                        }
                        case 18: {
                            String s = input.readStringRequireUtf8();
                            this.ensureKeywordsIsMutable();
                            this.keywords_.add((Object)s);
                            continue block16;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getHistoricalMetricsOptionsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block16;
                        }
                        case 34: {
                            this.language_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block16;
                        }
                        case 40: {
                            this.includeAdultKeywords_ = input.readBool();
                            this.bitField0_ |= 8;
                            continue block16;
                        }
                        case 50: {
                            String s = input.readStringRequireUtf8();
                            this.ensureGeoTargetConstantsIsMutable();
                            this.geoTargetConstants_.add((Object)s);
                            continue block16;
                        }
                        case 56: {
                            this.keywordPlanNetwork_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block16;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getAggregateMetricsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block16;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getCustomerId() {
            Object ref = this.customerId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.customerId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCustomerIdBytes() {
            Object ref = this.customerId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customerId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCustomerId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearCustomerId() {
            this.customerId_ = GenerateKeywordHistoricalMetricsRequest.getDefaultInstance().getCustomerId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setCustomerIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateKeywordHistoricalMetricsRequest.checkByteStringIsUtf8((ByteString)value);
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureKeywordsIsMutable() {
            if (!this.keywords_.isModifiable()) {
                this.keywords_ = new LazyStringArrayList((LazyStringList)this.keywords_);
            }
            this.bitField0_ |= 2;
        }

        public ProtocolStringList getKeywordsList() {
            this.keywords_.makeImmutable();
            return this.keywords_;
        }

        @Override
        public int getKeywordsCount() {
            return this.keywords_.size();
        }

        @Override
        public String getKeywords(int index) {
            return this.keywords_.get(index);
        }

        @Override
        public ByteString getKeywordsBytes(int index) {
            return this.keywords_.getByteString(index);
        }

        public Builder setKeywords(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureKeywordsIsMutable();
            this.keywords_.set(index, value);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder addKeywords(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureKeywordsIsMutable();
            this.keywords_.add((Object)value);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder addAllKeywords(Iterable<String> values) {
            this.ensureKeywordsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.keywords_);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearKeywords() {
            this.keywords_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder addKeywordsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateKeywordHistoricalMetricsRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensureKeywordsIsMutable();
            this.keywords_.add(value);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLanguage() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public String getLanguage() {
            Object ref = this.language_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.language_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLanguageBytes() {
            Object ref = this.language_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.language_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLanguage(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.language_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearLanguage() {
            this.language_ = GenerateKeywordHistoricalMetricsRequest.getDefaultInstance().getLanguage();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setLanguageBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateKeywordHistoricalMetricsRequest.checkByteStringIsUtf8((ByteString)value);
            this.language_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getIncludeAdultKeywords() {
            return this.includeAdultKeywords_;
        }

        public Builder setIncludeAdultKeywords(boolean value) {
            this.includeAdultKeywords_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearIncludeAdultKeywords() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.includeAdultKeywords_ = false;
            this.onChanged();
            return this;
        }

        private void ensureGeoTargetConstantsIsMutable() {
            if (!this.geoTargetConstants_.isModifiable()) {
                this.geoTargetConstants_ = new LazyStringArrayList((LazyStringList)this.geoTargetConstants_);
            }
            this.bitField0_ |= 0x10;
        }

        public ProtocolStringList getGeoTargetConstantsList() {
            this.geoTargetConstants_.makeImmutable();
            return this.geoTargetConstants_;
        }

        @Override
        public int getGeoTargetConstantsCount() {
            return this.geoTargetConstants_.size();
        }

        @Override
        public String getGeoTargetConstants(int index) {
            return this.geoTargetConstants_.get(index);
        }

        @Override
        public ByteString getGeoTargetConstantsBytes(int index) {
            return this.geoTargetConstants_.getByteString(index);
        }

        public Builder setGeoTargetConstants(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureGeoTargetConstantsIsMutable();
            this.geoTargetConstants_.set(index, value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addGeoTargetConstants(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureGeoTargetConstantsIsMutable();
            this.geoTargetConstants_.add((Object)value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addAllGeoTargetConstants(Iterable<String> values) {
            this.ensureGeoTargetConstantsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.geoTargetConstants_);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearGeoTargetConstants() {
            this.geoTargetConstants_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder addGeoTargetConstantsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateKeywordHistoricalMetricsRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensureGeoTargetConstantsIsMutable();
            this.geoTargetConstants_.add(value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public int getKeywordPlanNetworkValue() {
            return this.keywordPlanNetwork_;
        }

        public Builder setKeywordPlanNetworkValue(int value) {
            this.keywordPlanNetwork_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public KeywordPlanNetworkEnum.KeywordPlanNetwork getKeywordPlanNetwork() {
            KeywordPlanNetworkEnum.KeywordPlanNetwork result = KeywordPlanNetworkEnum.KeywordPlanNetwork.forNumber(this.keywordPlanNetwork_);
            return result == null ? KeywordPlanNetworkEnum.KeywordPlanNetwork.UNRECOGNIZED : result;
        }

        public Builder setKeywordPlanNetwork(KeywordPlanNetworkEnum.KeywordPlanNetwork value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.keywordPlanNetwork_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearKeywordPlanNetwork() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.keywordPlanNetwork_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAggregateMetrics() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public KeywordPlanAggregateMetrics getAggregateMetrics() {
            if (this.aggregateMetricsBuilder_ == null) {
                return this.aggregateMetrics_ == null ? KeywordPlanAggregateMetrics.getDefaultInstance() : this.aggregateMetrics_;
            }
            return (KeywordPlanAggregateMetrics)this.aggregateMetricsBuilder_.getMessage();
        }

        public Builder setAggregateMetrics(KeywordPlanAggregateMetrics value) {
            if (this.aggregateMetricsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.aggregateMetrics_ = value;
            } else {
                this.aggregateMetricsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setAggregateMetrics(KeywordPlanAggregateMetrics.Builder builderForValue) {
            if (this.aggregateMetricsBuilder_ == null) {
                this.aggregateMetrics_ = builderForValue.build();
            } else {
                this.aggregateMetricsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeAggregateMetrics(KeywordPlanAggregateMetrics value) {
            if (this.aggregateMetricsBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.aggregateMetrics_ != null && this.aggregateMetrics_ != KeywordPlanAggregateMetrics.getDefaultInstance()) {
                    this.getAggregateMetricsBuilder().mergeFrom(value);
                } else {
                    this.aggregateMetrics_ = value;
                }
            } else {
                this.aggregateMetricsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.aggregateMetrics_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearAggregateMetrics() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.aggregateMetrics_ = null;
            if (this.aggregateMetricsBuilder_ != null) {
                this.aggregateMetricsBuilder_.dispose();
                this.aggregateMetricsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public KeywordPlanAggregateMetrics.Builder getAggregateMetricsBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (KeywordPlanAggregateMetrics.Builder)this.getAggregateMetricsFieldBuilder().getBuilder();
        }

        @Override
        public KeywordPlanAggregateMetricsOrBuilder getAggregateMetricsOrBuilder() {
            if (this.aggregateMetricsBuilder_ != null) {
                return (KeywordPlanAggregateMetricsOrBuilder)this.aggregateMetricsBuilder_.getMessageOrBuilder();
            }
            return this.aggregateMetrics_ == null ? KeywordPlanAggregateMetrics.getDefaultInstance() : this.aggregateMetrics_;
        }

        private SingleFieldBuilderV3<KeywordPlanAggregateMetrics, KeywordPlanAggregateMetrics.Builder, KeywordPlanAggregateMetricsOrBuilder> getAggregateMetricsFieldBuilder() {
            if (this.aggregateMetricsBuilder_ == null) {
                this.aggregateMetricsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAggregateMetrics(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.aggregateMetrics_ = null;
            }
            return this.aggregateMetricsBuilder_;
        }

        @Override
        public boolean hasHistoricalMetricsOptions() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public HistoricalMetricsOptions getHistoricalMetricsOptions() {
            if (this.historicalMetricsOptionsBuilder_ == null) {
                return this.historicalMetricsOptions_ == null ? HistoricalMetricsOptions.getDefaultInstance() : this.historicalMetricsOptions_;
            }
            return (HistoricalMetricsOptions)this.historicalMetricsOptionsBuilder_.getMessage();
        }

        public Builder setHistoricalMetricsOptions(HistoricalMetricsOptions value) {
            if (this.historicalMetricsOptionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.historicalMetricsOptions_ = value;
            } else {
                this.historicalMetricsOptionsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setHistoricalMetricsOptions(HistoricalMetricsOptions.Builder builderForValue) {
            if (this.historicalMetricsOptionsBuilder_ == null) {
                this.historicalMetricsOptions_ = builderForValue.build();
            } else {
                this.historicalMetricsOptionsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeHistoricalMetricsOptions(HistoricalMetricsOptions value) {
            if (this.historicalMetricsOptionsBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.historicalMetricsOptions_ != null && this.historicalMetricsOptions_ != HistoricalMetricsOptions.getDefaultInstance()) {
                    this.getHistoricalMetricsOptionsBuilder().mergeFrom(value);
                } else {
                    this.historicalMetricsOptions_ = value;
                }
            } else {
                this.historicalMetricsOptionsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.historicalMetricsOptions_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearHistoricalMetricsOptions() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.historicalMetricsOptions_ = null;
            if (this.historicalMetricsOptionsBuilder_ != null) {
                this.historicalMetricsOptionsBuilder_.dispose();
                this.historicalMetricsOptionsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public HistoricalMetricsOptions.Builder getHistoricalMetricsOptionsBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (HistoricalMetricsOptions.Builder)this.getHistoricalMetricsOptionsFieldBuilder().getBuilder();
        }

        @Override
        public HistoricalMetricsOptionsOrBuilder getHistoricalMetricsOptionsOrBuilder() {
            if (this.historicalMetricsOptionsBuilder_ != null) {
                return (HistoricalMetricsOptionsOrBuilder)this.historicalMetricsOptionsBuilder_.getMessageOrBuilder();
            }
            return this.historicalMetricsOptions_ == null ? HistoricalMetricsOptions.getDefaultInstance() : this.historicalMetricsOptions_;
        }

        private SingleFieldBuilderV3<HistoricalMetricsOptions, HistoricalMetricsOptions.Builder, HistoricalMetricsOptionsOrBuilder> getHistoricalMetricsOptionsFieldBuilder() {
            if (this.historicalMetricsOptionsBuilder_ == null) {
                this.historicalMetricsOptionsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getHistoricalMetricsOptions(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.historicalMetricsOptions_ = null;
            }
            return this.historicalMetricsOptionsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

