/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.services.stub;

import com.google.ads.googleads.v18.services.CreateDataLinkRequest;
import com.google.ads.googleads.v18.services.CreateDataLinkResponse;
import com.google.ads.googleads.v18.services.stub.DataLinkServiceStub;
import com.google.ads.googleads.v18.services.stub.DataLinkServiceStubSettings;
import com.google.ads.googleads.v18.services.stub.GrpcDataLinkServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDataLinkServiceStub
extends DataLinkServiceStub {
    private static final MethodDescriptor<CreateDataLinkRequest, CreateDataLinkResponse> createDataLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v18.services.DataLinkService/CreateDataLink").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDataLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CreateDataLinkResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateDataLinkRequest, CreateDataLinkResponse> createDataLinkCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDataLinkServiceStub create(DataLinkServiceStubSettings settings) throws IOException {
        return new GrpcDataLinkServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDataLinkServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDataLinkServiceStub(DataLinkServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDataLinkServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDataLinkServiceStub(DataLinkServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDataLinkServiceStub(DataLinkServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcDataLinkServiceCallableFactory());
    }

    protected GrpcDataLinkServiceStub(DataLinkServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createDataLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDataLinkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        this.createDataLinkCallable = callableFactory.createUnaryCallable(createDataLinkTransportSettings, settings.createDataLinkSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateDataLinkRequest, CreateDataLinkResponse> createDataLinkCallable() {
        return this.createDataLinkCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

