// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v18/resources/audience.proto

// Protobuf Java Version: 3.25.7
package com.google.ads.googleads.v18.resources;

/**
 * <pre>
 * Audience is an effective targeting option that lets you
 * intersect different segment attributes, such as detailed demographics and
 * affinities, to create audiences that represent sections of your target
 * segments.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v18.resources.Audience}
 */
public final class Audience extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v18.resources.Audience)
    AudienceOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Audience.newBuilder() to construct.
  private Audience(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Audience() {
    resourceName_ = "";
    status_ = 0;
    name_ = "";
    description_ = "";
    dimensions_ = java.util.Collections.emptyList();
    scope_ = 0;
    assetGroup_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new Audience();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v18.resources.AudienceProto.internal_static_google_ads_googleads_v18_resources_Audience_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v18.resources.AudienceProto.internal_static_google_ads_googleads_v18_resources_Audience_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v18.resources.Audience.class, com.google.ads.googleads.v18.resources.Audience.Builder.class);
  }

  private int bitField0_;
  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Immutable. The resource name of the audience.
   * Audience names have the form:
   *
   * `customers/{customer_id}/audiences/{audience_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The resource name of the audience.
   * Audience names have the form:
   *
   * `customers/{customer_id}/audiences/{audience_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 2;
  private long id_ = 0L;
  /**
   * <pre>
   * Output only. ID of the audience.
   * </pre>
   *
   * <code>int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int STATUS_FIELD_NUMBER = 3;
  private int status_ = 0;
  /**
   * <pre>
   * Output only. Status of this audience. Indicates whether the audience
   * is enabled or removed.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus status = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * Output only. Status of this audience. Indicates whether the audience
   * is enabled or removed.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus status = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus getStatus() {
    com.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus result = com.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus.forNumber(status_);
    return result == null ? com.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus.UNRECOGNIZED : result;
  }

  public static final int NAME_FIELD_NUMBER = 10;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   * Name of the audience. It should be unique across all audiences within the
   * account. It must have a minimum length of 1 and maximum length of 255.
   * Required when scope is not set or is set to CUSTOMER. Cannot be set or
   * updated when scope is ASSET_GROUP.
   * </pre>
   *
   * <code>optional string name = 10;</code>
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Name of the audience. It should be unique across all audiences within the
   * account. It must have a minimum length of 1 and maximum length of 255.
   * Required when scope is not set or is set to CUSTOMER. Cannot be set or
   * updated when scope is ASSET_GROUP.
   * </pre>
   *
   * <code>optional string name = 10;</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Name of the audience. It should be unique across all audiences within the
   * account. It must have a minimum length of 1 and maximum length of 255.
   * Required when scope is not set or is set to CUSTOMER. Cannot be set or
   * updated when scope is ASSET_GROUP.
   * </pre>
   *
   * <code>optional string name = 10;</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   * <pre>
   * Description of this audience.
   * </pre>
   *
   * <code>string description = 5;</code>
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Description of this audience.
   * </pre>
   *
   * <code>string description = 5;</code>
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIMENSIONS_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ads.googleads.v18.common.AudienceDimension> dimensions_;
  /**
   * <pre>
   * Positive dimensions specifying the audience composition.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v18.common.AudienceDimension> getDimensionsList() {
    return dimensions_;
  }
  /**
   * <pre>
   * Positive dimensions specifying the audience composition.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v18.common.AudienceDimensionOrBuilder> 
      getDimensionsOrBuilderList() {
    return dimensions_;
  }
  /**
   * <pre>
   * Positive dimensions specifying the audience composition.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
   */
  @java.lang.Override
  public int getDimensionsCount() {
    return dimensions_.size();
  }
  /**
   * <pre>
   * Positive dimensions specifying the audience composition.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.common.AudienceDimension getDimensions(int index) {
    return dimensions_.get(index);
  }
  /**
   * <pre>
   * Positive dimensions specifying the audience composition.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.common.AudienceDimensionOrBuilder getDimensionsOrBuilder(
      int index) {
    return dimensions_.get(index);
  }

  public static final int EXCLUSION_DIMENSION_FIELD_NUMBER = 7;
  private com.google.ads.googleads.v18.common.AudienceExclusionDimension exclusionDimension_;
  /**
   * <pre>
   * Negative dimension specifying the audience composition.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.common.AudienceExclusionDimension exclusion_dimension = 7;</code>
   * @return Whether the exclusionDimension field is set.
   */
  @java.lang.Override
  public boolean hasExclusionDimension() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Negative dimension specifying the audience composition.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.common.AudienceExclusionDimension exclusion_dimension = 7;</code>
   * @return The exclusionDimension.
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.common.AudienceExclusionDimension getExclusionDimension() {
    return exclusionDimension_ == null ? com.google.ads.googleads.v18.common.AudienceExclusionDimension.getDefaultInstance() : exclusionDimension_;
  }
  /**
   * <pre>
   * Negative dimension specifying the audience composition.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.common.AudienceExclusionDimension exclusion_dimension = 7;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.common.AudienceExclusionDimensionOrBuilder getExclusionDimensionOrBuilder() {
    return exclusionDimension_ == null ? com.google.ads.googleads.v18.common.AudienceExclusionDimension.getDefaultInstance() : exclusionDimension_;
  }

  public static final int SCOPE_FIELD_NUMBER = 8;
  private int scope_ = 0;
  /**
   * <pre>
   * Defines the scope this audience can be used in. By default, the scope is
   * CUSTOMER. Audiences can be created with a scope of ASSET_GROUP for
   * exclusive use by a single asset_group. Scope may change from ASSET_GROUP to
   * CUSTOMER but not from CUSTOMER to ASSET_GROUP.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope scope = 8;</code>
   * @return The enum numeric value on the wire for scope.
   */
  @java.lang.Override public int getScopeValue() {
    return scope_;
  }
  /**
   * <pre>
   * Defines the scope this audience can be used in. By default, the scope is
   * CUSTOMER. Audiences can be created with a scope of ASSET_GROUP for
   * exclusive use by a single asset_group. Scope may change from ASSET_GROUP to
   * CUSTOMER but not from CUSTOMER to ASSET_GROUP.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope scope = 8;</code>
   * @return The scope.
   */
  @java.lang.Override public com.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope getScope() {
    com.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope result = com.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope.forNumber(scope_);
    return result == null ? com.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope.UNRECOGNIZED : result;
  }

  public static final int ASSET_GROUP_FIELD_NUMBER = 9;
  @SuppressWarnings("serial")
  private volatile java.lang.Object assetGroup_ = "";
  /**
   * <pre>
   * Immutable. The asset group that this audience is scoped under. Must be set
   * if and only if scope is ASSET_GROUP. Immutable after creation. If an
   * audience with ASSET_GROUP scope is upgraded to CUSTOMER scope, this field
   * will automatically be cleared.
   * </pre>
   *
   * <code>string asset_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The assetGroup.
   */
  @java.lang.Override
  public java.lang.String getAssetGroup() {
    java.lang.Object ref = assetGroup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      assetGroup_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The asset group that this audience is scoped under. Must be set
   * if and only if scope is ASSET_GROUP. Immutable after creation. If an
   * audience with ASSET_GROUP scope is upgraded to CUSTOMER scope, this field
   * will automatically be cleared.
   * </pre>
   *
   * <code>string asset_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for assetGroup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getAssetGroupBytes() {
    java.lang.Object ref = assetGroup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      assetGroup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (id_ != 0L) {
      output.writeInt64(2, id_);
    }
    if (status_ != com.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(3, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      output.writeMessage(6, dimensions_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getExclusionDimension());
    }
    if (scope_ != com.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope.UNSPECIFIED.getNumber()) {
      output.writeEnum(8, scope_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assetGroup_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, assetGroup_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, name_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (id_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(2, id_);
    }
    if (status_ != com.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, dimensions_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, getExclusionDimension());
    }
    if (scope_ != com.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(8, scope_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assetGroup_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, assetGroup_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, name_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v18.resources.Audience)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v18.resources.Audience other = (com.google.ads.googleads.v18.resources.Audience) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (getId()
        != other.getId()) return false;
    if (status_ != other.status_) return false;
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName()
          .equals(other.getName())) return false;
    }
    if (!getDescription()
        .equals(other.getDescription())) return false;
    if (!getDimensionsList()
        .equals(other.getDimensionsList())) return false;
    if (hasExclusionDimension() != other.hasExclusionDimension()) return false;
    if (hasExclusionDimension()) {
      if (!getExclusionDimension()
          .equals(other.getExclusionDimension())) return false;
    }
    if (scope_ != other.scope_) return false;
    if (!getAssetGroup()
        .equals(other.getAssetGroup())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getId());
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getDimensionsCount() > 0) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionsList().hashCode();
    }
    if (hasExclusionDimension()) {
      hash = (37 * hash) + EXCLUSION_DIMENSION_FIELD_NUMBER;
      hash = (53 * hash) + getExclusionDimension().hashCode();
    }
    hash = (37 * hash) + SCOPE_FIELD_NUMBER;
    hash = (53 * hash) + scope_;
    hash = (37 * hash) + ASSET_GROUP_FIELD_NUMBER;
    hash = (53 * hash) + getAssetGroup().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v18.resources.Audience parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v18.resources.Audience parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.Audience parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v18.resources.Audience parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.Audience parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v18.resources.Audience parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.Audience parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v18.resources.Audience parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v18.resources.Audience parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v18.resources.Audience parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.Audience parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v18.resources.Audience parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v18.resources.Audience prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Audience is an effective targeting option that lets you
   * intersect different segment attributes, such as detailed demographics and
   * affinities, to create audiences that represent sections of your target
   * segments.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v18.resources.Audience}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v18.resources.Audience)
      com.google.ads.googleads.v18.resources.AudienceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v18.resources.AudienceProto.internal_static_google_ads_googleads_v18_resources_Audience_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v18.resources.AudienceProto.internal_static_google_ads_googleads_v18_resources_Audience_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v18.resources.Audience.class, com.google.ads.googleads.v18.resources.Audience.Builder.class);
    }

    // Construct using com.google.ads.googleads.v18.resources.Audience.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getDimensionsFieldBuilder();
        getExclusionDimensionFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      id_ = 0L;
      status_ = 0;
      name_ = "";
      description_ = "";
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
      } else {
        dimensions_ = null;
        dimensionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      exclusionDimension_ = null;
      if (exclusionDimensionBuilder_ != null) {
        exclusionDimensionBuilder_.dispose();
        exclusionDimensionBuilder_ = null;
      }
      scope_ = 0;
      assetGroup_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v18.resources.AudienceProto.internal_static_google_ads_googleads_v18_resources_Audience_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.Audience getDefaultInstanceForType() {
      return com.google.ads.googleads.v18.resources.Audience.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.Audience build() {
      com.google.ads.googleads.v18.resources.Audience result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.Audience buildPartial() {
      com.google.ads.googleads.v18.resources.Audience result = new com.google.ads.googleads.v18.resources.Audience(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ads.googleads.v18.resources.Audience result) {
      if (dimensionsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          dimensions_ = java.util.Collections.unmodifiableList(dimensions_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.dimensions_ = dimensions_;
      } else {
        result.dimensions_ = dimensionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.ads.googleads.v18.resources.Audience result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.status_ = status_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.exclusionDimension_ = exclusionDimensionBuilder_ == null
            ? exclusionDimension_
            : exclusionDimensionBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.scope_ = scope_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.assetGroup_ = assetGroup_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v18.resources.Audience) {
        return mergeFrom((com.google.ads.googleads.v18.resources.Audience)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v18.resources.Audience other) {
      if (other == com.google.ads.googleads.v18.resources.Audience.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getId() != 0L) {
        setId(other.getId());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (dimensionsBuilder_ == null) {
        if (!other.dimensions_.isEmpty()) {
          if (dimensions_.isEmpty()) {
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureDimensionsIsMutable();
            dimensions_.addAll(other.dimensions_);
          }
          onChanged();
        }
      } else {
        if (!other.dimensions_.isEmpty()) {
          if (dimensionsBuilder_.isEmpty()) {
            dimensionsBuilder_.dispose();
            dimensionsBuilder_ = null;
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000020);
            dimensionsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getDimensionsFieldBuilder() : null;
          } else {
            dimensionsBuilder_.addAllMessages(other.dimensions_);
          }
        }
      }
      if (other.hasExclusionDimension()) {
        mergeExclusionDimension(other.getExclusionDimension());
      }
      if (other.scope_ != 0) {
        setScopeValue(other.getScopeValue());
      }
      if (!other.getAssetGroup().isEmpty()) {
        assetGroup_ = other.assetGroup_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 16: {
              id_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 16
            case 24: {
              status_ = input.readEnum();
              bitField0_ |= 0x00000004;
              break;
            } // case 24
            case 42: {
              description_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000010;
              break;
            } // case 42
            case 50: {
              com.google.ads.googleads.v18.common.AudienceDimension m =
                  input.readMessage(
                      com.google.ads.googleads.v18.common.AudienceDimension.parser(),
                      extensionRegistry);
              if (dimensionsBuilder_ == null) {
                ensureDimensionsIsMutable();
                dimensions_.add(m);
              } else {
                dimensionsBuilder_.addMessage(m);
              }
              break;
            } // case 50
            case 58: {
              input.readMessage(
                  getExclusionDimensionFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000040;
              break;
            } // case 58
            case 64: {
              scope_ = input.readEnum();
              bitField0_ |= 0x00000080;
              break;
            } // case 64
            case 74: {
              assetGroup_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000100;
              break;
            } // case 74
            case 82: {
              name_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000008;
              break;
            } // case 82
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Immutable. The resource name of the audience.
     * Audience names have the form:
     *
     * `customers/{customer_id}/audiences/{audience_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the audience.
     * Audience names have the form:
     *
     * `customers/{customer_id}/audiences/{audience_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the audience.
     * Audience names have the form:
     *
     * `customers/{customer_id}/audiences/{audience_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the audience.
     * Audience names have the form:
     *
     * `customers/{customer_id}/audiences/{audience_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the audience.
     * Audience names have the form:
     *
     * `customers/{customer_id}/audiences/{audience_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long id_ ;
    /**
     * <pre>
     * Output only. ID of the audience.
     * </pre>
     *
     * <code>int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     * <pre>
     * Output only. ID of the audience.
     * </pre>
     *
     * <code>int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. ID of the audience.
     * </pre>
     *
     * <code>int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      id_ = 0L;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * Output only. Status of this audience. Indicates whether the audience
     * is enabled or removed.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus status = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Output only. Status of this audience. Indicates whether the audience
     * is enabled or removed.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus status = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Status of this audience. Indicates whether the audience
     * is enabled or removed.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus status = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus getStatus() {
      com.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus result = com.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus.forNumber(status_);
      return result == null ? com.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. Status of this audience. Indicates whether the audience
     * is enabled or removed.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus status = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Status of this audience. Indicates whether the audience
     * is enabled or removed.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AudienceStatusEnum.AudienceStatus status = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000004);
      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * Name of the audience. It should be unique across all audiences within the
     * account. It must have a minimum length of 1 and maximum length of 255.
     * Required when scope is not set or is set to CUSTOMER. Cannot be set or
     * updated when scope is ASSET_GROUP.
     * </pre>
     *
     * <code>optional string name = 10;</code>
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Name of the audience. It should be unique across all audiences within the
     * account. It must have a minimum length of 1 and maximum length of 255.
     * Required when scope is not set or is set to CUSTOMER. Cannot be set or
     * updated when scope is ASSET_GROUP.
     * </pre>
     *
     * <code>optional string name = 10;</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Name of the audience. It should be unique across all audiences within the
     * account. It must have a minimum length of 1 and maximum length of 255.
     * Required when scope is not set or is set to CUSTOMER. Cannot be set or
     * updated when scope is ASSET_GROUP.
     * </pre>
     *
     * <code>optional string name = 10;</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Name of the audience. It should be unique across all audiences within the
     * account. It must have a minimum length of 1 and maximum length of 255.
     * Required when scope is not set or is set to CUSTOMER. Cannot be set or
     * updated when scope is ASSET_GROUP.
     * </pre>
     *
     * <code>optional string name = 10;</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Name of the audience. It should be unique across all audiences within the
     * account. It must have a minimum length of 1 and maximum length of 255.
     * Required when scope is not set or is set to CUSTOMER. Cannot be set or
     * updated when scope is ASSET_GROUP.
     * </pre>
     *
     * <code>optional string name = 10;</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Name of the audience. It should be unique across all audiences within the
     * account. It must have a minimum length of 1 and maximum length of 255.
     * Required when scope is not set or is set to CUSTOMER. Cannot be set or
     * updated when scope is ASSET_GROUP.
     * </pre>
     *
     * <code>optional string name = 10;</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     * <pre>
     * Description of this audience.
     * </pre>
     *
     * <code>string description = 5;</code>
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Description of this audience.
     * </pre>
     *
     * <code>string description = 5;</code>
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Description of this audience.
     * </pre>
     *
     * <code>string description = 5;</code>
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Description of this audience.
     * </pre>
     *
     * <code>string description = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Description of this audience.
     * </pre>
     *
     * <code>string description = 5;</code>
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.ads.googleads.v18.common.AudienceDimension> dimensions_ =
      java.util.Collections.emptyList();
    private void ensureDimensionsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        dimensions_ = new java.util.ArrayList<com.google.ads.googleads.v18.common.AudienceDimension>(dimensions_);
        bitField0_ |= 0x00000020;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v18.common.AudienceDimension, com.google.ads.googleads.v18.common.AudienceDimension.Builder, com.google.ads.googleads.v18.common.AudienceDimensionOrBuilder> dimensionsBuilder_;

    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public java.util.List<com.google.ads.googleads.v18.common.AudienceDimension> getDimensionsList() {
      if (dimensionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dimensions_);
      } else {
        return dimensionsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public int getDimensionsCount() {
      if (dimensionsBuilder_ == null) {
        return dimensions_.size();
      } else {
        return dimensionsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public com.google.ads.googleads.v18.common.AudienceDimension getDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public Builder setDimensions(
        int index, com.google.ads.googleads.v18.common.AudienceDimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.set(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public Builder setDimensions(
        int index, com.google.ads.googleads.v18.common.AudienceDimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.set(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public Builder addDimensions(com.google.ads.googleads.v18.common.AudienceDimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public Builder addDimensions(
        int index, com.google.ads.googleads.v18.common.AudienceDimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public Builder addDimensions(
        com.google.ads.googleads.v18.common.AudienceDimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public Builder addDimensions(
        int index, com.google.ads.googleads.v18.common.AudienceDimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public Builder addAllDimensions(
        java.lang.Iterable<? extends com.google.ads.googleads.v18.common.AudienceDimension> values) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, dimensions_);
        onChanged();
      } else {
        dimensionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public Builder clearDimensions() {
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        dimensionsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public Builder removeDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.remove(index);
        onChanged();
      } else {
        dimensionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public com.google.ads.googleads.v18.common.AudienceDimension.Builder getDimensionsBuilder(
        int index) {
      return getDimensionsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public com.google.ads.googleads.v18.common.AudienceDimensionOrBuilder getDimensionsOrBuilder(
        int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);  } else {
        return dimensionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v18.common.AudienceDimensionOrBuilder> 
         getDimensionsOrBuilderList() {
      if (dimensionsBuilder_ != null) {
        return dimensionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dimensions_);
      }
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public com.google.ads.googleads.v18.common.AudienceDimension.Builder addDimensionsBuilder() {
      return getDimensionsFieldBuilder().addBuilder(
          com.google.ads.googleads.v18.common.AudienceDimension.getDefaultInstance());
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public com.google.ads.googleads.v18.common.AudienceDimension.Builder addDimensionsBuilder(
        int index) {
      return getDimensionsFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v18.common.AudienceDimension.getDefaultInstance());
    }
    /**
     * <pre>
     * Positive dimensions specifying the audience composition.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.AudienceDimension dimensions = 6;</code>
     */
    public java.util.List<com.google.ads.googleads.v18.common.AudienceDimension.Builder> 
         getDimensionsBuilderList() {
      return getDimensionsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v18.common.AudienceDimension, com.google.ads.googleads.v18.common.AudienceDimension.Builder, com.google.ads.googleads.v18.common.AudienceDimensionOrBuilder> 
        getDimensionsFieldBuilder() {
      if (dimensionsBuilder_ == null) {
        dimensionsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v18.common.AudienceDimension, com.google.ads.googleads.v18.common.AudienceDimension.Builder, com.google.ads.googleads.v18.common.AudienceDimensionOrBuilder>(
                dimensions_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        dimensions_ = null;
      }
      return dimensionsBuilder_;
    }

    private com.google.ads.googleads.v18.common.AudienceExclusionDimension exclusionDimension_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v18.common.AudienceExclusionDimension, com.google.ads.googleads.v18.common.AudienceExclusionDimension.Builder, com.google.ads.googleads.v18.common.AudienceExclusionDimensionOrBuilder> exclusionDimensionBuilder_;
    /**
     * <pre>
     * Negative dimension specifying the audience composition.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.common.AudienceExclusionDimension exclusion_dimension = 7;</code>
     * @return Whether the exclusionDimension field is set.
     */
    public boolean hasExclusionDimension() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Negative dimension specifying the audience composition.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.common.AudienceExclusionDimension exclusion_dimension = 7;</code>
     * @return The exclusionDimension.
     */
    public com.google.ads.googleads.v18.common.AudienceExclusionDimension getExclusionDimension() {
      if (exclusionDimensionBuilder_ == null) {
        return exclusionDimension_ == null ? com.google.ads.googleads.v18.common.AudienceExclusionDimension.getDefaultInstance() : exclusionDimension_;
      } else {
        return exclusionDimensionBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Negative dimension specifying the audience composition.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.common.AudienceExclusionDimension exclusion_dimension = 7;</code>
     */
    public Builder setExclusionDimension(com.google.ads.googleads.v18.common.AudienceExclusionDimension value) {
      if (exclusionDimensionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        exclusionDimension_ = value;
      } else {
        exclusionDimensionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Negative dimension specifying the audience composition.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.common.AudienceExclusionDimension exclusion_dimension = 7;</code>
     */
    public Builder setExclusionDimension(
        com.google.ads.googleads.v18.common.AudienceExclusionDimension.Builder builderForValue) {
      if (exclusionDimensionBuilder_ == null) {
        exclusionDimension_ = builderForValue.build();
      } else {
        exclusionDimensionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Negative dimension specifying the audience composition.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.common.AudienceExclusionDimension exclusion_dimension = 7;</code>
     */
    public Builder mergeExclusionDimension(com.google.ads.googleads.v18.common.AudienceExclusionDimension value) {
      if (exclusionDimensionBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0) &&
          exclusionDimension_ != null &&
          exclusionDimension_ != com.google.ads.googleads.v18.common.AudienceExclusionDimension.getDefaultInstance()) {
          getExclusionDimensionBuilder().mergeFrom(value);
        } else {
          exclusionDimension_ = value;
        }
      } else {
        exclusionDimensionBuilder_.mergeFrom(value);
      }
      if (exclusionDimension_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Negative dimension specifying the audience composition.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.common.AudienceExclusionDimension exclusion_dimension = 7;</code>
     */
    public Builder clearExclusionDimension() {
      bitField0_ = (bitField0_ & ~0x00000040);
      exclusionDimension_ = null;
      if (exclusionDimensionBuilder_ != null) {
        exclusionDimensionBuilder_.dispose();
        exclusionDimensionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Negative dimension specifying the audience composition.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.common.AudienceExclusionDimension exclusion_dimension = 7;</code>
     */
    public com.google.ads.googleads.v18.common.AudienceExclusionDimension.Builder getExclusionDimensionBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getExclusionDimensionFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Negative dimension specifying the audience composition.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.common.AudienceExclusionDimension exclusion_dimension = 7;</code>
     */
    public com.google.ads.googleads.v18.common.AudienceExclusionDimensionOrBuilder getExclusionDimensionOrBuilder() {
      if (exclusionDimensionBuilder_ != null) {
        return exclusionDimensionBuilder_.getMessageOrBuilder();
      } else {
        return exclusionDimension_ == null ?
            com.google.ads.googleads.v18.common.AudienceExclusionDimension.getDefaultInstance() : exclusionDimension_;
      }
    }
    /**
     * <pre>
     * Negative dimension specifying the audience composition.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.common.AudienceExclusionDimension exclusion_dimension = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v18.common.AudienceExclusionDimension, com.google.ads.googleads.v18.common.AudienceExclusionDimension.Builder, com.google.ads.googleads.v18.common.AudienceExclusionDimensionOrBuilder> 
        getExclusionDimensionFieldBuilder() {
      if (exclusionDimensionBuilder_ == null) {
        exclusionDimensionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v18.common.AudienceExclusionDimension, com.google.ads.googleads.v18.common.AudienceExclusionDimension.Builder, com.google.ads.googleads.v18.common.AudienceExclusionDimensionOrBuilder>(
                getExclusionDimension(),
                getParentForChildren(),
                isClean());
        exclusionDimension_ = null;
      }
      return exclusionDimensionBuilder_;
    }

    private int scope_ = 0;
    /**
     * <pre>
     * Defines the scope this audience can be used in. By default, the scope is
     * CUSTOMER. Audiences can be created with a scope of ASSET_GROUP for
     * exclusive use by a single asset_group. Scope may change from ASSET_GROUP to
     * CUSTOMER but not from CUSTOMER to ASSET_GROUP.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope scope = 8;</code>
     * @return The enum numeric value on the wire for scope.
     */
    @java.lang.Override public int getScopeValue() {
      return scope_;
    }
    /**
     * <pre>
     * Defines the scope this audience can be used in. By default, the scope is
     * CUSTOMER. Audiences can be created with a scope of ASSET_GROUP for
     * exclusive use by a single asset_group. Scope may change from ASSET_GROUP to
     * CUSTOMER but not from CUSTOMER to ASSET_GROUP.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope scope = 8;</code>
     * @param value The enum numeric value on the wire for scope to set.
     * @return This builder for chaining.
     */
    public Builder setScopeValue(int value) {
      scope_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Defines the scope this audience can be used in. By default, the scope is
     * CUSTOMER. Audiences can be created with a scope of ASSET_GROUP for
     * exclusive use by a single asset_group. Scope may change from ASSET_GROUP to
     * CUSTOMER but not from CUSTOMER to ASSET_GROUP.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope scope = 8;</code>
     * @return The scope.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope getScope() {
      com.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope result = com.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope.forNumber(scope_);
      return result == null ? com.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Defines the scope this audience can be used in. By default, the scope is
     * CUSTOMER. Audiences can be created with a scope of ASSET_GROUP for
     * exclusive use by a single asset_group. Scope may change from ASSET_GROUP to
     * CUSTOMER but not from CUSTOMER to ASSET_GROUP.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope scope = 8;</code>
     * @param value The scope to set.
     * @return This builder for chaining.
     */
    public Builder setScope(com.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      scope_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Defines the scope this audience can be used in. By default, the scope is
     * CUSTOMER. Audiences can be created with a scope of ASSET_GROUP for
     * exclusive use by a single asset_group. Scope may change from ASSET_GROUP to
     * CUSTOMER but not from CUSTOMER to ASSET_GROUP.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AudienceScopeEnum.AudienceScope scope = 8;</code>
     * @return This builder for chaining.
     */
    public Builder clearScope() {
      bitField0_ = (bitField0_ & ~0x00000080);
      scope_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object assetGroup_ = "";
    /**
     * <pre>
     * Immutable. The asset group that this audience is scoped under. Must be set
     * if and only if scope is ASSET_GROUP. Immutable after creation. If an
     * audience with ASSET_GROUP scope is upgraded to CUSTOMER scope, this field
     * will automatically be cleared.
     * </pre>
     *
     * <code>string asset_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The assetGroup.
     */
    public java.lang.String getAssetGroup() {
      java.lang.Object ref = assetGroup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        assetGroup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The asset group that this audience is scoped under. Must be set
     * if and only if scope is ASSET_GROUP. Immutable after creation. If an
     * audience with ASSET_GROUP scope is upgraded to CUSTOMER scope, this field
     * will automatically be cleared.
     * </pre>
     *
     * <code>string asset_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for assetGroup.
     */
    public com.google.protobuf.ByteString
        getAssetGroupBytes() {
      java.lang.Object ref = assetGroup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        assetGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The asset group that this audience is scoped under. Must be set
     * if and only if scope is ASSET_GROUP. Immutable after creation. If an
     * audience with ASSET_GROUP scope is upgraded to CUSTOMER scope, this field
     * will automatically be cleared.
     * </pre>
     *
     * <code>string asset_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The assetGroup to set.
     * @return This builder for chaining.
     */
    public Builder setAssetGroup(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      assetGroup_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The asset group that this audience is scoped under. Must be set
     * if and only if scope is ASSET_GROUP. Immutable after creation. If an
     * audience with ASSET_GROUP scope is upgraded to CUSTOMER scope, this field
     * will automatically be cleared.
     * </pre>
     *
     * <code>string asset_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearAssetGroup() {
      assetGroup_ = getDefaultInstance().getAssetGroup();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The asset group that this audience is scoped under. Must be set
     * if and only if scope is ASSET_GROUP. Immutable after creation. If an
     * audience with ASSET_GROUP scope is upgraded to CUSTOMER scope, this field
     * will automatically be cleared.
     * </pre>
     *
     * <code>string asset_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for assetGroup to set.
     * @return This builder for chaining.
     */
    public Builder setAssetGroupBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      assetGroup_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v18.resources.Audience)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v18.resources.Audience)
  private static final com.google.ads.googleads.v18.resources.Audience DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v18.resources.Audience();
  }

  public static com.google.ads.googleads.v18.resources.Audience getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Audience>
      PARSER = new com.google.protobuf.AbstractParser<Audience>() {
    @java.lang.Override
    public Audience parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<Audience> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Audience> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v18.resources.Audience getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

