// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v18/resources/experiment.proto

// Protobuf Java Version: 3.25.7
package com.google.ads.googleads.v18.resources;

/**
 * <pre>
 * A Google ads experiment for users to experiment changes on multiple
 * campaigns, compare the performance, and apply the effective changes.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v18.resources.Experiment}
 */
public final class Experiment extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v18.resources.Experiment)
    ExperimentOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Experiment.newBuilder() to construct.
  private Experiment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Experiment() {
    resourceName_ = "";
    name_ = "";
    description_ = "";
    suffix_ = "";
    type_ = 0;
    status_ = 0;
    startDate_ = "";
    endDate_ = "";
    goals_ = java.util.Collections.emptyList();
    longRunningOperation_ = "";
    promoteStatus_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new Experiment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v18.resources.ExperimentProto.internal_static_google_ads_googleads_v18_resources_Experiment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v18.resources.ExperimentProto.internal_static_google_ads_googleads_v18_resources_Experiment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v18.resources.Experiment.class, com.google.ads.googleads.v18.resources.Experiment.Builder.class);
  }

  private int bitField0_;
  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Immutable. The resource name of the experiment.
   * Experiment resource names have the form:
   *
   * `customers/{customer_id}/experiments/{experiment_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The resource name of the experiment.
   * Experiment resource names have the form:
   *
   * `customers/{customer_id}/experiments/{experiment_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPERIMENT_ID_FIELD_NUMBER = 9;
  private long experimentId_ = 0L;
  /**
   * <pre>
   * Output only. The ID of the experiment. Read only.
   * </pre>
   *
   * <code>optional int64 experiment_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the experimentId field is set.
   */
  @java.lang.Override
  public boolean hasExperimentId() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Output only. The ID of the experiment. Read only.
   * </pre>
   *
   * <code>optional int64 experiment_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The experimentId.
   */
  @java.lang.Override
  public long getExperimentId() {
    return experimentId_;
  }

  public static final int NAME_FIELD_NUMBER = 10;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   * Required. The name of the experiment. It must have a minimum length of 1
   * and maximum length of 1024. It must be unique under a customer.
   * </pre>
   *
   * <code>string name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Required. The name of the experiment. It must have a minimum length of 1
   * and maximum length of 1024. It must be unique under a customer.
   * </pre>
   *
   * <code>string name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 11;
  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   * <pre>
   * The description of the experiment. It must have a minimum length of 1 and
   * maximum length of 2048.
   * </pre>
   *
   * <code>string description = 11;</code>
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The description of the experiment. It must have a minimum length of 1 and
   * maximum length of 2048.
   * </pre>
   *
   * <code>string description = 11;</code>
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUFFIX_FIELD_NUMBER = 12;
  @SuppressWarnings("serial")
  private volatile java.lang.Object suffix_ = "";
  /**
   * <pre>
   * For system managed experiments, the advertiser must provide a suffix during
   * construction, in the setup stage before moving to initiated. The suffix
   * will be appended to the in-design and experiment campaign names so that the
   * name is base campaign name + suffix.
   * </pre>
   *
   * <code>string suffix = 12;</code>
   * @return The suffix.
   */
  @java.lang.Override
  public java.lang.String getSuffix() {
    java.lang.Object ref = suffix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      suffix_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * For system managed experiments, the advertiser must provide a suffix during
   * construction, in the setup stage before moving to initiated. The suffix
   * will be appended to the in-design and experiment campaign names so that the
   * name is base campaign name + suffix.
   * </pre>
   *
   * <code>string suffix = 12;</code>
   * @return The bytes for suffix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getSuffixBytes() {
    java.lang.Object ref = suffix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      suffix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 13;
  private int type_ = 0;
  /**
   * <pre>
   * Required. The product/feature that uses this experiment.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType type = 13 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Required. The product/feature that uses this experiment.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType type = 13 [(.google.api.field_behavior) = REQUIRED];</code>
   * @return The type.
   */
  @java.lang.Override public com.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType getType() {
    com.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType result = com.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType.forNumber(type_);
    return result == null ? com.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType.UNRECOGNIZED : result;
  }

  public static final int STATUS_FIELD_NUMBER = 14;
  private int status_ = 0;
  /**
   * <pre>
   * The Advertiser-chosen status of this experiment.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus status = 14;</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * The Advertiser-chosen status of this experiment.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus status = 14;</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus getStatus() {
    com.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus result = com.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus.forNumber(status_);
    return result == null ? com.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus.UNRECOGNIZED : result;
  }

  public static final int START_DATE_FIELD_NUMBER = 15;
  @SuppressWarnings("serial")
  private volatile java.lang.Object startDate_ = "";
  /**
   * <pre>
   * Date when the experiment starts. By default, the experiment starts
   * now or on the campaign's start date, whichever is later. If this field is
   * set, then the experiment starts at the beginning of the specified date in
   * the customer's time zone.
   *
   * Format: YYYY-MM-DD
   * Example: 2019-03-14
   * </pre>
   *
   * <code>optional string start_date = 15;</code>
   * @return Whether the startDate field is set.
   */
  @java.lang.Override
  public boolean hasStartDate() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Date when the experiment starts. By default, the experiment starts
   * now or on the campaign's start date, whichever is later. If this field is
   * set, then the experiment starts at the beginning of the specified date in
   * the customer's time zone.
   *
   * Format: YYYY-MM-DD
   * Example: 2019-03-14
   * </pre>
   *
   * <code>optional string start_date = 15;</code>
   * @return The startDate.
   */
  @java.lang.Override
  public java.lang.String getStartDate() {
    java.lang.Object ref = startDate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startDate_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Date when the experiment starts. By default, the experiment starts
   * now or on the campaign's start date, whichever is later. If this field is
   * set, then the experiment starts at the beginning of the specified date in
   * the customer's time zone.
   *
   * Format: YYYY-MM-DD
   * Example: 2019-03-14
   * </pre>
   *
   * <code>optional string start_date = 15;</code>
   * @return The bytes for startDate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getStartDateBytes() {
    java.lang.Object ref = startDate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      startDate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int END_DATE_FIELD_NUMBER = 16;
  @SuppressWarnings("serial")
  private volatile java.lang.Object endDate_ = "";
  /**
   * <pre>
   * Date when the experiment ends. By default, the experiment ends on
   * the campaign's end date. If this field is set, then the experiment ends at
   * the end of the specified date in the customer's time zone.
   *
   * Format: YYYY-MM-DD
   * Example: 2019-04-18
   * </pre>
   *
   * <code>optional string end_date = 16;</code>
   * @return Whether the endDate field is set.
   */
  @java.lang.Override
  public boolean hasEndDate() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Date when the experiment ends. By default, the experiment ends on
   * the campaign's end date. If this field is set, then the experiment ends at
   * the end of the specified date in the customer's time zone.
   *
   * Format: YYYY-MM-DD
   * Example: 2019-04-18
   * </pre>
   *
   * <code>optional string end_date = 16;</code>
   * @return The endDate.
   */
  @java.lang.Override
  public java.lang.String getEndDate() {
    java.lang.Object ref = endDate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endDate_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Date when the experiment ends. By default, the experiment ends on
   * the campaign's end date. If this field is set, then the experiment ends at
   * the end of the specified date in the customer's time zone.
   *
   * Format: YYYY-MM-DD
   * Example: 2019-04-18
   * </pre>
   *
   * <code>optional string end_date = 16;</code>
   * @return The bytes for endDate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getEndDateBytes() {
    java.lang.Object ref = endDate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      endDate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GOALS_FIELD_NUMBER = 17;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ads.googleads.v18.common.MetricGoal> goals_;
  /**
   * <pre>
   * The goals of this experiment.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v18.common.MetricGoal> getGoalsList() {
    return goals_;
  }
  /**
   * <pre>
   * The goals of this experiment.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v18.common.MetricGoalOrBuilder> 
      getGoalsOrBuilderList() {
    return goals_;
  }
  /**
   * <pre>
   * The goals of this experiment.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
   */
  @java.lang.Override
  public int getGoalsCount() {
    return goals_.size();
  }
  /**
   * <pre>
   * The goals of this experiment.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.common.MetricGoal getGoals(int index) {
    return goals_.get(index);
  }
  /**
   * <pre>
   * The goals of this experiment.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.common.MetricGoalOrBuilder getGoalsOrBuilder(
      int index) {
    return goals_.get(index);
  }

  public static final int LONG_RUNNING_OPERATION_FIELD_NUMBER = 18;
  @SuppressWarnings("serial")
  private volatile java.lang.Object longRunningOperation_ = "";
  /**
   * <pre>
   * Output only. The resource name of the long-running operation that can be
   * used to poll for completion of experiment schedule or promote. The most
   * recent long running operation is returned.
   * </pre>
   *
   * <code>optional string long_running_operation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the longRunningOperation field is set.
   */
  @java.lang.Override
  public boolean hasLongRunningOperation() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Output only. The resource name of the long-running operation that can be
   * used to poll for completion of experiment schedule or promote. The most
   * recent long running operation is returned.
   * </pre>
   *
   * <code>optional string long_running_operation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The longRunningOperation.
   */
  @java.lang.Override
  public java.lang.String getLongRunningOperation() {
    java.lang.Object ref = longRunningOperation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      longRunningOperation_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name of the long-running operation that can be
   * used to poll for completion of experiment schedule or promote. The most
   * recent long running operation is returned.
   * </pre>
   *
   * <code>optional string long_running_operation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for longRunningOperation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getLongRunningOperationBytes() {
    java.lang.Object ref = longRunningOperation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      longRunningOperation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROMOTE_STATUS_FIELD_NUMBER = 19;
  private int promoteStatus_ = 0;
  /**
   * <pre>
   * Output only. The status of the experiment promotion process.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus promote_status = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for promoteStatus.
   */
  @java.lang.Override public int getPromoteStatusValue() {
    return promoteStatus_;
  }
  /**
   * <pre>
   * Output only. The status of the experiment promotion process.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus promote_status = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The promoteStatus.
   */
  @java.lang.Override public com.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus getPromoteStatus() {
    com.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus result = com.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus.forNumber(promoteStatus_);
    return result == null ? com.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus.UNRECOGNIZED : result;
  }

  public static final int SYNC_ENABLED_FIELD_NUMBER = 20;
  private boolean syncEnabled_ = false;
  /**
   * <pre>
   * Immutable. Set to true if changes to base campaigns should be synced to the
   * trial campaigns. Any changes made directly to trial campaigns will be
   * preserved. This field can only be set when the experiment is being created.
   * </pre>
   *
   * <code>optional bool sync_enabled = 20 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return Whether the syncEnabled field is set.
   */
  @java.lang.Override
  public boolean hasSyncEnabled() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * Immutable. Set to true if changes to base campaigns should be synced to the
   * trial campaigns. Any changes made directly to trial campaigns will be
   * preserved. This field can only be set when the experiment is being created.
   * </pre>
   *
   * <code>optional bool sync_enabled = 20 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The syncEnabled.
   */
  @java.lang.Override
  public boolean getSyncEnabled() {
    return syncEnabled_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(9, experimentId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suffix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, suffix_);
    }
    if (type_ != com.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType.UNSPECIFIED.getNumber()) {
      output.writeEnum(13, type_);
    }
    if (status_ != com.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(14, status_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, startDate_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, endDate_);
    }
    for (int i = 0; i < goals_.size(); i++) {
      output.writeMessage(17, goals_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, longRunningOperation_);
    }
    if (promoteStatus_ != com.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(19, promoteStatus_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeBool(20, syncEnabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(9, experimentId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suffix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, suffix_);
    }
    if (type_ != com.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(13, type_);
    }
    if (status_ != com.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(14, status_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, startDate_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, endDate_);
    }
    for (int i = 0; i < goals_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(17, goals_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, longRunningOperation_);
    }
    if (promoteStatus_ != com.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(19, promoteStatus_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(20, syncEnabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v18.resources.Experiment)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v18.resources.Experiment other = (com.google.ads.googleads.v18.resources.Experiment) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (hasExperimentId() != other.hasExperimentId()) return false;
    if (hasExperimentId()) {
      if (getExperimentId()
          != other.getExperimentId()) return false;
    }
    if (!getName()
        .equals(other.getName())) return false;
    if (!getDescription()
        .equals(other.getDescription())) return false;
    if (!getSuffix()
        .equals(other.getSuffix())) return false;
    if (type_ != other.type_) return false;
    if (status_ != other.status_) return false;
    if (hasStartDate() != other.hasStartDate()) return false;
    if (hasStartDate()) {
      if (!getStartDate()
          .equals(other.getStartDate())) return false;
    }
    if (hasEndDate() != other.hasEndDate()) return false;
    if (hasEndDate()) {
      if (!getEndDate()
          .equals(other.getEndDate())) return false;
    }
    if (!getGoalsList()
        .equals(other.getGoalsList())) return false;
    if (hasLongRunningOperation() != other.hasLongRunningOperation()) return false;
    if (hasLongRunningOperation()) {
      if (!getLongRunningOperation()
          .equals(other.getLongRunningOperation())) return false;
    }
    if (promoteStatus_ != other.promoteStatus_) return false;
    if (hasSyncEnabled() != other.hasSyncEnabled()) return false;
    if (hasSyncEnabled()) {
      if (getSyncEnabled()
          != other.getSyncEnabled()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    if (hasExperimentId()) {
      hash = (37 * hash) + EXPERIMENT_ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getExperimentId());
    }
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + SUFFIX_FIELD_NUMBER;
    hash = (53 * hash) + getSuffix().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    if (hasStartDate()) {
      hash = (37 * hash) + START_DATE_FIELD_NUMBER;
      hash = (53 * hash) + getStartDate().hashCode();
    }
    if (hasEndDate()) {
      hash = (37 * hash) + END_DATE_FIELD_NUMBER;
      hash = (53 * hash) + getEndDate().hashCode();
    }
    if (getGoalsCount() > 0) {
      hash = (37 * hash) + GOALS_FIELD_NUMBER;
      hash = (53 * hash) + getGoalsList().hashCode();
    }
    if (hasLongRunningOperation()) {
      hash = (37 * hash) + LONG_RUNNING_OPERATION_FIELD_NUMBER;
      hash = (53 * hash) + getLongRunningOperation().hashCode();
    }
    hash = (37 * hash) + PROMOTE_STATUS_FIELD_NUMBER;
    hash = (53 * hash) + promoteStatus_;
    if (hasSyncEnabled()) {
      hash = (37 * hash) + SYNC_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getSyncEnabled());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v18.resources.Experiment parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v18.resources.Experiment parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.Experiment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v18.resources.Experiment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.Experiment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v18.resources.Experiment parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.Experiment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v18.resources.Experiment parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v18.resources.Experiment parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v18.resources.Experiment parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.Experiment parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v18.resources.Experiment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v18.resources.Experiment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A Google ads experiment for users to experiment changes on multiple
   * campaigns, compare the performance, and apply the effective changes.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v18.resources.Experiment}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v18.resources.Experiment)
      com.google.ads.googleads.v18.resources.ExperimentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v18.resources.ExperimentProto.internal_static_google_ads_googleads_v18_resources_Experiment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v18.resources.ExperimentProto.internal_static_google_ads_googleads_v18_resources_Experiment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v18.resources.Experiment.class, com.google.ads.googleads.v18.resources.Experiment.Builder.class);
    }

    // Construct using com.google.ads.googleads.v18.resources.Experiment.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      experimentId_ = 0L;
      name_ = "";
      description_ = "";
      suffix_ = "";
      type_ = 0;
      status_ = 0;
      startDate_ = "";
      endDate_ = "";
      if (goalsBuilder_ == null) {
        goals_ = java.util.Collections.emptyList();
      } else {
        goals_ = null;
        goalsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      longRunningOperation_ = "";
      promoteStatus_ = 0;
      syncEnabled_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v18.resources.ExperimentProto.internal_static_google_ads_googleads_v18_resources_Experiment_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.Experiment getDefaultInstanceForType() {
      return com.google.ads.googleads.v18.resources.Experiment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.Experiment build() {
      com.google.ads.googleads.v18.resources.Experiment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.Experiment buildPartial() {
      com.google.ads.googleads.v18.resources.Experiment result = new com.google.ads.googleads.v18.resources.Experiment(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ads.googleads.v18.resources.Experiment result) {
      if (goalsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          goals_ = java.util.Collections.unmodifiableList(goals_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.goals_ = goals_;
      } else {
        result.goals_ = goalsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.ads.googleads.v18.resources.Experiment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.experimentId_ = experimentId_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.suffix_ = suffix_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.startDate_ = startDate_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.endDate_ = endDate_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.longRunningOperation_ = longRunningOperation_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.promoteStatus_ = promoteStatus_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.syncEnabled_ = syncEnabled_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v18.resources.Experiment) {
        return mergeFrom((com.google.ads.googleads.v18.resources.Experiment)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v18.resources.Experiment other) {
      if (other == com.google.ads.googleads.v18.resources.Experiment.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasExperimentId()) {
        setExperimentId(other.getExperimentId());
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getSuffix().isEmpty()) {
        suffix_ = other.suffix_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (other.hasStartDate()) {
        startDate_ = other.startDate_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasEndDate()) {
        endDate_ = other.endDate_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (goalsBuilder_ == null) {
        if (!other.goals_.isEmpty()) {
          if (goals_.isEmpty()) {
            goals_ = other.goals_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureGoalsIsMutable();
            goals_.addAll(other.goals_);
          }
          onChanged();
        }
      } else {
        if (!other.goals_.isEmpty()) {
          if (goalsBuilder_.isEmpty()) {
            goalsBuilder_.dispose();
            goalsBuilder_ = null;
            goals_ = other.goals_;
            bitField0_ = (bitField0_ & ~0x00000200);
            goalsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getGoalsFieldBuilder() : null;
          } else {
            goalsBuilder_.addAllMessages(other.goals_);
          }
        }
      }
      if (other.hasLongRunningOperation()) {
        longRunningOperation_ = other.longRunningOperation_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.promoteStatus_ != 0) {
        setPromoteStatusValue(other.getPromoteStatusValue());
      }
      if (other.hasSyncEnabled()) {
        setSyncEnabled(other.getSyncEnabled());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 72: {
              experimentId_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 72
            case 82: {
              name_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000004;
              break;
            } // case 82
            case 90: {
              description_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000008;
              break;
            } // case 90
            case 98: {
              suffix_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000010;
              break;
            } // case 98
            case 104: {
              type_ = input.readEnum();
              bitField0_ |= 0x00000020;
              break;
            } // case 104
            case 112: {
              status_ = input.readEnum();
              bitField0_ |= 0x00000040;
              break;
            } // case 112
            case 122: {
              startDate_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000080;
              break;
            } // case 122
            case 130: {
              endDate_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000100;
              break;
            } // case 130
            case 138: {
              com.google.ads.googleads.v18.common.MetricGoal m =
                  input.readMessage(
                      com.google.ads.googleads.v18.common.MetricGoal.parser(),
                      extensionRegistry);
              if (goalsBuilder_ == null) {
                ensureGoalsIsMutable();
                goals_.add(m);
              } else {
                goalsBuilder_.addMessage(m);
              }
              break;
            } // case 138
            case 146: {
              longRunningOperation_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000400;
              break;
            } // case 146
            case 152: {
              promoteStatus_ = input.readEnum();
              bitField0_ |= 0x00000800;
              break;
            } // case 152
            case 160: {
              syncEnabled_ = input.readBool();
              bitField0_ |= 0x00001000;
              break;
            } // case 160
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Immutable. The resource name of the experiment.
     * Experiment resource names have the form:
     *
     * `customers/{customer_id}/experiments/{experiment_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the experiment.
     * Experiment resource names have the form:
     *
     * `customers/{customer_id}/experiments/{experiment_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the experiment.
     * Experiment resource names have the form:
     *
     * `customers/{customer_id}/experiments/{experiment_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the experiment.
     * Experiment resource names have the form:
     *
     * `customers/{customer_id}/experiments/{experiment_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the experiment.
     * Experiment resource names have the form:
     *
     * `customers/{customer_id}/experiments/{experiment_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long experimentId_ ;
    /**
     * <pre>
     * Output only. The ID of the experiment. Read only.
     * </pre>
     *
     * <code>optional int64 experiment_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the experimentId field is set.
     */
    @java.lang.Override
    public boolean hasExperimentId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Output only. The ID of the experiment. Read only.
     * </pre>
     *
     * <code>optional int64 experiment_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The experimentId.
     */
    @java.lang.Override
    public long getExperimentId() {
      return experimentId_;
    }
    /**
     * <pre>
     * Output only. The ID of the experiment. Read only.
     * </pre>
     *
     * <code>optional int64 experiment_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The experimentId to set.
     * @return This builder for chaining.
     */
    public Builder setExperimentId(long value) {

      experimentId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The ID of the experiment. Read only.
     * </pre>
     *
     * <code>optional int64 experiment_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearExperimentId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      experimentId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * Required. The name of the experiment. It must have a minimum length of 1
     * and maximum length of 1024. It must be unique under a customer.
     * </pre>
     *
     * <code>string name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Required. The name of the experiment. It must have a minimum length of 1
     * and maximum length of 1024. It must be unique under a customer.
     * </pre>
     *
     * <code>string name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Required. The name of the experiment. It must have a minimum length of 1
     * and maximum length of 1024. It must be unique under a customer.
     * </pre>
     *
     * <code>string name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The name of the experiment. It must have a minimum length of 1
     * and maximum length of 1024. It must be unique under a customer.
     * </pre>
     *
     * <code>string name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The name of the experiment. It must have a minimum length of 1
     * and maximum length of 1024. It must be unique under a customer.
     * </pre>
     *
     * <code>string name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     * <pre>
     * The description of the experiment. It must have a minimum length of 1 and
     * maximum length of 2048.
     * </pre>
     *
     * <code>string description = 11;</code>
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The description of the experiment. It must have a minimum length of 1 and
     * maximum length of 2048.
     * </pre>
     *
     * <code>string description = 11;</code>
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The description of the experiment. It must have a minimum length of 1 and
     * maximum length of 2048.
     * </pre>
     *
     * <code>string description = 11;</code>
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The description of the experiment. It must have a minimum length of 1 and
     * maximum length of 2048.
     * </pre>
     *
     * <code>string description = 11;</code>
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The description of the experiment. It must have a minimum length of 1 and
     * maximum length of 2048.
     * </pre>
     *
     * <code>string description = 11;</code>
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object suffix_ = "";
    /**
     * <pre>
     * For system managed experiments, the advertiser must provide a suffix during
     * construction, in the setup stage before moving to initiated. The suffix
     * will be appended to the in-design and experiment campaign names so that the
     * name is base campaign name + suffix.
     * </pre>
     *
     * <code>string suffix = 12;</code>
     * @return The suffix.
     */
    public java.lang.String getSuffix() {
      java.lang.Object ref = suffix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        suffix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * For system managed experiments, the advertiser must provide a suffix during
     * construction, in the setup stage before moving to initiated. The suffix
     * will be appended to the in-design and experiment campaign names so that the
     * name is base campaign name + suffix.
     * </pre>
     *
     * <code>string suffix = 12;</code>
     * @return The bytes for suffix.
     */
    public com.google.protobuf.ByteString
        getSuffixBytes() {
      java.lang.Object ref = suffix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        suffix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * For system managed experiments, the advertiser must provide a suffix during
     * construction, in the setup stage before moving to initiated. The suffix
     * will be appended to the in-design and experiment campaign names so that the
     * name is base campaign name + suffix.
     * </pre>
     *
     * <code>string suffix = 12;</code>
     * @param value The suffix to set.
     * @return This builder for chaining.
     */
    public Builder setSuffix(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      suffix_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * For system managed experiments, the advertiser must provide a suffix during
     * construction, in the setup stage before moving to initiated. The suffix
     * will be appended to the in-design and experiment campaign names so that the
     * name is base campaign name + suffix.
     * </pre>
     *
     * <code>string suffix = 12;</code>
     * @return This builder for chaining.
     */
    public Builder clearSuffix() {
      suffix_ = getDefaultInstance().getSuffix();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * For system managed experiments, the advertiser must provide a suffix during
     * construction, in the setup stage before moving to initiated. The suffix
     * will be appended to the in-design and experiment campaign names so that the
     * name is base campaign name + suffix.
     * </pre>
     *
     * <code>string suffix = 12;</code>
     * @param value The bytes for suffix to set.
     * @return This builder for chaining.
     */
    public Builder setSuffixBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      suffix_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Required. The product/feature that uses this experiment.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType type = 13 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Required. The product/feature that uses this experiment.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType type = 13 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The product/feature that uses this experiment.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType type = 13 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The type.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType getType() {
      com.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType result = com.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType.forNumber(type_);
      return result == null ? com.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Required. The product/feature that uses this experiment.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType type = 13 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The product/feature that uses this experiment.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ExperimentTypeEnum.ExperimentType type = 13 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000020);
      type_ = 0;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * The Advertiser-chosen status of this experiment.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus status = 14;</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * The Advertiser-chosen status of this experiment.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus status = 14;</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The Advertiser-chosen status of this experiment.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus status = 14;</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus getStatus() {
      com.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus result = com.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus.forNumber(status_);
      return result == null ? com.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The Advertiser-chosen status of this experiment.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus status = 14;</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The Advertiser-chosen status of this experiment.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ExperimentStatusEnum.ExperimentStatus status = 14;</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000040);
      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object startDate_ = "";
    /**
     * <pre>
     * Date when the experiment starts. By default, the experiment starts
     * now or on the campaign's start date, whichever is later. If this field is
     * set, then the experiment starts at the beginning of the specified date in
     * the customer's time zone.
     *
     * Format: YYYY-MM-DD
     * Example: 2019-03-14
     * </pre>
     *
     * <code>optional string start_date = 15;</code>
     * @return Whether the startDate field is set.
     */
    public boolean hasStartDate() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * Date when the experiment starts. By default, the experiment starts
     * now or on the campaign's start date, whichever is later. If this field is
     * set, then the experiment starts at the beginning of the specified date in
     * the customer's time zone.
     *
     * Format: YYYY-MM-DD
     * Example: 2019-03-14
     * </pre>
     *
     * <code>optional string start_date = 15;</code>
     * @return The startDate.
     */
    public java.lang.String getStartDate() {
      java.lang.Object ref = startDate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startDate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Date when the experiment starts. By default, the experiment starts
     * now or on the campaign's start date, whichever is later. If this field is
     * set, then the experiment starts at the beginning of the specified date in
     * the customer's time zone.
     *
     * Format: YYYY-MM-DD
     * Example: 2019-03-14
     * </pre>
     *
     * <code>optional string start_date = 15;</code>
     * @return The bytes for startDate.
     */
    public com.google.protobuf.ByteString
        getStartDateBytes() {
      java.lang.Object ref = startDate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        startDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Date when the experiment starts. By default, the experiment starts
     * now or on the campaign's start date, whichever is later. If this field is
     * set, then the experiment starts at the beginning of the specified date in
     * the customer's time zone.
     *
     * Format: YYYY-MM-DD
     * Example: 2019-03-14
     * </pre>
     *
     * <code>optional string start_date = 15;</code>
     * @param value The startDate to set.
     * @return This builder for chaining.
     */
    public Builder setStartDate(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      startDate_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Date when the experiment starts. By default, the experiment starts
     * now or on the campaign's start date, whichever is later. If this field is
     * set, then the experiment starts at the beginning of the specified date in
     * the customer's time zone.
     *
     * Format: YYYY-MM-DD
     * Example: 2019-03-14
     * </pre>
     *
     * <code>optional string start_date = 15;</code>
     * @return This builder for chaining.
     */
    public Builder clearStartDate() {
      startDate_ = getDefaultInstance().getStartDate();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Date when the experiment starts. By default, the experiment starts
     * now or on the campaign's start date, whichever is later. If this field is
     * set, then the experiment starts at the beginning of the specified date in
     * the customer's time zone.
     *
     * Format: YYYY-MM-DD
     * Example: 2019-03-14
     * </pre>
     *
     * <code>optional string start_date = 15;</code>
     * @param value The bytes for startDate to set.
     * @return This builder for chaining.
     */
    public Builder setStartDateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      startDate_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object endDate_ = "";
    /**
     * <pre>
     * Date when the experiment ends. By default, the experiment ends on
     * the campaign's end date. If this field is set, then the experiment ends at
     * the end of the specified date in the customer's time zone.
     *
     * Format: YYYY-MM-DD
     * Example: 2019-04-18
     * </pre>
     *
     * <code>optional string end_date = 16;</code>
     * @return Whether the endDate field is set.
     */
    public boolean hasEndDate() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * Date when the experiment ends. By default, the experiment ends on
     * the campaign's end date. If this field is set, then the experiment ends at
     * the end of the specified date in the customer's time zone.
     *
     * Format: YYYY-MM-DD
     * Example: 2019-04-18
     * </pre>
     *
     * <code>optional string end_date = 16;</code>
     * @return The endDate.
     */
    public java.lang.String getEndDate() {
      java.lang.Object ref = endDate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endDate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Date when the experiment ends. By default, the experiment ends on
     * the campaign's end date. If this field is set, then the experiment ends at
     * the end of the specified date in the customer's time zone.
     *
     * Format: YYYY-MM-DD
     * Example: 2019-04-18
     * </pre>
     *
     * <code>optional string end_date = 16;</code>
     * @return The bytes for endDate.
     */
    public com.google.protobuf.ByteString
        getEndDateBytes() {
      java.lang.Object ref = endDate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        endDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Date when the experiment ends. By default, the experiment ends on
     * the campaign's end date. If this field is set, then the experiment ends at
     * the end of the specified date in the customer's time zone.
     *
     * Format: YYYY-MM-DD
     * Example: 2019-04-18
     * </pre>
     *
     * <code>optional string end_date = 16;</code>
     * @param value The endDate to set.
     * @return This builder for chaining.
     */
    public Builder setEndDate(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      endDate_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Date when the experiment ends. By default, the experiment ends on
     * the campaign's end date. If this field is set, then the experiment ends at
     * the end of the specified date in the customer's time zone.
     *
     * Format: YYYY-MM-DD
     * Example: 2019-04-18
     * </pre>
     *
     * <code>optional string end_date = 16;</code>
     * @return This builder for chaining.
     */
    public Builder clearEndDate() {
      endDate_ = getDefaultInstance().getEndDate();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Date when the experiment ends. By default, the experiment ends on
     * the campaign's end date. If this field is set, then the experiment ends at
     * the end of the specified date in the customer's time zone.
     *
     * Format: YYYY-MM-DD
     * Example: 2019-04-18
     * </pre>
     *
     * <code>optional string end_date = 16;</code>
     * @param value The bytes for endDate to set.
     * @return This builder for chaining.
     */
    public Builder setEndDateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      endDate_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.util.List<com.google.ads.googleads.v18.common.MetricGoal> goals_ =
      java.util.Collections.emptyList();
    private void ensureGoalsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        goals_ = new java.util.ArrayList<com.google.ads.googleads.v18.common.MetricGoal>(goals_);
        bitField0_ |= 0x00000200;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v18.common.MetricGoal, com.google.ads.googleads.v18.common.MetricGoal.Builder, com.google.ads.googleads.v18.common.MetricGoalOrBuilder> goalsBuilder_;

    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public java.util.List<com.google.ads.googleads.v18.common.MetricGoal> getGoalsList() {
      if (goalsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(goals_);
      } else {
        return goalsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public int getGoalsCount() {
      if (goalsBuilder_ == null) {
        return goals_.size();
      } else {
        return goalsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public com.google.ads.googleads.v18.common.MetricGoal getGoals(int index) {
      if (goalsBuilder_ == null) {
        return goals_.get(index);
      } else {
        return goalsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public Builder setGoals(
        int index, com.google.ads.googleads.v18.common.MetricGoal value) {
      if (goalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGoalsIsMutable();
        goals_.set(index, value);
        onChanged();
      } else {
        goalsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public Builder setGoals(
        int index, com.google.ads.googleads.v18.common.MetricGoal.Builder builderForValue) {
      if (goalsBuilder_ == null) {
        ensureGoalsIsMutable();
        goals_.set(index, builderForValue.build());
        onChanged();
      } else {
        goalsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public Builder addGoals(com.google.ads.googleads.v18.common.MetricGoal value) {
      if (goalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGoalsIsMutable();
        goals_.add(value);
        onChanged();
      } else {
        goalsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public Builder addGoals(
        int index, com.google.ads.googleads.v18.common.MetricGoal value) {
      if (goalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGoalsIsMutable();
        goals_.add(index, value);
        onChanged();
      } else {
        goalsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public Builder addGoals(
        com.google.ads.googleads.v18.common.MetricGoal.Builder builderForValue) {
      if (goalsBuilder_ == null) {
        ensureGoalsIsMutable();
        goals_.add(builderForValue.build());
        onChanged();
      } else {
        goalsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public Builder addGoals(
        int index, com.google.ads.googleads.v18.common.MetricGoal.Builder builderForValue) {
      if (goalsBuilder_ == null) {
        ensureGoalsIsMutable();
        goals_.add(index, builderForValue.build());
        onChanged();
      } else {
        goalsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public Builder addAllGoals(
        java.lang.Iterable<? extends com.google.ads.googleads.v18.common.MetricGoal> values) {
      if (goalsBuilder_ == null) {
        ensureGoalsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, goals_);
        onChanged();
      } else {
        goalsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public Builder clearGoals() {
      if (goalsBuilder_ == null) {
        goals_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        goalsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public Builder removeGoals(int index) {
      if (goalsBuilder_ == null) {
        ensureGoalsIsMutable();
        goals_.remove(index);
        onChanged();
      } else {
        goalsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public com.google.ads.googleads.v18.common.MetricGoal.Builder getGoalsBuilder(
        int index) {
      return getGoalsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public com.google.ads.googleads.v18.common.MetricGoalOrBuilder getGoalsOrBuilder(
        int index) {
      if (goalsBuilder_ == null) {
        return goals_.get(index);  } else {
        return goalsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v18.common.MetricGoalOrBuilder> 
         getGoalsOrBuilderList() {
      if (goalsBuilder_ != null) {
        return goalsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(goals_);
      }
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public com.google.ads.googleads.v18.common.MetricGoal.Builder addGoalsBuilder() {
      return getGoalsFieldBuilder().addBuilder(
          com.google.ads.googleads.v18.common.MetricGoal.getDefaultInstance());
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public com.google.ads.googleads.v18.common.MetricGoal.Builder addGoalsBuilder(
        int index) {
      return getGoalsFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v18.common.MetricGoal.getDefaultInstance());
    }
    /**
     * <pre>
     * The goals of this experiment.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.common.MetricGoal goals = 17;</code>
     */
    public java.util.List<com.google.ads.googleads.v18.common.MetricGoal.Builder> 
         getGoalsBuilderList() {
      return getGoalsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v18.common.MetricGoal, com.google.ads.googleads.v18.common.MetricGoal.Builder, com.google.ads.googleads.v18.common.MetricGoalOrBuilder> 
        getGoalsFieldBuilder() {
      if (goalsBuilder_ == null) {
        goalsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v18.common.MetricGoal, com.google.ads.googleads.v18.common.MetricGoal.Builder, com.google.ads.googleads.v18.common.MetricGoalOrBuilder>(
                goals_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        goals_ = null;
      }
      return goalsBuilder_;
    }

    private java.lang.Object longRunningOperation_ = "";
    /**
     * <pre>
     * Output only. The resource name of the long-running operation that can be
     * used to poll for completion of experiment schedule or promote. The most
     * recent long running operation is returned.
     * </pre>
     *
     * <code>optional string long_running_operation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the longRunningOperation field is set.
     */
    public boolean hasLongRunningOperation() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     * Output only. The resource name of the long-running operation that can be
     * used to poll for completion of experiment schedule or promote. The most
     * recent long running operation is returned.
     * </pre>
     *
     * <code>optional string long_running_operation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The longRunningOperation.
     */
    public java.lang.String getLongRunningOperation() {
      java.lang.Object ref = longRunningOperation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        longRunningOperation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the long-running operation that can be
     * used to poll for completion of experiment schedule or promote. The most
     * recent long running operation is returned.
     * </pre>
     *
     * <code>optional string long_running_operation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for longRunningOperation.
     */
    public com.google.protobuf.ByteString
        getLongRunningOperationBytes() {
      java.lang.Object ref = longRunningOperation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        longRunningOperation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the long-running operation that can be
     * used to poll for completion of experiment schedule or promote. The most
     * recent long running operation is returned.
     * </pre>
     *
     * <code>optional string long_running_operation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The longRunningOperation to set.
     * @return This builder for chaining.
     */
    public Builder setLongRunningOperation(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      longRunningOperation_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the long-running operation that can be
     * used to poll for completion of experiment schedule or promote. The most
     * recent long running operation is returned.
     * </pre>
     *
     * <code>optional string long_running_operation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearLongRunningOperation() {
      longRunningOperation_ = getDefaultInstance().getLongRunningOperation();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the long-running operation that can be
     * used to poll for completion of experiment schedule or promote. The most
     * recent long running operation is returned.
     * </pre>
     *
     * <code>optional string long_running_operation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for longRunningOperation to set.
     * @return This builder for chaining.
     */
    public Builder setLongRunningOperationBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      longRunningOperation_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private int promoteStatus_ = 0;
    /**
     * <pre>
     * Output only. The status of the experiment promotion process.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus promote_status = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for promoteStatus.
     */
    @java.lang.Override public int getPromoteStatusValue() {
      return promoteStatus_;
    }
    /**
     * <pre>
     * Output only. The status of the experiment promotion process.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus promote_status = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for promoteStatus to set.
     * @return This builder for chaining.
     */
    public Builder setPromoteStatusValue(int value) {
      promoteStatus_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The status of the experiment promotion process.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus promote_status = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The promoteStatus.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus getPromoteStatus() {
      com.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus result = com.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus.forNumber(promoteStatus_);
      return result == null ? com.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The status of the experiment promotion process.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus promote_status = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The promoteStatus to set.
     * @return This builder for chaining.
     */
    public Builder setPromoteStatus(com.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      promoteStatus_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The status of the experiment promotion process.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.AsyncActionStatusEnum.AsyncActionStatus promote_status = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearPromoteStatus() {
      bitField0_ = (bitField0_ & ~0x00000800);
      promoteStatus_ = 0;
      onChanged();
      return this;
    }

    private boolean syncEnabled_ ;
    /**
     * <pre>
     * Immutable. Set to true if changes to base campaigns should be synced to the
     * trial campaigns. Any changes made directly to trial campaigns will be
     * preserved. This field can only be set when the experiment is being created.
     * </pre>
     *
     * <code>optional bool sync_enabled = 20 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return Whether the syncEnabled field is set.
     */
    @java.lang.Override
    public boolean hasSyncEnabled() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     * <pre>
     * Immutable. Set to true if changes to base campaigns should be synced to the
     * trial campaigns. Any changes made directly to trial campaigns will be
     * preserved. This field can only be set when the experiment is being created.
     * </pre>
     *
     * <code>optional bool sync_enabled = 20 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The syncEnabled.
     */
    @java.lang.Override
    public boolean getSyncEnabled() {
      return syncEnabled_;
    }
    /**
     * <pre>
     * Immutable. Set to true if changes to base campaigns should be synced to the
     * trial campaigns. Any changes made directly to trial campaigns will be
     * preserved. This field can only be set when the experiment is being created.
     * </pre>
     *
     * <code>optional bool sync_enabled = 20 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param value The syncEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setSyncEnabled(boolean value) {

      syncEnabled_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. Set to true if changes to base campaigns should be synced to the
     * trial campaigns. Any changes made directly to trial campaigns will be
     * preserved. This field can only be set when the experiment is being created.
     * </pre>
     *
     * <code>optional bool sync_enabled = 20 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return This builder for chaining.
     */
    public Builder clearSyncEnabled() {
      bitField0_ = (bitField0_ & ~0x00001000);
      syncEnabled_ = false;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v18.resources.Experiment)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v18.resources.Experiment)
  private static final com.google.ads.googleads.v18.resources.Experiment DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v18.resources.Experiment();
  }

  public static com.google.ads.googleads.v18.resources.Experiment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Experiment>
      PARSER = new com.google.protobuf.AbstractParser<Experiment>() {
    @java.lang.Override
    public Experiment parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<Experiment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Experiment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v18.resources.Experiment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

