// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v18/resources/shopping_product.proto

// Protobuf Java Version: 3.25.7
package com.google.ads.googleads.v18.resources;

/**
 * <pre>
 * A shopping product from Google Merchant Center that can be advertised by
 * campaigns.
 *
 * The resource returns currently existing products from Google Merchant Center
 * accounts linked with the customer. A campaign includes a product by
 * specifying its merchant id (or, if available, the Multi Client Account id of
 * the merchant) in the `ShoppingSetting`, and can limit the inclusion to
 * products having a specified feed label. Standard Shopping campaigns can also
 * limit the inclusion through a `campaign_criterion.listing_scope`.
 *
 * Queries to this resource specify a scope:
 * Account:
 *   - Filters on campaigns or ad groups are not specified.
 *   - All products from the linked Google Merchant Center accounts are
 *     returned.
 *   - Metrics and some fields (see the per-field documentation) are aggregated
 *     across all Shopping and Performance Max campaigns that include a product.
 * Campaign:
 *   - An equality filter on `campaign` is specified. Supported campaign types
 *     are Shopping, Performance Max, Demand Gen, Video.
 *   - Only products that are included by the specified campaign are returned.
 *   - Metrics and some fields (see the per-field documentation) are restricted
 *     to the specified campaign.
 * Ad group:
 *   - An equality filter on `ad group` and `campaign` is specified. Supported
 *     campaign types are Shopping, Demand Gen, Video.
 *   - Only products that are included by the specified campaign are returned.
 *   - Metrics and some fields (see the per-field documentation) are restricted
 *     to the specified ad group.
 * Note that segmentation by date segments is not permitted and will return
 * UNSUPPORTED_DATE_SEGMENTATION error. On the other hand, filtering on date
 * segments is allowed.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v18.resources.ShoppingProduct}
 */
public final class ShoppingProduct extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v18.resources.ShoppingProduct)
    ShoppingProductOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ShoppingProduct.newBuilder() to construct.
  private ShoppingProduct(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ShoppingProduct() {
    resourceName_ = "";
    channel_ = 0;
    languageCode_ = "";
    feedLabel_ = "";
    itemId_ = "";
    title_ = "";
    brand_ = "";
    currencyCode_ = "";
    channelExclusivity_ = 0;
    condition_ = 0;
    availability_ = 0;
    targetCountries_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    customAttribute0_ = "";
    customAttribute1_ = "";
    customAttribute2_ = "";
    customAttribute3_ = "";
    customAttribute4_ = "";
    categoryLevel1_ = "";
    categoryLevel2_ = "";
    categoryLevel3_ = "";
    categoryLevel4_ = "";
    categoryLevel5_ = "";
    productTypeLevel1_ = "";
    productTypeLevel2_ = "";
    productTypeLevel3_ = "";
    productTypeLevel4_ = "";
    productTypeLevel5_ = "";
    status_ = 0;
    issues_ = java.util.Collections.emptyList();
    campaign_ = "";
    adGroup_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new ShoppingProduct();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v18.resources.ShoppingProductProto.internal_static_google_ads_googleads_v18_resources_ShoppingProduct_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v18.resources.ShoppingProductProto.internal_static_google_ads_googleads_v18_resources_ShoppingProduct_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v18.resources.ShoppingProduct.class, com.google.ads.googleads.v18.resources.ShoppingProduct.Builder.class);
  }

  public interface ProductIssueOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Output only. The error code that identifies the issue.
     * </pre>
     *
     * <code>string error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The errorCode.
     */
    java.lang.String getErrorCode();
    /**
     * <pre>
     * Output only. The error code that identifies the issue.
     * </pre>
     *
     * <code>string error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for errorCode.
     */
    com.google.protobuf.ByteString
        getErrorCodeBytes();

    /**
     * <pre>
     * Output only. The severity of the issue in Google Ads.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity ads_severity = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for adsSeverity.
     */
    int getAdsSeverityValue();
    /**
     * <pre>
     * Output only. The severity of the issue in Google Ads.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity ads_severity = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The adsSeverity.
     */
    com.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity getAdsSeverity();

    /**
     * <pre>
     * Output only. The name of the product's attribute, if any, that triggered
     * the issue.
     * </pre>
     *
     * <code>optional string attribute_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the attributeName field is set.
     */
    boolean hasAttributeName();
    /**
     * <pre>
     * Output only. The name of the product's attribute, if any, that triggered
     * the issue.
     * </pre>
     *
     * <code>optional string attribute_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The attributeName.
     */
    java.lang.String getAttributeName();
    /**
     * <pre>
     * Output only. The name of the product's attribute, if any, that triggered
     * the issue.
     * </pre>
     *
     * <code>optional string attribute_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for attributeName.
     */
    com.google.protobuf.ByteString
        getAttributeNameBytes();

    /**
     * <pre>
     * Output only. The short description of the issue in English.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     * <pre>
     * Output only. The short description of the issue in English.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString
        getDescriptionBytes();

    /**
     * <pre>
     * Output only. The detailed description of the issue in English.
     * </pre>
     *
     * <code>string detail = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The detail.
     */
    java.lang.String getDetail();
    /**
     * <pre>
     * Output only. The detailed description of the issue in English.
     * </pre>
     *
     * <code>string detail = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for detail.
     */
    com.google.protobuf.ByteString
        getDetailBytes();

    /**
     * <pre>
     * Output only. The URL of the Help Center article for the issue.
     * </pre>
     *
     * <code>string documentation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The documentation.
     */
    java.lang.String getDocumentation();
    /**
     * <pre>
     * Output only. The URL of the Help Center article for the issue.
     * </pre>
     *
     * <code>string documentation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for documentation.
     */
    com.google.protobuf.ByteString
        getDocumentationBytes();

    /**
     * <pre>
     * Output only. List of upper-case two-letter ISO 3166-1 codes of the
     * regions affected by the issue. If empty, all regions are affected.
     * </pre>
     *
     * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return A list containing the affectedRegions.
     */
    java.util.List<java.lang.String>
        getAffectedRegionsList();
    /**
     * <pre>
     * Output only. List of upper-case two-letter ISO 3166-1 codes of the
     * regions affected by the issue. If empty, all regions are affected.
     * </pre>
     *
     * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The count of affectedRegions.
     */
    int getAffectedRegionsCount();
    /**
     * <pre>
     * Output only. List of upper-case two-letter ISO 3166-1 codes of the
     * regions affected by the issue. If empty, all regions are affected.
     * </pre>
     *
     * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index of the element to return.
     * @return The affectedRegions at the given index.
     */
    java.lang.String getAffectedRegions(int index);
    /**
     * <pre>
     * Output only. List of upper-case two-letter ISO 3166-1 codes of the
     * regions affected by the issue. If empty, all regions are affected.
     * </pre>
     *
     * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index of the value to return.
     * @return The bytes of the affectedRegions at the given index.
     */
    com.google.protobuf.ByteString
        getAffectedRegionsBytes(int index);
  }
  /**
   * <pre>
   * An issue affecting whether a product can show in ads.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue}
   */
  public static final class ProductIssue extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue)
      ProductIssueOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ProductIssue.newBuilder() to construct.
    private ProductIssue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ProductIssue() {
      errorCode_ = "";
      adsSeverity_ = 0;
      attributeName_ = "";
      description_ = "";
      detail_ = "";
      documentation_ = "";
      affectedRegions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ProductIssue();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v18.resources.ShoppingProductProto.internal_static_google_ads_googleads_v18_resources_ShoppingProduct_ProductIssue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v18.resources.ShoppingProductProto.internal_static_google_ads_googleads_v18_resources_ShoppingProduct_ProductIssue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.class, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.Builder.class);
    }

    private int bitField0_;
    public static final int ERROR_CODE_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object errorCode_ = "";
    /**
     * <pre>
     * Output only. The error code that identifies the issue.
     * </pre>
     *
     * <code>string error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The errorCode.
     */
    @java.lang.Override
    public java.lang.String getErrorCode() {
      java.lang.Object ref = errorCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorCode_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Output only. The error code that identifies the issue.
     * </pre>
     *
     * <code>string error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for errorCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getErrorCodeBytes() {
      java.lang.Object ref = errorCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        errorCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ADS_SEVERITY_FIELD_NUMBER = 2;
    private int adsSeverity_ = 0;
    /**
     * <pre>
     * Output only. The severity of the issue in Google Ads.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity ads_severity = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for adsSeverity.
     */
    @java.lang.Override public int getAdsSeverityValue() {
      return adsSeverity_;
    }
    /**
     * <pre>
     * Output only. The severity of the issue in Google Ads.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity ads_severity = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The adsSeverity.
     */
    @java.lang.Override public com.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity getAdsSeverity() {
      com.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity result = com.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity.forNumber(adsSeverity_);
      return result == null ? com.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity.UNRECOGNIZED : result;
    }

    public static final int ATTRIBUTE_NAME_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private volatile java.lang.Object attributeName_ = "";
    /**
     * <pre>
     * Output only. The name of the product's attribute, if any, that triggered
     * the issue.
     * </pre>
     *
     * <code>optional string attribute_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the attributeName field is set.
     */
    @java.lang.Override
    public boolean hasAttributeName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Output only. The name of the product's attribute, if any, that triggered
     * the issue.
     * </pre>
     *
     * <code>optional string attribute_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The attributeName.
     */
    @java.lang.Override
    public java.lang.String getAttributeName() {
      java.lang.Object ref = attributeName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        attributeName_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Output only. The name of the product's attribute, if any, that triggered
     * the issue.
     * </pre>
     *
     * <code>optional string attribute_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for attributeName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getAttributeNameBytes() {
      java.lang.Object ref = attributeName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        attributeName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 4;
    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     * <pre>
     * Output only. The short description of the issue in English.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Output only. The short description of the issue in English.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DETAIL_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private volatile java.lang.Object detail_ = "";
    /**
     * <pre>
     * Output only. The detailed description of the issue in English.
     * </pre>
     *
     * <code>string detail = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The detail.
     */
    @java.lang.Override
    public java.lang.String getDetail() {
      java.lang.Object ref = detail_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        detail_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Output only. The detailed description of the issue in English.
     * </pre>
     *
     * <code>string detail = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for detail.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getDetailBytes() {
      java.lang.Object ref = detail_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        detail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DOCUMENTATION_FIELD_NUMBER = 6;
    @SuppressWarnings("serial")
    private volatile java.lang.Object documentation_ = "";
    /**
     * <pre>
     * Output only. The URL of the Help Center article for the issue.
     * </pre>
     *
     * <code>string documentation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The documentation.
     */
    @java.lang.Override
    public java.lang.String getDocumentation() {
      java.lang.Object ref = documentation_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        documentation_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Output only. The URL of the Help Center article for the issue.
     * </pre>
     *
     * <code>string documentation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for documentation.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getDocumentationBytes() {
      java.lang.Object ref = documentation_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        documentation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AFFECTED_REGIONS_FIELD_NUMBER = 7;
    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList affectedRegions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     * <pre>
     * Output only. List of upper-case two-letter ISO 3166-1 codes of the
     * regions affected by the issue. If empty, all regions are affected.
     * </pre>
     *
     * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return A list containing the affectedRegions.
     */
    public com.google.protobuf.ProtocolStringList
        getAffectedRegionsList() {
      return affectedRegions_;
    }
    /**
     * <pre>
     * Output only. List of upper-case two-letter ISO 3166-1 codes of the
     * regions affected by the issue. If empty, all regions are affected.
     * </pre>
     *
     * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The count of affectedRegions.
     */
    public int getAffectedRegionsCount() {
      return affectedRegions_.size();
    }
    /**
     * <pre>
     * Output only. List of upper-case two-letter ISO 3166-1 codes of the
     * regions affected by the issue. If empty, all regions are affected.
     * </pre>
     *
     * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index of the element to return.
     * @return The affectedRegions at the given index.
     */
    public java.lang.String getAffectedRegions(int index) {
      return affectedRegions_.get(index);
    }
    /**
     * <pre>
     * Output only. List of upper-case two-letter ISO 3166-1 codes of the
     * regions affected by the issue. If empty, all regions are affected.
     * </pre>
     *
     * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index of the value to return.
     * @return The bytes of the affectedRegions at the given index.
     */
    public com.google.protobuf.ByteString
        getAffectedRegionsBytes(int index) {
      return affectedRegions_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, errorCode_);
      }
      if (adsSeverity_ != com.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity.UNSPECIFIED.getNumber()) {
        output.writeEnum(2, adsSeverity_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, attributeName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, description_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detail_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, detail_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentation_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, documentation_);
      }
      for (int i = 0; i < affectedRegions_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, affectedRegions_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, errorCode_);
      }
      if (adsSeverity_ != com.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity.UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, adsSeverity_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, attributeName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, description_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detail_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, detail_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentation_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, documentation_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < affectedRegions_.size(); i++) {
          dataSize += computeStringSizeNoTag(affectedRegions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAffectedRegionsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue)) {
        return super.equals(obj);
      }
      com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue other = (com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue) obj;

      if (!getErrorCode()
          .equals(other.getErrorCode())) return false;
      if (adsSeverity_ != other.adsSeverity_) return false;
      if (hasAttributeName() != other.hasAttributeName()) return false;
      if (hasAttributeName()) {
        if (!getAttributeName()
            .equals(other.getAttributeName())) return false;
      }
      if (!getDescription()
          .equals(other.getDescription())) return false;
      if (!getDetail()
          .equals(other.getDetail())) return false;
      if (!getDocumentation()
          .equals(other.getDocumentation())) return false;
      if (!getAffectedRegionsList()
          .equals(other.getAffectedRegionsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ERROR_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getErrorCode().hashCode();
      hash = (37 * hash) + ADS_SEVERITY_FIELD_NUMBER;
      hash = (53 * hash) + adsSeverity_;
      if (hasAttributeName()) {
        hash = (37 * hash) + ATTRIBUTE_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getAttributeName().hashCode();
      }
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + DETAIL_FIELD_NUMBER;
      hash = (53 * hash) + getDetail().hashCode();
      hash = (37 * hash) + DOCUMENTATION_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentation().hashCode();
      if (getAffectedRegionsCount() > 0) {
        hash = (37 * hash) + AFFECTED_REGIONS_FIELD_NUMBER;
        hash = (53 * hash) + getAffectedRegionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * An issue affecting whether a product can show in ads.
     * </pre>
     *
     * Protobuf type {@code google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue)
        com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.ads.googleads.v18.resources.ShoppingProductProto.internal_static_google_ads_googleads_v18_resources_ShoppingProduct_ProductIssue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.ads.googleads.v18.resources.ShoppingProductProto.internal_static_google_ads_googleads_v18_resources_ShoppingProduct_ProductIssue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.class, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.Builder.class);
      }

      // Construct using com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        errorCode_ = "";
        adsSeverity_ = 0;
        attributeName_ = "";
        description_ = "";
        detail_ = "";
        documentation_ = "";
        affectedRegions_ =
            com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.ads.googleads.v18.resources.ShoppingProductProto.internal_static_google_ads_googleads_v18_resources_ShoppingProduct_ProductIssue_descriptor;
      }

      @java.lang.Override
      public com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue getDefaultInstanceForType() {
        return com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue build() {
        com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue buildPartial() {
        com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue result = new com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.errorCode_ = errorCode_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.adsSeverity_ = adsSeverity_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.attributeName_ = attributeName_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.detail_ = detail_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.documentation_ = documentation_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          affectedRegions_.makeImmutable();
          result.affectedRegions_ = affectedRegions_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue) {
          return mergeFrom((com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue other) {
        if (other == com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.getDefaultInstance()) return this;
        if (!other.getErrorCode().isEmpty()) {
          errorCode_ = other.errorCode_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.adsSeverity_ != 0) {
          setAdsSeverityValue(other.getAdsSeverityValue());
        }
        if (other.hasAttributeName()) {
          attributeName_ = other.attributeName_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getDetail().isEmpty()) {
          detail_ = other.detail_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (!other.getDocumentation().isEmpty()) {
          documentation_ = other.documentation_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        if (!other.affectedRegions_.isEmpty()) {
          if (affectedRegions_.isEmpty()) {
            affectedRegions_ = other.affectedRegions_;
            bitField0_ |= 0x00000040;
          } else {
            ensureAffectedRegionsIsMutable();
            affectedRegions_.addAll(other.affectedRegions_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                errorCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 16: {
                adsSeverity_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              case 26: {
                attributeName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              case 42: {
                detail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
              case 50: {
                documentation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
              case 58: {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAffectedRegionsIsMutable();
                affectedRegions_.add(s);
                break;
              } // case 58
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object errorCode_ = "";
      /**
       * <pre>
       * Output only. The error code that identifies the issue.
       * </pre>
       *
       * <code>string error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The errorCode.
       */
      public java.lang.String getErrorCode() {
        java.lang.Object ref = errorCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          errorCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Output only. The error code that identifies the issue.
       * </pre>
       *
       * <code>string error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The bytes for errorCode.
       */
      public com.google.protobuf.ByteString
          getErrorCodeBytes() {
        java.lang.Object ref = errorCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          errorCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Output only. The error code that identifies the issue.
       * </pre>
       *
       * <code>string error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The errorCode to set.
       * @return This builder for chaining.
       */
      public Builder setErrorCode(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        errorCode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The error code that identifies the issue.
       * </pre>
       *
       * <code>string error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return This builder for chaining.
       */
      public Builder clearErrorCode() {
        errorCode_ = getDefaultInstance().getErrorCode();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The error code that identifies the issue.
       * </pre>
       *
       * <code>string error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The bytes for errorCode to set.
       * @return This builder for chaining.
       */
      public Builder setErrorCodeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        errorCode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int adsSeverity_ = 0;
      /**
       * <pre>
       * Output only. The severity of the issue in Google Ads.
       * </pre>
       *
       * <code>.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity ads_severity = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The enum numeric value on the wire for adsSeverity.
       */
      @java.lang.Override public int getAdsSeverityValue() {
        return adsSeverity_;
      }
      /**
       * <pre>
       * Output only. The severity of the issue in Google Ads.
       * </pre>
       *
       * <code>.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity ads_severity = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The enum numeric value on the wire for adsSeverity to set.
       * @return This builder for chaining.
       */
      public Builder setAdsSeverityValue(int value) {
        adsSeverity_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The severity of the issue in Google Ads.
       * </pre>
       *
       * <code>.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity ads_severity = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The adsSeverity.
       */
      @java.lang.Override
      public com.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity getAdsSeverity() {
        com.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity result = com.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity.forNumber(adsSeverity_);
        return result == null ? com.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Output only. The severity of the issue in Google Ads.
       * </pre>
       *
       * <code>.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity ads_severity = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The adsSeverity to set.
       * @return This builder for chaining.
       */
      public Builder setAdsSeverity(com.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        adsSeverity_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The severity of the issue in Google Ads.
       * </pre>
       *
       * <code>.google.ads.googleads.v18.enums.ProductIssueSeverityEnum.ProductIssueSeverity ads_severity = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return This builder for chaining.
       */
      public Builder clearAdsSeverity() {
        bitField0_ = (bitField0_ & ~0x00000002);
        adsSeverity_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object attributeName_ = "";
      /**
       * <pre>
       * Output only. The name of the product's attribute, if any, that triggered
       * the issue.
       * </pre>
       *
       * <code>optional string attribute_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return Whether the attributeName field is set.
       */
      public boolean hasAttributeName() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Output only. The name of the product's attribute, if any, that triggered
       * the issue.
       * </pre>
       *
       * <code>optional string attribute_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The attributeName.
       */
      public java.lang.String getAttributeName() {
        java.lang.Object ref = attributeName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          attributeName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Output only. The name of the product's attribute, if any, that triggered
       * the issue.
       * </pre>
       *
       * <code>optional string attribute_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The bytes for attributeName.
       */
      public com.google.protobuf.ByteString
          getAttributeNameBytes() {
        java.lang.Object ref = attributeName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          attributeName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Output only. The name of the product's attribute, if any, that triggered
       * the issue.
       * </pre>
       *
       * <code>optional string attribute_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The attributeName to set.
       * @return This builder for chaining.
       */
      public Builder setAttributeName(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        attributeName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The name of the product's attribute, if any, that triggered
       * the issue.
       * </pre>
       *
       * <code>optional string attribute_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return This builder for chaining.
       */
      public Builder clearAttributeName() {
        attributeName_ = getDefaultInstance().getAttributeName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The name of the product's attribute, if any, that triggered
       * the issue.
       * </pre>
       *
       * <code>optional string attribute_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The bytes for attributeName to set.
       * @return This builder for chaining.
       */
      public Builder setAttributeNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        attributeName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       * <pre>
       * Output only. The short description of the issue in English.
       * </pre>
       *
       * <code>string description = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Output only. The short description of the issue in English.
       * </pre>
       *
       * <code>string description = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString
          getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Output only. The short description of the issue in English.
       * </pre>
       *
       * <code>string description = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        description_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The short description of the issue in English.
       * </pre>
       *
       * <code>string description = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The short description of the issue in English.
       * </pre>
       *
       * <code>string description = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object detail_ = "";
      /**
       * <pre>
       * Output only. The detailed description of the issue in English.
       * </pre>
       *
       * <code>string detail = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The detail.
       */
      public java.lang.String getDetail() {
        java.lang.Object ref = detail_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          detail_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Output only. The detailed description of the issue in English.
       * </pre>
       *
       * <code>string detail = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The bytes for detail.
       */
      public com.google.protobuf.ByteString
          getDetailBytes() {
        java.lang.Object ref = detail_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          detail_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Output only. The detailed description of the issue in English.
       * </pre>
       *
       * <code>string detail = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The detail to set.
       * @return This builder for chaining.
       */
      public Builder setDetail(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        detail_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The detailed description of the issue in English.
       * </pre>
       *
       * <code>string detail = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return This builder for chaining.
       */
      public Builder clearDetail() {
        detail_ = getDefaultInstance().getDetail();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The detailed description of the issue in English.
       * </pre>
       *
       * <code>string detail = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The bytes for detail to set.
       * @return This builder for chaining.
       */
      public Builder setDetailBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        detail_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private java.lang.Object documentation_ = "";
      /**
       * <pre>
       * Output only. The URL of the Help Center article for the issue.
       * </pre>
       *
       * <code>string documentation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The documentation.
       */
      public java.lang.String getDocumentation() {
        java.lang.Object ref = documentation_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          documentation_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Output only. The URL of the Help Center article for the issue.
       * </pre>
       *
       * <code>string documentation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The bytes for documentation.
       */
      public com.google.protobuf.ByteString
          getDocumentationBytes() {
        java.lang.Object ref = documentation_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          documentation_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Output only. The URL of the Help Center article for the issue.
       * </pre>
       *
       * <code>string documentation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The documentation to set.
       * @return This builder for chaining.
       */
      public Builder setDocumentation(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        documentation_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The URL of the Help Center article for the issue.
       * </pre>
       *
       * <code>string documentation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return This builder for chaining.
       */
      public Builder clearDocumentation() {
        documentation_ = getDefaultInstance().getDocumentation();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The URL of the Help Center article for the issue.
       * </pre>
       *
       * <code>string documentation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The bytes for documentation to set.
       * @return This builder for chaining.
       */
      public Builder setDocumentationBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        documentation_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList affectedRegions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      private void ensureAffectedRegionsIsMutable() {
        if (!affectedRegions_.isModifiable()) {
          affectedRegions_ = new com.google.protobuf.LazyStringArrayList(affectedRegions_);
        }
        bitField0_ |= 0x00000040;
      }
      /**
       * <pre>
       * Output only. List of upper-case two-letter ISO 3166-1 codes of the
       * regions affected by the issue. If empty, all regions are affected.
       * </pre>
       *
       * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return A list containing the affectedRegions.
       */
      public com.google.protobuf.ProtocolStringList
          getAffectedRegionsList() {
        affectedRegions_.makeImmutable();
        return affectedRegions_;
      }
      /**
       * <pre>
       * Output only. List of upper-case two-letter ISO 3166-1 codes of the
       * regions affected by the issue. If empty, all regions are affected.
       * </pre>
       *
       * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The count of affectedRegions.
       */
      public int getAffectedRegionsCount() {
        return affectedRegions_.size();
      }
      /**
       * <pre>
       * Output only. List of upper-case two-letter ISO 3166-1 codes of the
       * regions affected by the issue. If empty, all regions are affected.
       * </pre>
       *
       * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param index The index of the element to return.
       * @return The affectedRegions at the given index.
       */
      public java.lang.String getAffectedRegions(int index) {
        return affectedRegions_.get(index);
      }
      /**
       * <pre>
       * Output only. List of upper-case two-letter ISO 3166-1 codes of the
       * regions affected by the issue. If empty, all regions are affected.
       * </pre>
       *
       * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param index The index of the value to return.
       * @return The bytes of the affectedRegions at the given index.
       */
      public com.google.protobuf.ByteString
          getAffectedRegionsBytes(int index) {
        return affectedRegions_.getByteString(index);
      }
      /**
       * <pre>
       * Output only. List of upper-case two-letter ISO 3166-1 codes of the
       * regions affected by the issue. If empty, all regions are affected.
       * </pre>
       *
       * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param index The index to set the value at.
       * @param value The affectedRegions to set.
       * @return This builder for chaining.
       */
      public Builder setAffectedRegions(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureAffectedRegionsIsMutable();
        affectedRegions_.set(index, value);
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. List of upper-case two-letter ISO 3166-1 codes of the
       * regions affected by the issue. If empty, all regions are affected.
       * </pre>
       *
       * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The affectedRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAffectedRegions(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureAffectedRegionsIsMutable();
        affectedRegions_.add(value);
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. List of upper-case two-letter ISO 3166-1 codes of the
       * regions affected by the issue. If empty, all regions are affected.
       * </pre>
       *
       * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param values The affectedRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAllAffectedRegions(
          java.lang.Iterable<java.lang.String> values) {
        ensureAffectedRegionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, affectedRegions_);
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. List of upper-case two-letter ISO 3166-1 codes of the
       * regions affected by the issue. If empty, all regions are affected.
       * </pre>
       *
       * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return This builder for chaining.
       */
      public Builder clearAffectedRegions() {
        affectedRegions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. List of upper-case two-letter ISO 3166-1 codes of the
       * regions affected by the issue. If empty, all regions are affected.
       * </pre>
       *
       * <code>repeated string affected_regions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The bytes of the affectedRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAffectedRegionsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        ensureAffectedRegionsIsMutable();
        affectedRegions_.add(value);
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue)
    }

    // @@protoc_insertion_point(class_scope:google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue)
    private static final com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue();
    }

    public static com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ProductIssue>
        PARSER = new com.google.protobuf.AbstractParser<ProductIssue>() {
      @java.lang.Override
      public ProductIssue parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<ProductIssue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ProductIssue> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private int bitField0_;
  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Output only. The resource name of the shopping product.
   * Shopping product resource names have the form:
   *
   * `customers/{customer_id}/shoppingProducts/{merchant_center_id}~{channel}~{language_code}~{feed_label}~{item_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name of the shopping product.
   * Shopping product resource names have the form:
   *
   * `customers/{customer_id}/shoppingProducts/{merchant_center_id}~{channel}~{language_code}~{feed_label}~{item_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MERCHANT_CENTER_ID_FIELD_NUMBER = 2;
  private long merchantCenterId_ = 0L;
  /**
   * <pre>
   * Output only. The id of the merchant that owns the product.
   * </pre>
   *
   * <code>int64 merchant_center_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The merchantCenterId.
   */
  @java.lang.Override
  public long getMerchantCenterId() {
    return merchantCenterId_;
  }

  public static final int CHANNEL_FIELD_NUMBER = 3;
  private int channel_ = 0;
  /**
   * <pre>
   * Output only. The product channel describing the locality of the product.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for channel.
   */
  @java.lang.Override public int getChannelValue() {
    return channel_;
  }
  /**
   * <pre>
   * Output only. The product channel describing the locality of the product.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The channel.
   */
  @java.lang.Override public com.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel getChannel() {
    com.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel result = com.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel.forNumber(channel_);
    return result == null ? com.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel.UNRECOGNIZED : result;
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   * <pre>
   * Output only. The language code as provided by the merchant, in BCP 47
   * format.
   * </pre>
   *
   * <code>string language_code = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The language code as provided by the merchant, in BCP 47
   * format.
   * </pre>
   *
   * <code>string language_code = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FEED_LABEL_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private volatile java.lang.Object feedLabel_ = "";
  /**
   * <pre>
   * Output only. The product feed label as provided by the merchant.
   * </pre>
   *
   * <code>string feed_label = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The feedLabel.
   */
  @java.lang.Override
  public java.lang.String getFeedLabel() {
    java.lang.Object ref = feedLabel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      feedLabel_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The product feed label as provided by the merchant.
   * </pre>
   *
   * <code>string feed_label = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for feedLabel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getFeedLabelBytes() {
    java.lang.Object ref = feedLabel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      feedLabel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ITEM_ID_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private volatile java.lang.Object itemId_ = "";
  /**
   * <pre>
   * Output only. The item id of the product as provided by the merchant.
   * </pre>
   *
   * <code>string item_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The itemId.
   */
  @java.lang.Override
  public java.lang.String getItemId() {
    java.lang.Object ref = itemId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      itemId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The item id of the product as provided by the merchant.
   * </pre>
   *
   * <code>string item_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for itemId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getItemIdBytes() {
    java.lang.Object ref = itemId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      itemId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MULTI_CLIENT_ACCOUNT_ID_FIELD_NUMBER = 7;
  private long multiClientAccountId_ = 0L;
  /**
   * <pre>
   * Output only. The id of the Multi Client Account of the merchant, if
   * present.
   * </pre>
   *
   * <code>optional int64 multi_client_account_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the multiClientAccountId field is set.
   */
  @java.lang.Override
  public boolean hasMultiClientAccountId() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Output only. The id of the Multi Client Account of the merchant, if
   * present.
   * </pre>
   *
   * <code>optional int64 multi_client_account_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The multiClientAccountId.
   */
  @java.lang.Override
  public long getMultiClientAccountId() {
    return multiClientAccountId_;
  }

  public static final int TITLE_FIELD_NUMBER = 8;
  @SuppressWarnings("serial")
  private volatile java.lang.Object title_ = "";
  /**
   * <pre>
   * Output only. The title of the product as provided by the merchant.
   * </pre>
   *
   * <code>optional string title = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the title field is set.
   */
  @java.lang.Override
  public boolean hasTitle() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Output only. The title of the product as provided by the merchant.
   * </pre>
   *
   * <code>optional string title = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The title.
   */
  @java.lang.Override
  public java.lang.String getTitle() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      title_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The title of the product as provided by the merchant.
   * </pre>
   *
   * <code>optional string title = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for title.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getTitleBytes() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      title_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BRAND_FIELD_NUMBER = 9;
  @SuppressWarnings("serial")
  private volatile java.lang.Object brand_ = "";
  /**
   * <pre>
   * Output only. The brand of the product as provided by the merchant.
   * </pre>
   *
   * <code>optional string brand = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the brand field is set.
   */
  @java.lang.Override
  public boolean hasBrand() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Output only. The brand of the product as provided by the merchant.
   * </pre>
   *
   * <code>optional string brand = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The brand.
   */
  @java.lang.Override
  public java.lang.String getBrand() {
    java.lang.Object ref = brand_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      brand_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The brand of the product as provided by the merchant.
   * </pre>
   *
   * <code>optional string brand = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for brand.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getBrandBytes() {
    java.lang.Object ref = brand_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      brand_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRICE_MICROS_FIELD_NUMBER = 10;
  private long priceMicros_ = 0L;
  /**
   * <pre>
   * Output only. The price of the product in micros as provided by the
   * merchant, in the currency specified in `currency_code` (e.g. $2.97 is
   * reported as 2970000).
   * </pre>
   *
   * <code>optional int64 price_micros = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the priceMicros field is set.
   */
  @java.lang.Override
  public boolean hasPriceMicros() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Output only. The price of the product in micros as provided by the
   * merchant, in the currency specified in `currency_code` (e.g. $2.97 is
   * reported as 2970000).
   * </pre>
   *
   * <code>optional int64 price_micros = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The priceMicros.
   */
  @java.lang.Override
  public long getPriceMicros() {
    return priceMicros_;
  }

  public static final int CURRENCY_CODE_FIELD_NUMBER = 11;
  @SuppressWarnings("serial")
  private volatile java.lang.Object currencyCode_ = "";
  /**
   * <pre>
   * Output only. The currency code as provided by the merchant, in ISO 4217
   * format.
   * </pre>
   *
   * <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the currencyCode field is set.
   */
  @java.lang.Override
  public boolean hasCurrencyCode() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * Output only. The currency code as provided by the merchant, in ISO 4217
   * format.
   * </pre>
   *
   * <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The currencyCode.
   */
  @java.lang.Override
  public java.lang.String getCurrencyCode() {
    java.lang.Object ref = currencyCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currencyCode_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The currency code as provided by the merchant, in ISO 4217
   * format.
   * </pre>
   *
   * <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for currencyCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCurrencyCodeBytes() {
    java.lang.Object ref = currencyCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      currencyCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHANNEL_EXCLUSIVITY_FIELD_NUMBER = 12;
  private int channelExclusivity_ = 0;
  /**
   * <pre>
   * Output only. The channel exclusivity of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity channel_exclusivity = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the channelExclusivity field is set.
   */
  @java.lang.Override public boolean hasChannelExclusivity() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * Output only. The channel exclusivity of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity channel_exclusivity = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for channelExclusivity.
   */
  @java.lang.Override public int getChannelExclusivityValue() {
    return channelExclusivity_;
  }
  /**
   * <pre>
   * Output only. The channel exclusivity of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity channel_exclusivity = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The channelExclusivity.
   */
  @java.lang.Override public com.google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity getChannelExclusivity() {
    com.google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity result = com.google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity.forNumber(channelExclusivity_);
    return result == null ? com.google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity.UNRECOGNIZED : result;
  }

  public static final int CONDITION_FIELD_NUMBER = 13;
  private int condition_ = 0;
  /**
   * <pre>
   * Output only. The condition of the product as provided by the merchant.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition condition = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the condition field is set.
   */
  @java.lang.Override public boolean hasCondition() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * Output only. The condition of the product as provided by the merchant.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition condition = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for condition.
   */
  @java.lang.Override public int getConditionValue() {
    return condition_;
  }
  /**
   * <pre>
   * Output only. The condition of the product as provided by the merchant.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition condition = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The condition.
   */
  @java.lang.Override public com.google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition getCondition() {
    com.google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition result = com.google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition.forNumber(condition_);
    return result == null ? com.google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition.UNRECOGNIZED : result;
  }

  public static final int AVAILABILITY_FIELD_NUMBER = 14;
  private int availability_ = 0;
  /**
   * <pre>
   * Output only. The availability of the product as provided by the merchant.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability availability = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the availability field is set.
   */
  @java.lang.Override public boolean hasAvailability() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * Output only. The availability of the product as provided by the merchant.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability availability = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for availability.
   */
  @java.lang.Override public int getAvailabilityValue() {
    return availability_;
  }
  /**
   * <pre>
   * Output only. The availability of the product as provided by the merchant.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability availability = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The availability.
   */
  @java.lang.Override public com.google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability getAvailability() {
    com.google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability result = com.google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability.forNumber(availability_);
    return result == null ? com.google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability.UNRECOGNIZED : result;
  }

  public static final int TARGET_COUNTRIES_FIELD_NUMBER = 15;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList targetCountries_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
   * product is intended to be shown in ads.
   * </pre>
   *
   * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return A list containing the targetCountries.
   */
  public com.google.protobuf.ProtocolStringList
      getTargetCountriesList() {
    return targetCountries_;
  }
  /**
   * <pre>
   * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
   * product is intended to be shown in ads.
   * </pre>
   *
   * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The count of targetCountries.
   */
  public int getTargetCountriesCount() {
    return targetCountries_.size();
  }
  /**
   * <pre>
   * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
   * product is intended to be shown in ads.
   * </pre>
   *
   * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @param index The index of the element to return.
   * @return The targetCountries at the given index.
   */
  public java.lang.String getTargetCountries(int index) {
    return targetCountries_.get(index);
  }
  /**
   * <pre>
   * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
   * product is intended to be shown in ads.
   * </pre>
   *
   * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @param index The index of the value to return.
   * @return The bytes of the targetCountries at the given index.
   */
  public com.google.protobuf.ByteString
      getTargetCountriesBytes(int index) {
    return targetCountries_.getByteString(index);
  }

  public static final int CUSTOM_ATTRIBUTE0_FIELD_NUMBER = 16;
  @SuppressWarnings("serial")
  private volatile java.lang.Object customAttribute0_ = "";
  /**
   * <pre>
   * Output only. The custom attribute 0 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute0 = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the customAttribute0 field is set.
   */
  @java.lang.Override
  public boolean hasCustomAttribute0() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * Output only. The custom attribute 0 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute0 = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The customAttribute0.
   */
  @java.lang.Override
  public java.lang.String getCustomAttribute0() {
    java.lang.Object ref = customAttribute0_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customAttribute0_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The custom attribute 0 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute0 = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for customAttribute0.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCustomAttribute0Bytes() {
    java.lang.Object ref = customAttribute0_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      customAttribute0_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_ATTRIBUTE1_FIELD_NUMBER = 17;
  @SuppressWarnings("serial")
  private volatile java.lang.Object customAttribute1_ = "";
  /**
   * <pre>
   * Output only. The custom attribute 1 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute1 = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the customAttribute1 field is set.
   */
  @java.lang.Override
  public boolean hasCustomAttribute1() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * Output only. The custom attribute 1 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute1 = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The customAttribute1.
   */
  @java.lang.Override
  public java.lang.String getCustomAttribute1() {
    java.lang.Object ref = customAttribute1_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customAttribute1_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The custom attribute 1 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute1 = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for customAttribute1.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCustomAttribute1Bytes() {
    java.lang.Object ref = customAttribute1_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      customAttribute1_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_ATTRIBUTE2_FIELD_NUMBER = 18;
  @SuppressWarnings("serial")
  private volatile java.lang.Object customAttribute2_ = "";
  /**
   * <pre>
   * Output only. The custom attribute 2 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute2 = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the customAttribute2 field is set.
   */
  @java.lang.Override
  public boolean hasCustomAttribute2() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * Output only. The custom attribute 2 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute2 = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The customAttribute2.
   */
  @java.lang.Override
  public java.lang.String getCustomAttribute2() {
    java.lang.Object ref = customAttribute2_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customAttribute2_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The custom attribute 2 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute2 = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for customAttribute2.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCustomAttribute2Bytes() {
    java.lang.Object ref = customAttribute2_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      customAttribute2_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_ATTRIBUTE3_FIELD_NUMBER = 19;
  @SuppressWarnings("serial")
  private volatile java.lang.Object customAttribute3_ = "";
  /**
   * <pre>
   * Output only. The custom attribute 3 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute3 = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the customAttribute3 field is set.
   */
  @java.lang.Override
  public boolean hasCustomAttribute3() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   * <pre>
   * Output only. The custom attribute 3 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute3 = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The customAttribute3.
   */
  @java.lang.Override
  public java.lang.String getCustomAttribute3() {
    java.lang.Object ref = customAttribute3_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customAttribute3_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The custom attribute 3 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute3 = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for customAttribute3.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCustomAttribute3Bytes() {
    java.lang.Object ref = customAttribute3_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      customAttribute3_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_ATTRIBUTE4_FIELD_NUMBER = 20;
  @SuppressWarnings("serial")
  private volatile java.lang.Object customAttribute4_ = "";
  /**
   * <pre>
   * Output only. The custom attribute 4 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute4 = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the customAttribute4 field is set.
   */
  @java.lang.Override
  public boolean hasCustomAttribute4() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   * <pre>
   * Output only. The custom attribute 4 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute4 = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The customAttribute4.
   */
  @java.lang.Override
  public java.lang.String getCustomAttribute4() {
    java.lang.Object ref = customAttribute4_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customAttribute4_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The custom attribute 4 of the product as provided by the
   * merchant.
   * </pre>
   *
   * <code>optional string custom_attribute4 = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for customAttribute4.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCustomAttribute4Bytes() {
    java.lang.Object ref = customAttribute4_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      customAttribute4_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CATEGORY_LEVEL1_FIELD_NUMBER = 21;
  @SuppressWarnings("serial")
  private volatile java.lang.Object categoryLevel1_ = "";
  /**
   * <pre>
   * Output only. The category level 1 of the product.
   * </pre>
   *
   * <code>optional string category_level1 = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the categoryLevel1 field is set.
   */
  @java.lang.Override
  public boolean hasCategoryLevel1() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   * <pre>
   * Output only. The category level 1 of the product.
   * </pre>
   *
   * <code>optional string category_level1 = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The categoryLevel1.
   */
  @java.lang.Override
  public java.lang.String getCategoryLevel1() {
    java.lang.Object ref = categoryLevel1_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      categoryLevel1_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The category level 1 of the product.
   * </pre>
   *
   * <code>optional string category_level1 = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for categoryLevel1.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCategoryLevel1Bytes() {
    java.lang.Object ref = categoryLevel1_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      categoryLevel1_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CATEGORY_LEVEL2_FIELD_NUMBER = 22;
  @SuppressWarnings("serial")
  private volatile java.lang.Object categoryLevel2_ = "";
  /**
   * <pre>
   * Output only. The category level 2 of the product.
   * </pre>
   *
   * <code>optional string category_level2 = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the categoryLevel2 field is set.
   */
  @java.lang.Override
  public boolean hasCategoryLevel2() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   * <pre>
   * Output only. The category level 2 of the product.
   * </pre>
   *
   * <code>optional string category_level2 = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The categoryLevel2.
   */
  @java.lang.Override
  public java.lang.String getCategoryLevel2() {
    java.lang.Object ref = categoryLevel2_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      categoryLevel2_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The category level 2 of the product.
   * </pre>
   *
   * <code>optional string category_level2 = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for categoryLevel2.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCategoryLevel2Bytes() {
    java.lang.Object ref = categoryLevel2_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      categoryLevel2_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CATEGORY_LEVEL3_FIELD_NUMBER = 23;
  @SuppressWarnings("serial")
  private volatile java.lang.Object categoryLevel3_ = "";
  /**
   * <pre>
   * Output only. The category level 3 of the product.
   * </pre>
   *
   * <code>optional string category_level3 = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the categoryLevel3 field is set.
   */
  @java.lang.Override
  public boolean hasCategoryLevel3() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   * <pre>
   * Output only. The category level 3 of the product.
   * </pre>
   *
   * <code>optional string category_level3 = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The categoryLevel3.
   */
  @java.lang.Override
  public java.lang.String getCategoryLevel3() {
    java.lang.Object ref = categoryLevel3_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      categoryLevel3_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The category level 3 of the product.
   * </pre>
   *
   * <code>optional string category_level3 = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for categoryLevel3.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCategoryLevel3Bytes() {
    java.lang.Object ref = categoryLevel3_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      categoryLevel3_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CATEGORY_LEVEL4_FIELD_NUMBER = 24;
  @SuppressWarnings("serial")
  private volatile java.lang.Object categoryLevel4_ = "";
  /**
   * <pre>
   * Output only. The category level 4 of the product.
   * </pre>
   *
   * <code>optional string category_level4 = 24 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the categoryLevel4 field is set.
   */
  @java.lang.Override
  public boolean hasCategoryLevel4() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   * <pre>
   * Output only. The category level 4 of the product.
   * </pre>
   *
   * <code>optional string category_level4 = 24 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The categoryLevel4.
   */
  @java.lang.Override
  public java.lang.String getCategoryLevel4() {
    java.lang.Object ref = categoryLevel4_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      categoryLevel4_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The category level 4 of the product.
   * </pre>
   *
   * <code>optional string category_level4 = 24 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for categoryLevel4.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCategoryLevel4Bytes() {
    java.lang.Object ref = categoryLevel4_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      categoryLevel4_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CATEGORY_LEVEL5_FIELD_NUMBER = 25;
  @SuppressWarnings("serial")
  private volatile java.lang.Object categoryLevel5_ = "";
  /**
   * <pre>
   * Output only. The category level 5 of the product.
   * </pre>
   *
   * <code>optional string category_level5 = 25 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the categoryLevel5 field is set.
   */
  @java.lang.Override
  public boolean hasCategoryLevel5() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   * <pre>
   * Output only. The category level 5 of the product.
   * </pre>
   *
   * <code>optional string category_level5 = 25 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The categoryLevel5.
   */
  @java.lang.Override
  public java.lang.String getCategoryLevel5() {
    java.lang.Object ref = categoryLevel5_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      categoryLevel5_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The category level 5 of the product.
   * </pre>
   *
   * <code>optional string category_level5 = 25 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for categoryLevel5.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCategoryLevel5Bytes() {
    java.lang.Object ref = categoryLevel5_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      categoryLevel5_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCT_TYPE_LEVEL1_FIELD_NUMBER = 26;
  @SuppressWarnings("serial")
  private volatile java.lang.Object productTypeLevel1_ = "";
  /**
   * <pre>
   * Output only. The product type level 1 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level1 = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the productTypeLevel1 field is set.
   */
  @java.lang.Override
  public boolean hasProductTypeLevel1() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   * <pre>
   * Output only. The product type level 1 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level1 = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The productTypeLevel1.
   */
  @java.lang.Override
  public java.lang.String getProductTypeLevel1() {
    java.lang.Object ref = productTypeLevel1_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      productTypeLevel1_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The product type level 1 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level1 = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for productTypeLevel1.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getProductTypeLevel1Bytes() {
    java.lang.Object ref = productTypeLevel1_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      productTypeLevel1_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCT_TYPE_LEVEL2_FIELD_NUMBER = 27;
  @SuppressWarnings("serial")
  private volatile java.lang.Object productTypeLevel2_ = "";
  /**
   * <pre>
   * Output only. The product type level 2 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level2 = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the productTypeLevel2 field is set.
   */
  @java.lang.Override
  public boolean hasProductTypeLevel2() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   * <pre>
   * Output only. The product type level 2 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level2 = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The productTypeLevel2.
   */
  @java.lang.Override
  public java.lang.String getProductTypeLevel2() {
    java.lang.Object ref = productTypeLevel2_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      productTypeLevel2_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The product type level 2 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level2 = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for productTypeLevel2.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getProductTypeLevel2Bytes() {
    java.lang.Object ref = productTypeLevel2_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      productTypeLevel2_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCT_TYPE_LEVEL3_FIELD_NUMBER = 28;
  @SuppressWarnings("serial")
  private volatile java.lang.Object productTypeLevel3_ = "";
  /**
   * <pre>
   * Output only. The product type level 3 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level3 = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the productTypeLevel3 field is set.
   */
  @java.lang.Override
  public boolean hasProductTypeLevel3() {
    return ((bitField0_ & 0x00100000) != 0);
  }
  /**
   * <pre>
   * Output only. The product type level 3 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level3 = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The productTypeLevel3.
   */
  @java.lang.Override
  public java.lang.String getProductTypeLevel3() {
    java.lang.Object ref = productTypeLevel3_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      productTypeLevel3_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The product type level 3 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level3 = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for productTypeLevel3.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getProductTypeLevel3Bytes() {
    java.lang.Object ref = productTypeLevel3_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      productTypeLevel3_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCT_TYPE_LEVEL4_FIELD_NUMBER = 29;
  @SuppressWarnings("serial")
  private volatile java.lang.Object productTypeLevel4_ = "";
  /**
   * <pre>
   * Output only. The product type level 4 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level4 = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the productTypeLevel4 field is set.
   */
  @java.lang.Override
  public boolean hasProductTypeLevel4() {
    return ((bitField0_ & 0x00200000) != 0);
  }
  /**
   * <pre>
   * Output only. The product type level 4 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level4 = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The productTypeLevel4.
   */
  @java.lang.Override
  public java.lang.String getProductTypeLevel4() {
    java.lang.Object ref = productTypeLevel4_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      productTypeLevel4_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The product type level 4 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level4 = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for productTypeLevel4.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getProductTypeLevel4Bytes() {
    java.lang.Object ref = productTypeLevel4_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      productTypeLevel4_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCT_TYPE_LEVEL5_FIELD_NUMBER = 30;
  @SuppressWarnings("serial")
  private volatile java.lang.Object productTypeLevel5_ = "";
  /**
   * <pre>
   * Output only. The product type level 5 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level5 = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the productTypeLevel5 field is set.
   */
  @java.lang.Override
  public boolean hasProductTypeLevel5() {
    return ((bitField0_ & 0x00400000) != 0);
  }
  /**
   * <pre>
   * Output only. The product type level 5 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level5 = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The productTypeLevel5.
   */
  @java.lang.Override
  public java.lang.String getProductTypeLevel5() {
    java.lang.Object ref = productTypeLevel5_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      productTypeLevel5_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The product type level 5 as provided by the merchant.
   * </pre>
   *
   * <code>optional string product_type_level5 = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for productTypeLevel5.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getProductTypeLevel5Bytes() {
    java.lang.Object ref = productTypeLevel5_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      productTypeLevel5_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EFFECTIVE_MAX_CPC_MICROS_FIELD_NUMBER = 31;
  private long effectiveMaxCpcMicros_ = 0L;
  /**
   * <pre>
   * Output only. The effective maximum cost-per-click (effective max. CPC) of
   * the product. This field is available only if the query specifies the
   * campaign or ad group scope, and if the campaign uses manual bidding. The
   * value is the highest bid set for the product in product groups across all
   * enabled ad groups. It represents the most you're willing to pay for a click
   * on the product. This field can take up to 24 hours to update.
   * </pre>
   *
   * <code>optional int64 effective_max_cpc_micros = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the effectiveMaxCpcMicros field is set.
   */
  @java.lang.Override
  public boolean hasEffectiveMaxCpcMicros() {
    return ((bitField0_ & 0x00800000) != 0);
  }
  /**
   * <pre>
   * Output only. The effective maximum cost-per-click (effective max. CPC) of
   * the product. This field is available only if the query specifies the
   * campaign or ad group scope, and if the campaign uses manual bidding. The
   * value is the highest bid set for the product in product groups across all
   * enabled ad groups. It represents the most you're willing to pay for a click
   * on the product. This field can take up to 24 hours to update.
   * </pre>
   *
   * <code>optional int64 effective_max_cpc_micros = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The effectiveMaxCpcMicros.
   */
  @java.lang.Override
  public long getEffectiveMaxCpcMicros() {
    return effectiveMaxCpcMicros_;
  }

  public static final int STATUS_FIELD_NUMBER = 32;
  private int status_ = 0;
  /**
   * <pre>
   * Output only. The status that indicates whether the product can show in ads.
   * The value of this field is restricted to the scope specified in the query,
   * see the documentation of the resource.
   * This field can take up to 24 hours to update.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * Output only. The status that indicates whether the product can show in ads.
   * The value of this field is restricted to the scope specified in the query,
   * see the documentation of the resource.
   * This field can take up to 24 hours to update.
   * </pre>
   *
   * <code>.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus getStatus() {
    com.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus result = com.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus.forNumber(status_);
    return result == null ? com.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus.UNRECOGNIZED : result;
  }

  public static final int ISSUES_FIELD_NUMBER = 33;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue> issues_;
  /**
   * <pre>
   * Output only. The list of issues affecting whether the product can show in
   * ads. The value of this field is restricted to the scope specified in the
   * query, see the documentation of the resource. This field can take up to 24
   * hours to update.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue> getIssuesList() {
    return issues_;
  }
  /**
   * <pre>
   * Output only. The list of issues affecting whether the product can show in
   * ads. The value of this field is restricted to the scope specified in the
   * query, see the documentation of the resource. This field can take up to 24
   * hours to update.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssueOrBuilder> 
      getIssuesOrBuilderList() {
    return issues_;
  }
  /**
   * <pre>
   * Output only. The list of issues affecting whether the product can show in
   * ads. The value of this field is restricted to the scope specified in the
   * query, see the documentation of the resource. This field can take up to 24
   * hours to update.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public int getIssuesCount() {
    return issues_.size();
  }
  /**
   * <pre>
   * Output only. The list of issues affecting whether the product can show in
   * ads. The value of this field is restricted to the scope specified in the
   * query, see the documentation of the resource. This field can take up to 24
   * hours to update.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue getIssues(int index) {
    return issues_.get(index);
  }
  /**
   * <pre>
   * Output only. The list of issues affecting whether the product can show in
   * ads. The value of this field is restricted to the scope specified in the
   * query, see the documentation of the resource. This field can take up to 24
   * hours to update.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssueOrBuilder getIssuesOrBuilder(
      int index) {
    return issues_.get(index);
  }

  public static final int CAMPAIGN_FIELD_NUMBER = 34;
  @SuppressWarnings("serial")
  private volatile java.lang.Object campaign_ = "";
  /**
   * <pre>
   * Output only. A campaign that includes the product.
   * This field is selectable only in the campaign scope, which requires an
   * equality filter on `campaign`.
   * </pre>
   *
   * <code>optional string campaign = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the campaign field is set.
   */
  @java.lang.Override
  public boolean hasCampaign() {
    return ((bitField0_ & 0x01000000) != 0);
  }
  /**
   * <pre>
   * Output only. A campaign that includes the product.
   * This field is selectable only in the campaign scope, which requires an
   * equality filter on `campaign`.
   * </pre>
   *
   * <code>optional string campaign = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The campaign.
   */
  @java.lang.Override
  public java.lang.String getCampaign() {
    java.lang.Object ref = campaign_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      campaign_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. A campaign that includes the product.
   * This field is selectable only in the campaign scope, which requires an
   * equality filter on `campaign`.
   * </pre>
   *
   * <code>optional string campaign = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for campaign.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCampaignBytes() {
    java.lang.Object ref = campaign_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      campaign_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AD_GROUP_FIELD_NUMBER = 35;
  @SuppressWarnings("serial")
  private volatile java.lang.Object adGroup_ = "";
  /**
   * <pre>
   * Output only. An ad group of a campaign that includes the product.
   * This field is selectable only in the ad group scope, which requires an
   * equality filter on `campaign` and `ad_group`.
   * </pre>
   *
   * <code>optional string ad_group = 35 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the adGroup field is set.
   */
  @java.lang.Override
  public boolean hasAdGroup() {
    return ((bitField0_ & 0x02000000) != 0);
  }
  /**
   * <pre>
   * Output only. An ad group of a campaign that includes the product.
   * This field is selectable only in the ad group scope, which requires an
   * equality filter on `campaign` and `ad_group`.
   * </pre>
   *
   * <code>optional string ad_group = 35 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The adGroup.
   */
  @java.lang.Override
  public java.lang.String getAdGroup() {
    java.lang.Object ref = adGroup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      adGroup_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. An ad group of a campaign that includes the product.
   * This field is selectable only in the ad group scope, which requires an
   * equality filter on `campaign` and `ad_group`.
   * </pre>
   *
   * <code>optional string ad_group = 35 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for adGroup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getAdGroupBytes() {
    java.lang.Object ref = adGroup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      adGroup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (merchantCenterId_ != 0L) {
      output.writeInt64(2, merchantCenterId_);
    }
    if (channel_ != com.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel.UNSPECIFIED.getNumber()) {
      output.writeEnum(3, channel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, languageCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(feedLabel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, feedLabel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(itemId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, itemId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(7, multiClientAccountId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, title_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, brand_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(10, priceMicros_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, currencyCode_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeEnum(12, channelExclusivity_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeEnum(13, condition_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeEnum(14, availability_);
    }
    for (int i = 0; i < targetCountries_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, targetCountries_.getRaw(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, customAttribute0_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, customAttribute1_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, customAttribute2_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, customAttribute3_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, customAttribute4_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, categoryLevel1_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, categoryLevel2_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 23, categoryLevel3_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 24, categoryLevel4_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, categoryLevel5_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 26, productTypeLevel1_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27, productTypeLevel2_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 28, productTypeLevel3_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 29, productTypeLevel4_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30, productTypeLevel5_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      output.writeInt64(31, effectiveMaxCpcMicros_);
    }
    if (status_ != com.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(32, status_);
    }
    for (int i = 0; i < issues_.size(); i++) {
      output.writeMessage(33, issues_.get(i));
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 34, campaign_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 35, adGroup_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (merchantCenterId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(2, merchantCenterId_);
    }
    if (channel_ != com.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, channel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, languageCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(feedLabel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, feedLabel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(itemId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, itemId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(7, multiClientAccountId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, title_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, brand_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(10, priceMicros_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, currencyCode_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(12, channelExclusivity_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(13, condition_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(14, availability_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetCountries_.size(); i++) {
        dataSize += computeStringSizeNoTag(targetCountries_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTargetCountriesList().size();
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, customAttribute0_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, customAttribute1_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, customAttribute2_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, customAttribute3_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, customAttribute4_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, categoryLevel1_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, categoryLevel2_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(23, categoryLevel3_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(24, categoryLevel4_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, categoryLevel5_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(26, productTypeLevel1_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(27, productTypeLevel2_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(28, productTypeLevel3_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(29, productTypeLevel4_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(30, productTypeLevel5_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(31, effectiveMaxCpcMicros_);
    }
    if (status_ != com.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(32, status_);
    }
    for (int i = 0; i < issues_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(33, issues_.get(i));
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(34, campaign_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(35, adGroup_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v18.resources.ShoppingProduct)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v18.resources.ShoppingProduct other = (com.google.ads.googleads.v18.resources.ShoppingProduct) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (getMerchantCenterId()
        != other.getMerchantCenterId()) return false;
    if (channel_ != other.channel_) return false;
    if (!getLanguageCode()
        .equals(other.getLanguageCode())) return false;
    if (!getFeedLabel()
        .equals(other.getFeedLabel())) return false;
    if (!getItemId()
        .equals(other.getItemId())) return false;
    if (hasMultiClientAccountId() != other.hasMultiClientAccountId()) return false;
    if (hasMultiClientAccountId()) {
      if (getMultiClientAccountId()
          != other.getMultiClientAccountId()) return false;
    }
    if (hasTitle() != other.hasTitle()) return false;
    if (hasTitle()) {
      if (!getTitle()
          .equals(other.getTitle())) return false;
    }
    if (hasBrand() != other.hasBrand()) return false;
    if (hasBrand()) {
      if (!getBrand()
          .equals(other.getBrand())) return false;
    }
    if (hasPriceMicros() != other.hasPriceMicros()) return false;
    if (hasPriceMicros()) {
      if (getPriceMicros()
          != other.getPriceMicros()) return false;
    }
    if (hasCurrencyCode() != other.hasCurrencyCode()) return false;
    if (hasCurrencyCode()) {
      if (!getCurrencyCode()
          .equals(other.getCurrencyCode())) return false;
    }
    if (hasChannelExclusivity() != other.hasChannelExclusivity()) return false;
    if (hasChannelExclusivity()) {
      if (channelExclusivity_ != other.channelExclusivity_) return false;
    }
    if (hasCondition() != other.hasCondition()) return false;
    if (hasCondition()) {
      if (condition_ != other.condition_) return false;
    }
    if (hasAvailability() != other.hasAvailability()) return false;
    if (hasAvailability()) {
      if (availability_ != other.availability_) return false;
    }
    if (!getTargetCountriesList()
        .equals(other.getTargetCountriesList())) return false;
    if (hasCustomAttribute0() != other.hasCustomAttribute0()) return false;
    if (hasCustomAttribute0()) {
      if (!getCustomAttribute0()
          .equals(other.getCustomAttribute0())) return false;
    }
    if (hasCustomAttribute1() != other.hasCustomAttribute1()) return false;
    if (hasCustomAttribute1()) {
      if (!getCustomAttribute1()
          .equals(other.getCustomAttribute1())) return false;
    }
    if (hasCustomAttribute2() != other.hasCustomAttribute2()) return false;
    if (hasCustomAttribute2()) {
      if (!getCustomAttribute2()
          .equals(other.getCustomAttribute2())) return false;
    }
    if (hasCustomAttribute3() != other.hasCustomAttribute3()) return false;
    if (hasCustomAttribute3()) {
      if (!getCustomAttribute3()
          .equals(other.getCustomAttribute3())) return false;
    }
    if (hasCustomAttribute4() != other.hasCustomAttribute4()) return false;
    if (hasCustomAttribute4()) {
      if (!getCustomAttribute4()
          .equals(other.getCustomAttribute4())) return false;
    }
    if (hasCategoryLevel1() != other.hasCategoryLevel1()) return false;
    if (hasCategoryLevel1()) {
      if (!getCategoryLevel1()
          .equals(other.getCategoryLevel1())) return false;
    }
    if (hasCategoryLevel2() != other.hasCategoryLevel2()) return false;
    if (hasCategoryLevel2()) {
      if (!getCategoryLevel2()
          .equals(other.getCategoryLevel2())) return false;
    }
    if (hasCategoryLevel3() != other.hasCategoryLevel3()) return false;
    if (hasCategoryLevel3()) {
      if (!getCategoryLevel3()
          .equals(other.getCategoryLevel3())) return false;
    }
    if (hasCategoryLevel4() != other.hasCategoryLevel4()) return false;
    if (hasCategoryLevel4()) {
      if (!getCategoryLevel4()
          .equals(other.getCategoryLevel4())) return false;
    }
    if (hasCategoryLevel5() != other.hasCategoryLevel5()) return false;
    if (hasCategoryLevel5()) {
      if (!getCategoryLevel5()
          .equals(other.getCategoryLevel5())) return false;
    }
    if (hasProductTypeLevel1() != other.hasProductTypeLevel1()) return false;
    if (hasProductTypeLevel1()) {
      if (!getProductTypeLevel1()
          .equals(other.getProductTypeLevel1())) return false;
    }
    if (hasProductTypeLevel2() != other.hasProductTypeLevel2()) return false;
    if (hasProductTypeLevel2()) {
      if (!getProductTypeLevel2()
          .equals(other.getProductTypeLevel2())) return false;
    }
    if (hasProductTypeLevel3() != other.hasProductTypeLevel3()) return false;
    if (hasProductTypeLevel3()) {
      if (!getProductTypeLevel3()
          .equals(other.getProductTypeLevel3())) return false;
    }
    if (hasProductTypeLevel4() != other.hasProductTypeLevel4()) return false;
    if (hasProductTypeLevel4()) {
      if (!getProductTypeLevel4()
          .equals(other.getProductTypeLevel4())) return false;
    }
    if (hasProductTypeLevel5() != other.hasProductTypeLevel5()) return false;
    if (hasProductTypeLevel5()) {
      if (!getProductTypeLevel5()
          .equals(other.getProductTypeLevel5())) return false;
    }
    if (hasEffectiveMaxCpcMicros() != other.hasEffectiveMaxCpcMicros()) return false;
    if (hasEffectiveMaxCpcMicros()) {
      if (getEffectiveMaxCpcMicros()
          != other.getEffectiveMaxCpcMicros()) return false;
    }
    if (status_ != other.status_) return false;
    if (!getIssuesList()
        .equals(other.getIssuesList())) return false;
    if (hasCampaign() != other.hasCampaign()) return false;
    if (hasCampaign()) {
      if (!getCampaign()
          .equals(other.getCampaign())) return false;
    }
    if (hasAdGroup() != other.hasAdGroup()) return false;
    if (hasAdGroup()) {
      if (!getAdGroup()
          .equals(other.getAdGroup())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + MERCHANT_CENTER_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getMerchantCenterId());
    hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
    hash = (53 * hash) + channel_;
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + FEED_LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getFeedLabel().hashCode();
    hash = (37 * hash) + ITEM_ID_FIELD_NUMBER;
    hash = (53 * hash) + getItemId().hashCode();
    if (hasMultiClientAccountId()) {
      hash = (37 * hash) + MULTI_CLIENT_ACCOUNT_ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getMultiClientAccountId());
    }
    if (hasTitle()) {
      hash = (37 * hash) + TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getTitle().hashCode();
    }
    if (hasBrand()) {
      hash = (37 * hash) + BRAND_FIELD_NUMBER;
      hash = (53 * hash) + getBrand().hashCode();
    }
    if (hasPriceMicros()) {
      hash = (37 * hash) + PRICE_MICROS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getPriceMicros());
    }
    if (hasCurrencyCode()) {
      hash = (37 * hash) + CURRENCY_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getCurrencyCode().hashCode();
    }
    if (hasChannelExclusivity()) {
      hash = (37 * hash) + CHANNEL_EXCLUSIVITY_FIELD_NUMBER;
      hash = (53 * hash) + channelExclusivity_;
    }
    if (hasCondition()) {
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + condition_;
    }
    if (hasAvailability()) {
      hash = (37 * hash) + AVAILABILITY_FIELD_NUMBER;
      hash = (53 * hash) + availability_;
    }
    if (getTargetCountriesCount() > 0) {
      hash = (37 * hash) + TARGET_COUNTRIES_FIELD_NUMBER;
      hash = (53 * hash) + getTargetCountriesList().hashCode();
    }
    if (hasCustomAttribute0()) {
      hash = (37 * hash) + CUSTOM_ATTRIBUTE0_FIELD_NUMBER;
      hash = (53 * hash) + getCustomAttribute0().hashCode();
    }
    if (hasCustomAttribute1()) {
      hash = (37 * hash) + CUSTOM_ATTRIBUTE1_FIELD_NUMBER;
      hash = (53 * hash) + getCustomAttribute1().hashCode();
    }
    if (hasCustomAttribute2()) {
      hash = (37 * hash) + CUSTOM_ATTRIBUTE2_FIELD_NUMBER;
      hash = (53 * hash) + getCustomAttribute2().hashCode();
    }
    if (hasCustomAttribute3()) {
      hash = (37 * hash) + CUSTOM_ATTRIBUTE3_FIELD_NUMBER;
      hash = (53 * hash) + getCustomAttribute3().hashCode();
    }
    if (hasCustomAttribute4()) {
      hash = (37 * hash) + CUSTOM_ATTRIBUTE4_FIELD_NUMBER;
      hash = (53 * hash) + getCustomAttribute4().hashCode();
    }
    if (hasCategoryLevel1()) {
      hash = (37 * hash) + CATEGORY_LEVEL1_FIELD_NUMBER;
      hash = (53 * hash) + getCategoryLevel1().hashCode();
    }
    if (hasCategoryLevel2()) {
      hash = (37 * hash) + CATEGORY_LEVEL2_FIELD_NUMBER;
      hash = (53 * hash) + getCategoryLevel2().hashCode();
    }
    if (hasCategoryLevel3()) {
      hash = (37 * hash) + CATEGORY_LEVEL3_FIELD_NUMBER;
      hash = (53 * hash) + getCategoryLevel3().hashCode();
    }
    if (hasCategoryLevel4()) {
      hash = (37 * hash) + CATEGORY_LEVEL4_FIELD_NUMBER;
      hash = (53 * hash) + getCategoryLevel4().hashCode();
    }
    if (hasCategoryLevel5()) {
      hash = (37 * hash) + CATEGORY_LEVEL5_FIELD_NUMBER;
      hash = (53 * hash) + getCategoryLevel5().hashCode();
    }
    if (hasProductTypeLevel1()) {
      hash = (37 * hash) + PRODUCT_TYPE_LEVEL1_FIELD_NUMBER;
      hash = (53 * hash) + getProductTypeLevel1().hashCode();
    }
    if (hasProductTypeLevel2()) {
      hash = (37 * hash) + PRODUCT_TYPE_LEVEL2_FIELD_NUMBER;
      hash = (53 * hash) + getProductTypeLevel2().hashCode();
    }
    if (hasProductTypeLevel3()) {
      hash = (37 * hash) + PRODUCT_TYPE_LEVEL3_FIELD_NUMBER;
      hash = (53 * hash) + getProductTypeLevel3().hashCode();
    }
    if (hasProductTypeLevel4()) {
      hash = (37 * hash) + PRODUCT_TYPE_LEVEL4_FIELD_NUMBER;
      hash = (53 * hash) + getProductTypeLevel4().hashCode();
    }
    if (hasProductTypeLevel5()) {
      hash = (37 * hash) + PRODUCT_TYPE_LEVEL5_FIELD_NUMBER;
      hash = (53 * hash) + getProductTypeLevel5().hashCode();
    }
    if (hasEffectiveMaxCpcMicros()) {
      hash = (37 * hash) + EFFECTIVE_MAX_CPC_MICROS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getEffectiveMaxCpcMicros());
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    if (getIssuesCount() > 0) {
      hash = (37 * hash) + ISSUES_FIELD_NUMBER;
      hash = (53 * hash) + getIssuesList().hashCode();
    }
    if (hasCampaign()) {
      hash = (37 * hash) + CAMPAIGN_FIELD_NUMBER;
      hash = (53 * hash) + getCampaign().hashCode();
    }
    if (hasAdGroup()) {
      hash = (37 * hash) + AD_GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getAdGroup().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v18.resources.ShoppingProduct parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v18.resources.ShoppingProduct parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.ShoppingProduct parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v18.resources.ShoppingProduct parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.ShoppingProduct parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v18.resources.ShoppingProduct parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.ShoppingProduct parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v18.resources.ShoppingProduct parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v18.resources.ShoppingProduct parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v18.resources.ShoppingProduct parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v18.resources.ShoppingProduct parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v18.resources.ShoppingProduct parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v18.resources.ShoppingProduct prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A shopping product from Google Merchant Center that can be advertised by
   * campaigns.
   *
   * The resource returns currently existing products from Google Merchant Center
   * accounts linked with the customer. A campaign includes a product by
   * specifying its merchant id (or, if available, the Multi Client Account id of
   * the merchant) in the `ShoppingSetting`, and can limit the inclusion to
   * products having a specified feed label. Standard Shopping campaigns can also
   * limit the inclusion through a `campaign_criterion.listing_scope`.
   *
   * Queries to this resource specify a scope:
   * Account:
   *   - Filters on campaigns or ad groups are not specified.
   *   - All products from the linked Google Merchant Center accounts are
   *     returned.
   *   - Metrics and some fields (see the per-field documentation) are aggregated
   *     across all Shopping and Performance Max campaigns that include a product.
   * Campaign:
   *   - An equality filter on `campaign` is specified. Supported campaign types
   *     are Shopping, Performance Max, Demand Gen, Video.
   *   - Only products that are included by the specified campaign are returned.
   *   - Metrics and some fields (see the per-field documentation) are restricted
   *     to the specified campaign.
   * Ad group:
   *   - An equality filter on `ad group` and `campaign` is specified. Supported
   *     campaign types are Shopping, Demand Gen, Video.
   *   - Only products that are included by the specified campaign are returned.
   *   - Metrics and some fields (see the per-field documentation) are restricted
   *     to the specified ad group.
   * Note that segmentation by date segments is not permitted and will return
   * UNSUPPORTED_DATE_SEGMENTATION error. On the other hand, filtering on date
   * segments is allowed.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v18.resources.ShoppingProduct}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v18.resources.ShoppingProduct)
      com.google.ads.googleads.v18.resources.ShoppingProductOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v18.resources.ShoppingProductProto.internal_static_google_ads_googleads_v18_resources_ShoppingProduct_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v18.resources.ShoppingProductProto.internal_static_google_ads_googleads_v18_resources_ShoppingProduct_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v18.resources.ShoppingProduct.class, com.google.ads.googleads.v18.resources.ShoppingProduct.Builder.class);
    }

    // Construct using com.google.ads.googleads.v18.resources.ShoppingProduct.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      resourceName_ = "";
      merchantCenterId_ = 0L;
      channel_ = 0;
      languageCode_ = "";
      feedLabel_ = "";
      itemId_ = "";
      multiClientAccountId_ = 0L;
      title_ = "";
      brand_ = "";
      priceMicros_ = 0L;
      currencyCode_ = "";
      channelExclusivity_ = 0;
      condition_ = 0;
      availability_ = 0;
      targetCountries_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      customAttribute0_ = "";
      customAttribute1_ = "";
      customAttribute2_ = "";
      customAttribute3_ = "";
      customAttribute4_ = "";
      categoryLevel1_ = "";
      categoryLevel2_ = "";
      categoryLevel3_ = "";
      categoryLevel4_ = "";
      categoryLevel5_ = "";
      productTypeLevel1_ = "";
      productTypeLevel2_ = "";
      productTypeLevel3_ = "";
      productTypeLevel4_ = "";
      productTypeLevel5_ = "";
      effectiveMaxCpcMicros_ = 0L;
      status_ = 0;
      if (issuesBuilder_ == null) {
        issues_ = java.util.Collections.emptyList();
      } else {
        issues_ = null;
        issuesBuilder_.clear();
      }
      bitField1_ = (bitField1_ & ~0x00000001);
      campaign_ = "";
      adGroup_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v18.resources.ShoppingProductProto.internal_static_google_ads_googleads_v18_resources_ShoppingProduct_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.ShoppingProduct getDefaultInstanceForType() {
      return com.google.ads.googleads.v18.resources.ShoppingProduct.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.ShoppingProduct build() {
      com.google.ads.googleads.v18.resources.ShoppingProduct result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v18.resources.ShoppingProduct buildPartial() {
      com.google.ads.googleads.v18.resources.ShoppingProduct result = new com.google.ads.googleads.v18.resources.ShoppingProduct(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      if (bitField1_ != 0) { buildPartial1(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ads.googleads.v18.resources.ShoppingProduct result) {
      if (issuesBuilder_ == null) {
        if (((bitField1_ & 0x00000001) != 0)) {
          issues_ = java.util.Collections.unmodifiableList(issues_);
          bitField1_ = (bitField1_ & ~0x00000001);
        }
        result.issues_ = issues_;
      } else {
        result.issues_ = issuesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.ads.googleads.v18.resources.ShoppingProduct result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.merchantCenterId_ = merchantCenterId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.channel_ = channel_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.feedLabel_ = feedLabel_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.itemId_ = itemId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.multiClientAccountId_ = multiClientAccountId_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.title_ = title_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.brand_ = brand_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.priceMicros_ = priceMicros_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.currencyCode_ = currencyCode_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.channelExclusivity_ = channelExclusivity_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.condition_ = condition_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.availability_ = availability_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        targetCountries_.makeImmutable();
        result.targetCountries_ = targetCountries_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.customAttribute0_ = customAttribute0_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.customAttribute1_ = customAttribute1_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.customAttribute2_ = customAttribute2_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.customAttribute3_ = customAttribute3_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.customAttribute4_ = customAttribute4_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.categoryLevel1_ = categoryLevel1_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.categoryLevel2_ = categoryLevel2_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.categoryLevel3_ = categoryLevel3_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.categoryLevel4_ = categoryLevel4_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.categoryLevel5_ = categoryLevel5_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.productTypeLevel1_ = productTypeLevel1_;
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.productTypeLevel2_ = productTypeLevel2_;
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.productTypeLevel3_ = productTypeLevel3_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.productTypeLevel4_ = productTypeLevel4_;
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.productTypeLevel5_ = productTypeLevel5_;
        to_bitField0_ |= 0x00400000;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.effectiveMaxCpcMicros_ = effectiveMaxCpcMicros_;
        to_bitField0_ |= 0x00800000;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.status_ = status_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.ads.googleads.v18.resources.ShoppingProduct result) {
      int from_bitField1_ = bitField1_;
      int to_bitField0_ = 0;
      if (((from_bitField1_ & 0x00000002) != 0)) {
        result.campaign_ = campaign_;
        to_bitField0_ |= 0x01000000;
      }
      if (((from_bitField1_ & 0x00000004) != 0)) {
        result.adGroup_ = adGroup_;
        to_bitField0_ |= 0x02000000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v18.resources.ShoppingProduct) {
        return mergeFrom((com.google.ads.googleads.v18.resources.ShoppingProduct)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v18.resources.ShoppingProduct other) {
      if (other == com.google.ads.googleads.v18.resources.ShoppingProduct.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getMerchantCenterId() != 0L) {
        setMerchantCenterId(other.getMerchantCenterId());
      }
      if (other.channel_ != 0) {
        setChannelValue(other.getChannelValue());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getFeedLabel().isEmpty()) {
        feedLabel_ = other.feedLabel_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getItemId().isEmpty()) {
        itemId_ = other.itemId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasMultiClientAccountId()) {
        setMultiClientAccountId(other.getMultiClientAccountId());
      }
      if (other.hasTitle()) {
        title_ = other.title_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasBrand()) {
        brand_ = other.brand_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasPriceMicros()) {
        setPriceMicros(other.getPriceMicros());
      }
      if (other.hasCurrencyCode()) {
        currencyCode_ = other.currencyCode_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasChannelExclusivity()) {
        setChannelExclusivity(other.getChannelExclusivity());
      }
      if (other.hasCondition()) {
        setCondition(other.getCondition());
      }
      if (other.hasAvailability()) {
        setAvailability(other.getAvailability());
      }
      if (!other.targetCountries_.isEmpty()) {
        if (targetCountries_.isEmpty()) {
          targetCountries_ = other.targetCountries_;
          bitField0_ |= 0x00004000;
        } else {
          ensureTargetCountriesIsMutable();
          targetCountries_.addAll(other.targetCountries_);
        }
        onChanged();
      }
      if (other.hasCustomAttribute0()) {
        customAttribute0_ = other.customAttribute0_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasCustomAttribute1()) {
        customAttribute1_ = other.customAttribute1_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasCustomAttribute2()) {
        customAttribute2_ = other.customAttribute2_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasCustomAttribute3()) {
        customAttribute3_ = other.customAttribute3_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasCustomAttribute4()) {
        customAttribute4_ = other.customAttribute4_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (other.hasCategoryLevel1()) {
        categoryLevel1_ = other.categoryLevel1_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (other.hasCategoryLevel2()) {
        categoryLevel2_ = other.categoryLevel2_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (other.hasCategoryLevel3()) {
        categoryLevel3_ = other.categoryLevel3_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      if (other.hasCategoryLevel4()) {
        categoryLevel4_ = other.categoryLevel4_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      if (other.hasCategoryLevel5()) {
        categoryLevel5_ = other.categoryLevel5_;
        bitField0_ |= 0x01000000;
        onChanged();
      }
      if (other.hasProductTypeLevel1()) {
        productTypeLevel1_ = other.productTypeLevel1_;
        bitField0_ |= 0x02000000;
        onChanged();
      }
      if (other.hasProductTypeLevel2()) {
        productTypeLevel2_ = other.productTypeLevel2_;
        bitField0_ |= 0x04000000;
        onChanged();
      }
      if (other.hasProductTypeLevel3()) {
        productTypeLevel3_ = other.productTypeLevel3_;
        bitField0_ |= 0x08000000;
        onChanged();
      }
      if (other.hasProductTypeLevel4()) {
        productTypeLevel4_ = other.productTypeLevel4_;
        bitField0_ |= 0x10000000;
        onChanged();
      }
      if (other.hasProductTypeLevel5()) {
        productTypeLevel5_ = other.productTypeLevel5_;
        bitField0_ |= 0x20000000;
        onChanged();
      }
      if (other.hasEffectiveMaxCpcMicros()) {
        setEffectiveMaxCpcMicros(other.getEffectiveMaxCpcMicros());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (issuesBuilder_ == null) {
        if (!other.issues_.isEmpty()) {
          if (issues_.isEmpty()) {
            issues_ = other.issues_;
            bitField1_ = (bitField1_ & ~0x00000001);
          } else {
            ensureIssuesIsMutable();
            issues_.addAll(other.issues_);
          }
          onChanged();
        }
      } else {
        if (!other.issues_.isEmpty()) {
          if (issuesBuilder_.isEmpty()) {
            issuesBuilder_.dispose();
            issuesBuilder_ = null;
            issues_ = other.issues_;
            bitField1_ = (bitField1_ & ~0x00000001);
            issuesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getIssuesFieldBuilder() : null;
          } else {
            issuesBuilder_.addAllMessages(other.issues_);
          }
        }
      }
      if (other.hasCampaign()) {
        campaign_ = other.campaign_;
        bitField1_ |= 0x00000002;
        onChanged();
      }
      if (other.hasAdGroup()) {
        adGroup_ = other.adGroup_;
        bitField1_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 16: {
              merchantCenterId_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 16
            case 24: {
              channel_ = input.readEnum();
              bitField0_ |= 0x00000004;
              break;
            } // case 24
            case 34: {
              languageCode_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000008;
              break;
            } // case 34
            case 42: {
              feedLabel_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000010;
              break;
            } // case 42
            case 50: {
              itemId_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000020;
              break;
            } // case 50
            case 56: {
              multiClientAccountId_ = input.readInt64();
              bitField0_ |= 0x00000040;
              break;
            } // case 56
            case 66: {
              title_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000080;
              break;
            } // case 66
            case 74: {
              brand_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000100;
              break;
            } // case 74
            case 80: {
              priceMicros_ = input.readInt64();
              bitField0_ |= 0x00000200;
              break;
            } // case 80
            case 90: {
              currencyCode_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000400;
              break;
            } // case 90
            case 96: {
              channelExclusivity_ = input.readEnum();
              bitField0_ |= 0x00000800;
              break;
            } // case 96
            case 104: {
              condition_ = input.readEnum();
              bitField0_ |= 0x00001000;
              break;
            } // case 104
            case 112: {
              availability_ = input.readEnum();
              bitField0_ |= 0x00002000;
              break;
            } // case 112
            case 122: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureTargetCountriesIsMutable();
              targetCountries_.add(s);
              break;
            } // case 122
            case 130: {
              customAttribute0_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00008000;
              break;
            } // case 130
            case 138: {
              customAttribute1_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00010000;
              break;
            } // case 138
            case 146: {
              customAttribute2_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00020000;
              break;
            } // case 146
            case 154: {
              customAttribute3_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00040000;
              break;
            } // case 154
            case 162: {
              customAttribute4_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00080000;
              break;
            } // case 162
            case 170: {
              categoryLevel1_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00100000;
              break;
            } // case 170
            case 178: {
              categoryLevel2_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00200000;
              break;
            } // case 178
            case 186: {
              categoryLevel3_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00400000;
              break;
            } // case 186
            case 194: {
              categoryLevel4_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00800000;
              break;
            } // case 194
            case 202: {
              categoryLevel5_ = input.readStringRequireUtf8();
              bitField0_ |= 0x01000000;
              break;
            } // case 202
            case 210: {
              productTypeLevel1_ = input.readStringRequireUtf8();
              bitField0_ |= 0x02000000;
              break;
            } // case 210
            case 218: {
              productTypeLevel2_ = input.readStringRequireUtf8();
              bitField0_ |= 0x04000000;
              break;
            } // case 218
            case 226: {
              productTypeLevel3_ = input.readStringRequireUtf8();
              bitField0_ |= 0x08000000;
              break;
            } // case 226
            case 234: {
              productTypeLevel4_ = input.readStringRequireUtf8();
              bitField0_ |= 0x10000000;
              break;
            } // case 234
            case 242: {
              productTypeLevel5_ = input.readStringRequireUtf8();
              bitField0_ |= 0x20000000;
              break;
            } // case 242
            case 248: {
              effectiveMaxCpcMicros_ = input.readInt64();
              bitField0_ |= 0x40000000;
              break;
            } // case 248
            case 256: {
              status_ = input.readEnum();
              bitField0_ |= 0x80000000;
              break;
            } // case 256
            case 266: {
              com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue m =
                  input.readMessage(
                      com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.parser(),
                      extensionRegistry);
              if (issuesBuilder_ == null) {
                ensureIssuesIsMutable();
                issues_.add(m);
              } else {
                issuesBuilder_.addMessage(m);
              }
              break;
            } // case 266
            case 274: {
              campaign_ = input.readStringRequireUtf8();
              bitField1_ |= 0x00000002;
              break;
            } // case 274
            case 282: {
              adGroup_ = input.readStringRequireUtf8();
              bitField1_ |= 0x00000004;
              break;
            } // case 282
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;
    private int bitField1_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Output only. The resource name of the shopping product.
     * Shopping product resource names have the form:
     *
     * `customers/{customer_id}/shoppingProducts/{merchant_center_id}~{channel}~{language_code}~{feed_label}~{item_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the shopping product.
     * Shopping product resource names have the form:
     *
     * `customers/{customer_id}/shoppingProducts/{merchant_center_id}~{channel}~{language_code}~{feed_label}~{item_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the shopping product.
     * Shopping product resource names have the form:
     *
     * `customers/{customer_id}/shoppingProducts/{merchant_center_id}~{channel}~{language_code}~{feed_label}~{item_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the shopping product.
     * Shopping product resource names have the form:
     *
     * `customers/{customer_id}/shoppingProducts/{merchant_center_id}~{channel}~{language_code}~{feed_label}~{item_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the shopping product.
     * Shopping product resource names have the form:
     *
     * `customers/{customer_id}/shoppingProducts/{merchant_center_id}~{channel}~{language_code}~{feed_label}~{item_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long merchantCenterId_ ;
    /**
     * <pre>
     * Output only. The id of the merchant that owns the product.
     * </pre>
     *
     * <code>int64 merchant_center_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The merchantCenterId.
     */
    @java.lang.Override
    public long getMerchantCenterId() {
      return merchantCenterId_;
    }
    /**
     * <pre>
     * Output only. The id of the merchant that owns the product.
     * </pre>
     *
     * <code>int64 merchant_center_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The merchantCenterId to set.
     * @return This builder for chaining.
     */
    public Builder setMerchantCenterId(long value) {

      merchantCenterId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The id of the merchant that owns the product.
     * </pre>
     *
     * <code>int64 merchant_center_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearMerchantCenterId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      merchantCenterId_ = 0L;
      onChanged();
      return this;
    }

    private int channel_ = 0;
    /**
     * <pre>
     * Output only. The product channel describing the locality of the product.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for channel.
     */
    @java.lang.Override public int getChannelValue() {
      return channel_;
    }
    /**
     * <pre>
     * Output only. The product channel describing the locality of the product.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for channel to set.
     * @return This builder for chaining.
     */
    public Builder setChannelValue(int value) {
      channel_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product channel describing the locality of the product.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The channel.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel getChannel() {
      com.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel result = com.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel.forNumber(channel_);
      return result == null ? com.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The product channel describing the locality of the product.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The channel to set.
     * @return This builder for chaining.
     */
    public Builder setChannel(com.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      channel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product channel describing the locality of the product.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductChannelEnum.ProductChannel channel = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearChannel() {
      bitField0_ = (bitField0_ & ~0x00000004);
      channel_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     * <pre>
     * Output only. The language code as provided by the merchant, in BCP 47
     * format.
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The language code as provided by the merchant, in BCP 47
     * format.
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString
        getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The language code as provided by the merchant, in BCP 47
     * format.
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      languageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The language code as provided by the merchant, in BCP 47
     * format.
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The language code as provided by the merchant, in BCP 47
     * format.
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object feedLabel_ = "";
    /**
     * <pre>
     * Output only. The product feed label as provided by the merchant.
     * </pre>
     *
     * <code>string feed_label = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The feedLabel.
     */
    public java.lang.String getFeedLabel() {
      java.lang.Object ref = feedLabel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        feedLabel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The product feed label as provided by the merchant.
     * </pre>
     *
     * <code>string feed_label = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for feedLabel.
     */
    public com.google.protobuf.ByteString
        getFeedLabelBytes() {
      java.lang.Object ref = feedLabel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        feedLabel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The product feed label as provided by the merchant.
     * </pre>
     *
     * <code>string feed_label = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The feedLabel to set.
     * @return This builder for chaining.
     */
    public Builder setFeedLabel(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      feedLabel_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product feed label as provided by the merchant.
     * </pre>
     *
     * <code>string feed_label = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearFeedLabel() {
      feedLabel_ = getDefaultInstance().getFeedLabel();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product feed label as provided by the merchant.
     * </pre>
     *
     * <code>string feed_label = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for feedLabel to set.
     * @return This builder for chaining.
     */
    public Builder setFeedLabelBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      feedLabel_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object itemId_ = "";
    /**
     * <pre>
     * Output only. The item id of the product as provided by the merchant.
     * </pre>
     *
     * <code>string item_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The itemId.
     */
    public java.lang.String getItemId() {
      java.lang.Object ref = itemId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        itemId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The item id of the product as provided by the merchant.
     * </pre>
     *
     * <code>string item_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for itemId.
     */
    public com.google.protobuf.ByteString
        getItemIdBytes() {
      java.lang.Object ref = itemId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        itemId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The item id of the product as provided by the merchant.
     * </pre>
     *
     * <code>string item_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The itemId to set.
     * @return This builder for chaining.
     */
    public Builder setItemId(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      itemId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The item id of the product as provided by the merchant.
     * </pre>
     *
     * <code>string item_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearItemId() {
      itemId_ = getDefaultInstance().getItemId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The item id of the product as provided by the merchant.
     * </pre>
     *
     * <code>string item_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for itemId to set.
     * @return This builder for chaining.
     */
    public Builder setItemIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      itemId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private long multiClientAccountId_ ;
    /**
     * <pre>
     * Output only. The id of the Multi Client Account of the merchant, if
     * present.
     * </pre>
     *
     * <code>optional int64 multi_client_account_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the multiClientAccountId field is set.
     */
    @java.lang.Override
    public boolean hasMultiClientAccountId() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Output only. The id of the Multi Client Account of the merchant, if
     * present.
     * </pre>
     *
     * <code>optional int64 multi_client_account_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The multiClientAccountId.
     */
    @java.lang.Override
    public long getMultiClientAccountId() {
      return multiClientAccountId_;
    }
    /**
     * <pre>
     * Output only. The id of the Multi Client Account of the merchant, if
     * present.
     * </pre>
     *
     * <code>optional int64 multi_client_account_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The multiClientAccountId to set.
     * @return This builder for chaining.
     */
    public Builder setMultiClientAccountId(long value) {

      multiClientAccountId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The id of the Multi Client Account of the merchant, if
     * present.
     * </pre>
     *
     * <code>optional int64 multi_client_account_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearMultiClientAccountId() {
      bitField0_ = (bitField0_ & ~0x00000040);
      multiClientAccountId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object title_ = "";
    /**
     * <pre>
     * Output only. The title of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional string title = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the title field is set.
     */
    public boolean hasTitle() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * Output only. The title of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional string title = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The title.
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The title of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional string title = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for title.
     */
    public com.google.protobuf.ByteString
        getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The title of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional string title = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The title to set.
     * @return This builder for chaining.
     */
    public Builder setTitle(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      title_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The title of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional string title = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearTitle() {
      title_ = getDefaultInstance().getTitle();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The title of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional string title = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for title to set.
     * @return This builder for chaining.
     */
    public Builder setTitleBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      title_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object brand_ = "";
    /**
     * <pre>
     * Output only. The brand of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional string brand = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the brand field is set.
     */
    public boolean hasBrand() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * Output only. The brand of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional string brand = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The brand.
     */
    public java.lang.String getBrand() {
      java.lang.Object ref = brand_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        brand_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The brand of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional string brand = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for brand.
     */
    public com.google.protobuf.ByteString
        getBrandBytes() {
      java.lang.Object ref = brand_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        brand_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The brand of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional string brand = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The brand to set.
     * @return This builder for chaining.
     */
    public Builder setBrand(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      brand_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The brand of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional string brand = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearBrand() {
      brand_ = getDefaultInstance().getBrand();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The brand of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional string brand = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for brand to set.
     * @return This builder for chaining.
     */
    public Builder setBrandBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      brand_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private long priceMicros_ ;
    /**
     * <pre>
     * Output only. The price of the product in micros as provided by the
     * merchant, in the currency specified in `currency_code` (e.g. $2.97 is
     * reported as 2970000).
     * </pre>
     *
     * <code>optional int64 price_micros = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the priceMicros field is set.
     */
    @java.lang.Override
    public boolean hasPriceMicros() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * Output only. The price of the product in micros as provided by the
     * merchant, in the currency specified in `currency_code` (e.g. $2.97 is
     * reported as 2970000).
     * </pre>
     *
     * <code>optional int64 price_micros = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The priceMicros.
     */
    @java.lang.Override
    public long getPriceMicros() {
      return priceMicros_;
    }
    /**
     * <pre>
     * Output only. The price of the product in micros as provided by the
     * merchant, in the currency specified in `currency_code` (e.g. $2.97 is
     * reported as 2970000).
     * </pre>
     *
     * <code>optional int64 price_micros = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The priceMicros to set.
     * @return This builder for chaining.
     */
    public Builder setPriceMicros(long value) {

      priceMicros_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The price of the product in micros as provided by the
     * merchant, in the currency specified in `currency_code` (e.g. $2.97 is
     * reported as 2970000).
     * </pre>
     *
     * <code>optional int64 price_micros = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearPriceMicros() {
      bitField0_ = (bitField0_ & ~0x00000200);
      priceMicros_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object currencyCode_ = "";
    /**
     * <pre>
     * Output only. The currency code as provided by the merchant, in ISO 4217
     * format.
     * </pre>
     *
     * <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the currencyCode field is set.
     */
    public boolean hasCurrencyCode() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     * <pre>
     * Output only. The currency code as provided by the merchant, in ISO 4217
     * format.
     * </pre>
     *
     * <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The currencyCode.
     */
    public java.lang.String getCurrencyCode() {
      java.lang.Object ref = currencyCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currencyCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The currency code as provided by the merchant, in ISO 4217
     * format.
     * </pre>
     *
     * <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for currencyCode.
     */
    public com.google.protobuf.ByteString
        getCurrencyCodeBytes() {
      java.lang.Object ref = currencyCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        currencyCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The currency code as provided by the merchant, in ISO 4217
     * format.
     * </pre>
     *
     * <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The currencyCode to set.
     * @return This builder for chaining.
     */
    public Builder setCurrencyCode(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      currencyCode_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The currency code as provided by the merchant, in ISO 4217
     * format.
     * </pre>
     *
     * <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCurrencyCode() {
      currencyCode_ = getDefaultInstance().getCurrencyCode();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The currency code as provided by the merchant, in ISO 4217
     * format.
     * </pre>
     *
     * <code>optional string currency_code = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for currencyCode to set.
     * @return This builder for chaining.
     */
    public Builder setCurrencyCodeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      currencyCode_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private int channelExclusivity_ = 0;
    /**
     * <pre>
     * Output only. The channel exclusivity of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity channel_exclusivity = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the channelExclusivity field is set.
     */
    @java.lang.Override public boolean hasChannelExclusivity() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     * <pre>
     * Output only. The channel exclusivity of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity channel_exclusivity = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for channelExclusivity.
     */
    @java.lang.Override public int getChannelExclusivityValue() {
      return channelExclusivity_;
    }
    /**
     * <pre>
     * Output only. The channel exclusivity of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity channel_exclusivity = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for channelExclusivity to set.
     * @return This builder for chaining.
     */
    public Builder setChannelExclusivityValue(int value) {
      channelExclusivity_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The channel exclusivity of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity channel_exclusivity = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The channelExclusivity.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity getChannelExclusivity() {
      com.google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity result = com.google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity.forNumber(channelExclusivity_);
      return result == null ? com.google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The channel exclusivity of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity channel_exclusivity = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The channelExclusivity to set.
     * @return This builder for chaining.
     */
    public Builder setChannelExclusivity(com.google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      channelExclusivity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The channel exclusivity of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity channel_exclusivity = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearChannelExclusivity() {
      bitField0_ = (bitField0_ & ~0x00000800);
      channelExclusivity_ = 0;
      onChanged();
      return this;
    }

    private int condition_ = 0;
    /**
     * <pre>
     * Output only. The condition of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition condition = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the condition field is set.
     */
    @java.lang.Override public boolean hasCondition() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     * <pre>
     * Output only. The condition of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition condition = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for condition.
     */
    @java.lang.Override public int getConditionValue() {
      return condition_;
    }
    /**
     * <pre>
     * Output only. The condition of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition condition = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for condition to set.
     * @return This builder for chaining.
     */
    public Builder setConditionValue(int value) {
      condition_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The condition of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition condition = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The condition.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition getCondition() {
      com.google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition result = com.google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition.forNumber(condition_);
      return result == null ? com.google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The condition of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition condition = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The condition to set.
     * @return This builder for chaining.
     */
    public Builder setCondition(com.google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      condition_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The condition of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductConditionEnum.ProductCondition condition = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCondition() {
      bitField0_ = (bitField0_ & ~0x00001000);
      condition_ = 0;
      onChanged();
      return this;
    }

    private int availability_ = 0;
    /**
     * <pre>
     * Output only. The availability of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability availability = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the availability field is set.
     */
    @java.lang.Override public boolean hasAvailability() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     * <pre>
     * Output only. The availability of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability availability = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for availability.
     */
    @java.lang.Override public int getAvailabilityValue() {
      return availability_;
    }
    /**
     * <pre>
     * Output only. The availability of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability availability = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for availability to set.
     * @return This builder for chaining.
     */
    public Builder setAvailabilityValue(int value) {
      availability_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The availability of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability availability = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The availability.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability getAvailability() {
      com.google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability result = com.google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability.forNumber(availability_);
      return result == null ? com.google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The availability of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability availability = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The availability to set.
     * @return This builder for chaining.
     */
    public Builder setAvailability(com.google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00002000;
      availability_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The availability of the product as provided by the merchant.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v18.enums.ProductAvailabilityEnum.ProductAvailability availability = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearAvailability() {
      bitField0_ = (bitField0_ & ~0x00002000);
      availability_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList targetCountries_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureTargetCountriesIsMutable() {
      if (!targetCountries_.isModifiable()) {
        targetCountries_ = new com.google.protobuf.LazyStringArrayList(targetCountries_);
      }
      bitField0_ |= 0x00004000;
    }
    /**
     * <pre>
     * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     * product is intended to be shown in ads.
     * </pre>
     *
     * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return A list containing the targetCountries.
     */
    public com.google.protobuf.ProtocolStringList
        getTargetCountriesList() {
      targetCountries_.makeImmutable();
      return targetCountries_;
    }
    /**
     * <pre>
     * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     * product is intended to be shown in ads.
     * </pre>
     *
     * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The count of targetCountries.
     */
    public int getTargetCountriesCount() {
      return targetCountries_.size();
    }
    /**
     * <pre>
     * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     * product is intended to be shown in ads.
     * </pre>
     *
     * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index of the element to return.
     * @return The targetCountries at the given index.
     */
    public java.lang.String getTargetCountries(int index) {
      return targetCountries_.get(index);
    }
    /**
     * <pre>
     * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     * product is intended to be shown in ads.
     * </pre>
     *
     * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index of the value to return.
     * @return The bytes of the targetCountries at the given index.
     */
    public com.google.protobuf.ByteString
        getTargetCountriesBytes(int index) {
      return targetCountries_.getByteString(index);
    }
    /**
     * <pre>
     * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     * product is intended to be shown in ads.
     * </pre>
     *
     * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index to set the value at.
     * @param value The targetCountries to set.
     * @return This builder for chaining.
     */
    public Builder setTargetCountries(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureTargetCountriesIsMutable();
      targetCountries_.set(index, value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     * product is intended to be shown in ads.
     * </pre>
     *
     * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The targetCountries to add.
     * @return This builder for chaining.
     */
    public Builder addTargetCountries(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureTargetCountriesIsMutable();
      targetCountries_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     * product is intended to be shown in ads.
     * </pre>
     *
     * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param values The targetCountries to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetCountries(
        java.lang.Iterable<java.lang.String> values) {
      ensureTargetCountriesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, targetCountries_);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     * product is intended to be shown in ads.
     * </pre>
     *
     * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearTargetCountries() {
      targetCountries_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00004000);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Upper-case two-letter ISO 3166-1 code of the regions where the
     * product is intended to be shown in ads.
     * </pre>
     *
     * <code>repeated string target_countries = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes of the targetCountries to add.
     * @return This builder for chaining.
     */
    public Builder addTargetCountriesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureTargetCountriesIsMutable();
      targetCountries_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object customAttribute0_ = "";
    /**
     * <pre>
     * Output only. The custom attribute 0 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute0 = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the customAttribute0 field is set.
     */
    public boolean hasCustomAttribute0() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     * <pre>
     * Output only. The custom attribute 0 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute0 = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The customAttribute0.
     */
    public java.lang.String getCustomAttribute0() {
      java.lang.Object ref = customAttribute0_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customAttribute0_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The custom attribute 0 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute0 = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for customAttribute0.
     */
    public com.google.protobuf.ByteString
        getCustomAttribute0Bytes() {
      java.lang.Object ref = customAttribute0_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        customAttribute0_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The custom attribute 0 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute0 = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The customAttribute0 to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAttribute0(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      customAttribute0_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The custom attribute 0 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute0 = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCustomAttribute0() {
      customAttribute0_ = getDefaultInstance().getCustomAttribute0();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The custom attribute 0 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute0 = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for customAttribute0 to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAttribute0Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      customAttribute0_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object customAttribute1_ = "";
    /**
     * <pre>
     * Output only. The custom attribute 1 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute1 = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the customAttribute1 field is set.
     */
    public boolean hasCustomAttribute1() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     * <pre>
     * Output only. The custom attribute 1 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute1 = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The customAttribute1.
     */
    public java.lang.String getCustomAttribute1() {
      java.lang.Object ref = customAttribute1_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customAttribute1_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The custom attribute 1 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute1 = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for customAttribute1.
     */
    public com.google.protobuf.ByteString
        getCustomAttribute1Bytes() {
      java.lang.Object ref = customAttribute1_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        customAttribute1_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The custom attribute 1 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute1 = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The customAttribute1 to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAttribute1(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      customAttribute1_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The custom attribute 1 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute1 = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCustomAttribute1() {
      customAttribute1_ = getDefaultInstance().getCustomAttribute1();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The custom attribute 1 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute1 = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for customAttribute1 to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAttribute1Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      customAttribute1_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object customAttribute2_ = "";
    /**
     * <pre>
     * Output only. The custom attribute 2 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute2 = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the customAttribute2 field is set.
     */
    public boolean hasCustomAttribute2() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     * <pre>
     * Output only. The custom attribute 2 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute2 = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The customAttribute2.
     */
    public java.lang.String getCustomAttribute2() {
      java.lang.Object ref = customAttribute2_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customAttribute2_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The custom attribute 2 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute2 = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for customAttribute2.
     */
    public com.google.protobuf.ByteString
        getCustomAttribute2Bytes() {
      java.lang.Object ref = customAttribute2_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        customAttribute2_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The custom attribute 2 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute2 = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The customAttribute2 to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAttribute2(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      customAttribute2_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The custom attribute 2 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute2 = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCustomAttribute2() {
      customAttribute2_ = getDefaultInstance().getCustomAttribute2();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The custom attribute 2 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute2 = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for customAttribute2 to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAttribute2Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      customAttribute2_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object customAttribute3_ = "";
    /**
     * <pre>
     * Output only. The custom attribute 3 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute3 = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the customAttribute3 field is set.
     */
    public boolean hasCustomAttribute3() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     * <pre>
     * Output only. The custom attribute 3 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute3 = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The customAttribute3.
     */
    public java.lang.String getCustomAttribute3() {
      java.lang.Object ref = customAttribute3_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customAttribute3_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The custom attribute 3 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute3 = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for customAttribute3.
     */
    public com.google.protobuf.ByteString
        getCustomAttribute3Bytes() {
      java.lang.Object ref = customAttribute3_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        customAttribute3_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The custom attribute 3 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute3 = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The customAttribute3 to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAttribute3(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      customAttribute3_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The custom attribute 3 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute3 = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCustomAttribute3() {
      customAttribute3_ = getDefaultInstance().getCustomAttribute3();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The custom attribute 3 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute3 = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for customAttribute3 to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAttribute3Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      customAttribute3_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private java.lang.Object customAttribute4_ = "";
    /**
     * <pre>
     * Output only. The custom attribute 4 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute4 = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the customAttribute4 field is set.
     */
    public boolean hasCustomAttribute4() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     * <pre>
     * Output only. The custom attribute 4 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute4 = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The customAttribute4.
     */
    public java.lang.String getCustomAttribute4() {
      java.lang.Object ref = customAttribute4_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customAttribute4_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The custom attribute 4 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute4 = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for customAttribute4.
     */
    public com.google.protobuf.ByteString
        getCustomAttribute4Bytes() {
      java.lang.Object ref = customAttribute4_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        customAttribute4_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The custom attribute 4 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute4 = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The customAttribute4 to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAttribute4(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      customAttribute4_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The custom attribute 4 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute4 = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCustomAttribute4() {
      customAttribute4_ = getDefaultInstance().getCustomAttribute4();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The custom attribute 4 of the product as provided by the
     * merchant.
     * </pre>
     *
     * <code>optional string custom_attribute4 = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for customAttribute4 to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAttribute4Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      customAttribute4_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private java.lang.Object categoryLevel1_ = "";
    /**
     * <pre>
     * Output only. The category level 1 of the product.
     * </pre>
     *
     * <code>optional string category_level1 = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the categoryLevel1 field is set.
     */
    public boolean hasCategoryLevel1() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     * <pre>
     * Output only. The category level 1 of the product.
     * </pre>
     *
     * <code>optional string category_level1 = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The categoryLevel1.
     */
    public java.lang.String getCategoryLevel1() {
      java.lang.Object ref = categoryLevel1_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        categoryLevel1_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The category level 1 of the product.
     * </pre>
     *
     * <code>optional string category_level1 = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for categoryLevel1.
     */
    public com.google.protobuf.ByteString
        getCategoryLevel1Bytes() {
      java.lang.Object ref = categoryLevel1_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        categoryLevel1_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The category level 1 of the product.
     * </pre>
     *
     * <code>optional string category_level1 = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The categoryLevel1 to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryLevel1(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      categoryLevel1_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The category level 1 of the product.
     * </pre>
     *
     * <code>optional string category_level1 = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearCategoryLevel1() {
      categoryLevel1_ = getDefaultInstance().getCategoryLevel1();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The category level 1 of the product.
     * </pre>
     *
     * <code>optional string category_level1 = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for categoryLevel1 to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryLevel1Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      categoryLevel1_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private java.lang.Object categoryLevel2_ = "";
    /**
     * <pre>
     * Output only. The category level 2 of the product.
     * </pre>
     *
     * <code>optional string category_level2 = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the categoryLevel2 field is set.
     */
    public boolean hasCategoryLevel2() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     * <pre>
     * Output only. The category level 2 of the product.
     * </pre>
     *
     * <code>optional string category_level2 = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The categoryLevel2.
     */
    public java.lang.String getCategoryLevel2() {
      java.lang.Object ref = categoryLevel2_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        categoryLevel2_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The category level 2 of the product.
     * </pre>
     *
     * <code>optional string category_level2 = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for categoryLevel2.
     */
    public com.google.protobuf.ByteString
        getCategoryLevel2Bytes() {
      java.lang.Object ref = categoryLevel2_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        categoryLevel2_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The category level 2 of the product.
     * </pre>
     *
     * <code>optional string category_level2 = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The categoryLevel2 to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryLevel2(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      categoryLevel2_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The category level 2 of the product.
     * </pre>
     *
     * <code>optional string category_level2 = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearCategoryLevel2() {
      categoryLevel2_ = getDefaultInstance().getCategoryLevel2();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The category level 2 of the product.
     * </pre>
     *
     * <code>optional string category_level2 = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for categoryLevel2 to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryLevel2Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      categoryLevel2_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private java.lang.Object categoryLevel3_ = "";
    /**
     * <pre>
     * Output only. The category level 3 of the product.
     * </pre>
     *
     * <code>optional string category_level3 = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the categoryLevel3 field is set.
     */
    public boolean hasCategoryLevel3() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     * <pre>
     * Output only. The category level 3 of the product.
     * </pre>
     *
     * <code>optional string category_level3 = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The categoryLevel3.
     */
    public java.lang.String getCategoryLevel3() {
      java.lang.Object ref = categoryLevel3_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        categoryLevel3_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The category level 3 of the product.
     * </pre>
     *
     * <code>optional string category_level3 = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for categoryLevel3.
     */
    public com.google.protobuf.ByteString
        getCategoryLevel3Bytes() {
      java.lang.Object ref = categoryLevel3_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        categoryLevel3_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The category level 3 of the product.
     * </pre>
     *
     * <code>optional string category_level3 = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The categoryLevel3 to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryLevel3(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      categoryLevel3_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The category level 3 of the product.
     * </pre>
     *
     * <code>optional string category_level3 = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearCategoryLevel3() {
      categoryLevel3_ = getDefaultInstance().getCategoryLevel3();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The category level 3 of the product.
     * </pre>
     *
     * <code>optional string category_level3 = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for categoryLevel3 to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryLevel3Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      categoryLevel3_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    private java.lang.Object categoryLevel4_ = "";
    /**
     * <pre>
     * Output only. The category level 4 of the product.
     * </pre>
     *
     * <code>optional string category_level4 = 24 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the categoryLevel4 field is set.
     */
    public boolean hasCategoryLevel4() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     * <pre>
     * Output only. The category level 4 of the product.
     * </pre>
     *
     * <code>optional string category_level4 = 24 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The categoryLevel4.
     */
    public java.lang.String getCategoryLevel4() {
      java.lang.Object ref = categoryLevel4_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        categoryLevel4_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The category level 4 of the product.
     * </pre>
     *
     * <code>optional string category_level4 = 24 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for categoryLevel4.
     */
    public com.google.protobuf.ByteString
        getCategoryLevel4Bytes() {
      java.lang.Object ref = categoryLevel4_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        categoryLevel4_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The category level 4 of the product.
     * </pre>
     *
     * <code>optional string category_level4 = 24 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The categoryLevel4 to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryLevel4(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      categoryLevel4_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The category level 4 of the product.
     * </pre>
     *
     * <code>optional string category_level4 = 24 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearCategoryLevel4() {
      categoryLevel4_ = getDefaultInstance().getCategoryLevel4();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The category level 4 of the product.
     * </pre>
     *
     * <code>optional string category_level4 = 24 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for categoryLevel4 to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryLevel4Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      categoryLevel4_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    private java.lang.Object categoryLevel5_ = "";
    /**
     * <pre>
     * Output only. The category level 5 of the product.
     * </pre>
     *
     * <code>optional string category_level5 = 25 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the categoryLevel5 field is set.
     */
    public boolean hasCategoryLevel5() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     * <pre>
     * Output only. The category level 5 of the product.
     * </pre>
     *
     * <code>optional string category_level5 = 25 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The categoryLevel5.
     */
    public java.lang.String getCategoryLevel5() {
      java.lang.Object ref = categoryLevel5_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        categoryLevel5_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The category level 5 of the product.
     * </pre>
     *
     * <code>optional string category_level5 = 25 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for categoryLevel5.
     */
    public com.google.protobuf.ByteString
        getCategoryLevel5Bytes() {
      java.lang.Object ref = categoryLevel5_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        categoryLevel5_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The category level 5 of the product.
     * </pre>
     *
     * <code>optional string category_level5 = 25 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The categoryLevel5 to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryLevel5(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      categoryLevel5_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The category level 5 of the product.
     * </pre>
     *
     * <code>optional string category_level5 = 25 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearCategoryLevel5() {
      categoryLevel5_ = getDefaultInstance().getCategoryLevel5();
      bitField0_ = (bitField0_ & ~0x01000000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The category level 5 of the product.
     * </pre>
     *
     * <code>optional string category_level5 = 25 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for categoryLevel5 to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryLevel5Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      categoryLevel5_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    private java.lang.Object productTypeLevel1_ = "";
    /**
     * <pre>
     * Output only. The product type level 1 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level1 = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the productTypeLevel1 field is set.
     */
    public boolean hasProductTypeLevel1() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     * <pre>
     * Output only. The product type level 1 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level1 = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The productTypeLevel1.
     */
    public java.lang.String getProductTypeLevel1() {
      java.lang.Object ref = productTypeLevel1_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        productTypeLevel1_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The product type level 1 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level1 = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for productTypeLevel1.
     */
    public com.google.protobuf.ByteString
        getProductTypeLevel1Bytes() {
      java.lang.Object ref = productTypeLevel1_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        productTypeLevel1_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The product type level 1 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level1 = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The productTypeLevel1 to set.
     * @return This builder for chaining.
     */
    public Builder setProductTypeLevel1(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      productTypeLevel1_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product type level 1 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level1 = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearProductTypeLevel1() {
      productTypeLevel1_ = getDefaultInstance().getProductTypeLevel1();
      bitField0_ = (bitField0_ & ~0x02000000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product type level 1 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level1 = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for productTypeLevel1 to set.
     * @return This builder for chaining.
     */
    public Builder setProductTypeLevel1Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      productTypeLevel1_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    private java.lang.Object productTypeLevel2_ = "";
    /**
     * <pre>
     * Output only. The product type level 2 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level2 = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the productTypeLevel2 field is set.
     */
    public boolean hasProductTypeLevel2() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     * <pre>
     * Output only. The product type level 2 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level2 = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The productTypeLevel2.
     */
    public java.lang.String getProductTypeLevel2() {
      java.lang.Object ref = productTypeLevel2_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        productTypeLevel2_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The product type level 2 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level2 = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for productTypeLevel2.
     */
    public com.google.protobuf.ByteString
        getProductTypeLevel2Bytes() {
      java.lang.Object ref = productTypeLevel2_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        productTypeLevel2_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The product type level 2 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level2 = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The productTypeLevel2 to set.
     * @return This builder for chaining.
     */
    public Builder setProductTypeLevel2(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      productTypeLevel2_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product type level 2 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level2 = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearProductTypeLevel2() {
      productTypeLevel2_ = getDefaultInstance().getProductTypeLevel2();
      bitField0_ = (bitField0_ & ~0x04000000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product type level 2 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level2 = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for productTypeLevel2 to set.
     * @return This builder for chaining.
     */
    public Builder setProductTypeLevel2Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      productTypeLevel2_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    private java.lang.Object productTypeLevel3_ = "";
    /**
     * <pre>
     * Output only. The product type level 3 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level3 = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the productTypeLevel3 field is set.
     */
    public boolean hasProductTypeLevel3() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     * <pre>
     * Output only. The product type level 3 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level3 = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The productTypeLevel3.
     */
    public java.lang.String getProductTypeLevel3() {
      java.lang.Object ref = productTypeLevel3_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        productTypeLevel3_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The product type level 3 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level3 = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for productTypeLevel3.
     */
    public com.google.protobuf.ByteString
        getProductTypeLevel3Bytes() {
      java.lang.Object ref = productTypeLevel3_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        productTypeLevel3_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The product type level 3 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level3 = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The productTypeLevel3 to set.
     * @return This builder for chaining.
     */
    public Builder setProductTypeLevel3(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      productTypeLevel3_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product type level 3 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level3 = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearProductTypeLevel3() {
      productTypeLevel3_ = getDefaultInstance().getProductTypeLevel3();
      bitField0_ = (bitField0_ & ~0x08000000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product type level 3 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level3 = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for productTypeLevel3 to set.
     * @return This builder for chaining.
     */
    public Builder setProductTypeLevel3Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      productTypeLevel3_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    private java.lang.Object productTypeLevel4_ = "";
    /**
     * <pre>
     * Output only. The product type level 4 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level4 = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the productTypeLevel4 field is set.
     */
    public boolean hasProductTypeLevel4() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     * <pre>
     * Output only. The product type level 4 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level4 = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The productTypeLevel4.
     */
    public java.lang.String getProductTypeLevel4() {
      java.lang.Object ref = productTypeLevel4_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        productTypeLevel4_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The product type level 4 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level4 = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for productTypeLevel4.
     */
    public com.google.protobuf.ByteString
        getProductTypeLevel4Bytes() {
      java.lang.Object ref = productTypeLevel4_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        productTypeLevel4_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The product type level 4 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level4 = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The productTypeLevel4 to set.
     * @return This builder for chaining.
     */
    public Builder setProductTypeLevel4(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      productTypeLevel4_ = value;
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product type level 4 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level4 = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearProductTypeLevel4() {
      productTypeLevel4_ = getDefaultInstance().getProductTypeLevel4();
      bitField0_ = (bitField0_ & ~0x10000000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product type level 4 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level4 = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for productTypeLevel4 to set.
     * @return This builder for chaining.
     */
    public Builder setProductTypeLevel4Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      productTypeLevel4_ = value;
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }

    private java.lang.Object productTypeLevel5_ = "";
    /**
     * <pre>
     * Output only. The product type level 5 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level5 = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the productTypeLevel5 field is set.
     */
    public boolean hasProductTypeLevel5() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     * <pre>
     * Output only. The product type level 5 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level5 = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The productTypeLevel5.
     */
    public java.lang.String getProductTypeLevel5() {
      java.lang.Object ref = productTypeLevel5_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        productTypeLevel5_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The product type level 5 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level5 = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for productTypeLevel5.
     */
    public com.google.protobuf.ByteString
        getProductTypeLevel5Bytes() {
      java.lang.Object ref = productTypeLevel5_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        productTypeLevel5_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The product type level 5 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level5 = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The productTypeLevel5 to set.
     * @return This builder for chaining.
     */
    public Builder setProductTypeLevel5(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      productTypeLevel5_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product type level 5 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level5 = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearProductTypeLevel5() {
      productTypeLevel5_ = getDefaultInstance().getProductTypeLevel5();
      bitField0_ = (bitField0_ & ~0x20000000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The product type level 5 as provided by the merchant.
     * </pre>
     *
     * <code>optional string product_type_level5 = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for productTypeLevel5 to set.
     * @return This builder for chaining.
     */
    public Builder setProductTypeLevel5Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      productTypeLevel5_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }

    private long effectiveMaxCpcMicros_ ;
    /**
     * <pre>
     * Output only. The effective maximum cost-per-click (effective max. CPC) of
     * the product. This field is available only if the query specifies the
     * campaign or ad group scope, and if the campaign uses manual bidding. The
     * value is the highest bid set for the product in product groups across all
     * enabled ad groups. It represents the most you're willing to pay for a click
     * on the product. This field can take up to 24 hours to update.
     * </pre>
     *
     * <code>optional int64 effective_max_cpc_micros = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the effectiveMaxCpcMicros field is set.
     */
    @java.lang.Override
    public boolean hasEffectiveMaxCpcMicros() {
      return ((bitField0_ & 0x40000000) != 0);
    }
    /**
     * <pre>
     * Output only. The effective maximum cost-per-click (effective max. CPC) of
     * the product. This field is available only if the query specifies the
     * campaign or ad group scope, and if the campaign uses manual bidding. The
     * value is the highest bid set for the product in product groups across all
     * enabled ad groups. It represents the most you're willing to pay for a click
     * on the product. This field can take up to 24 hours to update.
     * </pre>
     *
     * <code>optional int64 effective_max_cpc_micros = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The effectiveMaxCpcMicros.
     */
    @java.lang.Override
    public long getEffectiveMaxCpcMicros() {
      return effectiveMaxCpcMicros_;
    }
    /**
     * <pre>
     * Output only. The effective maximum cost-per-click (effective max. CPC) of
     * the product. This field is available only if the query specifies the
     * campaign or ad group scope, and if the campaign uses manual bidding. The
     * value is the highest bid set for the product in product groups across all
     * enabled ad groups. It represents the most you're willing to pay for a click
     * on the product. This field can take up to 24 hours to update.
     * </pre>
     *
     * <code>optional int64 effective_max_cpc_micros = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The effectiveMaxCpcMicros to set.
     * @return This builder for chaining.
     */
    public Builder setEffectiveMaxCpcMicros(long value) {

      effectiveMaxCpcMicros_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The effective maximum cost-per-click (effective max. CPC) of
     * the product. This field is available only if the query specifies the
     * campaign or ad group scope, and if the campaign uses manual bidding. The
     * value is the highest bid set for the product in product groups across all
     * enabled ad groups. It represents the most you're willing to pay for a click
     * on the product. This field can take up to 24 hours to update.
     * </pre>
     *
     * <code>optional int64 effective_max_cpc_micros = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearEffectiveMaxCpcMicros() {
      bitField0_ = (bitField0_ & ~0x40000000);
      effectiveMaxCpcMicros_ = 0L;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * Output only. The status that indicates whether the product can show in ads.
     * The value of this field is restricted to the scope specified in the query,
     * see the documentation of the resource.
     * This field can take up to 24 hours to update.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Output only. The status that indicates whether the product can show in ads.
     * The value of this field is restricted to the scope specified in the query,
     * see the documentation of the resource.
     * This field can take up to 24 hours to update.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The status that indicates whether the product can show in ads.
     * The value of this field is restricted to the scope specified in the query,
     * see the documentation of the resource.
     * This field can take up to 24 hours to update.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus getStatus() {
      com.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus result = com.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus.forNumber(status_);
      return result == null ? com.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The status that indicates whether the product can show in ads.
     * The value of this field is restricted to the scope specified in the query,
     * see the documentation of the resource.
     * This field can take up to 24 hours to update.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x80000000;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The status that indicates whether the product can show in ads.
     * The value of this field is restricted to the scope specified in the query,
     * see the documentation of the resource.
     * This field can take up to 24 hours to update.
     * </pre>
     *
     * <code>.google.ads.googleads.v18.enums.ProductStatusEnum.ProductStatus status = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x80000000);
      status_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue> issues_ =
      java.util.Collections.emptyList();
    private void ensureIssuesIsMutable() {
      if (!((bitField1_ & 0x00000001) != 0)) {
        issues_ = new java.util.ArrayList<com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue>(issues_);
        bitField1_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.Builder, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssueOrBuilder> issuesBuilder_;

    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public java.util.List<com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue> getIssuesList() {
      if (issuesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(issues_);
      } else {
        return issuesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public int getIssuesCount() {
      if (issuesBuilder_ == null) {
        return issues_.size();
      } else {
        return issuesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue getIssues(int index) {
      if (issuesBuilder_ == null) {
        return issues_.get(index);
      } else {
        return issuesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setIssues(
        int index, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue value) {
      if (issuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIssuesIsMutable();
        issues_.set(index, value);
        onChanged();
      } else {
        issuesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setIssues(
        int index, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.Builder builderForValue) {
      if (issuesBuilder_ == null) {
        ensureIssuesIsMutable();
        issues_.set(index, builderForValue.build());
        onChanged();
      } else {
        issuesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder addIssues(com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue value) {
      if (issuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIssuesIsMutable();
        issues_.add(value);
        onChanged();
      } else {
        issuesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder addIssues(
        int index, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue value) {
      if (issuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIssuesIsMutable();
        issues_.add(index, value);
        onChanged();
      } else {
        issuesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder addIssues(
        com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.Builder builderForValue) {
      if (issuesBuilder_ == null) {
        ensureIssuesIsMutable();
        issues_.add(builderForValue.build());
        onChanged();
      } else {
        issuesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder addIssues(
        int index, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.Builder builderForValue) {
      if (issuesBuilder_ == null) {
        ensureIssuesIsMutable();
        issues_.add(index, builderForValue.build());
        onChanged();
      } else {
        issuesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder addAllIssues(
        java.lang.Iterable<? extends com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue> values) {
      if (issuesBuilder_ == null) {
        ensureIssuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, issues_);
        onChanged();
      } else {
        issuesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearIssues() {
      if (issuesBuilder_ == null) {
        issues_ = java.util.Collections.emptyList();
        bitField1_ = (bitField1_ & ~0x00000001);
        onChanged();
      } else {
        issuesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder removeIssues(int index) {
      if (issuesBuilder_ == null) {
        ensureIssuesIsMutable();
        issues_.remove(index);
        onChanged();
      } else {
        issuesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.Builder getIssuesBuilder(
        int index) {
      return getIssuesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssueOrBuilder getIssuesOrBuilder(
        int index) {
      if (issuesBuilder_ == null) {
        return issues_.get(index);  } else {
        return issuesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssueOrBuilder> 
         getIssuesOrBuilderList() {
      if (issuesBuilder_ != null) {
        return issuesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(issues_);
      }
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.Builder addIssuesBuilder() {
      return getIssuesFieldBuilder().addBuilder(
          com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.getDefaultInstance());
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.Builder addIssuesBuilder(
        int index) {
      return getIssuesFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.getDefaultInstance());
    }
    /**
     * <pre>
     * Output only. The list of issues affecting whether the product can show in
     * ads. The value of this field is restricted to the scope specified in the
     * query, see the documentation of the resource. This field can take up to 24
     * hours to update.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue issues = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public java.util.List<com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.Builder> 
         getIssuesBuilderList() {
      return getIssuesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.Builder, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssueOrBuilder> 
        getIssuesFieldBuilder() {
      if (issuesBuilder_ == null) {
        issuesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssue.Builder, com.google.ads.googleads.v18.resources.ShoppingProduct.ProductIssueOrBuilder>(
                issues_,
                ((bitField1_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        issues_ = null;
      }
      return issuesBuilder_;
    }

    private java.lang.Object campaign_ = "";
    /**
     * <pre>
     * Output only. A campaign that includes the product.
     * This field is selectable only in the campaign scope, which requires an
     * equality filter on `campaign`.
     * </pre>
     *
     * <code>optional string campaign = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the campaign field is set.
     */
    public boolean hasCampaign() {
      return ((bitField1_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Output only. A campaign that includes the product.
     * This field is selectable only in the campaign scope, which requires an
     * equality filter on `campaign`.
     * </pre>
     *
     * <code>optional string campaign = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The campaign.
     */
    public java.lang.String getCampaign() {
      java.lang.Object ref = campaign_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        campaign_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. A campaign that includes the product.
     * This field is selectable only in the campaign scope, which requires an
     * equality filter on `campaign`.
     * </pre>
     *
     * <code>optional string campaign = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for campaign.
     */
    public com.google.protobuf.ByteString
        getCampaignBytes() {
      java.lang.Object ref = campaign_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        campaign_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. A campaign that includes the product.
     * This field is selectable only in the campaign scope, which requires an
     * equality filter on `campaign`.
     * </pre>
     *
     * <code>optional string campaign = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The campaign to set.
     * @return This builder for chaining.
     */
    public Builder setCampaign(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      campaign_ = value;
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. A campaign that includes the product.
     * This field is selectable only in the campaign scope, which requires an
     * equality filter on `campaign`.
     * </pre>
     *
     * <code>optional string campaign = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearCampaign() {
      campaign_ = getDefaultInstance().getCampaign();
      bitField1_ = (bitField1_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. A campaign that includes the product.
     * This field is selectable only in the campaign scope, which requires an
     * equality filter on `campaign`.
     * </pre>
     *
     * <code>optional string campaign = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for campaign to set.
     * @return This builder for chaining.
     */
    public Builder setCampaignBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      campaign_ = value;
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object adGroup_ = "";
    /**
     * <pre>
     * Output only. An ad group of a campaign that includes the product.
     * This field is selectable only in the ad group scope, which requires an
     * equality filter on `campaign` and `ad_group`.
     * </pre>
     *
     * <code>optional string ad_group = 35 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the adGroup field is set.
     */
    public boolean hasAdGroup() {
      return ((bitField1_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Output only. An ad group of a campaign that includes the product.
     * This field is selectable only in the ad group scope, which requires an
     * equality filter on `campaign` and `ad_group`.
     * </pre>
     *
     * <code>optional string ad_group = 35 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The adGroup.
     */
    public java.lang.String getAdGroup() {
      java.lang.Object ref = adGroup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        adGroup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. An ad group of a campaign that includes the product.
     * This field is selectable only in the ad group scope, which requires an
     * equality filter on `campaign` and `ad_group`.
     * </pre>
     *
     * <code>optional string ad_group = 35 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for adGroup.
     */
    public com.google.protobuf.ByteString
        getAdGroupBytes() {
      java.lang.Object ref = adGroup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        adGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. An ad group of a campaign that includes the product.
     * This field is selectable only in the ad group scope, which requires an
     * equality filter on `campaign` and `ad_group`.
     * </pre>
     *
     * <code>optional string ad_group = 35 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The adGroup to set.
     * @return This builder for chaining.
     */
    public Builder setAdGroup(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      adGroup_ = value;
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. An ad group of a campaign that includes the product.
     * This field is selectable only in the ad group scope, which requires an
     * equality filter on `campaign` and `ad_group`.
     * </pre>
     *
     * <code>optional string ad_group = 35 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearAdGroup() {
      adGroup_ = getDefaultInstance().getAdGroup();
      bitField1_ = (bitField1_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. An ad group of a campaign that includes the product.
     * This field is selectable only in the ad group scope, which requires an
     * equality filter on `campaign` and `ad_group`.
     * </pre>
     *
     * <code>optional string ad_group = 35 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for adGroup to set.
     * @return This builder for chaining.
     */
    public Builder setAdGroupBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      adGroup_ = value;
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v18.resources.ShoppingProduct)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v18.resources.ShoppingProduct)
  private static final com.google.ads.googleads.v18.resources.ShoppingProduct DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v18.resources.ShoppingProduct();
  }

  public static com.google.ads.googleads.v18.resources.ShoppingProduct getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ShoppingProduct>
      PARSER = new com.google.protobuf.AbstractParser<ShoppingProduct>() {
    @java.lang.Override
    public ShoppingProduct parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<ShoppingProduct> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ShoppingProduct> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v18.resources.ShoppingProduct getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

