/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupAssetSetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_ASSET_SET_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroupAssetSets/{ad_group_id}~{asset_set_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String assetSetId;

    @Deprecated
    protected AdGroupAssetSetName() {
        this.customerId = null;
        this.adGroupId = null;
        this.assetSetId = null;
    }

    private AdGroupAssetSetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.assetSetId = (String)Preconditions.checkNotNull((Object)builder.getAssetSetId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getAssetSetId() {
        return this.assetSetId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupAssetSetName of(String customerId, String adGroupId, String assetSetId) {
        return AdGroupAssetSetName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setAssetSetId(assetSetId).build();
    }

    public static String format(String customerId, String adGroupId, String assetSetId) {
        return AdGroupAssetSetName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setAssetSetId(assetSetId).build().toString();
    }

    public static AdGroupAssetSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_ASSET_SET_ID.validatedMatch(formattedString, "AdGroupAssetSetName.parse: formattedString not in valid format");
        return AdGroupAssetSetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("asset_set_id"));
    }

    public static List<AdGroupAssetSetName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupAssetSetName> list = new ArrayList<AdGroupAssetSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupAssetSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupAssetSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupAssetSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_ASSET_SET_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupAssetSetName adGroupAssetSetName = this;
            synchronized (adGroupAssetSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.assetSetId != null) {
                        fieldMapBuilder.put((Object)"asset_set_id", (Object)this.assetSetId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_ASSET_SET_ID.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "asset_set_id", this.assetSetId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AdGroupAssetSetName that = (AdGroupAssetSetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.assetSetId, that.assetSetId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assetSetId);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String assetSetId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getAssetSetId() {
            return this.assetSetId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setAssetSetId(String assetSetId) {
            this.assetSetId = assetSetId;
            return this;
        }

        private Builder(AdGroupAssetSetName adGroupAssetSetName) {
            this.customerId = adGroupAssetSetName.customerId;
            this.adGroupId = adGroupAssetSetName.adGroupId;
            this.assetSetId = adGroupAssetSetName.assetSetId;
        }

        public AdGroupAssetSetName build() {
            return new AdGroupAssetSetName(this);
        }
    }
}

