/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.ads.googleads.v18.enums.AdStrengthEnum;
import com.google.ads.googleads.v18.enums.AssetGroupPrimaryStatusEnum;
import com.google.ads.googleads.v18.enums.AssetGroupPrimaryStatusReasonEnum;
import com.google.ads.googleads.v18.enums.AssetGroupStatusEnum;
import com.google.ads.googleads.v18.resources.AssetGroupOrBuilder;
import com.google.ads.googleads.v18.resources.AssetGroupProto;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class AssetGroup
extends GeneratedMessageV3
implements AssetGroupOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int ID_FIELD_NUMBER = 9;
    private long id_ = 0L;
    public static final int CAMPAIGN_FIELD_NUMBER = 2;
    private volatile Object campaign_ = "";
    public static final int NAME_FIELD_NUMBER = 3;
    private volatile Object name_ = "";
    public static final int FINAL_URLS_FIELD_NUMBER = 4;
    private LazyStringArrayList finalUrls_ = LazyStringArrayList.emptyList();
    public static final int FINAL_MOBILE_URLS_FIELD_NUMBER = 5;
    private LazyStringArrayList finalMobileUrls_ = LazyStringArrayList.emptyList();
    public static final int STATUS_FIELD_NUMBER = 6;
    private int status_ = 0;
    public static final int PRIMARY_STATUS_FIELD_NUMBER = 11;
    private int primaryStatus_ = 0;
    public static final int PRIMARY_STATUS_REASONS_FIELD_NUMBER = 12;
    private List<Integer> primaryStatusReasons_;
    private static final Internal.ListAdapter.Converter<Integer, AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason> primaryStatusReasons_converter_ = new Internal.ListAdapter.Converter<Integer, AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason>(){

        public AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason convert(Integer from) {
            AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason result = AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason.forNumber(from);
            return result == null ? AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason.UNRECOGNIZED : result;
        }
    };
    private int primaryStatusReasonsMemoizedSerializedSize;
    public static final int PATH1_FIELD_NUMBER = 7;
    private volatile Object path1_ = "";
    public static final int PATH2_FIELD_NUMBER = 8;
    private volatile Object path2_ = "";
    public static final int AD_STRENGTH_FIELD_NUMBER = 10;
    private int adStrength_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final AssetGroup DEFAULT_INSTANCE = new AssetGroup();
    private static final Parser<AssetGroup> PARSER = new AbstractParser<AssetGroup>(){

        public AssetGroup parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = AssetGroup.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private AssetGroup(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private AssetGroup() {
        this.resourceName_ = "";
        this.campaign_ = "";
        this.name_ = "";
        this.finalUrls_ = LazyStringArrayList.emptyList();
        this.finalMobileUrls_ = LazyStringArrayList.emptyList();
        this.status_ = 0;
        this.primaryStatus_ = 0;
        this.primaryStatusReasons_ = Collections.emptyList();
        this.path1_ = "";
        this.path2_ = "";
        this.adStrength_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new AssetGroup();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AssetGroupProto.internal_static_google_ads_googleads_v18_resources_AssetGroup_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AssetGroupProto.internal_static_google_ads_googleads_v18_resources_AssetGroup_fieldAccessorTable.ensureFieldAccessorsInitialized(AssetGroup.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public long getId() {
        return this.id_;
    }

    @Override
    public String getCampaign() {
        Object ref = this.campaign_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.campaign_ = s;
        return s;
    }

    @Override
    public ByteString getCampaignBytes() {
        Object ref = this.campaign_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.campaign_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getFinalUrlsList() {
        return this.finalUrls_;
    }

    @Override
    public int getFinalUrlsCount() {
        return this.finalUrls_.size();
    }

    @Override
    public String getFinalUrls(int index) {
        return this.finalUrls_.get(index);
    }

    @Override
    public ByteString getFinalUrlsBytes(int index) {
        return this.finalUrls_.getByteString(index);
    }

    public ProtocolStringList getFinalMobileUrlsList() {
        return this.finalMobileUrls_;
    }

    @Override
    public int getFinalMobileUrlsCount() {
        return this.finalMobileUrls_.size();
    }

    @Override
    public String getFinalMobileUrls(int index) {
        return this.finalMobileUrls_.get(index);
    }

    @Override
    public ByteString getFinalMobileUrlsBytes(int index) {
        return this.finalMobileUrls_.getByteString(index);
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public AssetGroupStatusEnum.AssetGroupStatus getStatus() {
        AssetGroupStatusEnum.AssetGroupStatus result = AssetGroupStatusEnum.AssetGroupStatus.forNumber(this.status_);
        return result == null ? AssetGroupStatusEnum.AssetGroupStatus.UNRECOGNIZED : result;
    }

    @Override
    public int getPrimaryStatusValue() {
        return this.primaryStatus_;
    }

    @Override
    public AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus getPrimaryStatus() {
        AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus result = AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus.forNumber(this.primaryStatus_);
        return result == null ? AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus.UNRECOGNIZED : result;
    }

    @Override
    public List<AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason> getPrimaryStatusReasonsList() {
        return new Internal.ListAdapter(this.primaryStatusReasons_, primaryStatusReasons_converter_);
    }

    @Override
    public int getPrimaryStatusReasonsCount() {
        return this.primaryStatusReasons_.size();
    }

    @Override
    public AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason getPrimaryStatusReasons(int index) {
        return (AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason)((Object)primaryStatusReasons_converter_.convert((Object)this.primaryStatusReasons_.get(index)));
    }

    @Override
    public List<Integer> getPrimaryStatusReasonsValueList() {
        return this.primaryStatusReasons_;
    }

    @Override
    public int getPrimaryStatusReasonsValue(int index) {
        return this.primaryStatusReasons_.get(index);
    }

    @Override
    public String getPath1() {
        Object ref = this.path1_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.path1_ = s;
        return s;
    }

    @Override
    public ByteString getPath1Bytes() {
        Object ref = this.path1_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.path1_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getPath2() {
        Object ref = this.path2_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.path2_ = s;
        return s;
    }

    @Override
    public ByteString getPath2Bytes() {
        Object ref = this.path2_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.path2_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getAdStrengthValue() {
        return this.adStrength_;
    }

    @Override
    public AdStrengthEnum.AdStrength getAdStrength() {
        AdStrengthEnum.AdStrength result = AdStrengthEnum.AdStrength.forNumber(this.adStrength_);
        return result == null ? AdStrengthEnum.AdStrength.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.campaign_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.campaign_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.name_);
        }
        for (i = 0; i < this.finalUrls_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.finalUrls_.getRaw(i));
        }
        for (i = 0; i < this.finalMobileUrls_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.finalMobileUrls_.getRaw(i));
        }
        if (this.status_ != AssetGroupStatusEnum.AssetGroupStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.status_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.path1_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.path1_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.path2_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.path2_);
        }
        if (this.id_ != 0L) {
            output.writeInt64(9, this.id_);
        }
        if (this.adStrength_ != AdStrengthEnum.AdStrength.UNSPECIFIED.getNumber()) {
            output.writeEnum(10, this.adStrength_);
        }
        if (this.primaryStatus_ != AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(11, this.primaryStatus_);
        }
        if (this.getPrimaryStatusReasonsList().size() > 0) {
            output.writeUInt32NoTag(98);
            output.writeUInt32NoTag(this.primaryStatusReasonsMemoizedSerializedSize);
        }
        for (i = 0; i < this.primaryStatusReasons_.size(); ++i) {
            output.writeEnumNoTag(this.primaryStatusReasons_.get(i).intValue());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.campaign_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.campaign_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.name_);
        }
        int dataSize = 0;
        for (i = 0; i < this.finalUrls_.size(); ++i) {
            dataSize += AssetGroup.computeStringSizeNoTag((Object)this.finalUrls_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getFinalUrlsList().size();
        dataSize = 0;
        for (i = 0; i < this.finalMobileUrls_.size(); ++i) {
            dataSize += AssetGroup.computeStringSizeNoTag((Object)this.finalMobileUrls_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getFinalMobileUrlsList().size();
        if (this.status_ != AssetGroupStatusEnum.AssetGroupStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.status_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.path1_)) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.path1_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.path2_)) {
            size += GeneratedMessageV3.computeStringSize((int)8, (Object)this.path2_);
        }
        if (this.id_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)9, (long)this.id_);
        }
        if (this.adStrength_ != AdStrengthEnum.AdStrength.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)10, (int)this.adStrength_);
        }
        if (this.primaryStatus_ != AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)11, (int)this.primaryStatus_);
        }
        dataSize = 0;
        for (i = 0; i < this.primaryStatusReasons_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.primaryStatusReasons_.get(i));
        }
        size += dataSize;
        if (!this.getPrimaryStatusReasonsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.primaryStatusReasonsMemoizedSerializedSize = dataSize;
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AssetGroup)) {
            return super.equals(obj);
        }
        AssetGroup other = (AssetGroup)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (!this.getCampaign().equals(other.getCampaign())) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getFinalUrlsList().equals(other.getFinalUrlsList())) {
            return false;
        }
        if (!this.getFinalMobileUrlsList().equals(other.getFinalMobileUrlsList())) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (this.primaryStatus_ != other.primaryStatus_) {
            return false;
        }
        if (!this.primaryStatusReasons_.equals(other.primaryStatusReasons_)) {
            return false;
        }
        if (!this.getPath1().equals(other.getPath1())) {
            return false;
        }
        if (!this.getPath2().equals(other.getPath2())) {
            return false;
        }
        if (this.adStrength_ != other.adStrength_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + AssetGroup.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        hash = 37 * hash + 9;
        hash = 53 * hash + Internal.hashLong((long)this.getId());
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getCampaign().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getName().hashCode();
        if (this.getFinalUrlsCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getFinalUrlsList().hashCode();
        }
        if (this.getFinalMobileUrlsCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getFinalMobileUrlsList().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.status_;
        hash = 37 * hash + 11;
        hash = 53 * hash + this.primaryStatus_;
        if (this.getPrimaryStatusReasonsCount() > 0) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.primaryStatusReasons_.hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getPath1().hashCode();
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getPath2().hashCode();
        hash = 37 * hash + 10;
        hash = 53 * hash + this.adStrength_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static AssetGroup parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (AssetGroup)PARSER.parseFrom(data);
    }

    public static AssetGroup parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AssetGroup)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AssetGroup parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (AssetGroup)PARSER.parseFrom(data);
    }

    public static AssetGroup parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AssetGroup)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AssetGroup parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (AssetGroup)PARSER.parseFrom(data);
    }

    public static AssetGroup parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AssetGroup)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AssetGroup parseFrom(InputStream input) throws IOException {
        return (AssetGroup)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static AssetGroup parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AssetGroup)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AssetGroup parseDelimitedFrom(InputStream input) throws IOException {
        return (AssetGroup)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static AssetGroup parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AssetGroup)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AssetGroup parseFrom(CodedInputStream input) throws IOException {
        return (AssetGroup)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static AssetGroup parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AssetGroup)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return AssetGroup.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AssetGroup prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static AssetGroup getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<AssetGroup> parser() {
        return PARSER;
    }

    public Parser<AssetGroup> getParserForType() {
        return PARSER;
    }

    public AssetGroup getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AssetGroupOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private long id_;
        private Object campaign_ = "";
        private Object name_ = "";
        private LazyStringArrayList finalUrls_ = LazyStringArrayList.emptyList();
        private LazyStringArrayList finalMobileUrls_ = LazyStringArrayList.emptyList();
        private int status_ = 0;
        private int primaryStatus_ = 0;
        private List<Integer> primaryStatusReasons_ = Collections.emptyList();
        private Object path1_ = "";
        private Object path2_ = "";
        private int adStrength_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return AssetGroupProto.internal_static_google_ads_googleads_v18_resources_AssetGroup_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AssetGroupProto.internal_static_google_ads_googleads_v18_resources_AssetGroup_fieldAccessorTable.ensureFieldAccessorsInitialized(AssetGroup.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.id_ = 0L;
            this.campaign_ = "";
            this.name_ = "";
            this.finalUrls_ = LazyStringArrayList.emptyList();
            this.finalMobileUrls_ = LazyStringArrayList.emptyList();
            this.status_ = 0;
            this.primaryStatus_ = 0;
            this.primaryStatusReasons_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.path1_ = "";
            this.path2_ = "";
            this.adStrength_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AssetGroupProto.internal_static_google_ads_googleads_v18_resources_AssetGroup_descriptor;
        }

        public AssetGroup getDefaultInstanceForType() {
            return AssetGroup.getDefaultInstance();
        }

        public AssetGroup build() {
            AssetGroup result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public AssetGroup buildPartial() {
            AssetGroup result = new AssetGroup(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(AssetGroup result) {
            if ((this.bitField0_ & 0x100) != 0) {
                this.primaryStatusReasons_ = Collections.unmodifiableList(this.primaryStatusReasons_);
                this.bitField0_ &= 0xFFFFFEFF;
            }
            result.primaryStatusReasons_ = this.primaryStatusReasons_;
        }

        private void buildPartial0(AssetGroup result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.id_ = this.id_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.campaign_ = this.campaign_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                this.finalUrls_.makeImmutable();
                result.finalUrls_ = this.finalUrls_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                this.finalMobileUrls_.makeImmutable();
                result.finalMobileUrls_ = this.finalMobileUrls_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.status_ = this.status_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.primaryStatus_ = this.primaryStatus_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.path1_ = this.path1_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.path2_ = this.path2_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.adStrength_ = this.adStrength_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof AssetGroup) {
                return this.mergeFrom((AssetGroup)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(AssetGroup other) {
            if (other == AssetGroup.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.getId() != 0L) {
                this.setId(other.getId());
            }
            if (!other.getCampaign().isEmpty()) {
                this.campaign_ = other.campaign_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (!other.finalUrls_.isEmpty()) {
                if (this.finalUrls_.isEmpty()) {
                    this.finalUrls_ = other.finalUrls_;
                    this.bitField0_ |= 0x10;
                } else {
                    this.ensureFinalUrlsIsMutable();
                    this.finalUrls_.addAll((Collection)other.finalUrls_);
                }
                this.onChanged();
            }
            if (!other.finalMobileUrls_.isEmpty()) {
                if (this.finalMobileUrls_.isEmpty()) {
                    this.finalMobileUrls_ = other.finalMobileUrls_;
                    this.bitField0_ |= 0x20;
                } else {
                    this.ensureFinalMobileUrlsIsMutable();
                    this.finalMobileUrls_.addAll((Collection)other.finalMobileUrls_);
                }
                this.onChanged();
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (other.primaryStatus_ != 0) {
                this.setPrimaryStatusValue(other.getPrimaryStatusValue());
            }
            if (!other.primaryStatusReasons_.isEmpty()) {
                if (this.primaryStatusReasons_.isEmpty()) {
                    this.primaryStatusReasons_ = other.primaryStatusReasons_;
                    this.bitField0_ &= 0xFFFFFEFF;
                } else {
                    this.ensurePrimaryStatusReasonsIsMutable();
                    this.primaryStatusReasons_.addAll(other.primaryStatusReasons_);
                }
                this.onChanged();
            }
            if (!other.getPath1().isEmpty()) {
                this.path1_ = other.path1_;
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            if (!other.getPath2().isEmpty()) {
                this.path2_ = other.path2_;
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            if (other.adStrength_ != 0) {
                this.setAdStrengthValue(other.getAdStrengthValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block21: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block21;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block21;
                        }
                        case 18: {
                            this.campaign_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block21;
                        }
                        case 26: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block21;
                        }
                        case 34: {
                            String s = input.readStringRequireUtf8();
                            this.ensureFinalUrlsIsMutable();
                            this.finalUrls_.add((Object)s);
                            continue block21;
                        }
                        case 42: {
                            String s = input.readStringRequireUtf8();
                            this.ensureFinalMobileUrlsIsMutable();
                            this.finalMobileUrls_.add((Object)s);
                            continue block21;
                        }
                        case 48: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 0x40;
                            continue block21;
                        }
                        case 58: {
                            this.path1_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x200;
                            continue block21;
                        }
                        case 66: {
                            this.path2_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x400;
                            continue block21;
                        }
                        case 72: {
                            this.id_ = input.readInt64();
                            this.bitField0_ |= 2;
                            continue block21;
                        }
                        case 80: {
                            this.adStrength_ = input.readEnum();
                            this.bitField0_ |= 0x800;
                            continue block21;
                        }
                        case 88: {
                            this.primaryStatus_ = input.readEnum();
                            this.bitField0_ |= 0x80;
                            continue block21;
                        }
                        case 96: {
                            int tmpRaw = input.readEnum();
                            this.ensurePrimaryStatusReasonsIsMutable();
                            this.primaryStatusReasons_.add(tmpRaw);
                            continue block21;
                        }
                        case 98: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensurePrimaryStatusReasonsIsMutable();
                                this.primaryStatusReasons_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block21;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = AssetGroup.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AssetGroup.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public long getId() {
            return this.id_;
        }

        public Builder setId(long value) {
            this.id_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.id_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public String getCampaign() {
            Object ref = this.campaign_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.campaign_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCampaignBytes() {
            Object ref = this.campaign_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.campaign_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCampaign(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.campaign_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearCampaign() {
            this.campaign_ = AssetGroup.getDefaultInstance().getCampaign();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setCampaignBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AssetGroup.checkByteStringIsUtf8((ByteString)value);
            this.campaign_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = AssetGroup.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AssetGroup.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        private void ensureFinalUrlsIsMutable() {
            if (!this.finalUrls_.isModifiable()) {
                this.finalUrls_ = new LazyStringArrayList((LazyStringList)this.finalUrls_);
            }
            this.bitField0_ |= 0x10;
        }

        public ProtocolStringList getFinalUrlsList() {
            this.finalUrls_.makeImmutable();
            return this.finalUrls_;
        }

        @Override
        public int getFinalUrlsCount() {
            return this.finalUrls_.size();
        }

        @Override
        public String getFinalUrls(int index) {
            return this.finalUrls_.get(index);
        }

        @Override
        public ByteString getFinalUrlsBytes(int index) {
            return this.finalUrls_.getByteString(index);
        }

        public Builder setFinalUrls(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureFinalUrlsIsMutable();
            this.finalUrls_.set(index, value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addFinalUrls(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureFinalUrlsIsMutable();
            this.finalUrls_.add((Object)value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addAllFinalUrls(Iterable<String> values) {
            this.ensureFinalUrlsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.finalUrls_);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearFinalUrls() {
            this.finalUrls_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder addFinalUrlsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AssetGroup.checkByteStringIsUtf8((ByteString)value);
            this.ensureFinalUrlsIsMutable();
            this.finalUrls_.add(value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        private void ensureFinalMobileUrlsIsMutable() {
            if (!this.finalMobileUrls_.isModifiable()) {
                this.finalMobileUrls_ = new LazyStringArrayList((LazyStringList)this.finalMobileUrls_);
            }
            this.bitField0_ |= 0x20;
        }

        public ProtocolStringList getFinalMobileUrlsList() {
            this.finalMobileUrls_.makeImmutable();
            return this.finalMobileUrls_;
        }

        @Override
        public int getFinalMobileUrlsCount() {
            return this.finalMobileUrls_.size();
        }

        @Override
        public String getFinalMobileUrls(int index) {
            return this.finalMobileUrls_.get(index);
        }

        @Override
        public ByteString getFinalMobileUrlsBytes(int index) {
            return this.finalMobileUrls_.getByteString(index);
        }

        public Builder setFinalMobileUrls(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureFinalMobileUrlsIsMutable();
            this.finalMobileUrls_.set(index, value);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder addFinalMobileUrls(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureFinalMobileUrlsIsMutable();
            this.finalMobileUrls_.add((Object)value);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder addAllFinalMobileUrls(Iterable<String> values) {
            this.ensureFinalMobileUrlsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.finalMobileUrls_);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearFinalMobileUrls() {
            this.finalMobileUrls_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder addFinalMobileUrlsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AssetGroup.checkByteStringIsUtf8((ByteString)value);
            this.ensureFinalMobileUrlsIsMutable();
            this.finalMobileUrls_.add(value);
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public AssetGroupStatusEnum.AssetGroupStatus getStatus() {
            AssetGroupStatusEnum.AssetGroupStatus result = AssetGroupStatusEnum.AssetGroupStatus.forNumber(this.status_);
            return result == null ? AssetGroupStatusEnum.AssetGroupStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(AssetGroupStatusEnum.AssetGroupStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x40;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getPrimaryStatusValue() {
            return this.primaryStatus_;
        }

        public Builder setPrimaryStatusValue(int value) {
            this.primaryStatus_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus getPrimaryStatus() {
            AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus result = AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus.forNumber(this.primaryStatus_);
            return result == null ? AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus.UNRECOGNIZED : result;
        }

        public Builder setPrimaryStatus(AssetGroupPrimaryStatusEnum.AssetGroupPrimaryStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x80;
            this.primaryStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryStatus() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.primaryStatus_ = 0;
            this.onChanged();
            return this;
        }

        private void ensurePrimaryStatusReasonsIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.primaryStatusReasons_ = new ArrayList<Integer>(this.primaryStatusReasons_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason> getPrimaryStatusReasonsList() {
            return new Internal.ListAdapter(this.primaryStatusReasons_, primaryStatusReasons_converter_);
        }

        @Override
        public int getPrimaryStatusReasonsCount() {
            return this.primaryStatusReasons_.size();
        }

        @Override
        public AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason getPrimaryStatusReasons(int index) {
            return (AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason)((Object)primaryStatusReasons_converter_.convert((Object)this.primaryStatusReasons_.get(index)));
        }

        public Builder setPrimaryStatusReasons(int index, AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addPrimaryStatusReasons(AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllPrimaryStatusReasons(Iterable<? extends AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason> values) {
            this.ensurePrimaryStatusReasonsIsMutable();
            for (AssetGroupPrimaryStatusReasonEnum.AssetGroupPrimaryStatusReason assetGroupPrimaryStatusReason : values) {
                this.primaryStatusReasons_.add(assetGroupPrimaryStatusReason.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryStatusReasons() {
            this.primaryStatusReasons_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getPrimaryStatusReasonsValueList() {
            return Collections.unmodifiableList(this.primaryStatusReasons_);
        }

        @Override
        public int getPrimaryStatusReasonsValue(int index) {
            return this.primaryStatusReasons_.get(index);
        }

        public Builder setPrimaryStatusReasonsValue(int index, int value) {
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addPrimaryStatusReasonsValue(int value) {
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllPrimaryStatusReasonsValue(Iterable<Integer> values) {
            this.ensurePrimaryStatusReasonsIsMutable();
            for (int value : values) {
                this.primaryStatusReasons_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public String getPath1() {
            Object ref = this.path1_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.path1_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPath1Bytes() {
            Object ref = this.path1_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.path1_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPath1(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.path1_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearPath1() {
            this.path1_ = AssetGroup.getDefaultInstance().getPath1();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder setPath1Bytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AssetGroup.checkByteStringIsUtf8((ByteString)value);
            this.path1_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public String getPath2() {
            Object ref = this.path2_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.path2_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPath2Bytes() {
            Object ref = this.path2_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.path2_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPath2(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.path2_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearPath2() {
            this.path2_ = AssetGroup.getDefaultInstance().getPath2();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        public Builder setPath2Bytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AssetGroup.checkByteStringIsUtf8((ByteString)value);
            this.path2_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public int getAdStrengthValue() {
            return this.adStrength_;
        }

        public Builder setAdStrengthValue(int value) {
            this.adStrength_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public AdStrengthEnum.AdStrength getAdStrength() {
            AdStrengthEnum.AdStrength result = AdStrengthEnum.AdStrength.forNumber(this.adStrength_);
            return result == null ? AdStrengthEnum.AdStrength.UNRECOGNIZED : result;
        }

        public Builder setAdStrength(AdStrengthEnum.AdStrength value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x800;
            this.adStrength_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAdStrength() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.adStrength_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

