/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BiddingStrategySimulationName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_BIDDING_STRATEGY_ID_TYPE_MODIFICATION_METHOD_START_DATE_END_DATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/biddingStrategySimulations/{bidding_strategy_id}~{type}~{modification_method}~{start_date}~{end_date}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String biddingStrategyId;
    private final String type;
    private final String modificationMethod;
    private final String startDate;
    private final String endDate;

    @Deprecated
    protected BiddingStrategySimulationName() {
        this.customerId = null;
        this.biddingStrategyId = null;
        this.type = null;
        this.modificationMethod = null;
        this.startDate = null;
        this.endDate = null;
    }

    private BiddingStrategySimulationName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.biddingStrategyId = (String)Preconditions.checkNotNull((Object)builder.getBiddingStrategyId());
        this.type = (String)Preconditions.checkNotNull((Object)builder.getType());
        this.modificationMethod = (String)Preconditions.checkNotNull((Object)builder.getModificationMethod());
        this.startDate = (String)Preconditions.checkNotNull((Object)builder.getStartDate());
        this.endDate = (String)Preconditions.checkNotNull((Object)builder.getEndDate());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getBiddingStrategyId() {
        return this.biddingStrategyId;
    }

    public String getType() {
        return this.type;
    }

    public String getModificationMethod() {
        return this.modificationMethod;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BiddingStrategySimulationName of(String customerId, String biddingStrategyId, String type, String modificationMethod, String startDate, String endDate) {
        return BiddingStrategySimulationName.newBuilder().setCustomerId(customerId).setBiddingStrategyId(biddingStrategyId).setType(type).setModificationMethod(modificationMethod).setStartDate(startDate).setEndDate(endDate).build();
    }

    public static String format(String customerId, String biddingStrategyId, String type, String modificationMethod, String startDate, String endDate) {
        return BiddingStrategySimulationName.newBuilder().setCustomerId(customerId).setBiddingStrategyId(biddingStrategyId).setType(type).setModificationMethod(modificationMethod).setStartDate(startDate).setEndDate(endDate).build().toString();
    }

    public static BiddingStrategySimulationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_BIDDING_STRATEGY_ID_TYPE_MODIFICATION_METHOD_START_DATE_END_DATE.validatedMatch(formattedString, "BiddingStrategySimulationName.parse: formattedString not in valid format");
        return BiddingStrategySimulationName.of((String)matchMap.get("customer_id"), (String)matchMap.get("bidding_strategy_id"), (String)matchMap.get("type"), (String)matchMap.get("modification_method"), (String)matchMap.get("start_date"), (String)matchMap.get("end_date"));
    }

    public static List<BiddingStrategySimulationName> parseList(List<String> formattedStrings) {
        ArrayList<BiddingStrategySimulationName> list = new ArrayList<BiddingStrategySimulationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BiddingStrategySimulationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BiddingStrategySimulationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BiddingStrategySimulationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_BIDDING_STRATEGY_ID_TYPE_MODIFICATION_METHOD_START_DATE_END_DATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BiddingStrategySimulationName biddingStrategySimulationName = this;
            synchronized (biddingStrategySimulationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.biddingStrategyId != null) {
                        fieldMapBuilder.put((Object)"bidding_strategy_id", (Object)this.biddingStrategyId);
                    }
                    if (this.type != null) {
                        fieldMapBuilder.put((Object)"type", (Object)this.type);
                    }
                    if (this.modificationMethod != null) {
                        fieldMapBuilder.put((Object)"modification_method", (Object)this.modificationMethod);
                    }
                    if (this.startDate != null) {
                        fieldMapBuilder.put((Object)"start_date", (Object)this.startDate);
                    }
                    if (this.endDate != null) {
                        fieldMapBuilder.put((Object)"end_date", (Object)this.endDate);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_BIDDING_STRATEGY_ID_TYPE_MODIFICATION_METHOD_START_DATE_END_DATE.instantiate(new String[]{"customer_id", this.customerId, "bidding_strategy_id", this.biddingStrategyId, "type", this.type, "modification_method", this.modificationMethod, "start_date", this.startDate, "end_date", this.endDate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BiddingStrategySimulationName that = (BiddingStrategySimulationName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.biddingStrategyId, that.biddingStrategyId) && Objects.equals(this.type, that.type) && Objects.equals(this.modificationMethod, that.modificationMethod) && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.biddingStrategyId);
        h *= 1000003;
        h ^= Objects.hashCode(this.type);
        h *= 1000003;
        h ^= Objects.hashCode(this.modificationMethod);
        h *= 1000003;
        h ^= Objects.hashCode(this.startDate);
        h *= 1000003;
        return h ^= Objects.hashCode(this.endDate);
    }

    public static class Builder {
        private String customerId;
        private String biddingStrategyId;
        private String type;
        private String modificationMethod;
        private String startDate;
        private String endDate;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getBiddingStrategyId() {
            return this.biddingStrategyId;
        }

        public String getType() {
            return this.type;
        }

        public String getModificationMethod() {
            return this.modificationMethod;
        }

        public String getStartDate() {
            return this.startDate;
        }

        public String getEndDate() {
            return this.endDate;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setBiddingStrategyId(String biddingStrategyId) {
            this.biddingStrategyId = biddingStrategyId;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setModificationMethod(String modificationMethod) {
            this.modificationMethod = modificationMethod;
            return this;
        }

        public Builder setStartDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder setEndDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        private Builder(BiddingStrategySimulationName biddingStrategySimulationName) {
            this.customerId = biddingStrategySimulationName.customerId;
            this.biddingStrategyId = biddingStrategySimulationName.biddingStrategyId;
            this.type = biddingStrategySimulationName.type;
            this.modificationMethod = biddingStrategySimulationName.modificationMethod;
            this.startDate = biddingStrategySimulationName.startDate;
            this.endDate = biddingStrategySimulationName.endDate;
        }

        public BiddingStrategySimulationName build() {
            return new BiddingStrategySimulationName(this);
        }
    }
}

