/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChangeEventName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_TIMESTAMP_MICROS_COMMAND_INDEX_MUTATE_INDEX = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/changeEvents/{timestamp_micros}~{command_index}~{mutate_index}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String timestampMicros;
    private final String commandIndex;
    private final String mutateIndex;

    @Deprecated
    protected ChangeEventName() {
        this.customerId = null;
        this.timestampMicros = null;
        this.commandIndex = null;
        this.mutateIndex = null;
    }

    private ChangeEventName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.timestampMicros = (String)Preconditions.checkNotNull((Object)builder.getTimestampMicros());
        this.commandIndex = (String)Preconditions.checkNotNull((Object)builder.getCommandIndex());
        this.mutateIndex = (String)Preconditions.checkNotNull((Object)builder.getMutateIndex());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getTimestampMicros() {
        return this.timestampMicros;
    }

    public String getCommandIndex() {
        return this.commandIndex;
    }

    public String getMutateIndex() {
        return this.mutateIndex;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ChangeEventName of(String customerId, String timestampMicros, String commandIndex, String mutateIndex) {
        return ChangeEventName.newBuilder().setCustomerId(customerId).setTimestampMicros(timestampMicros).setCommandIndex(commandIndex).setMutateIndex(mutateIndex).build();
    }

    public static String format(String customerId, String timestampMicros, String commandIndex, String mutateIndex) {
        return ChangeEventName.newBuilder().setCustomerId(customerId).setTimestampMicros(timestampMicros).setCommandIndex(commandIndex).setMutateIndex(mutateIndex).build().toString();
    }

    public static ChangeEventName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_TIMESTAMP_MICROS_COMMAND_INDEX_MUTATE_INDEX.validatedMatch(formattedString, "ChangeEventName.parse: formattedString not in valid format");
        return ChangeEventName.of((String)matchMap.get("customer_id"), (String)matchMap.get("timestamp_micros"), (String)matchMap.get("command_index"), (String)matchMap.get("mutate_index"));
    }

    public static List<ChangeEventName> parseList(List<String> formattedStrings) {
        ArrayList<ChangeEventName> list = new ArrayList<ChangeEventName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChangeEventName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChangeEventName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChangeEventName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_TIMESTAMP_MICROS_COMMAND_INDEX_MUTATE_INDEX.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChangeEventName changeEventName = this;
            synchronized (changeEventName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.timestampMicros != null) {
                        fieldMapBuilder.put((Object)"timestamp_micros", (Object)this.timestampMicros);
                    }
                    if (this.commandIndex != null) {
                        fieldMapBuilder.put((Object)"command_index", (Object)this.commandIndex);
                    }
                    if (this.mutateIndex != null) {
                        fieldMapBuilder.put((Object)"mutate_index", (Object)this.mutateIndex);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_TIMESTAMP_MICROS_COMMAND_INDEX_MUTATE_INDEX.instantiate(new String[]{"customer_id", this.customerId, "timestamp_micros", this.timestampMicros, "command_index", this.commandIndex, "mutate_index", this.mutateIndex});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ChangeEventName that = (ChangeEventName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.timestampMicros, that.timestampMicros) && Objects.equals(this.commandIndex, that.commandIndex) && Objects.equals(this.mutateIndex, that.mutateIndex);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.timestampMicros);
        h *= 1000003;
        h ^= Objects.hashCode(this.commandIndex);
        h *= 1000003;
        return h ^= Objects.hashCode(this.mutateIndex);
    }

    public static class Builder {
        private String customerId;
        private String timestampMicros;
        private String commandIndex;
        private String mutateIndex;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getTimestampMicros() {
            return this.timestampMicros;
        }

        public String getCommandIndex() {
            return this.commandIndex;
        }

        public String getMutateIndex() {
            return this.mutateIndex;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setTimestampMicros(String timestampMicros) {
            this.timestampMicros = timestampMicros;
            return this;
        }

        public Builder setCommandIndex(String commandIndex) {
            this.commandIndex = commandIndex;
            return this;
        }

        public Builder setMutateIndex(String mutateIndex) {
            this.mutateIndex = mutateIndex;
            return this;
        }

        private Builder(ChangeEventName changeEventName) {
            this.customerId = changeEventName.customerId;
            this.timestampMicros = changeEventName.timestampMicros;
            this.commandIndex = changeEventName.commandIndex;
            this.mutateIndex = changeEventName.mutateIndex;
        }

        public ChangeEventName build() {
            return new ChangeEventName(this);
        }
    }
}

