/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeywordPlanAdGroupKeywordName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_KEYWORD_PLAN_AD_GROUP_KEYWORD_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/keywordPlanAdGroupKeywords/{keyword_plan_ad_group_keyword_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String keywordPlanAdGroupKeywordId;

    @Deprecated
    protected KeywordPlanAdGroupKeywordName() {
        this.customerId = null;
        this.keywordPlanAdGroupKeywordId = null;
    }

    private KeywordPlanAdGroupKeywordName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.keywordPlanAdGroupKeywordId = (String)Preconditions.checkNotNull((Object)builder.getKeywordPlanAdGroupKeywordId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getKeywordPlanAdGroupKeywordId() {
        return this.keywordPlanAdGroupKeywordId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KeywordPlanAdGroupKeywordName of(String customerId, String keywordPlanAdGroupKeywordId) {
        return KeywordPlanAdGroupKeywordName.newBuilder().setCustomerId(customerId).setKeywordPlanAdGroupKeywordId(keywordPlanAdGroupKeywordId).build();
    }

    public static String format(String customerId, String keywordPlanAdGroupKeywordId) {
        return KeywordPlanAdGroupKeywordName.newBuilder().setCustomerId(customerId).setKeywordPlanAdGroupKeywordId(keywordPlanAdGroupKeywordId).build().toString();
    }

    public static KeywordPlanAdGroupKeywordName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_KEYWORD_PLAN_AD_GROUP_KEYWORD_ID.validatedMatch(formattedString, "KeywordPlanAdGroupKeywordName.parse: formattedString not in valid format");
        return KeywordPlanAdGroupKeywordName.of((String)matchMap.get("customer_id"), (String)matchMap.get("keyword_plan_ad_group_keyword_id"));
    }

    public static List<KeywordPlanAdGroupKeywordName> parseList(List<String> formattedStrings) {
        ArrayList<KeywordPlanAdGroupKeywordName> list = new ArrayList<KeywordPlanAdGroupKeywordName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeywordPlanAdGroupKeywordName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeywordPlanAdGroupKeywordName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeywordPlanAdGroupKeywordName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_KEYWORD_PLAN_AD_GROUP_KEYWORD_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeywordPlanAdGroupKeywordName keywordPlanAdGroupKeywordName = this;
            synchronized (keywordPlanAdGroupKeywordName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.keywordPlanAdGroupKeywordId != null) {
                        fieldMapBuilder.put((Object)"keyword_plan_ad_group_keyword_id", (Object)this.keywordPlanAdGroupKeywordId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_KEYWORD_PLAN_AD_GROUP_KEYWORD_ID.instantiate(new String[]{"customer_id", this.customerId, "keyword_plan_ad_group_keyword_id", this.keywordPlanAdGroupKeywordId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            KeywordPlanAdGroupKeywordName that = (KeywordPlanAdGroupKeywordName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.keywordPlanAdGroupKeywordId, that.keywordPlanAdGroupKeywordId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.keywordPlanAdGroupKeywordId);
    }

    public static class Builder {
        private String customerId;
        private String keywordPlanAdGroupKeywordId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getKeywordPlanAdGroupKeywordId() {
            return this.keywordPlanAdGroupKeywordId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setKeywordPlanAdGroupKeywordId(String keywordPlanAdGroupKeywordId) {
            this.keywordPlanAdGroupKeywordId = keywordPlanAdGroupKeywordId;
            return this;
        }

        private Builder(KeywordPlanAdGroupKeywordName keywordPlanAdGroupKeywordName) {
            this.customerId = keywordPlanAdGroupKeywordName.customerId;
            this.keywordPlanAdGroupKeywordId = keywordPlanAdGroupKeywordName.keywordPlanAdGroupKeywordId;
        }

        public KeywordPlanAdGroupKeywordName build() {
            return new KeywordPlanAdGroupKeywordName(this);
        }
    }
}

