/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LocalServicesEmployeeName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_GLS_EMPLOYEE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/localServicesEmployees/{gls_employee_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String glsEmployeeId;

    @Deprecated
    protected LocalServicesEmployeeName() {
        this.customerId = null;
        this.glsEmployeeId = null;
    }

    private LocalServicesEmployeeName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.glsEmployeeId = (String)Preconditions.checkNotNull((Object)builder.getGlsEmployeeId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getGlsEmployeeId() {
        return this.glsEmployeeId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LocalServicesEmployeeName of(String customerId, String glsEmployeeId) {
        return LocalServicesEmployeeName.newBuilder().setCustomerId(customerId).setGlsEmployeeId(glsEmployeeId).build();
    }

    public static String format(String customerId, String glsEmployeeId) {
        return LocalServicesEmployeeName.newBuilder().setCustomerId(customerId).setGlsEmployeeId(glsEmployeeId).build().toString();
    }

    public static LocalServicesEmployeeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_GLS_EMPLOYEE_ID.validatedMatch(formattedString, "LocalServicesEmployeeName.parse: formattedString not in valid format");
        return LocalServicesEmployeeName.of((String)matchMap.get("customer_id"), (String)matchMap.get("gls_employee_id"));
    }

    public static List<LocalServicesEmployeeName> parseList(List<String> formattedStrings) {
        ArrayList<LocalServicesEmployeeName> list = new ArrayList<LocalServicesEmployeeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LocalServicesEmployeeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LocalServicesEmployeeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LocalServicesEmployeeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_GLS_EMPLOYEE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LocalServicesEmployeeName localServicesEmployeeName = this;
            synchronized (localServicesEmployeeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.glsEmployeeId != null) {
                        fieldMapBuilder.put((Object)"gls_employee_id", (Object)this.glsEmployeeId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_GLS_EMPLOYEE_ID.instantiate(new String[]{"customer_id", this.customerId, "gls_employee_id", this.glsEmployeeId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LocalServicesEmployeeName that = (LocalServicesEmployeeName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.glsEmployeeId, that.glsEmployeeId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.glsEmployeeId);
    }

    public static class Builder {
        private String customerId;
        private String glsEmployeeId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getGlsEmployeeId() {
            return this.glsEmployeeId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setGlsEmployeeId(String glsEmployeeId) {
            this.glsEmployeeId = glsEmployeeId;
            return this;
        }

        private Builder(LocalServicesEmployeeName localServicesEmployeeName) {
            this.customerId = localServicesEmployeeName.customerId;
            this.glsEmployeeId = localServicesEmployeeName.glsEmployeeId;
        }

        public LocalServicesEmployeeName build() {
            return new LocalServicesEmployeeName(this);
        }
    }
}

