/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.resources;

import com.google.ads.googleads.v18.enums.OfflineConversionDiagnosticStatusEnum;
import com.google.ads.googleads.v18.enums.OfflineEventUploadClientEnum;
import com.google.ads.googleads.v18.resources.OfflineConversionAlert;
import com.google.ads.googleads.v18.resources.OfflineConversionAlertOrBuilder;
import com.google.ads.googleads.v18.resources.OfflineConversionSummary;
import com.google.ads.googleads.v18.resources.OfflineConversionSummaryOrBuilder;
import com.google.ads.googleads.v18.resources.OfflineConversionUploadConversionActionSummaryOrBuilder;
import com.google.ads.googleads.v18.resources.OfflineConversionUploadConversionActionSummaryProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OfflineConversionUploadConversionActionSummary
extends GeneratedMessageV3
implements OfflineConversionUploadConversionActionSummaryOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int CLIENT_FIELD_NUMBER = 2;
    private int client_ = 0;
    public static final int CONVERSION_ACTION_ID_FIELD_NUMBER = 3;
    private long conversionActionId_ = 0L;
    public static final int CONVERSION_ACTION_NAME_FIELD_NUMBER = 4;
    private volatile Object conversionActionName_ = "";
    public static final int STATUS_FIELD_NUMBER = 5;
    private int status_ = 0;
    public static final int TOTAL_EVENT_COUNT_FIELD_NUMBER = 6;
    private long totalEventCount_ = 0L;
    public static final int SUCCESSFUL_EVENT_COUNT_FIELD_NUMBER = 7;
    private long successfulEventCount_ = 0L;
    public static final int PENDING_EVENT_COUNT_FIELD_NUMBER = 8;
    private long pendingEventCount_ = 0L;
    public static final int LAST_UPLOAD_DATE_TIME_FIELD_NUMBER = 9;
    private volatile Object lastUploadDateTime_ = "";
    public static final int DAILY_SUMMARIES_FIELD_NUMBER = 10;
    private List<OfflineConversionSummary> dailySummaries_;
    public static final int JOB_SUMMARIES_FIELD_NUMBER = 11;
    private List<OfflineConversionSummary> jobSummaries_;
    public static final int ALERTS_FIELD_NUMBER = 12;
    private List<OfflineConversionAlert> alerts_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final OfflineConversionUploadConversionActionSummary DEFAULT_INSTANCE = new OfflineConversionUploadConversionActionSummary();
    private static final Parser<OfflineConversionUploadConversionActionSummary> PARSER = new AbstractParser<OfflineConversionUploadConversionActionSummary>(){

        public OfflineConversionUploadConversionActionSummary parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = OfflineConversionUploadConversionActionSummary.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private OfflineConversionUploadConversionActionSummary(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private OfflineConversionUploadConversionActionSummary() {
        this.resourceName_ = "";
        this.client_ = 0;
        this.conversionActionName_ = "";
        this.status_ = 0;
        this.lastUploadDateTime_ = "";
        this.dailySummaries_ = Collections.emptyList();
        this.jobSummaries_ = Collections.emptyList();
        this.alerts_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new OfflineConversionUploadConversionActionSummary();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return OfflineConversionUploadConversionActionSummaryProto.internal_static_google_ads_googleads_v18_resources_OfflineConversionUploadConversionActionSummary_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return OfflineConversionUploadConversionActionSummaryProto.internal_static_google_ads_googleads_v18_resources_OfflineConversionUploadConversionActionSummary_fieldAccessorTable.ensureFieldAccessorsInitialized(OfflineConversionUploadConversionActionSummary.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getClientValue() {
        return this.client_;
    }

    @Override
    public OfflineEventUploadClientEnum.OfflineEventUploadClient getClient() {
        OfflineEventUploadClientEnum.OfflineEventUploadClient result = OfflineEventUploadClientEnum.OfflineEventUploadClient.forNumber(this.client_);
        return result == null ? OfflineEventUploadClientEnum.OfflineEventUploadClient.UNRECOGNIZED : result;
    }

    @Override
    public long getConversionActionId() {
        return this.conversionActionId_;
    }

    @Override
    public String getConversionActionName() {
        Object ref = this.conversionActionName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.conversionActionName_ = s;
        return s;
    }

    @Override
    public ByteString getConversionActionNameBytes() {
        Object ref = this.conversionActionName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.conversionActionName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus getStatus() {
        OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus result = OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus.forNumber(this.status_);
        return result == null ? OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus.UNRECOGNIZED : result;
    }

    @Override
    public long getTotalEventCount() {
        return this.totalEventCount_;
    }

    @Override
    public long getSuccessfulEventCount() {
        return this.successfulEventCount_;
    }

    @Override
    public long getPendingEventCount() {
        return this.pendingEventCount_;
    }

    @Override
    public String getLastUploadDateTime() {
        Object ref = this.lastUploadDateTime_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.lastUploadDateTime_ = s;
        return s;
    }

    @Override
    public ByteString getLastUploadDateTimeBytes() {
        Object ref = this.lastUploadDateTime_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.lastUploadDateTime_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<OfflineConversionSummary> getDailySummariesList() {
        return this.dailySummaries_;
    }

    @Override
    public List<? extends OfflineConversionSummaryOrBuilder> getDailySummariesOrBuilderList() {
        return this.dailySummaries_;
    }

    @Override
    public int getDailySummariesCount() {
        return this.dailySummaries_.size();
    }

    @Override
    public OfflineConversionSummary getDailySummaries(int index) {
        return this.dailySummaries_.get(index);
    }

    @Override
    public OfflineConversionSummaryOrBuilder getDailySummariesOrBuilder(int index) {
        return this.dailySummaries_.get(index);
    }

    @Override
    public List<OfflineConversionSummary> getJobSummariesList() {
        return this.jobSummaries_;
    }

    @Override
    public List<? extends OfflineConversionSummaryOrBuilder> getJobSummariesOrBuilderList() {
        return this.jobSummaries_;
    }

    @Override
    public int getJobSummariesCount() {
        return this.jobSummaries_.size();
    }

    @Override
    public OfflineConversionSummary getJobSummaries(int index) {
        return this.jobSummaries_.get(index);
    }

    @Override
    public OfflineConversionSummaryOrBuilder getJobSummariesOrBuilder(int index) {
        return this.jobSummaries_.get(index);
    }

    @Override
    public List<OfflineConversionAlert> getAlertsList() {
        return this.alerts_;
    }

    @Override
    public List<? extends OfflineConversionAlertOrBuilder> getAlertsOrBuilderList() {
        return this.alerts_;
    }

    @Override
    public int getAlertsCount() {
        return this.alerts_.size();
    }

    @Override
    public OfflineConversionAlert getAlerts(int index) {
        return this.alerts_.get(index);
    }

    @Override
    public OfflineConversionAlertOrBuilder getAlertsOrBuilder(int index) {
        return this.alerts_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (this.client_ != OfflineEventUploadClientEnum.OfflineEventUploadClient.UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.client_);
        }
        if (this.conversionActionId_ != 0L) {
            output.writeInt64(3, this.conversionActionId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.conversionActionName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.conversionActionName_);
        }
        if (this.status_ != OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.status_);
        }
        if (this.totalEventCount_ != 0L) {
            output.writeInt64(6, this.totalEventCount_);
        }
        if (this.successfulEventCount_ != 0L) {
            output.writeInt64(7, this.successfulEventCount_);
        }
        if (this.pendingEventCount_ != 0L) {
            output.writeInt64(8, this.pendingEventCount_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.lastUploadDateTime_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.lastUploadDateTime_);
        }
        for (i = 0; i < this.dailySummaries_.size(); ++i) {
            output.writeMessage(10, (MessageLite)this.dailySummaries_.get(i));
        }
        for (i = 0; i < this.jobSummaries_.size(); ++i) {
            output.writeMessage(11, (MessageLite)this.jobSummaries_.get(i));
        }
        for (i = 0; i < this.alerts_.size(); ++i) {
            output.writeMessage(12, (MessageLite)this.alerts_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (this.client_ != OfflineEventUploadClientEnum.OfflineEventUploadClient.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.client_);
        }
        if (this.conversionActionId_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)3, (long)this.conversionActionId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.conversionActionName_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.conversionActionName_);
        }
        if (this.status_ != OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.status_);
        }
        if (this.totalEventCount_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)6, (long)this.totalEventCount_);
        }
        if (this.successfulEventCount_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)7, (long)this.successfulEventCount_);
        }
        if (this.pendingEventCount_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)8, (long)this.pendingEventCount_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.lastUploadDateTime_)) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.lastUploadDateTime_);
        }
        for (i = 0; i < this.dailySummaries_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)((MessageLite)this.dailySummaries_.get(i)));
        }
        for (i = 0; i < this.jobSummaries_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)((MessageLite)this.jobSummaries_.get(i)));
        }
        for (i = 0; i < this.alerts_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)((MessageLite)this.alerts_.get(i)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OfflineConversionUploadConversionActionSummary)) {
            return super.equals(obj);
        }
        OfflineConversionUploadConversionActionSummary other = (OfflineConversionUploadConversionActionSummary)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.client_ != other.client_) {
            return false;
        }
        if (this.getConversionActionId() != other.getConversionActionId()) {
            return false;
        }
        if (!this.getConversionActionName().equals(other.getConversionActionName())) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (this.getTotalEventCount() != other.getTotalEventCount()) {
            return false;
        }
        if (this.getSuccessfulEventCount() != other.getSuccessfulEventCount()) {
            return false;
        }
        if (this.getPendingEventCount() != other.getPendingEventCount()) {
            return false;
        }
        if (!this.getLastUploadDateTime().equals(other.getLastUploadDateTime())) {
            return false;
        }
        if (!this.getDailySummariesList().equals(other.getDailySummariesList())) {
            return false;
        }
        if (!this.getJobSummariesList().equals(other.getJobSummariesList())) {
            return false;
        }
        if (!this.getAlertsList().equals(other.getAlertsList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + OfflineConversionUploadConversionActionSummary.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.client_;
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashLong((long)this.getConversionActionId());
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getConversionActionName().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.status_;
        hash = 37 * hash + 6;
        hash = 53 * hash + Internal.hashLong((long)this.getTotalEventCount());
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashLong((long)this.getSuccessfulEventCount());
        hash = 37 * hash + 8;
        hash = 53 * hash + Internal.hashLong((long)this.getPendingEventCount());
        hash = 37 * hash + 9;
        hash = 53 * hash + this.getLastUploadDateTime().hashCode();
        if (this.getDailySummariesCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getDailySummariesList().hashCode();
        }
        if (this.getJobSummariesCount() > 0) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getJobSummariesList().hashCode();
        }
        if (this.getAlertsCount() > 0) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getAlertsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static OfflineConversionUploadConversionActionSummary parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (OfflineConversionUploadConversionActionSummary)PARSER.parseFrom(data);
    }

    public static OfflineConversionUploadConversionActionSummary parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OfflineConversionUploadConversionActionSummary)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OfflineConversionUploadConversionActionSummary parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (OfflineConversionUploadConversionActionSummary)PARSER.parseFrom(data);
    }

    public static OfflineConversionUploadConversionActionSummary parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OfflineConversionUploadConversionActionSummary)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OfflineConversionUploadConversionActionSummary parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (OfflineConversionUploadConversionActionSummary)PARSER.parseFrom(data);
    }

    public static OfflineConversionUploadConversionActionSummary parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OfflineConversionUploadConversionActionSummary)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OfflineConversionUploadConversionActionSummary parseFrom(InputStream input) throws IOException {
        return (OfflineConversionUploadConversionActionSummary)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static OfflineConversionUploadConversionActionSummary parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OfflineConversionUploadConversionActionSummary)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OfflineConversionUploadConversionActionSummary parseDelimitedFrom(InputStream input) throws IOException {
        return (OfflineConversionUploadConversionActionSummary)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static OfflineConversionUploadConversionActionSummary parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OfflineConversionUploadConversionActionSummary)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OfflineConversionUploadConversionActionSummary parseFrom(CodedInputStream input) throws IOException {
        return (OfflineConversionUploadConversionActionSummary)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static OfflineConversionUploadConversionActionSummary parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OfflineConversionUploadConversionActionSummary)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return OfflineConversionUploadConversionActionSummary.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(OfflineConversionUploadConversionActionSummary prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static OfflineConversionUploadConversionActionSummary getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<OfflineConversionUploadConversionActionSummary> parser() {
        return PARSER;
    }

    public Parser<OfflineConversionUploadConversionActionSummary> getParserForType() {
        return PARSER;
    }

    public OfflineConversionUploadConversionActionSummary getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements OfflineConversionUploadConversionActionSummaryOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private int client_ = 0;
        private long conversionActionId_;
        private Object conversionActionName_ = "";
        private int status_ = 0;
        private long totalEventCount_;
        private long successfulEventCount_;
        private long pendingEventCount_;
        private Object lastUploadDateTime_ = "";
        private List<OfflineConversionSummary> dailySummaries_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<OfflineConversionSummary, OfflineConversionSummary.Builder, OfflineConversionSummaryOrBuilder> dailySummariesBuilder_;
        private List<OfflineConversionSummary> jobSummaries_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<OfflineConversionSummary, OfflineConversionSummary.Builder, OfflineConversionSummaryOrBuilder> jobSummariesBuilder_;
        private List<OfflineConversionAlert> alerts_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<OfflineConversionAlert, OfflineConversionAlert.Builder, OfflineConversionAlertOrBuilder> alertsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return OfflineConversionUploadConversionActionSummaryProto.internal_static_google_ads_googleads_v18_resources_OfflineConversionUploadConversionActionSummary_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return OfflineConversionUploadConversionActionSummaryProto.internal_static_google_ads_googleads_v18_resources_OfflineConversionUploadConversionActionSummary_fieldAccessorTable.ensureFieldAccessorsInitialized(OfflineConversionUploadConversionActionSummary.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.client_ = 0;
            this.conversionActionId_ = 0L;
            this.conversionActionName_ = "";
            this.status_ = 0;
            this.totalEventCount_ = 0L;
            this.successfulEventCount_ = 0L;
            this.pendingEventCount_ = 0L;
            this.lastUploadDateTime_ = "";
            if (this.dailySummariesBuilder_ == null) {
                this.dailySummaries_ = Collections.emptyList();
            } else {
                this.dailySummaries_ = null;
                this.dailySummariesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            if (this.jobSummariesBuilder_ == null) {
                this.jobSummaries_ = Collections.emptyList();
            } else {
                this.jobSummaries_ = null;
                this.jobSummariesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFBFF;
            if (this.alertsBuilder_ == null) {
                this.alerts_ = Collections.emptyList();
            } else {
                this.alerts_ = null;
                this.alertsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFF7FF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return OfflineConversionUploadConversionActionSummaryProto.internal_static_google_ads_googleads_v18_resources_OfflineConversionUploadConversionActionSummary_descriptor;
        }

        public OfflineConversionUploadConversionActionSummary getDefaultInstanceForType() {
            return OfflineConversionUploadConversionActionSummary.getDefaultInstance();
        }

        public OfflineConversionUploadConversionActionSummary build() {
            OfflineConversionUploadConversionActionSummary result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public OfflineConversionUploadConversionActionSummary buildPartial() {
            OfflineConversionUploadConversionActionSummary result = new OfflineConversionUploadConversionActionSummary(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(OfflineConversionUploadConversionActionSummary result) {
            if (this.dailySummariesBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.dailySummaries_ = Collections.unmodifiableList(this.dailySummaries_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.dailySummaries_ = this.dailySummaries_;
            } else {
                result.dailySummaries_ = this.dailySummariesBuilder_.build();
            }
            if (this.jobSummariesBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0) {
                    this.jobSummaries_ = Collections.unmodifiableList(this.jobSummaries_);
                    this.bitField0_ &= 0xFFFFFBFF;
                }
                result.jobSummaries_ = this.jobSummaries_;
            } else {
                result.jobSummaries_ = this.jobSummariesBuilder_.build();
            }
            if (this.alertsBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0) {
                    this.alerts_ = Collections.unmodifiableList(this.alerts_);
                    this.bitField0_ &= 0xFFFFF7FF;
                }
                result.alerts_ = this.alerts_;
            } else {
                result.alerts_ = this.alertsBuilder_.build();
            }
        }

        private void buildPartial0(OfflineConversionUploadConversionActionSummary result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.client_ = this.client_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.conversionActionId_ = this.conversionActionId_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.conversionActionName_ = this.conversionActionName_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.status_ = this.status_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.totalEventCount_ = this.totalEventCount_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.successfulEventCount_ = this.successfulEventCount_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.pendingEventCount_ = this.pendingEventCount_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.lastUploadDateTime_ = this.lastUploadDateTime_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof OfflineConversionUploadConversionActionSummary) {
                return this.mergeFrom((OfflineConversionUploadConversionActionSummary)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(OfflineConversionUploadConversionActionSummary other) {
            if (other == OfflineConversionUploadConversionActionSummary.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.client_ != 0) {
                this.setClientValue(other.getClientValue());
            }
            if (other.getConversionActionId() != 0L) {
                this.setConversionActionId(other.getConversionActionId());
            }
            if (!other.getConversionActionName().isEmpty()) {
                this.conversionActionName_ = other.conversionActionName_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (other.getTotalEventCount() != 0L) {
                this.setTotalEventCount(other.getTotalEventCount());
            }
            if (other.getSuccessfulEventCount() != 0L) {
                this.setSuccessfulEventCount(other.getSuccessfulEventCount());
            }
            if (other.getPendingEventCount() != 0L) {
                this.setPendingEventCount(other.getPendingEventCount());
            }
            if (!other.getLastUploadDateTime().isEmpty()) {
                this.lastUploadDateTime_ = other.lastUploadDateTime_;
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            if (this.dailySummariesBuilder_ == null) {
                if (!other.dailySummaries_.isEmpty()) {
                    if (this.dailySummaries_.isEmpty()) {
                        this.dailySummaries_ = other.dailySummaries_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureDailySummariesIsMutable();
                        this.dailySummaries_.addAll(other.dailySummaries_);
                    }
                    this.onChanged();
                }
            } else if (!other.dailySummaries_.isEmpty()) {
                if (this.dailySummariesBuilder_.isEmpty()) {
                    this.dailySummariesBuilder_.dispose();
                    this.dailySummariesBuilder_ = null;
                    this.dailySummaries_ = other.dailySummaries_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.dailySummariesBuilder_ = alwaysUseFieldBuilders ? this.getDailySummariesFieldBuilder() : null;
                } else {
                    this.dailySummariesBuilder_.addAllMessages((Iterable)other.dailySummaries_);
                }
            }
            if (this.jobSummariesBuilder_ == null) {
                if (!other.jobSummaries_.isEmpty()) {
                    if (this.jobSummaries_.isEmpty()) {
                        this.jobSummaries_ = other.jobSummaries_;
                        this.bitField0_ &= 0xFFFFFBFF;
                    } else {
                        this.ensureJobSummariesIsMutable();
                        this.jobSummaries_.addAll(other.jobSummaries_);
                    }
                    this.onChanged();
                }
            } else if (!other.jobSummaries_.isEmpty()) {
                if (this.jobSummariesBuilder_.isEmpty()) {
                    this.jobSummariesBuilder_.dispose();
                    this.jobSummariesBuilder_ = null;
                    this.jobSummaries_ = other.jobSummaries_;
                    this.bitField0_ &= 0xFFFFFBFF;
                    this.jobSummariesBuilder_ = alwaysUseFieldBuilders ? this.getJobSummariesFieldBuilder() : null;
                } else {
                    this.jobSummariesBuilder_.addAllMessages((Iterable)other.jobSummaries_);
                }
            }
            if (this.alertsBuilder_ == null) {
                if (!other.alerts_.isEmpty()) {
                    if (this.alerts_.isEmpty()) {
                        this.alerts_ = other.alerts_;
                        this.bitField0_ &= 0xFFFFF7FF;
                    } else {
                        this.ensureAlertsIsMutable();
                        this.alerts_.addAll(other.alerts_);
                    }
                    this.onChanged();
                }
            } else if (!other.alerts_.isEmpty()) {
                if (this.alertsBuilder_.isEmpty()) {
                    this.alertsBuilder_.dispose();
                    this.alertsBuilder_ = null;
                    this.alerts_ = other.alerts_;
                    this.bitField0_ &= 0xFFFFF7FF;
                    this.alertsBuilder_ = alwaysUseFieldBuilders ? this.getAlertsFieldBuilder() : null;
                } else {
                    this.alertsBuilder_.addAllMessages((Iterable)other.alerts_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block20: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block20;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block20;
                        }
                        case 16: {
                            this.client_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block20;
                        }
                        case 24: {
                            this.conversionActionId_ = input.readInt64();
                            this.bitField0_ |= 4;
                            continue block20;
                        }
                        case 34: {
                            this.conversionActionName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block20;
                        }
                        case 40: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block20;
                        }
                        case 48: {
                            this.totalEventCount_ = input.readInt64();
                            this.bitField0_ |= 0x20;
                            continue block20;
                        }
                        case 56: {
                            this.successfulEventCount_ = input.readInt64();
                            this.bitField0_ |= 0x40;
                            continue block20;
                        }
                        case 64: {
                            this.pendingEventCount_ = input.readInt64();
                            this.bitField0_ |= 0x80;
                            continue block20;
                        }
                        case 74: {
                            this.lastUploadDateTime_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x100;
                            continue block20;
                        }
                        case 82: {
                            GeneratedMessageV3 m = (OfflineConversionSummary)input.readMessage(OfflineConversionSummary.parser(), extensionRegistry);
                            if (this.dailySummariesBuilder_ == null) {
                                this.ensureDailySummariesIsMutable();
                                this.dailySummaries_.add((OfflineConversionSummary)m);
                                continue block20;
                            }
                            this.dailySummariesBuilder_.addMessage((AbstractMessage)m);
                            continue block20;
                        }
                        case 90: {
                            GeneratedMessageV3 m = (OfflineConversionSummary)input.readMessage(OfflineConversionSummary.parser(), extensionRegistry);
                            if (this.jobSummariesBuilder_ == null) {
                                this.ensureJobSummariesIsMutable();
                                this.jobSummaries_.add((OfflineConversionSummary)m);
                                continue block20;
                            }
                            this.jobSummariesBuilder_.addMessage((AbstractMessage)m);
                            continue block20;
                        }
                        case 98: {
                            GeneratedMessageV3 m = (OfflineConversionAlert)input.readMessage(OfflineConversionAlert.parser(), extensionRegistry);
                            if (this.alertsBuilder_ == null) {
                                this.ensureAlertsIsMutable();
                                this.alerts_.add((OfflineConversionAlert)m);
                                continue block20;
                            }
                            this.alertsBuilder_.addMessage((AbstractMessage)m);
                            continue block20;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = OfflineConversionUploadConversionActionSummary.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OfflineConversionUploadConversionActionSummary.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getClientValue() {
            return this.client_;
        }

        public Builder setClientValue(int value) {
            this.client_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public OfflineEventUploadClientEnum.OfflineEventUploadClient getClient() {
            OfflineEventUploadClientEnum.OfflineEventUploadClient result = OfflineEventUploadClientEnum.OfflineEventUploadClient.forNumber(this.client_);
            return result == null ? OfflineEventUploadClientEnum.OfflineEventUploadClient.UNRECOGNIZED : result;
        }

        public Builder setClient(OfflineEventUploadClientEnum.OfflineEventUploadClient value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.client_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearClient() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.client_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public long getConversionActionId() {
            return this.conversionActionId_;
        }

        public Builder setConversionActionId(long value) {
            this.conversionActionId_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearConversionActionId() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.conversionActionId_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public String getConversionActionName() {
            Object ref = this.conversionActionName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.conversionActionName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getConversionActionNameBytes() {
            Object ref = this.conversionActionName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.conversionActionName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setConversionActionName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.conversionActionName_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearConversionActionName() {
            this.conversionActionName_ = OfflineConversionUploadConversionActionSummary.getDefaultInstance().getConversionActionName();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setConversionActionNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OfflineConversionUploadConversionActionSummary.checkByteStringIsUtf8((ByteString)value);
            this.conversionActionName_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus getStatus() {
            OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus result = OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus.forNumber(this.status_);
            return result == null ? OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public long getTotalEventCount() {
            return this.totalEventCount_;
        }

        public Builder setTotalEventCount(long value) {
            this.totalEventCount_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearTotalEventCount() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.totalEventCount_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getSuccessfulEventCount() {
            return this.successfulEventCount_;
        }

        public Builder setSuccessfulEventCount(long value) {
            this.successfulEventCount_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearSuccessfulEventCount() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.successfulEventCount_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getPendingEventCount() {
            return this.pendingEventCount_;
        }

        public Builder setPendingEventCount(long value) {
            this.pendingEventCount_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearPendingEventCount() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.pendingEventCount_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public String getLastUploadDateTime() {
            Object ref = this.lastUploadDateTime_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.lastUploadDateTime_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLastUploadDateTimeBytes() {
            Object ref = this.lastUploadDateTime_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.lastUploadDateTime_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLastUploadDateTime(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.lastUploadDateTime_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearLastUploadDateTime() {
            this.lastUploadDateTime_ = OfflineConversionUploadConversionActionSummary.getDefaultInstance().getLastUploadDateTime();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder setLastUploadDateTimeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OfflineConversionUploadConversionActionSummary.checkByteStringIsUtf8((ByteString)value);
            this.lastUploadDateTime_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        private void ensureDailySummariesIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.dailySummaries_ = new ArrayList<OfflineConversionSummary>(this.dailySummaries_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<OfflineConversionSummary> getDailySummariesList() {
            if (this.dailySummariesBuilder_ == null) {
                return Collections.unmodifiableList(this.dailySummaries_);
            }
            return this.dailySummariesBuilder_.getMessageList();
        }

        @Override
        public int getDailySummariesCount() {
            if (this.dailySummariesBuilder_ == null) {
                return this.dailySummaries_.size();
            }
            return this.dailySummariesBuilder_.getCount();
        }

        @Override
        public OfflineConversionSummary getDailySummaries(int index) {
            if (this.dailySummariesBuilder_ == null) {
                return this.dailySummaries_.get(index);
            }
            return (OfflineConversionSummary)this.dailySummariesBuilder_.getMessage(index);
        }

        public Builder setDailySummaries(int index, OfflineConversionSummary value) {
            if (this.dailySummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.set(index, value);
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setDailySummaries(int index, OfflineConversionSummary.Builder builderForValue) {
            if (this.dailySummariesBuilder_ == null) {
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDailySummaries(OfflineConversionSummary value) {
            if (this.dailySummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.add(value);
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addDailySummaries(int index, OfflineConversionSummary value) {
            if (this.dailySummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.add(index, value);
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addDailySummaries(OfflineConversionSummary.Builder builderForValue) {
            if (this.dailySummariesBuilder_ == null) {
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDailySummaries(int index, OfflineConversionSummary.Builder builderForValue) {
            if (this.dailySummariesBuilder_ == null) {
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllDailySummaries(Iterable<? extends OfflineConversionSummary> values) {
            if (this.dailySummariesBuilder_ == null) {
                this.ensureDailySummariesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.dailySummaries_);
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearDailySummaries() {
            if (this.dailySummariesBuilder_ == null) {
                this.dailySummaries_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.clear();
            }
            return this;
        }

        public Builder removeDailySummaries(int index) {
            if (this.dailySummariesBuilder_ == null) {
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.remove(index);
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.remove(index);
            }
            return this;
        }

        public OfflineConversionSummary.Builder getDailySummariesBuilder(int index) {
            return (OfflineConversionSummary.Builder)this.getDailySummariesFieldBuilder().getBuilder(index);
        }

        @Override
        public OfflineConversionSummaryOrBuilder getDailySummariesOrBuilder(int index) {
            if (this.dailySummariesBuilder_ == null) {
                return this.dailySummaries_.get(index);
            }
            return (OfflineConversionSummaryOrBuilder)this.dailySummariesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends OfflineConversionSummaryOrBuilder> getDailySummariesOrBuilderList() {
            if (this.dailySummariesBuilder_ != null) {
                return this.dailySummariesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.dailySummaries_);
        }

        public OfflineConversionSummary.Builder addDailySummariesBuilder() {
            return (OfflineConversionSummary.Builder)this.getDailySummariesFieldBuilder().addBuilder((AbstractMessage)OfflineConversionSummary.getDefaultInstance());
        }

        public OfflineConversionSummary.Builder addDailySummariesBuilder(int index) {
            return (OfflineConversionSummary.Builder)this.getDailySummariesFieldBuilder().addBuilder(index, (AbstractMessage)OfflineConversionSummary.getDefaultInstance());
        }

        public List<OfflineConversionSummary.Builder> getDailySummariesBuilderList() {
            return this.getDailySummariesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<OfflineConversionSummary, OfflineConversionSummary.Builder, OfflineConversionSummaryOrBuilder> getDailySummariesFieldBuilder() {
            if (this.dailySummariesBuilder_ == null) {
                this.dailySummariesBuilder_ = new RepeatedFieldBuilderV3(this.dailySummaries_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.dailySummaries_ = null;
            }
            return this.dailySummariesBuilder_;
        }

        private void ensureJobSummariesIsMutable() {
            if ((this.bitField0_ & 0x400) == 0) {
                this.jobSummaries_ = new ArrayList<OfflineConversionSummary>(this.jobSummaries_);
                this.bitField0_ |= 0x400;
            }
        }

        @Override
        public List<OfflineConversionSummary> getJobSummariesList() {
            if (this.jobSummariesBuilder_ == null) {
                return Collections.unmodifiableList(this.jobSummaries_);
            }
            return this.jobSummariesBuilder_.getMessageList();
        }

        @Override
        public int getJobSummariesCount() {
            if (this.jobSummariesBuilder_ == null) {
                return this.jobSummaries_.size();
            }
            return this.jobSummariesBuilder_.getCount();
        }

        @Override
        public OfflineConversionSummary getJobSummaries(int index) {
            if (this.jobSummariesBuilder_ == null) {
                return this.jobSummaries_.get(index);
            }
            return (OfflineConversionSummary)this.jobSummariesBuilder_.getMessage(index);
        }

        public Builder setJobSummaries(int index, OfflineConversionSummary value) {
            if (this.jobSummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.set(index, value);
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setJobSummaries(int index, OfflineConversionSummary.Builder builderForValue) {
            if (this.jobSummariesBuilder_ == null) {
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addJobSummaries(OfflineConversionSummary value) {
            if (this.jobSummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.add(value);
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addJobSummaries(int index, OfflineConversionSummary value) {
            if (this.jobSummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.add(index, value);
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addJobSummaries(OfflineConversionSummary.Builder builderForValue) {
            if (this.jobSummariesBuilder_ == null) {
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addJobSummaries(int index, OfflineConversionSummary.Builder builderForValue) {
            if (this.jobSummariesBuilder_ == null) {
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllJobSummaries(Iterable<? extends OfflineConversionSummary> values) {
            if (this.jobSummariesBuilder_ == null) {
                this.ensureJobSummariesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.jobSummaries_);
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearJobSummaries() {
            if (this.jobSummariesBuilder_ == null) {
                this.jobSummaries_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFBFF;
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.clear();
            }
            return this;
        }

        public Builder removeJobSummaries(int index) {
            if (this.jobSummariesBuilder_ == null) {
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.remove(index);
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.remove(index);
            }
            return this;
        }

        public OfflineConversionSummary.Builder getJobSummariesBuilder(int index) {
            return (OfflineConversionSummary.Builder)this.getJobSummariesFieldBuilder().getBuilder(index);
        }

        @Override
        public OfflineConversionSummaryOrBuilder getJobSummariesOrBuilder(int index) {
            if (this.jobSummariesBuilder_ == null) {
                return this.jobSummaries_.get(index);
            }
            return (OfflineConversionSummaryOrBuilder)this.jobSummariesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends OfflineConversionSummaryOrBuilder> getJobSummariesOrBuilderList() {
            if (this.jobSummariesBuilder_ != null) {
                return this.jobSummariesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.jobSummaries_);
        }

        public OfflineConversionSummary.Builder addJobSummariesBuilder() {
            return (OfflineConversionSummary.Builder)this.getJobSummariesFieldBuilder().addBuilder((AbstractMessage)OfflineConversionSummary.getDefaultInstance());
        }

        public OfflineConversionSummary.Builder addJobSummariesBuilder(int index) {
            return (OfflineConversionSummary.Builder)this.getJobSummariesFieldBuilder().addBuilder(index, (AbstractMessage)OfflineConversionSummary.getDefaultInstance());
        }

        public List<OfflineConversionSummary.Builder> getJobSummariesBuilderList() {
            return this.getJobSummariesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<OfflineConversionSummary, OfflineConversionSummary.Builder, OfflineConversionSummaryOrBuilder> getJobSummariesFieldBuilder() {
            if (this.jobSummariesBuilder_ == null) {
                this.jobSummariesBuilder_ = new RepeatedFieldBuilderV3(this.jobSummaries_, (this.bitField0_ & 0x400) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.jobSummaries_ = null;
            }
            return this.jobSummariesBuilder_;
        }

        private void ensureAlertsIsMutable() {
            if ((this.bitField0_ & 0x800) == 0) {
                this.alerts_ = new ArrayList<OfflineConversionAlert>(this.alerts_);
                this.bitField0_ |= 0x800;
            }
        }

        @Override
        public List<OfflineConversionAlert> getAlertsList() {
            if (this.alertsBuilder_ == null) {
                return Collections.unmodifiableList(this.alerts_);
            }
            return this.alertsBuilder_.getMessageList();
        }

        @Override
        public int getAlertsCount() {
            if (this.alertsBuilder_ == null) {
                return this.alerts_.size();
            }
            return this.alertsBuilder_.getCount();
        }

        @Override
        public OfflineConversionAlert getAlerts(int index) {
            if (this.alertsBuilder_ == null) {
                return this.alerts_.get(index);
            }
            return (OfflineConversionAlert)this.alertsBuilder_.getMessage(index);
        }

        public Builder setAlerts(int index, OfflineConversionAlert value) {
            if (this.alertsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAlertsIsMutable();
                this.alerts_.set(index, value);
                this.onChanged();
            } else {
                this.alertsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAlerts(int index, OfflineConversionAlert.Builder builderForValue) {
            if (this.alertsBuilder_ == null) {
                this.ensureAlertsIsMutable();
                this.alerts_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.alertsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAlerts(OfflineConversionAlert value) {
            if (this.alertsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAlertsIsMutable();
                this.alerts_.add(value);
                this.onChanged();
            } else {
                this.alertsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAlerts(int index, OfflineConversionAlert value) {
            if (this.alertsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAlertsIsMutable();
                this.alerts_.add(index, value);
                this.onChanged();
            } else {
                this.alertsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAlerts(OfflineConversionAlert.Builder builderForValue) {
            if (this.alertsBuilder_ == null) {
                this.ensureAlertsIsMutable();
                this.alerts_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.alertsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAlerts(int index, OfflineConversionAlert.Builder builderForValue) {
            if (this.alertsBuilder_ == null) {
                this.ensureAlertsIsMutable();
                this.alerts_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.alertsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAlerts(Iterable<? extends OfflineConversionAlert> values) {
            if (this.alertsBuilder_ == null) {
                this.ensureAlertsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.alerts_);
                this.onChanged();
            } else {
                this.alertsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAlerts() {
            if (this.alertsBuilder_ == null) {
                this.alerts_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFF7FF;
                this.onChanged();
            } else {
                this.alertsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAlerts(int index) {
            if (this.alertsBuilder_ == null) {
                this.ensureAlertsIsMutable();
                this.alerts_.remove(index);
                this.onChanged();
            } else {
                this.alertsBuilder_.remove(index);
            }
            return this;
        }

        public OfflineConversionAlert.Builder getAlertsBuilder(int index) {
            return (OfflineConversionAlert.Builder)this.getAlertsFieldBuilder().getBuilder(index);
        }

        @Override
        public OfflineConversionAlertOrBuilder getAlertsOrBuilder(int index) {
            if (this.alertsBuilder_ == null) {
                return this.alerts_.get(index);
            }
            return (OfflineConversionAlertOrBuilder)this.alertsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends OfflineConversionAlertOrBuilder> getAlertsOrBuilderList() {
            if (this.alertsBuilder_ != null) {
                return this.alertsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.alerts_);
        }

        public OfflineConversionAlert.Builder addAlertsBuilder() {
            return (OfflineConversionAlert.Builder)this.getAlertsFieldBuilder().addBuilder((AbstractMessage)OfflineConversionAlert.getDefaultInstance());
        }

        public OfflineConversionAlert.Builder addAlertsBuilder(int index) {
            return (OfflineConversionAlert.Builder)this.getAlertsFieldBuilder().addBuilder(index, (AbstractMessage)OfflineConversionAlert.getDefaultInstance());
        }

        public List<OfflineConversionAlert.Builder> getAlertsBuilderList() {
            return this.getAlertsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<OfflineConversionAlert, OfflineConversionAlert.Builder, OfflineConversionAlertOrBuilder> getAlertsFieldBuilder() {
            if (this.alertsBuilder_ == null) {
                this.alertsBuilder_ = new RepeatedFieldBuilderV3(this.alerts_, (this.bitField0_ & 0x800) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.alerts_ = null;
            }
            return this.alertsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

