/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.services;

import com.google.ads.googleads.v18.resources.DataLink;
import com.google.ads.googleads.v18.services.CreateDataLinkRequest;
import com.google.ads.googleads.v18.services.CreateDataLinkResponse;
import com.google.ads.googleads.v18.services.DataLinkServiceSettings;
import com.google.ads.googleads.v18.services.stub.DataLinkServiceStub;
import com.google.ads.googleads.v18.services.stub.DataLinkServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class DataLinkServiceClient
implements BackgroundResource {
    private final DataLinkServiceSettings settings;
    private final DataLinkServiceStub stub;

    public static final DataLinkServiceClient create() throws IOException {
        return DataLinkServiceClient.create(DataLinkServiceSettings.newBuilder().build());
    }

    public static final DataLinkServiceClient create(DataLinkServiceSettings settings) throws IOException {
        return new DataLinkServiceClient(settings);
    }

    public static final DataLinkServiceClient create(DataLinkServiceStub stub) {
        return new DataLinkServiceClient(stub);
    }

    protected DataLinkServiceClient(DataLinkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataLinkServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DataLinkServiceClient(DataLinkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataLinkServiceSettings getSettings() {
        return this.settings;
    }

    public DataLinkServiceStub getStub() {
        return this.stub;
    }

    public final CreateDataLinkResponse createDataLink(String customerId, DataLink dataLink) {
        CreateDataLinkRequest request = CreateDataLinkRequest.newBuilder().setCustomerId(customerId).setDataLink(dataLink).build();
        return this.createDataLink(request);
    }

    public final CreateDataLinkResponse createDataLink(CreateDataLinkRequest request) {
        return (CreateDataLinkResponse)this.createDataLinkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDataLinkRequest, CreateDataLinkResponse> createDataLinkCallable() {
        return this.stub.createDataLinkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

