/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v18.services;

import com.google.ads.googleads.v18.enums.ResponseContentTypeEnum;
import com.google.ads.googleads.v18.services.BatchJobServiceProto;
import com.google.ads.googleads.v18.services.ListBatchJobResultsRequestOrBuilder;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ListBatchJobResultsRequest
extends GeneratedMessageV3
implements ListBatchJobResultsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int PAGE_TOKEN_FIELD_NUMBER = 2;
    private volatile Object pageToken_ = "";
    public static final int PAGE_SIZE_FIELD_NUMBER = 3;
    private int pageSize_ = 0;
    public static final int RESPONSE_CONTENT_TYPE_FIELD_NUMBER = 4;
    private int responseContentType_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ListBatchJobResultsRequest DEFAULT_INSTANCE = new ListBatchJobResultsRequest();
    private static final Parser<ListBatchJobResultsRequest> PARSER = new AbstractParser<ListBatchJobResultsRequest>(){

        public ListBatchJobResultsRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ListBatchJobResultsRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ListBatchJobResultsRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ListBatchJobResultsRequest() {
        this.resourceName_ = "";
        this.pageToken_ = "";
        this.responseContentType_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ListBatchJobResultsRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return BatchJobServiceProto.internal_static_google_ads_googleads_v18_services_ListBatchJobResultsRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return BatchJobServiceProto.internal_static_google_ads_googleads_v18_services_ListBatchJobResultsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(ListBatchJobResultsRequest.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getPageToken() {
        Object ref = this.pageToken_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.pageToken_ = s;
        return s;
    }

    @Override
    public ByteString getPageTokenBytes() {
        Object ref = this.pageToken_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.pageToken_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getPageSize() {
        return this.pageSize_;
    }

    @Override
    public int getResponseContentTypeValue() {
        return this.responseContentType_;
    }

    @Override
    public ResponseContentTypeEnum.ResponseContentType getResponseContentType() {
        ResponseContentTypeEnum.ResponseContentType result = ResponseContentTypeEnum.ResponseContentType.forNumber(this.responseContentType_);
        return result == null ? ResponseContentTypeEnum.ResponseContentType.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.pageToken_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.pageToken_);
        }
        if (this.pageSize_ != 0) {
            output.writeInt32(3, this.pageSize_);
        }
        if (this.responseContentType_ != ResponseContentTypeEnum.ResponseContentType.UNSPECIFIED.getNumber()) {
            output.writeEnum(4, this.responseContentType_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.pageToken_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.pageToken_);
        }
        if (this.pageSize_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)3, (int)this.pageSize_);
        }
        if (this.responseContentType_ != ResponseContentTypeEnum.ResponseContentType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.responseContentType_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListBatchJobResultsRequest)) {
            return super.equals(obj);
        }
        ListBatchJobResultsRequest other = (ListBatchJobResultsRequest)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (!this.getPageToken().equals(other.getPageToken())) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.responseContentType_ != other.responseContentType_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ListBatchJobResultsRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getPageToken().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getPageSize();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.responseContentType_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ListBatchJobResultsRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ListBatchJobResultsRequest)PARSER.parseFrom(data);
    }

    public static ListBatchJobResultsRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ListBatchJobResultsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ListBatchJobResultsRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ListBatchJobResultsRequest)PARSER.parseFrom(data);
    }

    public static ListBatchJobResultsRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ListBatchJobResultsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ListBatchJobResultsRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ListBatchJobResultsRequest)PARSER.parseFrom(data);
    }

    public static ListBatchJobResultsRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ListBatchJobResultsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ListBatchJobResultsRequest parseFrom(InputStream input) throws IOException {
        return (ListBatchJobResultsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ListBatchJobResultsRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ListBatchJobResultsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ListBatchJobResultsRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (ListBatchJobResultsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ListBatchJobResultsRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ListBatchJobResultsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ListBatchJobResultsRequest parseFrom(CodedInputStream input) throws IOException {
        return (ListBatchJobResultsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ListBatchJobResultsRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ListBatchJobResultsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ListBatchJobResultsRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ListBatchJobResultsRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ListBatchJobResultsRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ListBatchJobResultsRequest> parser() {
        return PARSER;
    }

    public Parser<ListBatchJobResultsRequest> getParserForType() {
        return PARSER;
    }

    public ListBatchJobResultsRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ListBatchJobResultsRequestOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private Object pageToken_ = "";
        private int pageSize_;
        private int responseContentType_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return BatchJobServiceProto.internal_static_google_ads_googleads_v18_services_ListBatchJobResultsRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return BatchJobServiceProto.internal_static_google_ads_googleads_v18_services_ListBatchJobResultsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(ListBatchJobResultsRequest.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.pageToken_ = "";
            this.pageSize_ = 0;
            this.responseContentType_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return BatchJobServiceProto.internal_static_google_ads_googleads_v18_services_ListBatchJobResultsRequest_descriptor;
        }

        public ListBatchJobResultsRequest getDefaultInstanceForType() {
            return ListBatchJobResultsRequest.getDefaultInstance();
        }

        public ListBatchJobResultsRequest build() {
            ListBatchJobResultsRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ListBatchJobResultsRequest buildPartial() {
            ListBatchJobResultsRequest result = new ListBatchJobResultsRequest(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(ListBatchJobResultsRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.pageToken_ = this.pageToken_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.pageSize_ = this.pageSize_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.responseContentType_ = this.responseContentType_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ListBatchJobResultsRequest) {
                return this.mergeFrom((ListBatchJobResultsRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ListBatchJobResultsRequest other) {
            if (other == ListBatchJobResultsRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getPageToken().isEmpty()) {
                this.pageToken_ = other.pageToken_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.getPageSize() != 0) {
                this.setPageSize(other.getPageSize());
            }
            if (other.responseContentType_ != 0) {
                this.setResponseContentTypeValue(other.getResponseContentTypeValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block12: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block12;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block12;
                        }
                        case 18: {
                            this.pageToken_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block12;
                        }
                        case 24: {
                            this.pageSize_ = input.readInt32();
                            this.bitField0_ |= 4;
                            continue block12;
                        }
                        case 32: {
                            this.responseContentType_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block12;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = ListBatchJobResultsRequest.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ListBatchJobResultsRequest.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getPageToken() {
            Object ref = this.pageToken_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.pageToken_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPageTokenBytes() {
            Object ref = this.pageToken_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.pageToken_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPageToken(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.pageToken_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearPageToken() {
            this.pageToken_ = ListBatchJobResultsRequest.getDefaultInstance().getPageToken();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setPageTokenBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ListBatchJobResultsRequest.checkByteStringIsUtf8((ByteString)value);
            this.pageToken_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public int getPageSize() {
            return this.pageSize_;
        }

        public Builder setPageSize(int value) {
            this.pageSize_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearPageSize() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.pageSize_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getResponseContentTypeValue() {
            return this.responseContentType_;
        }

        public Builder setResponseContentTypeValue(int value) {
            this.responseContentType_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public ResponseContentTypeEnum.ResponseContentType getResponseContentType() {
            ResponseContentTypeEnum.ResponseContentType result = ResponseContentTypeEnum.ResponseContentType.forNumber(this.responseContentType_);
            return result == null ? ResponseContentTypeEnum.ResponseContentType.UNRECOGNIZED : result;
        }

        public Builder setResponseContentType(ResponseContentTypeEnum.ResponseContentType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.responseContentType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearResponseContentType() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.responseContentType_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

