/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.resources;

import com.google.ads.googleads.v19.common.AssetLinkPrimaryStatusDetails;
import com.google.ads.googleads.v19.common.AssetLinkPrimaryStatusDetailsOrBuilder;
import com.google.ads.googleads.v19.enums.AssetFieldTypeEnum;
import com.google.ads.googleads.v19.enums.AssetLinkPrimaryStatusEnum;
import com.google.ads.googleads.v19.enums.AssetLinkPrimaryStatusReasonEnum;
import com.google.ads.googleads.v19.enums.AssetLinkStatusEnum;
import com.google.ads.googleads.v19.enums.AssetSourceEnum;
import com.google.ads.googleads.v19.resources.CustomerAssetOrBuilder;
import com.google.ads.googleads.v19.resources.CustomerAssetProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CustomerAsset
extends GeneratedMessageV3
implements CustomerAssetOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int ASSET_FIELD_NUMBER = 2;
    private volatile Object asset_ = "";
    public static final int FIELD_TYPE_FIELD_NUMBER = 3;
    private int fieldType_ = 0;
    public static final int SOURCE_FIELD_NUMBER = 5;
    private int source_ = 0;
    public static final int STATUS_FIELD_NUMBER = 4;
    private int status_ = 0;
    public static final int PRIMARY_STATUS_FIELD_NUMBER = 6;
    private int primaryStatus_ = 0;
    public static final int PRIMARY_STATUS_DETAILS_FIELD_NUMBER = 7;
    private List<AssetLinkPrimaryStatusDetails> primaryStatusDetails_;
    public static final int PRIMARY_STATUS_REASONS_FIELD_NUMBER = 8;
    private List<Integer> primaryStatusReasons_;
    private static final Internal.ListAdapter.Converter<Integer, AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason> primaryStatusReasons_converter_ = new Internal.ListAdapter.Converter<Integer, AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason>(){

        public AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason convert(Integer from) {
            AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason result = AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason.forNumber(from);
            return result == null ? AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason.UNRECOGNIZED : result;
        }
    };
    private int primaryStatusReasonsMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final CustomerAsset DEFAULT_INSTANCE = new CustomerAsset();
    private static final Parser<CustomerAsset> PARSER = new AbstractParser<CustomerAsset>(){

        public CustomerAsset parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = CustomerAsset.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private CustomerAsset(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private CustomerAsset() {
        this.resourceName_ = "";
        this.asset_ = "";
        this.fieldType_ = 0;
        this.source_ = 0;
        this.status_ = 0;
        this.primaryStatus_ = 0;
        this.primaryStatusDetails_ = Collections.emptyList();
        this.primaryStatusReasons_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new CustomerAsset();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CustomerAssetProto.internal_static_google_ads_googleads_v19_resources_CustomerAsset_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CustomerAssetProto.internal_static_google_ads_googleads_v19_resources_CustomerAsset_fieldAccessorTable.ensureFieldAccessorsInitialized(CustomerAsset.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getAsset() {
        Object ref = this.asset_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.asset_ = s;
        return s;
    }

    @Override
    public ByteString getAssetBytes() {
        Object ref = this.asset_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.asset_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getFieldTypeValue() {
        return this.fieldType_;
    }

    @Override
    public AssetFieldTypeEnum.AssetFieldType getFieldType() {
        AssetFieldTypeEnum.AssetFieldType result = AssetFieldTypeEnum.AssetFieldType.forNumber(this.fieldType_);
        return result == null ? AssetFieldTypeEnum.AssetFieldType.UNRECOGNIZED : result;
    }

    @Override
    public int getSourceValue() {
        return this.source_;
    }

    @Override
    public AssetSourceEnum.AssetSource getSource() {
        AssetSourceEnum.AssetSource result = AssetSourceEnum.AssetSource.forNumber(this.source_);
        return result == null ? AssetSourceEnum.AssetSource.UNRECOGNIZED : result;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public AssetLinkStatusEnum.AssetLinkStatus getStatus() {
        AssetLinkStatusEnum.AssetLinkStatus result = AssetLinkStatusEnum.AssetLinkStatus.forNumber(this.status_);
        return result == null ? AssetLinkStatusEnum.AssetLinkStatus.UNRECOGNIZED : result;
    }

    @Override
    public int getPrimaryStatusValue() {
        return this.primaryStatus_;
    }

    @Override
    public AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus getPrimaryStatus() {
        AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus result = AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus.forNumber(this.primaryStatus_);
        return result == null ? AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus.UNRECOGNIZED : result;
    }

    @Override
    public List<AssetLinkPrimaryStatusDetails> getPrimaryStatusDetailsList() {
        return this.primaryStatusDetails_;
    }

    @Override
    public List<? extends AssetLinkPrimaryStatusDetailsOrBuilder> getPrimaryStatusDetailsOrBuilderList() {
        return this.primaryStatusDetails_;
    }

    @Override
    public int getPrimaryStatusDetailsCount() {
        return this.primaryStatusDetails_.size();
    }

    @Override
    public AssetLinkPrimaryStatusDetails getPrimaryStatusDetails(int index) {
        return this.primaryStatusDetails_.get(index);
    }

    @Override
    public AssetLinkPrimaryStatusDetailsOrBuilder getPrimaryStatusDetailsOrBuilder(int index) {
        return this.primaryStatusDetails_.get(index);
    }

    @Override
    public List<AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason> getPrimaryStatusReasonsList() {
        return new Internal.ListAdapter(this.primaryStatusReasons_, primaryStatusReasons_converter_);
    }

    @Override
    public int getPrimaryStatusReasonsCount() {
        return this.primaryStatusReasons_.size();
    }

    @Override
    public AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason getPrimaryStatusReasons(int index) {
        return (AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason)((Object)primaryStatusReasons_converter_.convert((Object)this.primaryStatusReasons_.get(index)));
    }

    @Override
    public List<Integer> getPrimaryStatusReasonsValueList() {
        return this.primaryStatusReasons_;
    }

    @Override
    public int getPrimaryStatusReasonsValue(int index) {
        return this.primaryStatusReasons_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.asset_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.asset_);
        }
        if (this.fieldType_ != AssetFieldTypeEnum.AssetFieldType.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.fieldType_);
        }
        if (this.status_ != AssetLinkStatusEnum.AssetLinkStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(4, this.status_);
        }
        if (this.source_ != AssetSourceEnum.AssetSource.UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.source_);
        }
        if (this.primaryStatus_ != AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.primaryStatus_);
        }
        for (i = 0; i < this.primaryStatusDetails_.size(); ++i) {
            output.writeMessage(7, (MessageLite)this.primaryStatusDetails_.get(i));
        }
        if (this.getPrimaryStatusReasonsList().size() > 0) {
            output.writeUInt32NoTag(66);
            output.writeUInt32NoTag(this.primaryStatusReasonsMemoizedSerializedSize);
        }
        for (i = 0; i < this.primaryStatusReasons_.size(); ++i) {
            output.writeEnumNoTag(this.primaryStatusReasons_.get(i).intValue());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.asset_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.asset_);
        }
        if (this.fieldType_ != AssetFieldTypeEnum.AssetFieldType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.fieldType_);
        }
        if (this.status_ != AssetLinkStatusEnum.AssetLinkStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.status_);
        }
        if (this.source_ != AssetSourceEnum.AssetSource.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.source_);
        }
        if (this.primaryStatus_ != AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.primaryStatus_);
        }
        for (int i = 0; i < this.primaryStatusDetails_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)((MessageLite)this.primaryStatusDetails_.get(i)));
        }
        int dataSize = 0;
        for (int i = 0; i < this.primaryStatusReasons_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.primaryStatusReasons_.get(i));
        }
        size += dataSize;
        if (!this.getPrimaryStatusReasonsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.primaryStatusReasonsMemoizedSerializedSize = dataSize;
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerAsset)) {
            return super.equals(obj);
        }
        CustomerAsset other = (CustomerAsset)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (!this.getAsset().equals(other.getAsset())) {
            return false;
        }
        if (this.fieldType_ != other.fieldType_) {
            return false;
        }
        if (this.source_ != other.source_) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (this.primaryStatus_ != other.primaryStatus_) {
            return false;
        }
        if (!this.getPrimaryStatusDetailsList().equals(other.getPrimaryStatusDetailsList())) {
            return false;
        }
        if (!this.primaryStatusReasons_.equals(other.primaryStatusReasons_)) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + CustomerAsset.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getAsset().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.fieldType_;
        hash = 37 * hash + 5;
        hash = 53 * hash + this.source_;
        hash = 37 * hash + 4;
        hash = 53 * hash + this.status_;
        hash = 37 * hash + 6;
        hash = 53 * hash + this.primaryStatus_;
        if (this.getPrimaryStatusDetailsCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getPrimaryStatusDetailsList().hashCode();
        }
        if (this.getPrimaryStatusReasonsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.primaryStatusReasons_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static CustomerAsset parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (CustomerAsset)PARSER.parseFrom(data);
    }

    public static CustomerAsset parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CustomerAsset)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CustomerAsset parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (CustomerAsset)PARSER.parseFrom(data);
    }

    public static CustomerAsset parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CustomerAsset)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CustomerAsset parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (CustomerAsset)PARSER.parseFrom(data);
    }

    public static CustomerAsset parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CustomerAsset)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CustomerAsset parseFrom(InputStream input) throws IOException {
        return (CustomerAsset)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static CustomerAsset parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CustomerAsset)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CustomerAsset parseDelimitedFrom(InputStream input) throws IOException {
        return (CustomerAsset)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static CustomerAsset parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CustomerAsset)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CustomerAsset parseFrom(CodedInputStream input) throws IOException {
        return (CustomerAsset)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static CustomerAsset parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CustomerAsset)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return CustomerAsset.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CustomerAsset prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static CustomerAsset getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<CustomerAsset> parser() {
        return PARSER;
    }

    public Parser<CustomerAsset> getParserForType() {
        return PARSER;
    }

    public CustomerAsset getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements CustomerAssetOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private Object asset_ = "";
        private int fieldType_ = 0;
        private int source_ = 0;
        private int status_ = 0;
        private int primaryStatus_ = 0;
        private List<AssetLinkPrimaryStatusDetails> primaryStatusDetails_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AssetLinkPrimaryStatusDetails, AssetLinkPrimaryStatusDetails.Builder, AssetLinkPrimaryStatusDetailsOrBuilder> primaryStatusDetailsBuilder_;
        private List<Integer> primaryStatusReasons_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return CustomerAssetProto.internal_static_google_ads_googleads_v19_resources_CustomerAsset_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CustomerAssetProto.internal_static_google_ads_googleads_v19_resources_CustomerAsset_fieldAccessorTable.ensureFieldAccessorsInitialized(CustomerAsset.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.asset_ = "";
            this.fieldType_ = 0;
            this.source_ = 0;
            this.status_ = 0;
            this.primaryStatus_ = 0;
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.primaryStatusDetails_ = Collections.emptyList();
            } else {
                this.primaryStatusDetails_ = null;
                this.primaryStatusDetailsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFBF;
            this.primaryStatusReasons_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CustomerAssetProto.internal_static_google_ads_googleads_v19_resources_CustomerAsset_descriptor;
        }

        public CustomerAsset getDefaultInstanceForType() {
            return CustomerAsset.getDefaultInstance();
        }

        public CustomerAsset build() {
            CustomerAsset result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public CustomerAsset buildPartial() {
            CustomerAsset result = new CustomerAsset(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(CustomerAsset result) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0) {
                    this.primaryStatusDetails_ = Collections.unmodifiableList(this.primaryStatusDetails_);
                    this.bitField0_ &= 0xFFFFFFBF;
                }
                result.primaryStatusDetails_ = this.primaryStatusDetails_;
            } else {
                result.primaryStatusDetails_ = this.primaryStatusDetailsBuilder_.build();
            }
            if ((this.bitField0_ & 0x80) != 0) {
                this.primaryStatusReasons_ = Collections.unmodifiableList(this.primaryStatusReasons_);
                this.bitField0_ &= 0xFFFFFF7F;
            }
            result.primaryStatusReasons_ = this.primaryStatusReasons_;
        }

        private void buildPartial0(CustomerAsset result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.asset_ = this.asset_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.fieldType_ = this.fieldType_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.source_ = this.source_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.status_ = this.status_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.primaryStatus_ = this.primaryStatus_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof CustomerAsset) {
                return this.mergeFrom((CustomerAsset)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(CustomerAsset other) {
            if (other == CustomerAsset.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getAsset().isEmpty()) {
                this.asset_ = other.asset_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.fieldType_ != 0) {
                this.setFieldTypeValue(other.getFieldTypeValue());
            }
            if (other.source_ != 0) {
                this.setSourceValue(other.getSourceValue());
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (other.primaryStatus_ != 0) {
                this.setPrimaryStatusValue(other.getPrimaryStatusValue());
            }
            if (this.primaryStatusDetailsBuilder_ == null) {
                if (!other.primaryStatusDetails_.isEmpty()) {
                    if (this.primaryStatusDetails_.isEmpty()) {
                        this.primaryStatusDetails_ = other.primaryStatusDetails_;
                        this.bitField0_ &= 0xFFFFFFBF;
                    } else {
                        this.ensurePrimaryStatusDetailsIsMutable();
                        this.primaryStatusDetails_.addAll(other.primaryStatusDetails_);
                    }
                    this.onChanged();
                }
            } else if (!other.primaryStatusDetails_.isEmpty()) {
                if (this.primaryStatusDetailsBuilder_.isEmpty()) {
                    this.primaryStatusDetailsBuilder_.dispose();
                    this.primaryStatusDetailsBuilder_ = null;
                    this.primaryStatusDetails_ = other.primaryStatusDetails_;
                    this.bitField0_ &= 0xFFFFFFBF;
                    this.primaryStatusDetailsBuilder_ = alwaysUseFieldBuilders ? this.getPrimaryStatusDetailsFieldBuilder() : null;
                } else {
                    this.primaryStatusDetailsBuilder_.addAllMessages((Iterable)other.primaryStatusDetails_);
                }
            }
            if (!other.primaryStatusReasons_.isEmpty()) {
                if (this.primaryStatusReasons_.isEmpty()) {
                    this.primaryStatusReasons_ = other.primaryStatusReasons_;
                    this.bitField0_ &= 0xFFFFFF7F;
                } else {
                    this.ensurePrimaryStatusReasonsIsMutable();
                    this.primaryStatusReasons_.addAll(other.primaryStatusReasons_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block17: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block17;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block17;
                        }
                        case 18: {
                            this.asset_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block17;
                        }
                        case 24: {
                            this.fieldType_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block17;
                        }
                        case 32: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block17;
                        }
                        case 40: {
                            this.source_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block17;
                        }
                        case 48: {
                            this.primaryStatus_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block17;
                        }
                        case 58: {
                            AssetLinkPrimaryStatusDetails m = (AssetLinkPrimaryStatusDetails)input.readMessage(AssetLinkPrimaryStatusDetails.parser(), extensionRegistry);
                            if (this.primaryStatusDetailsBuilder_ == null) {
                                this.ensurePrimaryStatusDetailsIsMutable();
                                this.primaryStatusDetails_.add(m);
                                continue block17;
                            }
                            this.primaryStatusDetailsBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                        case 64: {
                            int tmpRaw = input.readEnum();
                            this.ensurePrimaryStatusReasonsIsMutable();
                            this.primaryStatusReasons_.add(tmpRaw);
                            continue block17;
                        }
                        case 66: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensurePrimaryStatusReasonsIsMutable();
                                this.primaryStatusReasons_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block17;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = CustomerAsset.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CustomerAsset.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getAsset() {
            Object ref = this.asset_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.asset_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAssetBytes() {
            Object ref = this.asset_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.asset_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAsset(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.asset_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearAsset() {
            this.asset_ = CustomerAsset.getDefaultInstance().getAsset();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setAssetBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CustomerAsset.checkByteStringIsUtf8((ByteString)value);
            this.asset_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public int getFieldTypeValue() {
            return this.fieldType_;
        }

        public Builder setFieldTypeValue(int value) {
            this.fieldType_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public AssetFieldTypeEnum.AssetFieldType getFieldType() {
            AssetFieldTypeEnum.AssetFieldType result = AssetFieldTypeEnum.AssetFieldType.forNumber(this.fieldType_);
            return result == null ? AssetFieldTypeEnum.AssetFieldType.UNRECOGNIZED : result;
        }

        public Builder setFieldType(AssetFieldTypeEnum.AssetFieldType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.fieldType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearFieldType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.fieldType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getSourceValue() {
            return this.source_;
        }

        public Builder setSourceValue(int value) {
            this.source_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public AssetSourceEnum.AssetSource getSource() {
            AssetSourceEnum.AssetSource result = AssetSourceEnum.AssetSource.forNumber(this.source_);
            return result == null ? AssetSourceEnum.AssetSource.UNRECOGNIZED : result;
        }

        public Builder setSource(AssetSourceEnum.AssetSource value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.source_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearSource() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.source_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public AssetLinkStatusEnum.AssetLinkStatus getStatus() {
            AssetLinkStatusEnum.AssetLinkStatus result = AssetLinkStatusEnum.AssetLinkStatus.forNumber(this.status_);
            return result == null ? AssetLinkStatusEnum.AssetLinkStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(AssetLinkStatusEnum.AssetLinkStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getPrimaryStatusValue() {
            return this.primaryStatus_;
        }

        public Builder setPrimaryStatusValue(int value) {
            this.primaryStatus_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus getPrimaryStatus() {
            AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus result = AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus.forNumber(this.primaryStatus_);
            return result == null ? AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus.UNRECOGNIZED : result;
        }

        public Builder setPrimaryStatus(AssetLinkPrimaryStatusEnum.AssetLinkPrimaryStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.primaryStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryStatus() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.primaryStatus_ = 0;
            this.onChanged();
            return this;
        }

        private void ensurePrimaryStatusDetailsIsMutable() {
            if ((this.bitField0_ & 0x40) == 0) {
                this.primaryStatusDetails_ = new ArrayList<AssetLinkPrimaryStatusDetails>(this.primaryStatusDetails_);
                this.bitField0_ |= 0x40;
            }
        }

        @Override
        public List<AssetLinkPrimaryStatusDetails> getPrimaryStatusDetailsList() {
            if (this.primaryStatusDetailsBuilder_ == null) {
                return Collections.unmodifiableList(this.primaryStatusDetails_);
            }
            return this.primaryStatusDetailsBuilder_.getMessageList();
        }

        @Override
        public int getPrimaryStatusDetailsCount() {
            if (this.primaryStatusDetailsBuilder_ == null) {
                return this.primaryStatusDetails_.size();
            }
            return this.primaryStatusDetailsBuilder_.getCount();
        }

        @Override
        public AssetLinkPrimaryStatusDetails getPrimaryStatusDetails(int index) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                return this.primaryStatusDetails_.get(index);
            }
            return (AssetLinkPrimaryStatusDetails)this.primaryStatusDetailsBuilder_.getMessage(index);
        }

        public Builder setPrimaryStatusDetails(int index, AssetLinkPrimaryStatusDetails value) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.set(index, value);
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPrimaryStatusDetails(int index, AssetLinkPrimaryStatusDetails.Builder builderForValue) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPrimaryStatusDetails(AssetLinkPrimaryStatusDetails value) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.add(value);
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPrimaryStatusDetails(int index, AssetLinkPrimaryStatusDetails value) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.add(index, value);
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPrimaryStatusDetails(AssetLinkPrimaryStatusDetails.Builder builderForValue) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPrimaryStatusDetails(int index, AssetLinkPrimaryStatusDetails.Builder builderForValue) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPrimaryStatusDetails(Iterable<? extends AssetLinkPrimaryStatusDetails> values) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.ensurePrimaryStatusDetailsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.primaryStatusDetails_);
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPrimaryStatusDetails() {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.primaryStatusDetails_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFBF;
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.clear();
            }
            return this;
        }

        public Builder removePrimaryStatusDetails(int index) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.ensurePrimaryStatusDetailsIsMutable();
                this.primaryStatusDetails_.remove(index);
                this.onChanged();
            } else {
                this.primaryStatusDetailsBuilder_.remove(index);
            }
            return this;
        }

        public AssetLinkPrimaryStatusDetails.Builder getPrimaryStatusDetailsBuilder(int index) {
            return (AssetLinkPrimaryStatusDetails.Builder)this.getPrimaryStatusDetailsFieldBuilder().getBuilder(index);
        }

        @Override
        public AssetLinkPrimaryStatusDetailsOrBuilder getPrimaryStatusDetailsOrBuilder(int index) {
            if (this.primaryStatusDetailsBuilder_ == null) {
                return this.primaryStatusDetails_.get(index);
            }
            return (AssetLinkPrimaryStatusDetailsOrBuilder)this.primaryStatusDetailsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AssetLinkPrimaryStatusDetailsOrBuilder> getPrimaryStatusDetailsOrBuilderList() {
            if (this.primaryStatusDetailsBuilder_ != null) {
                return this.primaryStatusDetailsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.primaryStatusDetails_);
        }

        public AssetLinkPrimaryStatusDetails.Builder addPrimaryStatusDetailsBuilder() {
            return (AssetLinkPrimaryStatusDetails.Builder)this.getPrimaryStatusDetailsFieldBuilder().addBuilder((AbstractMessage)AssetLinkPrimaryStatusDetails.getDefaultInstance());
        }

        public AssetLinkPrimaryStatusDetails.Builder addPrimaryStatusDetailsBuilder(int index) {
            return (AssetLinkPrimaryStatusDetails.Builder)this.getPrimaryStatusDetailsFieldBuilder().addBuilder(index, (AbstractMessage)AssetLinkPrimaryStatusDetails.getDefaultInstance());
        }

        public List<AssetLinkPrimaryStatusDetails.Builder> getPrimaryStatusDetailsBuilderList() {
            return this.getPrimaryStatusDetailsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AssetLinkPrimaryStatusDetails, AssetLinkPrimaryStatusDetails.Builder, AssetLinkPrimaryStatusDetailsOrBuilder> getPrimaryStatusDetailsFieldBuilder() {
            if (this.primaryStatusDetailsBuilder_ == null) {
                this.primaryStatusDetailsBuilder_ = new RepeatedFieldBuilderV3(this.primaryStatusDetails_, (this.bitField0_ & 0x40) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.primaryStatusDetails_ = null;
            }
            return this.primaryStatusDetailsBuilder_;
        }

        private void ensurePrimaryStatusReasonsIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.primaryStatusReasons_ = new ArrayList<Integer>(this.primaryStatusReasons_);
                this.bitField0_ |= 0x80;
            }
        }

        @Override
        public List<AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason> getPrimaryStatusReasonsList() {
            return new Internal.ListAdapter(this.primaryStatusReasons_, primaryStatusReasons_converter_);
        }

        @Override
        public int getPrimaryStatusReasonsCount() {
            return this.primaryStatusReasons_.size();
        }

        @Override
        public AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason getPrimaryStatusReasons(int index) {
            return (AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason)((Object)primaryStatusReasons_converter_.convert((Object)this.primaryStatusReasons_.get(index)));
        }

        public Builder setPrimaryStatusReasons(int index, AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addPrimaryStatusReasons(AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllPrimaryStatusReasons(Iterable<? extends AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason> values) {
            this.ensurePrimaryStatusReasonsIsMutable();
            for (AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason assetLinkPrimaryStatusReason : values) {
                this.primaryStatusReasons_.add(assetLinkPrimaryStatusReason.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryStatusReasons() {
            this.primaryStatusReasons_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getPrimaryStatusReasonsValueList() {
            return Collections.unmodifiableList(this.primaryStatusReasons_);
        }

        @Override
        public int getPrimaryStatusReasonsValue(int index) {
            return this.primaryStatusReasons_.get(index);
        }

        public Builder setPrimaryStatusReasonsValue(int index, int value) {
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addPrimaryStatusReasonsValue(int value) {
            this.ensurePrimaryStatusReasonsIsMutable();
            this.primaryStatusReasons_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllPrimaryStatusReasonsValue(Iterable<Integer> values) {
            this.ensurePrimaryStatusReasonsIsMutable();
            for (int value : values) {
                this.primaryStatusReasons_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

