/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LeadFormSubmissionDataName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_LEAD_FORM_USER_SUBMISSION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/leadFormSubmissionData/{lead_form_user_submission_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String leadFormUserSubmissionId;

    @Deprecated
    protected LeadFormSubmissionDataName() {
        this.customerId = null;
        this.leadFormUserSubmissionId = null;
    }

    private LeadFormSubmissionDataName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.leadFormUserSubmissionId = (String)Preconditions.checkNotNull((Object)builder.getLeadFormUserSubmissionId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getLeadFormUserSubmissionId() {
        return this.leadFormUserSubmissionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LeadFormSubmissionDataName of(String customerId, String leadFormUserSubmissionId) {
        return LeadFormSubmissionDataName.newBuilder().setCustomerId(customerId).setLeadFormUserSubmissionId(leadFormUserSubmissionId).build();
    }

    public static String format(String customerId, String leadFormUserSubmissionId) {
        return LeadFormSubmissionDataName.newBuilder().setCustomerId(customerId).setLeadFormUserSubmissionId(leadFormUserSubmissionId).build().toString();
    }

    public static LeadFormSubmissionDataName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_LEAD_FORM_USER_SUBMISSION_ID.validatedMatch(formattedString, "LeadFormSubmissionDataName.parse: formattedString not in valid format");
        return LeadFormSubmissionDataName.of((String)matchMap.get("customer_id"), (String)matchMap.get("lead_form_user_submission_id"));
    }

    public static List<LeadFormSubmissionDataName> parseList(List<String> formattedStrings) {
        ArrayList<LeadFormSubmissionDataName> list = new ArrayList<LeadFormSubmissionDataName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LeadFormSubmissionDataName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LeadFormSubmissionDataName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LeadFormSubmissionDataName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_LEAD_FORM_USER_SUBMISSION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LeadFormSubmissionDataName leadFormSubmissionDataName = this;
            synchronized (leadFormSubmissionDataName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.leadFormUserSubmissionId != null) {
                        fieldMapBuilder.put((Object)"lead_form_user_submission_id", (Object)this.leadFormUserSubmissionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_LEAD_FORM_USER_SUBMISSION_ID.instantiate(new String[]{"customer_id", this.customerId, "lead_form_user_submission_id", this.leadFormUserSubmissionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LeadFormSubmissionDataName that = (LeadFormSubmissionDataName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.leadFormUserSubmissionId, that.leadFormUserSubmissionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.leadFormUserSubmissionId);
    }

    public static class Builder {
        private String customerId;
        private String leadFormUserSubmissionId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getLeadFormUserSubmissionId() {
            return this.leadFormUserSubmissionId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setLeadFormUserSubmissionId(String leadFormUserSubmissionId) {
            this.leadFormUserSubmissionId = leadFormUserSubmissionId;
            return this;
        }

        private Builder(LeadFormSubmissionDataName leadFormSubmissionDataName) {
            this.customerId = leadFormSubmissionDataName.customerId;
            this.leadFormUserSubmissionId = leadFormSubmissionDataName.leadFormUserSubmissionId;
        }

        public LeadFormSubmissionDataName build() {
            return new LeadFormSubmissionDataName(this);
        }
    }
}

