/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SmartCampaignSettingName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/smartCampaignSettings/{campaign_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;

    @Deprecated
    protected SmartCampaignSettingName() {
        this.customerId = null;
        this.campaignId = null;
    }

    private SmartCampaignSettingName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SmartCampaignSettingName of(String customerId, String campaignId) {
        return SmartCampaignSettingName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).build();
    }

    public static String format(String customerId, String campaignId) {
        return SmartCampaignSettingName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).build().toString();
    }

    public static SmartCampaignSettingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID.validatedMatch(formattedString, "SmartCampaignSettingName.parse: formattedString not in valid format");
        return SmartCampaignSettingName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"));
    }

    public static List<SmartCampaignSettingName> parseList(List<String> formattedStrings) {
        ArrayList<SmartCampaignSettingName> list = new ArrayList<SmartCampaignSettingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SmartCampaignSettingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SmartCampaignSettingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SmartCampaignSettingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SmartCampaignSettingName smartCampaignSettingName = this;
            synchronized (smartCampaignSettingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SmartCampaignSettingName that = (SmartCampaignSettingName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.campaignId);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        private Builder(SmartCampaignSettingName smartCampaignSettingName) {
            this.customerId = smartCampaignSettingName.customerId;
            this.campaignId = smartCampaignSettingName.campaignId;
        }

        public SmartCampaignSettingName build() {
            return new SmartCampaignSettingName(this);
        }
    }
}

