/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.services;

import com.google.ads.googleads.v19.services.BrandSuggestionServiceSettings;
import com.google.ads.googleads.v19.services.SuggestBrandsRequest;
import com.google.ads.googleads.v19.services.SuggestBrandsResponse;
import com.google.ads.googleads.v19.services.stub.BrandSuggestionServiceStub;
import com.google.ads.googleads.v19.services.stub.BrandSuggestionServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class BrandSuggestionServiceClient
implements BackgroundResource {
    private final BrandSuggestionServiceSettings settings;
    private final BrandSuggestionServiceStub stub;

    public static final BrandSuggestionServiceClient create() throws IOException {
        return BrandSuggestionServiceClient.create(BrandSuggestionServiceSettings.newBuilder().build());
    }

    public static final BrandSuggestionServiceClient create(BrandSuggestionServiceSettings settings) throws IOException {
        return new BrandSuggestionServiceClient(settings);
    }

    public static final BrandSuggestionServiceClient create(BrandSuggestionServiceStub stub) {
        return new BrandSuggestionServiceClient(stub);
    }

    protected BrandSuggestionServiceClient(BrandSuggestionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BrandSuggestionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected BrandSuggestionServiceClient(BrandSuggestionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BrandSuggestionServiceSettings getSettings() {
        return this.settings;
    }

    public BrandSuggestionServiceStub getStub() {
        return this.stub;
    }

    public final SuggestBrandsResponse suggestBrands(String customerId, String brandPrefix) {
        SuggestBrandsRequest request = SuggestBrandsRequest.newBuilder().setCustomerId(customerId).setBrandPrefix(brandPrefix).build();
        return this.suggestBrands(request);
    }

    public final SuggestBrandsResponse suggestBrands(SuggestBrandsRequest request) {
        return (SuggestBrandsResponse)this.suggestBrandsCallable().call((Object)request);
    }

    public final UnaryCallable<SuggestBrandsRequest, SuggestBrandsResponse> suggestBrandsCallable() {
        return this.stub.suggestBrandsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

