/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.services;

import com.google.ads.googleads.v19.services.AppendLeadConversationRequest;
import com.google.ads.googleads.v19.services.AppendLeadConversationResponse;
import com.google.ads.googleads.v19.services.Conversation;
import com.google.ads.googleads.v19.services.LocalServicesLeadServiceSettings;
import com.google.ads.googleads.v19.services.stub.LocalServicesLeadServiceStub;
import com.google.ads.googleads.v19.services.stub.LocalServicesLeadServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LocalServicesLeadServiceClient
implements BackgroundResource {
    private final LocalServicesLeadServiceSettings settings;
    private final LocalServicesLeadServiceStub stub;

    public static final LocalServicesLeadServiceClient create() throws IOException {
        return LocalServicesLeadServiceClient.create(LocalServicesLeadServiceSettings.newBuilder().build());
    }

    public static final LocalServicesLeadServiceClient create(LocalServicesLeadServiceSettings settings) throws IOException {
        return new LocalServicesLeadServiceClient(settings);
    }

    public static final LocalServicesLeadServiceClient create(LocalServicesLeadServiceStub stub) {
        return new LocalServicesLeadServiceClient(stub);
    }

    protected LocalServicesLeadServiceClient(LocalServicesLeadServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LocalServicesLeadServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected LocalServicesLeadServiceClient(LocalServicesLeadServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LocalServicesLeadServiceSettings getSettings() {
        return this.settings;
    }

    public LocalServicesLeadServiceStub getStub() {
        return this.stub;
    }

    public final AppendLeadConversationResponse appendLeadConversation(String customerId, List<Conversation> conversations) {
        AppendLeadConversationRequest request = AppendLeadConversationRequest.newBuilder().setCustomerId(customerId).addAllConversations(conversations).build();
        return this.appendLeadConversation(request);
    }

    public final AppendLeadConversationResponse appendLeadConversation(AppendLeadConversationRequest request) {
        return (AppendLeadConversationResponse)this.appendLeadConversationCallable().call((Object)request);
    }

    public final UnaryCallable<AppendLeadConversationRequest, AppendLeadConversationResponse> appendLeadConversationCallable() {
        return this.stub.appendLeadConversationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

