/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.services.stub;

import com.google.ads.googleads.v19.services.GetIdentityVerificationRequest;
import com.google.ads.googleads.v19.services.GetIdentityVerificationResponse;
import com.google.ads.googleads.v19.services.StartIdentityVerificationRequest;
import com.google.ads.googleads.v19.services.stub.GrpcIdentityVerificationServiceCallableFactory;
import com.google.ads.googleads.v19.services.stub.IdentityVerificationServiceStub;
import com.google.ads.googleads.v19.services.stub.IdentityVerificationServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcIdentityVerificationServiceStub
extends IdentityVerificationServiceStub {
    private static final MethodDescriptor<StartIdentityVerificationRequest, Empty> startIdentityVerificationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v19.services.IdentityVerificationService/StartIdentityVerification").setRequestMarshaller(ProtoUtils.marshaller((Message)StartIdentityVerificationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIdentityVerificationRequest, GetIdentityVerificationResponse> getIdentityVerificationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v19.services.IdentityVerificationService/GetIdentityVerification").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIdentityVerificationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GetIdentityVerificationResponse.getDefaultInstance())).build();
    private final UnaryCallable<StartIdentityVerificationRequest, Empty> startIdentityVerificationCallable;
    private final UnaryCallable<GetIdentityVerificationRequest, GetIdentityVerificationResponse> getIdentityVerificationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcIdentityVerificationServiceStub create(IdentityVerificationServiceStubSettings settings) throws IOException {
        return new GrpcIdentityVerificationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcIdentityVerificationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcIdentityVerificationServiceStub(IdentityVerificationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcIdentityVerificationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcIdentityVerificationServiceStub(IdentityVerificationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcIdentityVerificationServiceStub(IdentityVerificationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcIdentityVerificationServiceCallableFactory());
    }

    protected GrpcIdentityVerificationServiceStub(IdentityVerificationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings startIdentityVerificationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startIdentityVerificationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        GrpcCallSettings getIdentityVerificationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIdentityVerificationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        this.startIdentityVerificationCallable = callableFactory.createUnaryCallable(startIdentityVerificationTransportSettings, settings.startIdentityVerificationSettings(), clientContext);
        this.getIdentityVerificationCallable = callableFactory.createUnaryCallable(getIdentityVerificationTransportSettings, settings.getIdentityVerificationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<StartIdentityVerificationRequest, Empty> startIdentityVerificationCallable() {
        return this.startIdentityVerificationCallable;
    }

    @Override
    public UnaryCallable<GetIdentityVerificationRequest, GetIdentityVerificationResponse> getIdentityVerificationCallable() {
        return this.getIdentityVerificationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

