/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SharedCriterionName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_SHARED_SET_ID_CRITERION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/sharedCriteria/{shared_set_id}~{criterion_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String sharedSetId;
    private final String criterionId;

    @Deprecated
    protected SharedCriterionName() {
        this.customerId = null;
        this.sharedSetId = null;
        this.criterionId = null;
    }

    private SharedCriterionName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.sharedSetId = (String)Preconditions.checkNotNull((Object)builder.getSharedSetId());
        this.criterionId = (String)Preconditions.checkNotNull((Object)builder.getCriterionId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getSharedSetId() {
        return this.sharedSetId;
    }

    public String getCriterionId() {
        return this.criterionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SharedCriterionName of(String customerId, String sharedSetId, String criterionId) {
        return SharedCriterionName.newBuilder().setCustomerId(customerId).setSharedSetId(sharedSetId).setCriterionId(criterionId).build();
    }

    public static String format(String customerId, String sharedSetId, String criterionId) {
        return SharedCriterionName.newBuilder().setCustomerId(customerId).setSharedSetId(sharedSetId).setCriterionId(criterionId).build().toString();
    }

    public static SharedCriterionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_SHARED_SET_ID_CRITERION_ID.validatedMatch(formattedString, "SharedCriterionName.parse: formattedString not in valid format");
        return SharedCriterionName.of((String)matchMap.get("customer_id"), (String)matchMap.get("shared_set_id"), (String)matchMap.get("criterion_id"));
    }

    public static List<SharedCriterionName> parseList(List<String> formattedStrings) {
        ArrayList<SharedCriterionName> list = new ArrayList<SharedCriterionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SharedCriterionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SharedCriterionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SharedCriterionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_SHARED_SET_ID_CRITERION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SharedCriterionName sharedCriterionName = this;
            synchronized (sharedCriterionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.sharedSetId != null) {
                        fieldMapBuilder.put((Object)"shared_set_id", (Object)this.sharedSetId);
                    }
                    if (this.criterionId != null) {
                        fieldMapBuilder.put((Object)"criterion_id", (Object)this.criterionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_SHARED_SET_ID_CRITERION_ID.instantiate(new String[]{"customer_id", this.customerId, "shared_set_id", this.sharedSetId, "criterion_id", this.criterionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SharedCriterionName that = (SharedCriterionName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.sharedSetId, that.sharedSetId) && Objects.equals(this.criterionId, that.criterionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.sharedSetId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.criterionId);
    }

    public static class Builder {
        private String customerId;
        private String sharedSetId;
        private String criterionId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getSharedSetId() {
            return this.sharedSetId;
        }

        public String getCriterionId() {
            return this.criterionId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setSharedSetId(String sharedSetId) {
            this.sharedSetId = sharedSetId;
            return this;
        }

        public Builder setCriterionId(String criterionId) {
            this.criterionId = criterionId;
            return this;
        }

        private Builder(SharedCriterionName sharedCriterionName) {
            this.customerId = sharedCriterionName.customerId;
            this.sharedSetId = sharedCriterionName.sharedSetId;
            this.criterionId = sharedCriterionName.criterionId;
        }

        public SharedCriterionName build() {
            return new SharedCriterionName(this);
        }
    }
}

