/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CombinedAudienceName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_COMBINED_AUDIENCE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/combinedAudiences/{combined_audience_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String combinedAudienceId;

    @Deprecated
    protected CombinedAudienceName() {
        this.customerId = null;
        this.combinedAudienceId = null;
    }

    private CombinedAudienceName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.combinedAudienceId = (String)Preconditions.checkNotNull((Object)builder.getCombinedAudienceId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCombinedAudienceId() {
        return this.combinedAudienceId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CombinedAudienceName of(String customerId, String combinedAudienceId) {
        return CombinedAudienceName.newBuilder().setCustomerId(customerId).setCombinedAudienceId(combinedAudienceId).build();
    }

    public static String format(String customerId, String combinedAudienceId) {
        return CombinedAudienceName.newBuilder().setCustomerId(customerId).setCombinedAudienceId(combinedAudienceId).build().toString();
    }

    public static CombinedAudienceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_COMBINED_AUDIENCE_ID.validatedMatch(formattedString, "CombinedAudienceName.parse: formattedString not in valid format");
        return CombinedAudienceName.of((String)matchMap.get("customer_id"), (String)matchMap.get("combined_audience_id"));
    }

    public static List<CombinedAudienceName> parseList(List<String> formattedStrings) {
        ArrayList<CombinedAudienceName> list = new ArrayList<CombinedAudienceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CombinedAudienceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CombinedAudienceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CombinedAudienceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_COMBINED_AUDIENCE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CombinedAudienceName combinedAudienceName = this;
            synchronized (combinedAudienceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.combinedAudienceId != null) {
                        fieldMapBuilder.put((Object)"combined_audience_id", (Object)this.combinedAudienceId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_COMBINED_AUDIENCE_ID.instantiate(new String[]{"customer_id", this.customerId, "combined_audience_id", this.combinedAudienceId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CombinedAudienceName that = (CombinedAudienceName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.combinedAudienceId, that.combinedAudienceId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.combinedAudienceId);
    }

    public static class Builder {
        private String customerId;
        private String combinedAudienceId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCombinedAudienceId() {
            return this.combinedAudienceId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCombinedAudienceId(String combinedAudienceId) {
            this.combinedAudienceId = combinedAudienceId;
            return this;
        }

        private Builder(CombinedAudienceName combinedAudienceName) {
            this.customerId = combinedAudienceName.customerId;
            this.combinedAudienceId = combinedAudienceName.combinedAudienceId;
        }

        public CombinedAudienceName build() {
            return new CombinedAudienceName(this);
        }
    }
}

