/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.services;

import com.google.ads.googleads.v19.resources.ProductLink;
import com.google.ads.googleads.v19.resources.ProductLinkName;
import com.google.ads.googleads.v19.services.CreateProductLinkRequest;
import com.google.ads.googleads.v19.services.CreateProductLinkResponse;
import com.google.ads.googleads.v19.services.ProductLinkServiceSettings;
import com.google.ads.googleads.v19.services.RemoveProductLinkRequest;
import com.google.ads.googleads.v19.services.RemoveProductLinkResponse;
import com.google.ads.googleads.v19.services.stub.ProductLinkServiceStub;
import com.google.ads.googleads.v19.services.stub.ProductLinkServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ProductLinkServiceClient
implements BackgroundResource {
    private final ProductLinkServiceSettings settings;
    private final ProductLinkServiceStub stub;

    public static final ProductLinkServiceClient create() throws IOException {
        return ProductLinkServiceClient.create(ProductLinkServiceSettings.newBuilder().build());
    }

    public static final ProductLinkServiceClient create(ProductLinkServiceSettings settings) throws IOException {
        return new ProductLinkServiceClient(settings);
    }

    public static final ProductLinkServiceClient create(ProductLinkServiceStub stub) {
        return new ProductLinkServiceClient(stub);
    }

    protected ProductLinkServiceClient(ProductLinkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProductLinkServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ProductLinkServiceClient(ProductLinkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ProductLinkServiceSettings getSettings() {
        return this.settings;
    }

    public ProductLinkServiceStub getStub() {
        return this.stub;
    }

    public final CreateProductLinkResponse createProductLink(String customerId, ProductLink productLink) {
        CreateProductLinkRequest request = CreateProductLinkRequest.newBuilder().setCustomerId(customerId).setProductLink(productLink).build();
        return this.createProductLink(request);
    }

    public final CreateProductLinkResponse createProductLink(CreateProductLinkRequest request) {
        return (CreateProductLinkResponse)this.createProductLinkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProductLinkRequest, CreateProductLinkResponse> createProductLinkCallable() {
        return this.stub.createProductLinkCallable();
    }

    public final RemoveProductLinkResponse removeProductLink(String customerId, ProductLinkName resourceName) {
        RemoveProductLinkRequest request = RemoveProductLinkRequest.newBuilder().setCustomerId(customerId).setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.removeProductLink(request);
    }

    public final RemoveProductLinkResponse removeProductLink(String customerId, String resourceName) {
        RemoveProductLinkRequest request = RemoveProductLinkRequest.newBuilder().setCustomerId(customerId).setResourceName(resourceName).build();
        return this.removeProductLink(request);
    }

    public final RemoveProductLinkResponse removeProductLink(RemoveProductLinkRequest request) {
        return (RemoveProductLinkResponse)this.removeProductLinkCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveProductLinkRequest, RemoveProductLinkResponse> removeProductLinkCallable() {
        return this.stub.removeProductLinkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

