// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v20/common/user_lists.proto

// Protobuf Java Version: 3.25.7
package com.google.ads.googleads.v20.common;

/**
 * <pre>
 * Flexible rule representation of visitors with one or multiple actions. The
 * flexible user list is defined by two lists of operands – inclusive_operands
 * and exclusive_operands; each operand represents a set of users based on
 * actions they took in a given timeframe. These lists of operands are combined
 * with the AND_NOT operator, so that users represented by the inclusive
 * operands are included in the user list, minus the users represented by the
 * exclusive operands.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v20.common.FlexibleRuleUserListInfo}
 */
public final class FlexibleRuleUserListInfo extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v20.common.FlexibleRuleUserListInfo)
    FlexibleRuleUserListInfoOrBuilder {
private static final long serialVersionUID = 0L;
  // Use FlexibleRuleUserListInfo.newBuilder() to construct.
  private FlexibleRuleUserListInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private FlexibleRuleUserListInfo() {
    inclusiveRuleOperator_ = 0;
    inclusiveOperands_ = java.util.Collections.emptyList();
    exclusiveOperands_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new FlexibleRuleUserListInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v20.common.UserListsProto.internal_static_google_ads_googleads_v20_common_FlexibleRuleUserListInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v20.common.UserListsProto.internal_static_google_ads_googleads_v20_common_FlexibleRuleUserListInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo.class, com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo.Builder.class);
  }

  public static final int INCLUSIVE_RULE_OPERATOR_FIELD_NUMBER = 1;
  private int inclusiveRuleOperator_ = 0;
  /**
   * <pre>
   * Operator that defines how the inclusive operands are combined.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator inclusive_rule_operator = 1;</code>
   * @return The enum numeric value on the wire for inclusiveRuleOperator.
   */
  @java.lang.Override public int getInclusiveRuleOperatorValue() {
    return inclusiveRuleOperator_;
  }
  /**
   * <pre>
   * Operator that defines how the inclusive operands are combined.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator inclusive_rule_operator = 1;</code>
   * @return The inclusiveRuleOperator.
   */
  @java.lang.Override public com.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator getInclusiveRuleOperator() {
    com.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator result = com.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator.forNumber(inclusiveRuleOperator_);
    return result == null ? com.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator.UNRECOGNIZED : result;
  }

  public static final int INCLUSIVE_OPERANDS_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo> inclusiveOperands_;
  /**
   * <pre>
   * Rules representing users that should be included in the user list. These
   * are located on the left side of the AND_NOT operator, and joined together
   * by either AND/OR as specified by the inclusive_rule_operator.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo> getInclusiveOperandsList() {
    return inclusiveOperands_;
  }
  /**
   * <pre>
   * Rules representing users that should be included in the user list. These
   * are located on the left side of the AND_NOT operator, and joined together
   * by either AND/OR as specified by the inclusive_rule_operator.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder> 
      getInclusiveOperandsOrBuilderList() {
    return inclusiveOperands_;
  }
  /**
   * <pre>
   * Rules representing users that should be included in the user list. These
   * are located on the left side of the AND_NOT operator, and joined together
   * by either AND/OR as specified by the inclusive_rule_operator.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
   */
  @java.lang.Override
  public int getInclusiveOperandsCount() {
    return inclusiveOperands_.size();
  }
  /**
   * <pre>
   * Rules representing users that should be included in the user list. These
   * are located on the left side of the AND_NOT operator, and joined together
   * by either AND/OR as specified by the inclusive_rule_operator.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo getInclusiveOperands(int index) {
    return inclusiveOperands_.get(index);
  }
  /**
   * <pre>
   * Rules representing users that should be included in the user list. These
   * are located on the left side of the AND_NOT operator, and joined together
   * by either AND/OR as specified by the inclusive_rule_operator.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder getInclusiveOperandsOrBuilder(
      int index) {
    return inclusiveOperands_.get(index);
  }

  public static final int EXCLUSIVE_OPERANDS_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo> exclusiveOperands_;
  /**
   * <pre>
   * Rules representing users that should be excluded from the user list. These
   * are located on the right side of the AND_NOT operator, and joined together
   * by OR.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo> getExclusiveOperandsList() {
    return exclusiveOperands_;
  }
  /**
   * <pre>
   * Rules representing users that should be excluded from the user list. These
   * are located on the right side of the AND_NOT operator, and joined together
   * by OR.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder> 
      getExclusiveOperandsOrBuilderList() {
    return exclusiveOperands_;
  }
  /**
   * <pre>
   * Rules representing users that should be excluded from the user list. These
   * are located on the right side of the AND_NOT operator, and joined together
   * by OR.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
   */
  @java.lang.Override
  public int getExclusiveOperandsCount() {
    return exclusiveOperands_.size();
  }
  /**
   * <pre>
   * Rules representing users that should be excluded from the user list. These
   * are located on the right side of the AND_NOT operator, and joined together
   * by OR.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo getExclusiveOperands(int index) {
    return exclusiveOperands_.get(index);
  }
  /**
   * <pre>
   * Rules representing users that should be excluded from the user list. These
   * are located on the right side of the AND_NOT operator, and joined together
   * by OR.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder getExclusiveOperandsOrBuilder(
      int index) {
    return exclusiveOperands_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (inclusiveRuleOperator_ != com.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator.UNSPECIFIED.getNumber()) {
      output.writeEnum(1, inclusiveRuleOperator_);
    }
    for (int i = 0; i < inclusiveOperands_.size(); i++) {
      output.writeMessage(2, inclusiveOperands_.get(i));
    }
    for (int i = 0; i < exclusiveOperands_.size(); i++) {
      output.writeMessage(3, exclusiveOperands_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (inclusiveRuleOperator_ != com.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, inclusiveRuleOperator_);
    }
    for (int i = 0; i < inclusiveOperands_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, inclusiveOperands_.get(i));
    }
    for (int i = 0; i < exclusiveOperands_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, exclusiveOperands_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo other = (com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo) obj;

    if (inclusiveRuleOperator_ != other.inclusiveRuleOperator_) return false;
    if (!getInclusiveOperandsList()
        .equals(other.getInclusiveOperandsList())) return false;
    if (!getExclusiveOperandsList()
        .equals(other.getExclusiveOperandsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INCLUSIVE_RULE_OPERATOR_FIELD_NUMBER;
    hash = (53 * hash) + inclusiveRuleOperator_;
    if (getInclusiveOperandsCount() > 0) {
      hash = (37 * hash) + INCLUSIVE_OPERANDS_FIELD_NUMBER;
      hash = (53 * hash) + getInclusiveOperandsList().hashCode();
    }
    if (getExclusiveOperandsCount() > 0) {
      hash = (37 * hash) + EXCLUSIVE_OPERANDS_FIELD_NUMBER;
      hash = (53 * hash) + getExclusiveOperandsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Flexible rule representation of visitors with one or multiple actions. The
   * flexible user list is defined by two lists of operands – inclusive_operands
   * and exclusive_operands; each operand represents a set of users based on
   * actions they took in a given timeframe. These lists of operands are combined
   * with the AND_NOT operator, so that users represented by the inclusive
   * operands are included in the user list, minus the users represented by the
   * exclusive operands.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v20.common.FlexibleRuleUserListInfo}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v20.common.FlexibleRuleUserListInfo)
      com.google.ads.googleads.v20.common.FlexibleRuleUserListInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v20.common.UserListsProto.internal_static_google_ads_googleads_v20_common_FlexibleRuleUserListInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v20.common.UserListsProto.internal_static_google_ads_googleads_v20_common_FlexibleRuleUserListInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo.class, com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo.Builder.class);
    }

    // Construct using com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      inclusiveRuleOperator_ = 0;
      if (inclusiveOperandsBuilder_ == null) {
        inclusiveOperands_ = java.util.Collections.emptyList();
      } else {
        inclusiveOperands_ = null;
        inclusiveOperandsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (exclusiveOperandsBuilder_ == null) {
        exclusiveOperands_ = java.util.Collections.emptyList();
      } else {
        exclusiveOperands_ = null;
        exclusiveOperandsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v20.common.UserListsProto.internal_static_google_ads_googleads_v20_common_FlexibleRuleUserListInfo_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo getDefaultInstanceForType() {
      return com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo build() {
      com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo buildPartial() {
      com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo result = new com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo result) {
      if (inclusiveOperandsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          inclusiveOperands_ = java.util.Collections.unmodifiableList(inclusiveOperands_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.inclusiveOperands_ = inclusiveOperands_;
      } else {
        result.inclusiveOperands_ = inclusiveOperandsBuilder_.build();
      }
      if (exclusiveOperandsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          exclusiveOperands_ = java.util.Collections.unmodifiableList(exclusiveOperands_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.exclusiveOperands_ = exclusiveOperands_;
      } else {
        result.exclusiveOperands_ = exclusiveOperandsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.inclusiveRuleOperator_ = inclusiveRuleOperator_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo) {
        return mergeFrom((com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo other) {
      if (other == com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo.getDefaultInstance()) return this;
      if (other.inclusiveRuleOperator_ != 0) {
        setInclusiveRuleOperatorValue(other.getInclusiveRuleOperatorValue());
      }
      if (inclusiveOperandsBuilder_ == null) {
        if (!other.inclusiveOperands_.isEmpty()) {
          if (inclusiveOperands_.isEmpty()) {
            inclusiveOperands_ = other.inclusiveOperands_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureInclusiveOperandsIsMutable();
            inclusiveOperands_.addAll(other.inclusiveOperands_);
          }
          onChanged();
        }
      } else {
        if (!other.inclusiveOperands_.isEmpty()) {
          if (inclusiveOperandsBuilder_.isEmpty()) {
            inclusiveOperandsBuilder_.dispose();
            inclusiveOperandsBuilder_ = null;
            inclusiveOperands_ = other.inclusiveOperands_;
            bitField0_ = (bitField0_ & ~0x00000002);
            inclusiveOperandsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getInclusiveOperandsFieldBuilder() : null;
          } else {
            inclusiveOperandsBuilder_.addAllMessages(other.inclusiveOperands_);
          }
        }
      }
      if (exclusiveOperandsBuilder_ == null) {
        if (!other.exclusiveOperands_.isEmpty()) {
          if (exclusiveOperands_.isEmpty()) {
            exclusiveOperands_ = other.exclusiveOperands_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureExclusiveOperandsIsMutable();
            exclusiveOperands_.addAll(other.exclusiveOperands_);
          }
          onChanged();
        }
      } else {
        if (!other.exclusiveOperands_.isEmpty()) {
          if (exclusiveOperandsBuilder_.isEmpty()) {
            exclusiveOperandsBuilder_.dispose();
            exclusiveOperandsBuilder_ = null;
            exclusiveOperands_ = other.exclusiveOperands_;
            bitField0_ = (bitField0_ & ~0x00000004);
            exclusiveOperandsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getExclusiveOperandsFieldBuilder() : null;
          } else {
            exclusiveOperandsBuilder_.addAllMessages(other.exclusiveOperands_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              inclusiveRuleOperator_ = input.readEnum();
              bitField0_ |= 0x00000001;
              break;
            } // case 8
            case 18: {
              com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo m =
                  input.readMessage(
                      com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.parser(),
                      extensionRegistry);
              if (inclusiveOperandsBuilder_ == null) {
                ensureInclusiveOperandsIsMutable();
                inclusiveOperands_.add(m);
              } else {
                inclusiveOperandsBuilder_.addMessage(m);
              }
              break;
            } // case 18
            case 26: {
              com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo m =
                  input.readMessage(
                      com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.parser(),
                      extensionRegistry);
              if (exclusiveOperandsBuilder_ == null) {
                ensureExclusiveOperandsIsMutable();
                exclusiveOperands_.add(m);
              } else {
                exclusiveOperandsBuilder_.addMessage(m);
              }
              break;
            } // case 26
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private int inclusiveRuleOperator_ = 0;
    /**
     * <pre>
     * Operator that defines how the inclusive operands are combined.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator inclusive_rule_operator = 1;</code>
     * @return The enum numeric value on the wire for inclusiveRuleOperator.
     */
    @java.lang.Override public int getInclusiveRuleOperatorValue() {
      return inclusiveRuleOperator_;
    }
    /**
     * <pre>
     * Operator that defines how the inclusive operands are combined.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator inclusive_rule_operator = 1;</code>
     * @param value The enum numeric value on the wire for inclusiveRuleOperator to set.
     * @return This builder for chaining.
     */
    public Builder setInclusiveRuleOperatorValue(int value) {
      inclusiveRuleOperator_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Operator that defines how the inclusive operands are combined.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator inclusive_rule_operator = 1;</code>
     * @return The inclusiveRuleOperator.
     */
    @java.lang.Override
    public com.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator getInclusiveRuleOperator() {
      com.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator result = com.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator.forNumber(inclusiveRuleOperator_);
      return result == null ? com.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Operator that defines how the inclusive operands are combined.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator inclusive_rule_operator = 1;</code>
     * @param value The inclusiveRuleOperator to set.
     * @return This builder for chaining.
     */
    public Builder setInclusiveRuleOperator(com.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      inclusiveRuleOperator_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Operator that defines how the inclusive operands are combined.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.UserListFlexibleRuleOperatorEnum.UserListFlexibleRuleOperator inclusive_rule_operator = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearInclusiveRuleOperator() {
      bitField0_ = (bitField0_ & ~0x00000001);
      inclusiveRuleOperator_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo> inclusiveOperands_ =
      java.util.Collections.emptyList();
    private void ensureInclusiveOperandsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        inclusiveOperands_ = new java.util.ArrayList<com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo>(inclusiveOperands_);
        bitField0_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder> inclusiveOperandsBuilder_;

    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public java.util.List<com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo> getInclusiveOperandsList() {
      if (inclusiveOperandsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(inclusiveOperands_);
      } else {
        return inclusiveOperandsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public int getInclusiveOperandsCount() {
      if (inclusiveOperandsBuilder_ == null) {
        return inclusiveOperands_.size();
      } else {
        return inclusiveOperandsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo getInclusiveOperands(int index) {
      if (inclusiveOperandsBuilder_ == null) {
        return inclusiveOperands_.get(index);
      } else {
        return inclusiveOperandsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public Builder setInclusiveOperands(
        int index, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo value) {
      if (inclusiveOperandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInclusiveOperandsIsMutable();
        inclusiveOperands_.set(index, value);
        onChanged();
      } else {
        inclusiveOperandsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public Builder setInclusiveOperands(
        int index, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder builderForValue) {
      if (inclusiveOperandsBuilder_ == null) {
        ensureInclusiveOperandsIsMutable();
        inclusiveOperands_.set(index, builderForValue.build());
        onChanged();
      } else {
        inclusiveOperandsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public Builder addInclusiveOperands(com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo value) {
      if (inclusiveOperandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInclusiveOperandsIsMutable();
        inclusiveOperands_.add(value);
        onChanged();
      } else {
        inclusiveOperandsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public Builder addInclusiveOperands(
        int index, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo value) {
      if (inclusiveOperandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInclusiveOperandsIsMutable();
        inclusiveOperands_.add(index, value);
        onChanged();
      } else {
        inclusiveOperandsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public Builder addInclusiveOperands(
        com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder builderForValue) {
      if (inclusiveOperandsBuilder_ == null) {
        ensureInclusiveOperandsIsMutable();
        inclusiveOperands_.add(builderForValue.build());
        onChanged();
      } else {
        inclusiveOperandsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public Builder addInclusiveOperands(
        int index, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder builderForValue) {
      if (inclusiveOperandsBuilder_ == null) {
        ensureInclusiveOperandsIsMutable();
        inclusiveOperands_.add(index, builderForValue.build());
        onChanged();
      } else {
        inclusiveOperandsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public Builder addAllInclusiveOperands(
        java.lang.Iterable<? extends com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo> values) {
      if (inclusiveOperandsBuilder_ == null) {
        ensureInclusiveOperandsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, inclusiveOperands_);
        onChanged();
      } else {
        inclusiveOperandsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public Builder clearInclusiveOperands() {
      if (inclusiveOperandsBuilder_ == null) {
        inclusiveOperands_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        inclusiveOperandsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public Builder removeInclusiveOperands(int index) {
      if (inclusiveOperandsBuilder_ == null) {
        ensureInclusiveOperandsIsMutable();
        inclusiveOperands_.remove(index);
        onChanged();
      } else {
        inclusiveOperandsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder getInclusiveOperandsBuilder(
        int index) {
      return getInclusiveOperandsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder getInclusiveOperandsOrBuilder(
        int index) {
      if (inclusiveOperandsBuilder_ == null) {
        return inclusiveOperands_.get(index);  } else {
        return inclusiveOperandsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder> 
         getInclusiveOperandsOrBuilderList() {
      if (inclusiveOperandsBuilder_ != null) {
        return inclusiveOperandsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(inclusiveOperands_);
      }
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder addInclusiveOperandsBuilder() {
      return getInclusiveOperandsFieldBuilder().addBuilder(
          com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.getDefaultInstance());
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder addInclusiveOperandsBuilder(
        int index) {
      return getInclusiveOperandsFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.getDefaultInstance());
    }
    /**
     * <pre>
     * Rules representing users that should be included in the user list. These
     * are located on the left side of the AND_NOT operator, and joined together
     * by either AND/OR as specified by the inclusive_rule_operator.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo inclusive_operands = 2;</code>
     */
    public java.util.List<com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder> 
         getInclusiveOperandsBuilderList() {
      return getInclusiveOperandsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder> 
        getInclusiveOperandsFieldBuilder() {
      if (inclusiveOperandsBuilder_ == null) {
        inclusiveOperandsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder>(
                inclusiveOperands_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        inclusiveOperands_ = null;
      }
      return inclusiveOperandsBuilder_;
    }

    private java.util.List<com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo> exclusiveOperands_ =
      java.util.Collections.emptyList();
    private void ensureExclusiveOperandsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        exclusiveOperands_ = new java.util.ArrayList<com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo>(exclusiveOperands_);
        bitField0_ |= 0x00000004;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder> exclusiveOperandsBuilder_;

    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public java.util.List<com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo> getExclusiveOperandsList() {
      if (exclusiveOperandsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(exclusiveOperands_);
      } else {
        return exclusiveOperandsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public int getExclusiveOperandsCount() {
      if (exclusiveOperandsBuilder_ == null) {
        return exclusiveOperands_.size();
      } else {
        return exclusiveOperandsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo getExclusiveOperands(int index) {
      if (exclusiveOperandsBuilder_ == null) {
        return exclusiveOperands_.get(index);
      } else {
        return exclusiveOperandsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public Builder setExclusiveOperands(
        int index, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo value) {
      if (exclusiveOperandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusiveOperandsIsMutable();
        exclusiveOperands_.set(index, value);
        onChanged();
      } else {
        exclusiveOperandsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public Builder setExclusiveOperands(
        int index, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder builderForValue) {
      if (exclusiveOperandsBuilder_ == null) {
        ensureExclusiveOperandsIsMutable();
        exclusiveOperands_.set(index, builderForValue.build());
        onChanged();
      } else {
        exclusiveOperandsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public Builder addExclusiveOperands(com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo value) {
      if (exclusiveOperandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusiveOperandsIsMutable();
        exclusiveOperands_.add(value);
        onChanged();
      } else {
        exclusiveOperandsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public Builder addExclusiveOperands(
        int index, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo value) {
      if (exclusiveOperandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusiveOperandsIsMutable();
        exclusiveOperands_.add(index, value);
        onChanged();
      } else {
        exclusiveOperandsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public Builder addExclusiveOperands(
        com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder builderForValue) {
      if (exclusiveOperandsBuilder_ == null) {
        ensureExclusiveOperandsIsMutable();
        exclusiveOperands_.add(builderForValue.build());
        onChanged();
      } else {
        exclusiveOperandsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public Builder addExclusiveOperands(
        int index, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder builderForValue) {
      if (exclusiveOperandsBuilder_ == null) {
        ensureExclusiveOperandsIsMutable();
        exclusiveOperands_.add(index, builderForValue.build());
        onChanged();
      } else {
        exclusiveOperandsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public Builder addAllExclusiveOperands(
        java.lang.Iterable<? extends com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo> values) {
      if (exclusiveOperandsBuilder_ == null) {
        ensureExclusiveOperandsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, exclusiveOperands_);
        onChanged();
      } else {
        exclusiveOperandsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public Builder clearExclusiveOperands() {
      if (exclusiveOperandsBuilder_ == null) {
        exclusiveOperands_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        exclusiveOperandsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public Builder removeExclusiveOperands(int index) {
      if (exclusiveOperandsBuilder_ == null) {
        ensureExclusiveOperandsIsMutable();
        exclusiveOperands_.remove(index);
        onChanged();
      } else {
        exclusiveOperandsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder getExclusiveOperandsBuilder(
        int index) {
      return getExclusiveOperandsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder getExclusiveOperandsOrBuilder(
        int index) {
      if (exclusiveOperandsBuilder_ == null) {
        return exclusiveOperands_.get(index);  } else {
        return exclusiveOperandsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder> 
         getExclusiveOperandsOrBuilderList() {
      if (exclusiveOperandsBuilder_ != null) {
        return exclusiveOperandsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(exclusiveOperands_);
      }
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder addExclusiveOperandsBuilder() {
      return getExclusiveOperandsFieldBuilder().addBuilder(
          com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.getDefaultInstance());
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder addExclusiveOperandsBuilder(
        int index) {
      return getExclusiveOperandsFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.getDefaultInstance());
    }
    /**
     * <pre>
     * Rules representing users that should be excluded from the user list. These
     * are located on the right side of the AND_NOT operator, and joined together
     * by OR.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v20.common.FlexibleRuleOperandInfo exclusive_operands = 3;</code>
     */
    public java.util.List<com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder> 
         getExclusiveOperandsBuilderList() {
      return getExclusiveOperandsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder> 
        getExclusiveOperandsFieldBuilder() {
      if (exclusiveOperandsBuilder_ == null) {
        exclusiveOperandsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfo.Builder, com.google.ads.googleads.v20.common.FlexibleRuleOperandInfoOrBuilder>(
                exclusiveOperands_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        exclusiveOperands_ = null;
      }
      return exclusiveOperandsBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v20.common.FlexibleRuleUserListInfo)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v20.common.FlexibleRuleUserListInfo)
  private static final com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo();
  }

  public static com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FlexibleRuleUserListInfo>
      PARSER = new com.google.protobuf.AbstractParser<FlexibleRuleUserListInfo>() {
    @java.lang.Override
    public FlexibleRuleUserListInfo parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<FlexibleRuleUserListInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FlexibleRuleUserListInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v20.common.FlexibleRuleUserListInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

