// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v20/resources/ad_group_criterion_simulation.proto

// Protobuf Java Version: 3.25.7
package com.google.ads.googleads.v20.resources;

/**
 * <pre>
 * An ad group criterion simulation. Supported combinations of advertising
 * channel type, criterion type, simulation type, and simulation modification
 * method are detailed below respectively. Hotel AdGroupCriterion simulation
 * operations starting in V5.
 *
 * 1. DISPLAY - KEYWORD - CPC_BID - UNIFORM
 * 2. SEARCH - KEYWORD - CPC_BID - UNIFORM
 * 3. SHOPPING - LISTING_GROUP - CPC_BID - UNIFORM
 * 4. HOTEL - LISTING_GROUP - CPC_BID - UNIFORM
 * 5. HOTEL - LISTING_GROUP - PERCENT_CPC_BID - UNIFORM
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v20.resources.AdGroupCriterionSimulation}
 */
public final class AdGroupCriterionSimulation extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v20.resources.AdGroupCriterionSimulation)
    AdGroupCriterionSimulationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use AdGroupCriterionSimulation.newBuilder() to construct.
  private AdGroupCriterionSimulation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private AdGroupCriterionSimulation() {
    resourceName_ = "";
    type_ = 0;
    modificationMethod_ = 0;
    startDate_ = "";
    endDate_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new AdGroupCriterionSimulation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v20.resources.AdGroupCriterionSimulationProto.internal_static_google_ads_googleads_v20_resources_AdGroupCriterionSimulation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v20.resources.AdGroupCriterionSimulationProto.internal_static_google_ads_googleads_v20_resources_AdGroupCriterionSimulation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation.class, com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation.Builder.class);
  }

  private int bitField0_;
  private int pointListCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object pointList_;
  public enum PointListCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CPC_BID_POINT_LIST(8),
    PERCENT_CPC_BID_POINT_LIST(13),
    POINTLIST_NOT_SET(0);
    private final int value;
    private PointListCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PointListCase valueOf(int value) {
      return forNumber(value);
    }

    public static PointListCase forNumber(int value) {
      switch (value) {
        case 8: return CPC_BID_POINT_LIST;
        case 13: return PERCENT_CPC_BID_POINT_LIST;
        case 0: return POINTLIST_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public PointListCase
  getPointListCase() {
    return PointListCase.forNumber(
        pointListCase_);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Output only. The resource name of the ad group criterion simulation.
   * Ad group criterion simulation resource names have the form:
   *
   * `customers/{customer_id}/adGroupCriterionSimulations/{ad_group_id}~{criterion_id}~{type}~{modification_method}~{start_date}~{end_date}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name of the ad group criterion simulation.
   * Ad group criterion simulation resource names have the form:
   *
   * `customers/{customer_id}/adGroupCriterionSimulations/{ad_group_id}~{criterion_id}~{type}~{modification_method}~{start_date}~{end_date}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AD_GROUP_ID_FIELD_NUMBER = 9;
  private long adGroupId_ = 0L;
  /**
   * <pre>
   * Output only. AdGroup ID of the simulation.
   * </pre>
   *
   * <code>optional int64 ad_group_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the adGroupId field is set.
   */
  @java.lang.Override
  public boolean hasAdGroupId() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Output only. AdGroup ID of the simulation.
   * </pre>
   *
   * <code>optional int64 ad_group_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The adGroupId.
   */
  @java.lang.Override
  public long getAdGroupId() {
    return adGroupId_;
  }

  public static final int CRITERION_ID_FIELD_NUMBER = 10;
  private long criterionId_ = 0L;
  /**
   * <pre>
   * Output only. Criterion ID of the simulation.
   * </pre>
   *
   * <code>optional int64 criterion_id = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the criterionId field is set.
   */
  @java.lang.Override
  public boolean hasCriterionId() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Output only. Criterion ID of the simulation.
   * </pre>
   *
   * <code>optional int64 criterion_id = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The criterionId.
   */
  @java.lang.Override
  public long getCriterionId() {
    return criterionId_;
  }

  public static final int TYPE_FIELD_NUMBER = 4;
  private int type_ = 0;
  /**
   * <pre>
   * Output only. The field that the simulation modifies.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Output only. The field that the simulation modifies.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The type.
   */
  @java.lang.Override public com.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType getType() {
    com.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType result = com.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType.forNumber(type_);
    return result == null ? com.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType.UNRECOGNIZED : result;
  }

  public static final int MODIFICATION_METHOD_FIELD_NUMBER = 5;
  private int modificationMethod_ = 0;
  /**
   * <pre>
   * Output only. How the simulation modifies the field.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for modificationMethod.
   */
  @java.lang.Override public int getModificationMethodValue() {
    return modificationMethod_;
  }
  /**
   * <pre>
   * Output only. How the simulation modifies the field.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The modificationMethod.
   */
  @java.lang.Override public com.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod getModificationMethod() {
    com.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod result = com.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod.forNumber(modificationMethod_);
    return result == null ? com.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNRECOGNIZED : result;
  }

  public static final int START_DATE_FIELD_NUMBER = 11;
  @SuppressWarnings("serial")
  private volatile java.lang.Object startDate_ = "";
  /**
   * <pre>
   * Output only. First day on which the simulation is based, in YYYY-MM-DD
   * format.
   * </pre>
   *
   * <code>optional string start_date = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the startDate field is set.
   */
  @java.lang.Override
  public boolean hasStartDate() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Output only. First day on which the simulation is based, in YYYY-MM-DD
   * format.
   * </pre>
   *
   * <code>optional string start_date = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The startDate.
   */
  @java.lang.Override
  public java.lang.String getStartDate() {
    java.lang.Object ref = startDate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startDate_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. First day on which the simulation is based, in YYYY-MM-DD
   * format.
   * </pre>
   *
   * <code>optional string start_date = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for startDate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getStartDateBytes() {
    java.lang.Object ref = startDate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      startDate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int END_DATE_FIELD_NUMBER = 12;
  @SuppressWarnings("serial")
  private volatile java.lang.Object endDate_ = "";
  /**
   * <pre>
   * Output only. Last day on which the simulation is based, in YYYY-MM-DD
   * format.
   * </pre>
   *
   * <code>optional string end_date = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the endDate field is set.
   */
  @java.lang.Override
  public boolean hasEndDate() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Output only. Last day on which the simulation is based, in YYYY-MM-DD
   * format.
   * </pre>
   *
   * <code>optional string end_date = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The endDate.
   */
  @java.lang.Override
  public java.lang.String getEndDate() {
    java.lang.Object ref = endDate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endDate_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Last day on which the simulation is based, in YYYY-MM-DD
   * format.
   * </pre>
   *
   * <code>optional string end_date = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for endDate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getEndDateBytes() {
    java.lang.Object ref = endDate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      endDate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CPC_BID_POINT_LIST_FIELD_NUMBER = 8;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is CPC_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the cpcBidPointList field is set.
   */
  @java.lang.Override
  public boolean hasCpcBidPointList() {
    return pointListCase_ == 8;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is CPC_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The cpcBidPointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.common.CpcBidSimulationPointList getCpcBidPointList() {
    if (pointListCase_ == 8) {
       return (com.google.ads.googleads.v20.common.CpcBidSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v20.common.CpcBidSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is CPC_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.common.CpcBidSimulationPointListOrBuilder getCpcBidPointListOrBuilder() {
    if (pointListCase_ == 8) {
       return (com.google.ads.googleads.v20.common.CpcBidSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v20.common.CpcBidSimulationPointList.getDefaultInstance();
  }

  public static final int PERCENT_CPC_BID_POINT_LIST_FIELD_NUMBER = 13;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is PERCENT_CPC_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList percent_cpc_bid_point_list = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the percentCpcBidPointList field is set.
   */
  @java.lang.Override
  public boolean hasPercentCpcBidPointList() {
    return pointListCase_ == 13;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is PERCENT_CPC_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList percent_cpc_bid_point_list = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The percentCpcBidPointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList getPercentCpcBidPointList() {
    if (pointListCase_ == 13) {
       return (com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is PERCENT_CPC_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList percent_cpc_bid_point_list = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointListOrBuilder getPercentCpcBidPointListOrBuilder() {
    if (pointListCase_ == 13) {
       return (com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (type_ != com.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType.UNSPECIFIED.getNumber()) {
      output.writeEnum(4, type_);
    }
    if (modificationMethod_ != com.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNSPECIFIED.getNumber()) {
      output.writeEnum(5, modificationMethod_);
    }
    if (pointListCase_ == 8) {
      output.writeMessage(8, (com.google.ads.googleads.v20.common.CpcBidSimulationPointList) pointList_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(9, adGroupId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(10, criterionId_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, startDate_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, endDate_);
    }
    if (pointListCase_ == 13) {
      output.writeMessage(13, (com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList) pointList_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (type_ != com.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, type_);
    }
    if (modificationMethod_ != com.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(5, modificationMethod_);
    }
    if (pointListCase_ == 8) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, (com.google.ads.googleads.v20.common.CpcBidSimulationPointList) pointList_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(9, adGroupId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(10, criterionId_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, startDate_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, endDate_);
    }
    if (pointListCase_ == 13) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(13, (com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList) pointList_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation other = (com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (hasAdGroupId() != other.hasAdGroupId()) return false;
    if (hasAdGroupId()) {
      if (getAdGroupId()
          != other.getAdGroupId()) return false;
    }
    if (hasCriterionId() != other.hasCriterionId()) return false;
    if (hasCriterionId()) {
      if (getCriterionId()
          != other.getCriterionId()) return false;
    }
    if (type_ != other.type_) return false;
    if (modificationMethod_ != other.modificationMethod_) return false;
    if (hasStartDate() != other.hasStartDate()) return false;
    if (hasStartDate()) {
      if (!getStartDate()
          .equals(other.getStartDate())) return false;
    }
    if (hasEndDate() != other.hasEndDate()) return false;
    if (hasEndDate()) {
      if (!getEndDate()
          .equals(other.getEndDate())) return false;
    }
    if (!getPointListCase().equals(other.getPointListCase())) return false;
    switch (pointListCase_) {
      case 8:
        if (!getCpcBidPointList()
            .equals(other.getCpcBidPointList())) return false;
        break;
      case 13:
        if (!getPercentCpcBidPointList()
            .equals(other.getPercentCpcBidPointList())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    if (hasAdGroupId()) {
      hash = (37 * hash) + AD_GROUP_ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getAdGroupId());
    }
    if (hasCriterionId()) {
      hash = (37 * hash) + CRITERION_ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getCriterionId());
    }
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + MODIFICATION_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + modificationMethod_;
    if (hasStartDate()) {
      hash = (37 * hash) + START_DATE_FIELD_NUMBER;
      hash = (53 * hash) + getStartDate().hashCode();
    }
    if (hasEndDate()) {
      hash = (37 * hash) + END_DATE_FIELD_NUMBER;
      hash = (53 * hash) + getEndDate().hashCode();
    }
    switch (pointListCase_) {
      case 8:
        hash = (37 * hash) + CPC_BID_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getCpcBidPointList().hashCode();
        break;
      case 13:
        hash = (37 * hash) + PERCENT_CPC_BID_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getPercentCpcBidPointList().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * An ad group criterion simulation. Supported combinations of advertising
   * channel type, criterion type, simulation type, and simulation modification
   * method are detailed below respectively. Hotel AdGroupCriterion simulation
   * operations starting in V5.
   *
   * 1. DISPLAY - KEYWORD - CPC_BID - UNIFORM
   * 2. SEARCH - KEYWORD - CPC_BID - UNIFORM
   * 3. SHOPPING - LISTING_GROUP - CPC_BID - UNIFORM
   * 4. HOTEL - LISTING_GROUP - CPC_BID - UNIFORM
   * 5. HOTEL - LISTING_GROUP - PERCENT_CPC_BID - UNIFORM
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v20.resources.AdGroupCriterionSimulation}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v20.resources.AdGroupCriterionSimulation)
      com.google.ads.googleads.v20.resources.AdGroupCriterionSimulationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v20.resources.AdGroupCriterionSimulationProto.internal_static_google_ads_googleads_v20_resources_AdGroupCriterionSimulation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v20.resources.AdGroupCriterionSimulationProto.internal_static_google_ads_googleads_v20_resources_AdGroupCriterionSimulation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation.class, com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation.Builder.class);
    }

    // Construct using com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      adGroupId_ = 0L;
      criterionId_ = 0L;
      type_ = 0;
      modificationMethod_ = 0;
      startDate_ = "";
      endDate_ = "";
      if (cpcBidPointListBuilder_ != null) {
        cpcBidPointListBuilder_.clear();
      }
      if (percentCpcBidPointListBuilder_ != null) {
        percentCpcBidPointListBuilder_.clear();
      }
      pointListCase_ = 0;
      pointList_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v20.resources.AdGroupCriterionSimulationProto.internal_static_google_ads_googleads_v20_resources_AdGroupCriterionSimulation_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation getDefaultInstanceForType() {
      return com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation build() {
      com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation buildPartial() {
      com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation result = new com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.adGroupId_ = adGroupId_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.criterionId_ = criterionId_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.modificationMethod_ = modificationMethod_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.startDate_ = startDate_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.endDate_ = endDate_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation result) {
      result.pointListCase_ = pointListCase_;
      result.pointList_ = this.pointList_;
      if (pointListCase_ == 8 &&
          cpcBidPointListBuilder_ != null) {
        result.pointList_ = cpcBidPointListBuilder_.build();
      }
      if (pointListCase_ == 13 &&
          percentCpcBidPointListBuilder_ != null) {
        result.pointList_ = percentCpcBidPointListBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation) {
        return mergeFrom((com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation other) {
      if (other == com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasAdGroupId()) {
        setAdGroupId(other.getAdGroupId());
      }
      if (other.hasCriterionId()) {
        setCriterionId(other.getCriterionId());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.modificationMethod_ != 0) {
        setModificationMethodValue(other.getModificationMethodValue());
      }
      if (other.hasStartDate()) {
        startDate_ = other.startDate_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasEndDate()) {
        endDate_ = other.endDate_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      switch (other.getPointListCase()) {
        case CPC_BID_POINT_LIST: {
          mergeCpcBidPointList(other.getCpcBidPointList());
          break;
        }
        case PERCENT_CPC_BID_POINT_LIST: {
          mergePercentCpcBidPointList(other.getPercentCpcBidPointList());
          break;
        }
        case POINTLIST_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 32: {
              type_ = input.readEnum();
              bitField0_ |= 0x00000008;
              break;
            } // case 32
            case 40: {
              modificationMethod_ = input.readEnum();
              bitField0_ |= 0x00000010;
              break;
            } // case 40
            case 66: {
              input.readMessage(
                  getCpcBidPointListFieldBuilder().getBuilder(),
                  extensionRegistry);
              pointListCase_ = 8;
              break;
            } // case 66
            case 72: {
              adGroupId_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 72
            case 80: {
              criterionId_ = input.readInt64();
              bitField0_ |= 0x00000004;
              break;
            } // case 80
            case 90: {
              startDate_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000020;
              break;
            } // case 90
            case 98: {
              endDate_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000040;
              break;
            } // case 98
            case 106: {
              input.readMessage(
                  getPercentCpcBidPointListFieldBuilder().getBuilder(),
                  extensionRegistry);
              pointListCase_ = 13;
              break;
            } // case 106
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int pointListCase_ = 0;
    private java.lang.Object pointList_;
    public PointListCase
        getPointListCase() {
      return PointListCase.forNumber(
          pointListCase_);
    }

    public Builder clearPointList() {
      pointListCase_ = 0;
      pointList_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Output only. The resource name of the ad group criterion simulation.
     * Ad group criterion simulation resource names have the form:
     *
     * `customers/{customer_id}/adGroupCriterionSimulations/{ad_group_id}~{criterion_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the ad group criterion simulation.
     * Ad group criterion simulation resource names have the form:
     *
     * `customers/{customer_id}/adGroupCriterionSimulations/{ad_group_id}~{criterion_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the ad group criterion simulation.
     * Ad group criterion simulation resource names have the form:
     *
     * `customers/{customer_id}/adGroupCriterionSimulations/{ad_group_id}~{criterion_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the ad group criterion simulation.
     * Ad group criterion simulation resource names have the form:
     *
     * `customers/{customer_id}/adGroupCriterionSimulations/{ad_group_id}~{criterion_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the ad group criterion simulation.
     * Ad group criterion simulation resource names have the form:
     *
     * `customers/{customer_id}/adGroupCriterionSimulations/{ad_group_id}~{criterion_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long adGroupId_ ;
    /**
     * <pre>
     * Output only. AdGroup ID of the simulation.
     * </pre>
     *
     * <code>optional int64 ad_group_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the adGroupId field is set.
     */
    @java.lang.Override
    public boolean hasAdGroupId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Output only. AdGroup ID of the simulation.
     * </pre>
     *
     * <code>optional int64 ad_group_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The adGroupId.
     */
    @java.lang.Override
    public long getAdGroupId() {
      return adGroupId_;
    }
    /**
     * <pre>
     * Output only. AdGroup ID of the simulation.
     * </pre>
     *
     * <code>optional int64 ad_group_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The adGroupId to set.
     * @return This builder for chaining.
     */
    public Builder setAdGroupId(long value) {

      adGroupId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. AdGroup ID of the simulation.
     * </pre>
     *
     * <code>optional int64 ad_group_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearAdGroupId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      adGroupId_ = 0L;
      onChanged();
      return this;
    }

    private long criterionId_ ;
    /**
     * <pre>
     * Output only. Criterion ID of the simulation.
     * </pre>
     *
     * <code>optional int64 criterion_id = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the criterionId field is set.
     */
    @java.lang.Override
    public boolean hasCriterionId() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Output only. Criterion ID of the simulation.
     * </pre>
     *
     * <code>optional int64 criterion_id = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The criterionId.
     */
    @java.lang.Override
    public long getCriterionId() {
      return criterionId_;
    }
    /**
     * <pre>
     * Output only. Criterion ID of the simulation.
     * </pre>
     *
     * <code>optional int64 criterion_id = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The criterionId to set.
     * @return This builder for chaining.
     */
    public Builder setCriterionId(long value) {

      criterionId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Criterion ID of the simulation.
     * </pre>
     *
     * <code>optional int64 criterion_id = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCriterionId() {
      bitField0_ = (bitField0_ & ~0x00000004);
      criterionId_ = 0L;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The type.
     */
    @java.lang.Override
    public com.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType getType() {
      com.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType result = com.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType.forNumber(type_);
      return result == null ? com.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.SimulationTypeEnum.SimulationType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      type_ = 0;
      onChanged();
      return this;
    }

    private int modificationMethod_ = 0;
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for modificationMethod.
     */
    @java.lang.Override public int getModificationMethodValue() {
      return modificationMethod_;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for modificationMethod to set.
     * @return This builder for chaining.
     */
    public Builder setModificationMethodValue(int value) {
      modificationMethod_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The modificationMethod.
     */
    @java.lang.Override
    public com.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod getModificationMethod() {
      com.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod result = com.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod.forNumber(modificationMethod_);
      return result == null ? com.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The modificationMethod to set.
     * @return This builder for chaining.
     */
    public Builder setModificationMethod(com.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      modificationMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearModificationMethod() {
      bitField0_ = (bitField0_ & ~0x00000010);
      modificationMethod_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object startDate_ = "";
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>optional string start_date = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the startDate field is set.
     */
    public boolean hasStartDate() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>optional string start_date = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The startDate.
     */
    public java.lang.String getStartDate() {
      java.lang.Object ref = startDate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startDate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>optional string start_date = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for startDate.
     */
    public com.google.protobuf.ByteString
        getStartDateBytes() {
      java.lang.Object ref = startDate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        startDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>optional string start_date = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The startDate to set.
     * @return This builder for chaining.
     */
    public Builder setStartDate(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      startDate_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>optional string start_date = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearStartDate() {
      startDate_ = getDefaultInstance().getStartDate();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>optional string start_date = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for startDate to set.
     * @return This builder for chaining.
     */
    public Builder setStartDateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      startDate_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object endDate_ = "";
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>optional string end_date = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the endDate field is set.
     */
    public boolean hasEndDate() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>optional string end_date = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The endDate.
     */
    public java.lang.String getEndDate() {
      java.lang.Object ref = endDate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endDate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>optional string end_date = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for endDate.
     */
    public com.google.protobuf.ByteString
        getEndDateBytes() {
      java.lang.Object ref = endDate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        endDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>optional string end_date = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The endDate to set.
     * @return This builder for chaining.
     */
    public Builder setEndDate(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      endDate_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>optional string end_date = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearEndDate() {
      endDate_ = getDefaultInstance().getEndDate();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD
     * format.
     * </pre>
     *
     * <code>optional string end_date = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for endDate to set.
     * @return This builder for chaining.
     */
    public Builder setEndDateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      endDate_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v20.common.CpcBidSimulationPointList, com.google.ads.googleads.v20.common.CpcBidSimulationPointList.Builder, com.google.ads.googleads.v20.common.CpcBidSimulationPointListOrBuilder> cpcBidPointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the cpcBidPointList field is set.
     */
    @java.lang.Override
    public boolean hasCpcBidPointList() {
      return pointListCase_ == 8;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The cpcBidPointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v20.common.CpcBidSimulationPointList getCpcBidPointList() {
      if (cpcBidPointListBuilder_ == null) {
        if (pointListCase_ == 8) {
          return (com.google.ads.googleads.v20.common.CpcBidSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v20.common.CpcBidSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 8) {
          return cpcBidPointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v20.common.CpcBidSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setCpcBidPointList(com.google.ads.googleads.v20.common.CpcBidSimulationPointList value) {
      if (cpcBidPointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        cpcBidPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setCpcBidPointList(
        com.google.ads.googleads.v20.common.CpcBidSimulationPointList.Builder builderForValue) {
      if (cpcBidPointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        cpcBidPointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeCpcBidPointList(com.google.ads.googleads.v20.common.CpcBidSimulationPointList value) {
      if (cpcBidPointListBuilder_ == null) {
        if (pointListCase_ == 8 &&
            pointList_ != com.google.ads.googleads.v20.common.CpcBidSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v20.common.CpcBidSimulationPointList.newBuilder((com.google.ads.googleads.v20.common.CpcBidSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 8) {
          cpcBidPointListBuilder_.mergeFrom(value);
        } else {
          cpcBidPointListBuilder_.setMessage(value);
        }
      }
      pointListCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearCpcBidPointList() {
      if (cpcBidPointListBuilder_ == null) {
        if (pointListCase_ == 8) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 8) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        cpcBidPointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v20.common.CpcBidSimulationPointList.Builder getCpcBidPointListBuilder() {
      return getCpcBidPointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v20.common.CpcBidSimulationPointListOrBuilder getCpcBidPointListOrBuilder() {
      if ((pointListCase_ == 8) && (cpcBidPointListBuilder_ != null)) {
        return cpcBidPointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 8) {
          return (com.google.ads.googleads.v20.common.CpcBidSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v20.common.CpcBidSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v20.common.CpcBidSimulationPointList, com.google.ads.googleads.v20.common.CpcBidSimulationPointList.Builder, com.google.ads.googleads.v20.common.CpcBidSimulationPointListOrBuilder> 
        getCpcBidPointListFieldBuilder() {
      if (cpcBidPointListBuilder_ == null) {
        if (!(pointListCase_ == 8)) {
          pointList_ = com.google.ads.googleads.v20.common.CpcBidSimulationPointList.getDefaultInstance();
        }
        cpcBidPointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v20.common.CpcBidSimulationPointList, com.google.ads.googleads.v20.common.CpcBidSimulationPointList.Builder, com.google.ads.googleads.v20.common.CpcBidSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v20.common.CpcBidSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 8;
      onChanged();
      return cpcBidPointListBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList, com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.Builder, com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointListOrBuilder> percentCpcBidPointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is PERCENT_CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList percent_cpc_bid_point_list = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the percentCpcBidPointList field is set.
     */
    @java.lang.Override
    public boolean hasPercentCpcBidPointList() {
      return pointListCase_ == 13;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is PERCENT_CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList percent_cpc_bid_point_list = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The percentCpcBidPointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList getPercentCpcBidPointList() {
      if (percentCpcBidPointListBuilder_ == null) {
        if (pointListCase_ == 13) {
          return (com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 13) {
          return percentCpcBidPointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is PERCENT_CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList percent_cpc_bid_point_list = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setPercentCpcBidPointList(com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList value) {
      if (percentCpcBidPointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        percentCpcBidPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 13;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is PERCENT_CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList percent_cpc_bid_point_list = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setPercentCpcBidPointList(
        com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.Builder builderForValue) {
      if (percentCpcBidPointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        percentCpcBidPointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 13;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is PERCENT_CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList percent_cpc_bid_point_list = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergePercentCpcBidPointList(com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList value) {
      if (percentCpcBidPointListBuilder_ == null) {
        if (pointListCase_ == 13 &&
            pointList_ != com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.newBuilder((com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 13) {
          percentCpcBidPointListBuilder_.mergeFrom(value);
        } else {
          percentCpcBidPointListBuilder_.setMessage(value);
        }
      }
      pointListCase_ = 13;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is PERCENT_CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList percent_cpc_bid_point_list = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearPercentCpcBidPointList() {
      if (percentCpcBidPointListBuilder_ == null) {
        if (pointListCase_ == 13) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 13) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        percentCpcBidPointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is PERCENT_CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList percent_cpc_bid_point_list = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.Builder getPercentCpcBidPointListBuilder() {
      return getPercentCpcBidPointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is PERCENT_CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList percent_cpc_bid_point_list = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointListOrBuilder getPercentCpcBidPointListOrBuilder() {
      if ((pointListCase_ == 13) && (percentCpcBidPointListBuilder_ != null)) {
        return percentCpcBidPointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 13) {
          return (com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is PERCENT_CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList percent_cpc_bid_point_list = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList, com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.Builder, com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointListOrBuilder> 
        getPercentCpcBidPointListFieldBuilder() {
      if (percentCpcBidPointListBuilder_ == null) {
        if (!(pointListCase_ == 13)) {
          pointList_ = com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.getDefaultInstance();
        }
        percentCpcBidPointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList, com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList.Builder, com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v20.common.PercentCpcBidSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 13;
      onChanged();
      return percentCpcBidPointListBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v20.resources.AdGroupCriterionSimulation)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v20.resources.AdGroupCriterionSimulation)
  private static final com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation();
  }

  public static com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdGroupCriterionSimulation>
      PARSER = new com.google.protobuf.AbstractParser<AdGroupCriterionSimulation>() {
    @java.lang.Override
    public AdGroupCriterionSimulation parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<AdGroupCriterionSimulation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdGroupCriterionSimulation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v20.resources.AdGroupCriterionSimulation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

