// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v20/resources/local_services_lead.proto

// Protobuf Java Version: 3.25.7
package com.google.ads.googleads.v20.resources;

/**
 * <pre>
 * Data from Local Services Lead.
 * Contains details of Lead which is generated when user calls, messages or
 * books service from advertiser.
 * More info: https://ads.google.com/local-services-ads
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v20.resources.LocalServicesLead}
 */
public final class LocalServicesLead extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v20.resources.LocalServicesLead)
    LocalServicesLeadOrBuilder {
private static final long serialVersionUID = 0L;
  // Use LocalServicesLead.newBuilder() to construct.
  private LocalServicesLead(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private LocalServicesLead() {
    resourceName_ = "";
    categoryId_ = "";
    serviceId_ = "";
    leadType_ = 0;
    leadStatus_ = 0;
    creationDateTime_ = "";
    locale_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new LocalServicesLead();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v20.resources.LocalServicesLeadProto.internal_static_google_ads_googleads_v20_resources_LocalServicesLead_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v20.resources.LocalServicesLeadProto.internal_static_google_ads_googleads_v20_resources_LocalServicesLead_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v20.resources.LocalServicesLead.class, com.google.ads.googleads.v20.resources.LocalServicesLead.Builder.class);
  }

  private int bitField0_;
  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Output only. The resource name of the local services lead data.
   * Local Services Lead resource name have the form
   *
   * `customers/{customer_id}/localServicesLead/{local_services_lead_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name of the local services lead data.
   * Local Services Lead resource name have the form
   *
   * `customers/{customer_id}/localServicesLead/{local_services_lead_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 2;
  private long id_ = 0L;
  /**
   * <pre>
   * Output only. ID of this Lead.
   * </pre>
   *
   * <code>int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int CATEGORY_ID_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private volatile java.lang.Object categoryId_ = "";
  /**
   * <pre>
   * Output only. Service category of the lead. For example:
   * `xcat:service_area_business_hvac`,
   * `xcat:service_area_business_real_estate_agent`, etc.
   * For more details see:
   * https://developers.google.com/google-ads/api/data/codes-formats#local_services_ids
   * </pre>
   *
   * <code>string category_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The categoryId.
   */
  @java.lang.Override
  public java.lang.String getCategoryId() {
    java.lang.Object ref = categoryId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      categoryId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Service category of the lead. For example:
   * `xcat:service_area_business_hvac`,
   * `xcat:service_area_business_real_estate_agent`, etc.
   * For more details see:
   * https://developers.google.com/google-ads/api/data/codes-formats#local_services_ids
   * </pre>
   *
   * <code>string category_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for categoryId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCategoryIdBytes() {
    java.lang.Object ref = categoryId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      categoryId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ID_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceId_ = "";
  /**
   * <pre>
   * Output only. Service for the  category. For example: `buyer_agent`,
   * `seller_agent` for the category of
   * `xcat:service_area_business_real_estate_agent`.
   * </pre>
   *
   * <code>string service_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The serviceId.
   */
  @java.lang.Override
  public java.lang.String getServiceId() {
    java.lang.Object ref = serviceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Service for the  category. For example: `buyer_agent`,
   * `seller_agent` for the category of
   * `xcat:service_area_business_real_estate_agent`.
   * </pre>
   *
   * <code>string service_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for serviceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getServiceIdBytes() {
    java.lang.Object ref = serviceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      serviceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTACT_DETAILS_FIELD_NUMBER = 5;
  private com.google.ads.googleads.v20.resources.ContactDetails contactDetails_;
  /**
   * <pre>
   * Output only. Lead's contact details.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.resources.ContactDetails contact_details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the contactDetails field is set.
   */
  @java.lang.Override
  public boolean hasContactDetails() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Output only. Lead's contact details.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.resources.ContactDetails contact_details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The contactDetails.
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.resources.ContactDetails getContactDetails() {
    return contactDetails_ == null ? com.google.ads.googleads.v20.resources.ContactDetails.getDefaultInstance() : contactDetails_;
  }
  /**
   * <pre>
   * Output only. Lead's contact details.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.resources.ContactDetails contact_details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.resources.ContactDetailsOrBuilder getContactDetailsOrBuilder() {
    return contactDetails_ == null ? com.google.ads.googleads.v20.resources.ContactDetails.getDefaultInstance() : contactDetails_;
  }

  public static final int LEAD_TYPE_FIELD_NUMBER = 6;
  private int leadType_ = 0;
  /**
   * <pre>
   * Output only. Type of Local Services lead: phone, message, booking, etc.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType lead_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for leadType.
   */
  @java.lang.Override public int getLeadTypeValue() {
    return leadType_;
  }
  /**
   * <pre>
   * Output only. Type of Local Services lead: phone, message, booking, etc.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType lead_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The leadType.
   */
  @java.lang.Override public com.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType getLeadType() {
    com.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType result = com.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType.forNumber(leadType_);
    return result == null ? com.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType.UNRECOGNIZED : result;
  }

  public static final int LEAD_STATUS_FIELD_NUMBER = 7;
  private int leadStatus_ = 0;
  /**
   * <pre>
   * Output only. Current status of lead.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus lead_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for leadStatus.
   */
  @java.lang.Override public int getLeadStatusValue() {
    return leadStatus_;
  }
  /**
   * <pre>
   * Output only. Current status of lead.
   * </pre>
   *
   * <code>.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus lead_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The leadStatus.
   */
  @java.lang.Override public com.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus getLeadStatus() {
    com.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus result = com.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus.forNumber(leadStatus_);
    return result == null ? com.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus.UNRECOGNIZED : result;
  }

  public static final int CREATION_DATE_TIME_FIELD_NUMBER = 8;
  @SuppressWarnings("serial")
  private volatile java.lang.Object creationDateTime_ = "";
  /**
   * <pre>
   * Output only. The date time at which lead was created by Local Services Ads.
   * The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads account's timezone.
   * Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
   * </pre>
   *
   * <code>string creation_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The creationDateTime.
   */
  @java.lang.Override
  public java.lang.String getCreationDateTime() {
    java.lang.Object ref = creationDateTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationDateTime_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The date time at which lead was created by Local Services Ads.
   * The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads account's timezone.
   * Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
   * </pre>
   *
   * <code>string creation_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for creationDateTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCreationDateTimeBytes() {
    java.lang.Object ref = creationDateTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      creationDateTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCALE_FIELD_NUMBER = 9;
  @SuppressWarnings("serial")
  private volatile java.lang.Object locale_ = "";
  /**
   * <pre>
   * Output only. Language used by the Local Services provider linked to lead.
   * See https://developers.google.com/google-ads/api/data/codes-formats#locales
   * </pre>
   *
   * <code>string locale = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The locale.
   */
  @java.lang.Override
  public java.lang.String getLocale() {
    java.lang.Object ref = locale_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locale_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Language used by the Local Services provider linked to lead.
   * See https://developers.google.com/google-ads/api/data/codes-formats#locales
   * </pre>
   *
   * <code>string locale = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for locale.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getLocaleBytes() {
    java.lang.Object ref = locale_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      locale_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NOTE_FIELD_NUMBER = 10;
  private com.google.ads.googleads.v20.resources.Note note_;
  /**
   * <pre>
   * Output only. Note added by advertiser for the lead.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v20.resources.Note note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the note field is set.
   */
  @java.lang.Override
  public boolean hasNote() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Output only. Note added by advertiser for the lead.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v20.resources.Note note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The note.
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.resources.Note getNote() {
    return note_ == null ? com.google.ads.googleads.v20.resources.Note.getDefaultInstance() : note_;
  }
  /**
   * <pre>
   * Output only. Note added by advertiser for the lead.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v20.resources.Note note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.resources.NoteOrBuilder getNoteOrBuilder() {
    return note_ == null ? com.google.ads.googleads.v20.resources.Note.getDefaultInstance() : note_;
  }

  public static final int LEAD_CHARGED_FIELD_NUMBER = 11;
  private boolean leadCharged_ = false;
  /**
   * <pre>
   * Output only. True if the advertiser was charged for the lead.
   * </pre>
   *
   * <code>bool lead_charged = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The leadCharged.
   */
  @java.lang.Override
  public boolean getLeadCharged() {
    return leadCharged_;
  }

  public static final int CREDIT_DETAILS_FIELD_NUMBER = 12;
  private com.google.ads.googleads.v20.resources.CreditDetails creditDetails_;
  /**
   * <pre>
   * Output only. Credit details of the lead.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v20.resources.CreditDetails credit_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the creditDetails field is set.
   */
  @java.lang.Override
  public boolean hasCreditDetails() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Output only. Credit details of the lead.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v20.resources.CreditDetails credit_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The creditDetails.
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.resources.CreditDetails getCreditDetails() {
    return creditDetails_ == null ? com.google.ads.googleads.v20.resources.CreditDetails.getDefaultInstance() : creditDetails_;
  }
  /**
   * <pre>
   * Output only. Credit details of the lead.
   * </pre>
   *
   * <code>optional .google.ads.googleads.v20.resources.CreditDetails credit_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v20.resources.CreditDetailsOrBuilder getCreditDetailsOrBuilder() {
    return creditDetails_ == null ? com.google.ads.googleads.v20.resources.CreditDetails.getDefaultInstance() : creditDetails_;
  }

  public static final int LEAD_FEEDBACK_SUBMITTED_FIELD_NUMBER = 13;
  private boolean leadFeedbackSubmitted_ = false;
  /**
   * <pre>
   * Output only. True if the advertiser submitted feedback for the lead.
   * </pre>
   *
   * <code>bool lead_feedback_submitted = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The leadFeedbackSubmitted.
   */
  @java.lang.Override
  public boolean getLeadFeedbackSubmitted() {
    return leadFeedbackSubmitted_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (id_ != 0L) {
      output.writeInt64(2, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(categoryId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, categoryId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, serviceId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getContactDetails());
    }
    if (leadType_ != com.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType.UNSPECIFIED.getNumber()) {
      output.writeEnum(6, leadType_);
    }
    if (leadStatus_ != com.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(7, leadStatus_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creationDateTime_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, creationDateTime_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locale_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, locale_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getNote());
    }
    if (leadCharged_ != false) {
      output.writeBool(11, leadCharged_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(12, getCreditDetails());
    }
    if (leadFeedbackSubmitted_ != false) {
      output.writeBool(13, leadFeedbackSubmitted_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (id_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(2, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(categoryId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, categoryId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, serviceId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getContactDetails());
    }
    if (leadType_ != com.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(6, leadType_);
    }
    if (leadStatus_ != com.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(7, leadStatus_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creationDateTime_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, creationDateTime_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locale_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, locale_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, getNote());
    }
    if (leadCharged_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(11, leadCharged_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(12, getCreditDetails());
    }
    if (leadFeedbackSubmitted_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(13, leadFeedbackSubmitted_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v20.resources.LocalServicesLead)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v20.resources.LocalServicesLead other = (com.google.ads.googleads.v20.resources.LocalServicesLead) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (getId()
        != other.getId()) return false;
    if (!getCategoryId()
        .equals(other.getCategoryId())) return false;
    if (!getServiceId()
        .equals(other.getServiceId())) return false;
    if (hasContactDetails() != other.hasContactDetails()) return false;
    if (hasContactDetails()) {
      if (!getContactDetails()
          .equals(other.getContactDetails())) return false;
    }
    if (leadType_ != other.leadType_) return false;
    if (leadStatus_ != other.leadStatus_) return false;
    if (!getCreationDateTime()
        .equals(other.getCreationDateTime())) return false;
    if (!getLocale()
        .equals(other.getLocale())) return false;
    if (hasNote() != other.hasNote()) return false;
    if (hasNote()) {
      if (!getNote()
          .equals(other.getNote())) return false;
    }
    if (getLeadCharged()
        != other.getLeadCharged()) return false;
    if (hasCreditDetails() != other.hasCreditDetails()) return false;
    if (hasCreditDetails()) {
      if (!getCreditDetails()
          .equals(other.getCreditDetails())) return false;
    }
    if (getLeadFeedbackSubmitted()
        != other.getLeadFeedbackSubmitted()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getId());
    hash = (37 * hash) + CATEGORY_ID_FIELD_NUMBER;
    hash = (53 * hash) + getCategoryId().hashCode();
    hash = (37 * hash) + SERVICE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getServiceId().hashCode();
    if (hasContactDetails()) {
      hash = (37 * hash) + CONTACT_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getContactDetails().hashCode();
    }
    hash = (37 * hash) + LEAD_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + leadType_;
    hash = (37 * hash) + LEAD_STATUS_FIELD_NUMBER;
    hash = (53 * hash) + leadStatus_;
    hash = (37 * hash) + CREATION_DATE_TIME_FIELD_NUMBER;
    hash = (53 * hash) + getCreationDateTime().hashCode();
    hash = (37 * hash) + LOCALE_FIELD_NUMBER;
    hash = (53 * hash) + getLocale().hashCode();
    if (hasNote()) {
      hash = (37 * hash) + NOTE_FIELD_NUMBER;
      hash = (53 * hash) + getNote().hashCode();
    }
    hash = (37 * hash) + LEAD_CHARGED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getLeadCharged());
    if (hasCreditDetails()) {
      hash = (37 * hash) + CREDIT_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getCreditDetails().hashCode();
    }
    hash = (37 * hash) + LEAD_FEEDBACK_SUBMITTED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getLeadFeedbackSubmitted());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v20.resources.LocalServicesLead parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v20.resources.LocalServicesLead parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v20.resources.LocalServicesLead parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v20.resources.LocalServicesLead parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v20.resources.LocalServicesLead parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v20.resources.LocalServicesLead parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v20.resources.LocalServicesLead parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v20.resources.LocalServicesLead parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v20.resources.LocalServicesLead parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v20.resources.LocalServicesLead parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v20.resources.LocalServicesLead parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v20.resources.LocalServicesLead parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v20.resources.LocalServicesLead prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Data from Local Services Lead.
   * Contains details of Lead which is generated when user calls, messages or
   * books service from advertiser.
   * More info: https://ads.google.com/local-services-ads
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v20.resources.LocalServicesLead}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v20.resources.LocalServicesLead)
      com.google.ads.googleads.v20.resources.LocalServicesLeadOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v20.resources.LocalServicesLeadProto.internal_static_google_ads_googleads_v20_resources_LocalServicesLead_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v20.resources.LocalServicesLeadProto.internal_static_google_ads_googleads_v20_resources_LocalServicesLead_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v20.resources.LocalServicesLead.class, com.google.ads.googleads.v20.resources.LocalServicesLead.Builder.class);
    }

    // Construct using com.google.ads.googleads.v20.resources.LocalServicesLead.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getContactDetailsFieldBuilder();
        getNoteFieldBuilder();
        getCreditDetailsFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      id_ = 0L;
      categoryId_ = "";
      serviceId_ = "";
      contactDetails_ = null;
      if (contactDetailsBuilder_ != null) {
        contactDetailsBuilder_.dispose();
        contactDetailsBuilder_ = null;
      }
      leadType_ = 0;
      leadStatus_ = 0;
      creationDateTime_ = "";
      locale_ = "";
      note_ = null;
      if (noteBuilder_ != null) {
        noteBuilder_.dispose();
        noteBuilder_ = null;
      }
      leadCharged_ = false;
      creditDetails_ = null;
      if (creditDetailsBuilder_ != null) {
        creditDetailsBuilder_.dispose();
        creditDetailsBuilder_ = null;
      }
      leadFeedbackSubmitted_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v20.resources.LocalServicesLeadProto.internal_static_google_ads_googleads_v20_resources_LocalServicesLead_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v20.resources.LocalServicesLead getDefaultInstanceForType() {
      return com.google.ads.googleads.v20.resources.LocalServicesLead.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v20.resources.LocalServicesLead build() {
      com.google.ads.googleads.v20.resources.LocalServicesLead result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v20.resources.LocalServicesLead buildPartial() {
      com.google.ads.googleads.v20.resources.LocalServicesLead result = new com.google.ads.googleads.v20.resources.LocalServicesLead(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ads.googleads.v20.resources.LocalServicesLead result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.categoryId_ = categoryId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.serviceId_ = serviceId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.contactDetails_ = contactDetailsBuilder_ == null
            ? contactDetails_
            : contactDetailsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.leadType_ = leadType_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.leadStatus_ = leadStatus_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.creationDateTime_ = creationDateTime_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.locale_ = locale_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.note_ = noteBuilder_ == null
            ? note_
            : noteBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.leadCharged_ = leadCharged_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.creditDetails_ = creditDetailsBuilder_ == null
            ? creditDetails_
            : creditDetailsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.leadFeedbackSubmitted_ = leadFeedbackSubmitted_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v20.resources.LocalServicesLead) {
        return mergeFrom((com.google.ads.googleads.v20.resources.LocalServicesLead)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v20.resources.LocalServicesLead other) {
      if (other == com.google.ads.googleads.v20.resources.LocalServicesLead.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getId() != 0L) {
        setId(other.getId());
      }
      if (!other.getCategoryId().isEmpty()) {
        categoryId_ = other.categoryId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getServiceId().isEmpty()) {
        serviceId_ = other.serviceId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasContactDetails()) {
        mergeContactDetails(other.getContactDetails());
      }
      if (other.leadType_ != 0) {
        setLeadTypeValue(other.getLeadTypeValue());
      }
      if (other.leadStatus_ != 0) {
        setLeadStatusValue(other.getLeadStatusValue());
      }
      if (!other.getCreationDateTime().isEmpty()) {
        creationDateTime_ = other.creationDateTime_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getLocale().isEmpty()) {
        locale_ = other.locale_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasNote()) {
        mergeNote(other.getNote());
      }
      if (other.getLeadCharged() != false) {
        setLeadCharged(other.getLeadCharged());
      }
      if (other.hasCreditDetails()) {
        mergeCreditDetails(other.getCreditDetails());
      }
      if (other.getLeadFeedbackSubmitted() != false) {
        setLeadFeedbackSubmitted(other.getLeadFeedbackSubmitted());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 16: {
              id_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 16
            case 26: {
              categoryId_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000004;
              break;
            } // case 26
            case 34: {
              serviceId_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000008;
              break;
            } // case 34
            case 42: {
              input.readMessage(
                  getContactDetailsFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000010;
              break;
            } // case 42
            case 48: {
              leadType_ = input.readEnum();
              bitField0_ |= 0x00000020;
              break;
            } // case 48
            case 56: {
              leadStatus_ = input.readEnum();
              bitField0_ |= 0x00000040;
              break;
            } // case 56
            case 66: {
              creationDateTime_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000080;
              break;
            } // case 66
            case 74: {
              locale_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000100;
              break;
            } // case 74
            case 82: {
              input.readMessage(
                  getNoteFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000200;
              break;
            } // case 82
            case 88: {
              leadCharged_ = input.readBool();
              bitField0_ |= 0x00000400;
              break;
            } // case 88
            case 98: {
              input.readMessage(
                  getCreditDetailsFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000800;
              break;
            } // case 98
            case 104: {
              leadFeedbackSubmitted_ = input.readBool();
              bitField0_ |= 0x00001000;
              break;
            } // case 104
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Output only. The resource name of the local services lead data.
     * Local Services Lead resource name have the form
     *
     * `customers/{customer_id}/localServicesLead/{local_services_lead_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the local services lead data.
     * Local Services Lead resource name have the form
     *
     * `customers/{customer_id}/localServicesLead/{local_services_lead_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the local services lead data.
     * Local Services Lead resource name have the form
     *
     * `customers/{customer_id}/localServicesLead/{local_services_lead_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the local services lead data.
     * Local Services Lead resource name have the form
     *
     * `customers/{customer_id}/localServicesLead/{local_services_lead_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the local services lead data.
     * Local Services Lead resource name have the form
     *
     * `customers/{customer_id}/localServicesLead/{local_services_lead_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long id_ ;
    /**
     * <pre>
     * Output only. ID of this Lead.
     * </pre>
     *
     * <code>int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     * <pre>
     * Output only. ID of this Lead.
     * </pre>
     *
     * <code>int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. ID of this Lead.
     * </pre>
     *
     * <code>int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object categoryId_ = "";
    /**
     * <pre>
     * Output only. Service category of the lead. For example:
     * `xcat:service_area_business_hvac`,
     * `xcat:service_area_business_real_estate_agent`, etc.
     * For more details see:
     * https://developers.google.com/google-ads/api/data/codes-formats#local_services_ids
     * </pre>
     *
     * <code>string category_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The categoryId.
     */
    public java.lang.String getCategoryId() {
      java.lang.Object ref = categoryId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        categoryId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Service category of the lead. For example:
     * `xcat:service_area_business_hvac`,
     * `xcat:service_area_business_real_estate_agent`, etc.
     * For more details see:
     * https://developers.google.com/google-ads/api/data/codes-formats#local_services_ids
     * </pre>
     *
     * <code>string category_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for categoryId.
     */
    public com.google.protobuf.ByteString
        getCategoryIdBytes() {
      java.lang.Object ref = categoryId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        categoryId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Service category of the lead. For example:
     * `xcat:service_area_business_hvac`,
     * `xcat:service_area_business_real_estate_agent`, etc.
     * For more details see:
     * https://developers.google.com/google-ads/api/data/codes-formats#local_services_ids
     * </pre>
     *
     * <code>string category_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The categoryId to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryId(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      categoryId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Service category of the lead. For example:
     * `xcat:service_area_business_hvac`,
     * `xcat:service_area_business_real_estate_agent`, etc.
     * For more details see:
     * https://developers.google.com/google-ads/api/data/codes-formats#local_services_ids
     * </pre>
     *
     * <code>string category_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCategoryId() {
      categoryId_ = getDefaultInstance().getCategoryId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Service category of the lead. For example:
     * `xcat:service_area_business_hvac`,
     * `xcat:service_area_business_real_estate_agent`, etc.
     * For more details see:
     * https://developers.google.com/google-ads/api/data/codes-formats#local_services_ids
     * </pre>
     *
     * <code>string category_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for categoryId to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      categoryId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object serviceId_ = "";
    /**
     * <pre>
     * Output only. Service for the  category. For example: `buyer_agent`,
     * `seller_agent` for the category of
     * `xcat:service_area_business_real_estate_agent`.
     * </pre>
     *
     * <code>string service_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The serviceId.
     */
    public java.lang.String getServiceId() {
      java.lang.Object ref = serviceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Service for the  category. For example: `buyer_agent`,
     * `seller_agent` for the category of
     * `xcat:service_area_business_real_estate_agent`.
     * </pre>
     *
     * <code>string service_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for serviceId.
     */
    public com.google.protobuf.ByteString
        getServiceIdBytes() {
      java.lang.Object ref = serviceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        serviceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Service for the  category. For example: `buyer_agent`,
     * `seller_agent` for the category of
     * `xcat:service_area_business_real_estate_agent`.
     * </pre>
     *
     * <code>string service_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The serviceId to set.
     * @return This builder for chaining.
     */
    public Builder setServiceId(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      serviceId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Service for the  category. For example: `buyer_agent`,
     * `seller_agent` for the category of
     * `xcat:service_area_business_real_estate_agent`.
     * </pre>
     *
     * <code>string service_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearServiceId() {
      serviceId_ = getDefaultInstance().getServiceId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Service for the  category. For example: `buyer_agent`,
     * `seller_agent` for the category of
     * `xcat:service_area_business_real_estate_agent`.
     * </pre>
     *
     * <code>string service_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for serviceId to set.
     * @return This builder for chaining.
     */
    public Builder setServiceIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      serviceId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.ads.googleads.v20.resources.ContactDetails contactDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v20.resources.ContactDetails, com.google.ads.googleads.v20.resources.ContactDetails.Builder, com.google.ads.googleads.v20.resources.ContactDetailsOrBuilder> contactDetailsBuilder_;
    /**
     * <pre>
     * Output only. Lead's contact details.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.resources.ContactDetails contact_details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the contactDetails field is set.
     */
    public boolean hasContactDetails() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Output only. Lead's contact details.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.resources.ContactDetails contact_details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The contactDetails.
     */
    public com.google.ads.googleads.v20.resources.ContactDetails getContactDetails() {
      if (contactDetailsBuilder_ == null) {
        return contactDetails_ == null ? com.google.ads.googleads.v20.resources.ContactDetails.getDefaultInstance() : contactDetails_;
      } else {
        return contactDetailsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. Lead's contact details.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.resources.ContactDetails contact_details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setContactDetails(com.google.ads.googleads.v20.resources.ContactDetails value) {
      if (contactDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        contactDetails_ = value;
      } else {
        contactDetailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Lead's contact details.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.resources.ContactDetails contact_details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setContactDetails(
        com.google.ads.googleads.v20.resources.ContactDetails.Builder builderForValue) {
      if (contactDetailsBuilder_ == null) {
        contactDetails_ = builderForValue.build();
      } else {
        contactDetailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Lead's contact details.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.resources.ContactDetails contact_details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeContactDetails(com.google.ads.googleads.v20.resources.ContactDetails value) {
      if (contactDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0) &&
          contactDetails_ != null &&
          contactDetails_ != com.google.ads.googleads.v20.resources.ContactDetails.getDefaultInstance()) {
          getContactDetailsBuilder().mergeFrom(value);
        } else {
          contactDetails_ = value;
        }
      } else {
        contactDetailsBuilder_.mergeFrom(value);
      }
      if (contactDetails_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Lead's contact details.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.resources.ContactDetails contact_details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearContactDetails() {
      bitField0_ = (bitField0_ & ~0x00000010);
      contactDetails_ = null;
      if (contactDetailsBuilder_ != null) {
        contactDetailsBuilder_.dispose();
        contactDetailsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Lead's contact details.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.resources.ContactDetails contact_details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v20.resources.ContactDetails.Builder getContactDetailsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getContactDetailsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Lead's contact details.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.resources.ContactDetails contact_details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v20.resources.ContactDetailsOrBuilder getContactDetailsOrBuilder() {
      if (contactDetailsBuilder_ != null) {
        return contactDetailsBuilder_.getMessageOrBuilder();
      } else {
        return contactDetails_ == null ?
            com.google.ads.googleads.v20.resources.ContactDetails.getDefaultInstance() : contactDetails_;
      }
    }
    /**
     * <pre>
     * Output only. Lead's contact details.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.resources.ContactDetails contact_details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v20.resources.ContactDetails, com.google.ads.googleads.v20.resources.ContactDetails.Builder, com.google.ads.googleads.v20.resources.ContactDetailsOrBuilder> 
        getContactDetailsFieldBuilder() {
      if (contactDetailsBuilder_ == null) {
        contactDetailsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v20.resources.ContactDetails, com.google.ads.googleads.v20.resources.ContactDetails.Builder, com.google.ads.googleads.v20.resources.ContactDetailsOrBuilder>(
                getContactDetails(),
                getParentForChildren(),
                isClean());
        contactDetails_ = null;
      }
      return contactDetailsBuilder_;
    }

    private int leadType_ = 0;
    /**
     * <pre>
     * Output only. Type of Local Services lead: phone, message, booking, etc.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType lead_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for leadType.
     */
    @java.lang.Override public int getLeadTypeValue() {
      return leadType_;
    }
    /**
     * <pre>
     * Output only. Type of Local Services lead: phone, message, booking, etc.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType lead_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for leadType to set.
     * @return This builder for chaining.
     */
    public Builder setLeadTypeValue(int value) {
      leadType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Type of Local Services lead: phone, message, booking, etc.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType lead_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The leadType.
     */
    @java.lang.Override
    public com.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType getLeadType() {
      com.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType result = com.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType.forNumber(leadType_);
      return result == null ? com.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. Type of Local Services lead: phone, message, booking, etc.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType lead_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The leadType to set.
     * @return This builder for chaining.
     */
    public Builder setLeadType(com.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      leadType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Type of Local Services lead: phone, message, booking, etc.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.LocalServicesLeadTypeEnum.LeadType lead_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearLeadType() {
      bitField0_ = (bitField0_ & ~0x00000020);
      leadType_ = 0;
      onChanged();
      return this;
    }

    private int leadStatus_ = 0;
    /**
     * <pre>
     * Output only. Current status of lead.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus lead_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for leadStatus.
     */
    @java.lang.Override public int getLeadStatusValue() {
      return leadStatus_;
    }
    /**
     * <pre>
     * Output only. Current status of lead.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus lead_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for leadStatus to set.
     * @return This builder for chaining.
     */
    public Builder setLeadStatusValue(int value) {
      leadStatus_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Current status of lead.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus lead_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The leadStatus.
     */
    @java.lang.Override
    public com.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus getLeadStatus() {
      com.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus result = com.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus.forNumber(leadStatus_);
      return result == null ? com.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. Current status of lead.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus lead_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The leadStatus to set.
     * @return This builder for chaining.
     */
    public Builder setLeadStatus(com.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      leadStatus_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Current status of lead.
     * </pre>
     *
     * <code>.google.ads.googleads.v20.enums.LocalServicesLeadStatusEnum.LeadStatus lead_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearLeadStatus() {
      bitField0_ = (bitField0_ & ~0x00000040);
      leadStatus_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object creationDateTime_ = "";
    /**
     * <pre>
     * Output only. The date time at which lead was created by Local Services Ads.
     * The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads account's timezone.
     * Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
     * </pre>
     *
     * <code>string creation_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The creationDateTime.
     */
    public java.lang.String getCreationDateTime() {
      java.lang.Object ref = creationDateTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationDateTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The date time at which lead was created by Local Services Ads.
     * The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads account's timezone.
     * Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
     * </pre>
     *
     * <code>string creation_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for creationDateTime.
     */
    public com.google.protobuf.ByteString
        getCreationDateTimeBytes() {
      java.lang.Object ref = creationDateTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        creationDateTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The date time at which lead was created by Local Services Ads.
     * The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads account's timezone.
     * Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
     * </pre>
     *
     * <code>string creation_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The creationDateTime to set.
     * @return This builder for chaining.
     */
    public Builder setCreationDateTime(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      creationDateTime_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The date time at which lead was created by Local Services Ads.
     * The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads account's timezone.
     * Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
     * </pre>
     *
     * <code>string creation_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCreationDateTime() {
      creationDateTime_ = getDefaultInstance().getCreationDateTime();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The date time at which lead was created by Local Services Ads.
     * The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads account's timezone.
     * Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
     * </pre>
     *
     * <code>string creation_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for creationDateTime to set.
     * @return This builder for chaining.
     */
    public Builder setCreationDateTimeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      creationDateTime_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object locale_ = "";
    /**
     * <pre>
     * Output only. Language used by the Local Services provider linked to lead.
     * See https://developers.google.com/google-ads/api/data/codes-formats#locales
     * </pre>
     *
     * <code>string locale = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The locale.
     */
    public java.lang.String getLocale() {
      java.lang.Object ref = locale_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locale_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Language used by the Local Services provider linked to lead.
     * See https://developers.google.com/google-ads/api/data/codes-formats#locales
     * </pre>
     *
     * <code>string locale = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for locale.
     */
    public com.google.protobuf.ByteString
        getLocaleBytes() {
      java.lang.Object ref = locale_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        locale_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Language used by the Local Services provider linked to lead.
     * See https://developers.google.com/google-ads/api/data/codes-formats#locales
     * </pre>
     *
     * <code>string locale = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The locale to set.
     * @return This builder for chaining.
     */
    public Builder setLocale(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      locale_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Language used by the Local Services provider linked to lead.
     * See https://developers.google.com/google-ads/api/data/codes-formats#locales
     * </pre>
     *
     * <code>string locale = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearLocale() {
      locale_ = getDefaultInstance().getLocale();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Language used by the Local Services provider linked to lead.
     * See https://developers.google.com/google-ads/api/data/codes-formats#locales
     * </pre>
     *
     * <code>string locale = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for locale to set.
     * @return This builder for chaining.
     */
    public Builder setLocaleBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      locale_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.ads.googleads.v20.resources.Note note_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v20.resources.Note, com.google.ads.googleads.v20.resources.Note.Builder, com.google.ads.googleads.v20.resources.NoteOrBuilder> noteBuilder_;
    /**
     * <pre>
     * Output only. Note added by advertiser for the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.Note note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the note field is set.
     */
    public boolean hasNote() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * Output only. Note added by advertiser for the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.Note note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The note.
     */
    public com.google.ads.googleads.v20.resources.Note getNote() {
      if (noteBuilder_ == null) {
        return note_ == null ? com.google.ads.googleads.v20.resources.Note.getDefaultInstance() : note_;
      } else {
        return noteBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. Note added by advertiser for the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.Note note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setNote(com.google.ads.googleads.v20.resources.Note value) {
      if (noteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        note_ = value;
      } else {
        noteBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Note added by advertiser for the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.Note note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setNote(
        com.google.ads.googleads.v20.resources.Note.Builder builderForValue) {
      if (noteBuilder_ == null) {
        note_ = builderForValue.build();
      } else {
        noteBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Note added by advertiser for the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.Note note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeNote(com.google.ads.googleads.v20.resources.Note value) {
      if (noteBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0) &&
          note_ != null &&
          note_ != com.google.ads.googleads.v20.resources.Note.getDefaultInstance()) {
          getNoteBuilder().mergeFrom(value);
        } else {
          note_ = value;
        }
      } else {
        noteBuilder_.mergeFrom(value);
      }
      if (note_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Note added by advertiser for the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.Note note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearNote() {
      bitField0_ = (bitField0_ & ~0x00000200);
      note_ = null;
      if (noteBuilder_ != null) {
        noteBuilder_.dispose();
        noteBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Note added by advertiser for the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.Note note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v20.resources.Note.Builder getNoteBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getNoteFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Note added by advertiser for the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.Note note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v20.resources.NoteOrBuilder getNoteOrBuilder() {
      if (noteBuilder_ != null) {
        return noteBuilder_.getMessageOrBuilder();
      } else {
        return note_ == null ?
            com.google.ads.googleads.v20.resources.Note.getDefaultInstance() : note_;
      }
    }
    /**
     * <pre>
     * Output only. Note added by advertiser for the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.Note note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v20.resources.Note, com.google.ads.googleads.v20.resources.Note.Builder, com.google.ads.googleads.v20.resources.NoteOrBuilder> 
        getNoteFieldBuilder() {
      if (noteBuilder_ == null) {
        noteBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v20.resources.Note, com.google.ads.googleads.v20.resources.Note.Builder, com.google.ads.googleads.v20.resources.NoteOrBuilder>(
                getNote(),
                getParentForChildren(),
                isClean());
        note_ = null;
      }
      return noteBuilder_;
    }

    private boolean leadCharged_ ;
    /**
     * <pre>
     * Output only. True if the advertiser was charged for the lead.
     * </pre>
     *
     * <code>bool lead_charged = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The leadCharged.
     */
    @java.lang.Override
    public boolean getLeadCharged() {
      return leadCharged_;
    }
    /**
     * <pre>
     * Output only. True if the advertiser was charged for the lead.
     * </pre>
     *
     * <code>bool lead_charged = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The leadCharged to set.
     * @return This builder for chaining.
     */
    public Builder setLeadCharged(boolean value) {

      leadCharged_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. True if the advertiser was charged for the lead.
     * </pre>
     *
     * <code>bool lead_charged = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearLeadCharged() {
      bitField0_ = (bitField0_ & ~0x00000400);
      leadCharged_ = false;
      onChanged();
      return this;
    }

    private com.google.ads.googleads.v20.resources.CreditDetails creditDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v20.resources.CreditDetails, com.google.ads.googleads.v20.resources.CreditDetails.Builder, com.google.ads.googleads.v20.resources.CreditDetailsOrBuilder> creditDetailsBuilder_;
    /**
     * <pre>
     * Output only. Credit details of the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.CreditDetails credit_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the creditDetails field is set.
     */
    public boolean hasCreditDetails() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     * <pre>
     * Output only. Credit details of the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.CreditDetails credit_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The creditDetails.
     */
    public com.google.ads.googleads.v20.resources.CreditDetails getCreditDetails() {
      if (creditDetailsBuilder_ == null) {
        return creditDetails_ == null ? com.google.ads.googleads.v20.resources.CreditDetails.getDefaultInstance() : creditDetails_;
      } else {
        return creditDetailsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. Credit details of the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.CreditDetails credit_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setCreditDetails(com.google.ads.googleads.v20.resources.CreditDetails value) {
      if (creditDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        creditDetails_ = value;
      } else {
        creditDetailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Credit details of the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.CreditDetails credit_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setCreditDetails(
        com.google.ads.googleads.v20.resources.CreditDetails.Builder builderForValue) {
      if (creditDetailsBuilder_ == null) {
        creditDetails_ = builderForValue.build();
      } else {
        creditDetailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Credit details of the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.CreditDetails credit_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeCreditDetails(com.google.ads.googleads.v20.resources.CreditDetails value) {
      if (creditDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0) &&
          creditDetails_ != null &&
          creditDetails_ != com.google.ads.googleads.v20.resources.CreditDetails.getDefaultInstance()) {
          getCreditDetailsBuilder().mergeFrom(value);
        } else {
          creditDetails_ = value;
        }
      } else {
        creditDetailsBuilder_.mergeFrom(value);
      }
      if (creditDetails_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Credit details of the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.CreditDetails credit_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearCreditDetails() {
      bitField0_ = (bitField0_ & ~0x00000800);
      creditDetails_ = null;
      if (creditDetailsBuilder_ != null) {
        creditDetailsBuilder_.dispose();
        creditDetailsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Credit details of the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.CreditDetails credit_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v20.resources.CreditDetails.Builder getCreditDetailsBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getCreditDetailsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Credit details of the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.CreditDetails credit_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v20.resources.CreditDetailsOrBuilder getCreditDetailsOrBuilder() {
      if (creditDetailsBuilder_ != null) {
        return creditDetailsBuilder_.getMessageOrBuilder();
      } else {
        return creditDetails_ == null ?
            com.google.ads.googleads.v20.resources.CreditDetails.getDefaultInstance() : creditDetails_;
      }
    }
    /**
     * <pre>
     * Output only. Credit details of the lead.
     * </pre>
     *
     * <code>optional .google.ads.googleads.v20.resources.CreditDetails credit_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v20.resources.CreditDetails, com.google.ads.googleads.v20.resources.CreditDetails.Builder, com.google.ads.googleads.v20.resources.CreditDetailsOrBuilder> 
        getCreditDetailsFieldBuilder() {
      if (creditDetailsBuilder_ == null) {
        creditDetailsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v20.resources.CreditDetails, com.google.ads.googleads.v20.resources.CreditDetails.Builder, com.google.ads.googleads.v20.resources.CreditDetailsOrBuilder>(
                getCreditDetails(),
                getParentForChildren(),
                isClean());
        creditDetails_ = null;
      }
      return creditDetailsBuilder_;
    }

    private boolean leadFeedbackSubmitted_ ;
    /**
     * <pre>
     * Output only. True if the advertiser submitted feedback for the lead.
     * </pre>
     *
     * <code>bool lead_feedback_submitted = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The leadFeedbackSubmitted.
     */
    @java.lang.Override
    public boolean getLeadFeedbackSubmitted() {
      return leadFeedbackSubmitted_;
    }
    /**
     * <pre>
     * Output only. True if the advertiser submitted feedback for the lead.
     * </pre>
     *
     * <code>bool lead_feedback_submitted = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The leadFeedbackSubmitted to set.
     * @return This builder for chaining.
     */
    public Builder setLeadFeedbackSubmitted(boolean value) {

      leadFeedbackSubmitted_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. True if the advertiser submitted feedback for the lead.
     * </pre>
     *
     * <code>bool lead_feedback_submitted = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearLeadFeedbackSubmitted() {
      bitField0_ = (bitField0_ & ~0x00001000);
      leadFeedbackSubmitted_ = false;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v20.resources.LocalServicesLead)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v20.resources.LocalServicesLead)
  private static final com.google.ads.googleads.v20.resources.LocalServicesLead DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v20.resources.LocalServicesLead();
  }

  public static com.google.ads.googleads.v20.resources.LocalServicesLead getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LocalServicesLead>
      PARSER = new com.google.protobuf.AbstractParser<LocalServicesLead>() {
    @java.lang.Override
    public LocalServicesLead parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<LocalServicesLead> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LocalServicesLead> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v20.resources.LocalServicesLead getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

