/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.services;

import com.google.ads.googleads.v20.common.AdScheduleInfo;
import com.google.ads.googleads.v20.common.AdScheduleInfoOrBuilder;
import com.google.ads.googleads.v20.common.KeywordThemeInfo;
import com.google.ads.googleads.v20.common.KeywordThemeInfoOrBuilder;
import com.google.ads.googleads.v20.common.LocationInfo;
import com.google.ads.googleads.v20.common.LocationInfoOrBuilder;
import com.google.ads.googleads.v20.common.ProximityInfo;
import com.google.ads.googleads.v20.common.ProximityInfoOrBuilder;
import com.google.ads.googleads.v20.services.SmartCampaignSuggestServiceProto;
import com.google.ads.googleads.v20.services.SmartCampaignSuggestionInfoOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SmartCampaignSuggestionInfo
extends GeneratedMessageV3
implements SmartCampaignSuggestionInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    private int businessSettingCase_ = 0;
    private Object businessSetting_;
    private int geoTargetCase_ = 0;
    private Object geoTarget_;
    public static final int FINAL_URL_FIELD_NUMBER = 1;
    private volatile Object finalUrl_ = "";
    public static final int LANGUAGE_CODE_FIELD_NUMBER = 3;
    private volatile Object languageCode_ = "";
    public static final int AD_SCHEDULES_FIELD_NUMBER = 6;
    private List<AdScheduleInfo> adSchedules_;
    public static final int KEYWORD_THEMES_FIELD_NUMBER = 7;
    private List<KeywordThemeInfo> keywordThemes_;
    public static final int BUSINESS_CONTEXT_FIELD_NUMBER = 8;
    public static final int BUSINESS_PROFILE_LOCATION_FIELD_NUMBER = 9;
    public static final int LOCATION_LIST_FIELD_NUMBER = 4;
    public static final int PROXIMITY_FIELD_NUMBER = 5;
    private byte memoizedIsInitialized = (byte)-1;
    private static final SmartCampaignSuggestionInfo DEFAULT_INSTANCE = new SmartCampaignSuggestionInfo();
    private static final Parser<SmartCampaignSuggestionInfo> PARSER = new AbstractParser<SmartCampaignSuggestionInfo>(){

        public SmartCampaignSuggestionInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = SmartCampaignSuggestionInfo.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private SmartCampaignSuggestionInfo(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private SmartCampaignSuggestionInfo() {
        this.finalUrl_ = "";
        this.languageCode_ = "";
        this.adSchedules_ = Collections.emptyList();
        this.keywordThemes_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new SmartCampaignSuggestionInfo();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(SmartCampaignSuggestionInfo.class, Builder.class);
    }

    @Override
    public BusinessSettingCase getBusinessSettingCase() {
        return BusinessSettingCase.forNumber(this.businessSettingCase_);
    }

    @Override
    public GeoTargetCase getGeoTargetCase() {
        return GeoTargetCase.forNumber(this.geoTargetCase_);
    }

    @Override
    public String getFinalUrl() {
        Object ref = this.finalUrl_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.finalUrl_ = s;
        return s;
    }

    @Override
    public ByteString getFinalUrlBytes() {
        Object ref = this.finalUrl_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.finalUrl_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getLanguageCode() {
        Object ref = this.languageCode_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.languageCode_ = s;
        return s;
    }

    @Override
    public ByteString getLanguageCodeBytes() {
        Object ref = this.languageCode_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.languageCode_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<AdScheduleInfo> getAdSchedulesList() {
        return this.adSchedules_;
    }

    @Override
    public List<? extends AdScheduleInfoOrBuilder> getAdSchedulesOrBuilderList() {
        return this.adSchedules_;
    }

    @Override
    public int getAdSchedulesCount() {
        return this.adSchedules_.size();
    }

    @Override
    public AdScheduleInfo getAdSchedules(int index) {
        return this.adSchedules_.get(index);
    }

    @Override
    public AdScheduleInfoOrBuilder getAdSchedulesOrBuilder(int index) {
        return this.adSchedules_.get(index);
    }

    @Override
    public List<KeywordThemeInfo> getKeywordThemesList() {
        return this.keywordThemes_;
    }

    @Override
    public List<? extends KeywordThemeInfoOrBuilder> getKeywordThemesOrBuilderList() {
        return this.keywordThemes_;
    }

    @Override
    public int getKeywordThemesCount() {
        return this.keywordThemes_.size();
    }

    @Override
    public KeywordThemeInfo getKeywordThemes(int index) {
        return this.keywordThemes_.get(index);
    }

    @Override
    public KeywordThemeInfoOrBuilder getKeywordThemesOrBuilder(int index) {
        return this.keywordThemes_.get(index);
    }

    @Override
    public boolean hasBusinessContext() {
        return this.businessSettingCase_ == 8;
    }

    @Override
    public BusinessContext getBusinessContext() {
        if (this.businessSettingCase_ == 8) {
            return (BusinessContext)this.businessSetting_;
        }
        return BusinessContext.getDefaultInstance();
    }

    @Override
    public BusinessContextOrBuilder getBusinessContextOrBuilder() {
        if (this.businessSettingCase_ == 8) {
            return (BusinessContext)this.businessSetting_;
        }
        return BusinessContext.getDefaultInstance();
    }

    @Override
    public boolean hasBusinessProfileLocation() {
        return this.businessSettingCase_ == 9;
    }

    @Override
    public String getBusinessProfileLocation() {
        Object ref = "";
        if (this.businessSettingCase_ == 9) {
            ref = this.businessSetting_;
        }
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        if (this.businessSettingCase_ == 9) {
            this.businessSetting_ = s;
        }
        return s;
    }

    @Override
    public ByteString getBusinessProfileLocationBytes() {
        Object ref = "";
        if (this.businessSettingCase_ == 9) {
            ref = this.businessSetting_;
        }
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            if (this.businessSettingCase_ == 9) {
                this.businessSetting_ = b;
            }
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasLocationList() {
        return this.geoTargetCase_ == 4;
    }

    @Override
    public LocationList getLocationList() {
        if (this.geoTargetCase_ == 4) {
            return (LocationList)this.geoTarget_;
        }
        return LocationList.getDefaultInstance();
    }

    @Override
    public LocationListOrBuilder getLocationListOrBuilder() {
        if (this.geoTargetCase_ == 4) {
            return (LocationList)this.geoTarget_;
        }
        return LocationList.getDefaultInstance();
    }

    @Override
    public boolean hasProximity() {
        return this.geoTargetCase_ == 5;
    }

    @Override
    public ProximityInfo getProximity() {
        if (this.geoTargetCase_ == 5) {
            return (ProximityInfo)this.geoTarget_;
        }
        return ProximityInfo.getDefaultInstance();
    }

    @Override
    public ProximityInfoOrBuilder getProximityOrBuilder() {
        if (this.geoTargetCase_ == 5) {
            return (ProximityInfo)this.geoTarget_;
        }
        return ProximityInfo.getDefaultInstance();
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.finalUrl_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.finalUrl_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.languageCode_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.languageCode_);
        }
        if (this.geoTargetCase_ == 4) {
            output.writeMessage(4, (MessageLite)((LocationList)this.geoTarget_));
        }
        if (this.geoTargetCase_ == 5) {
            output.writeMessage(5, (MessageLite)((ProximityInfo)this.geoTarget_));
        }
        for (i = 0; i < this.adSchedules_.size(); ++i) {
            output.writeMessage(6, (MessageLite)this.adSchedules_.get(i));
        }
        for (i = 0; i < this.keywordThemes_.size(); ++i) {
            output.writeMessage(7, (MessageLite)this.keywordThemes_.get(i));
        }
        if (this.businessSettingCase_ == 8) {
            output.writeMessage(8, (MessageLite)((BusinessContext)this.businessSetting_));
        }
        if (this.businessSettingCase_ == 9) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.businessSetting_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.finalUrl_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.finalUrl_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.languageCode_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.languageCode_);
        }
        if (this.geoTargetCase_ == 4) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((LocationList)this.geoTarget_));
        }
        if (this.geoTargetCase_ == 5) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((ProximityInfo)this.geoTarget_));
        }
        for (i = 0; i < this.adSchedules_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((MessageLite)this.adSchedules_.get(i)));
        }
        for (i = 0; i < this.keywordThemes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)((MessageLite)this.keywordThemes_.get(i)));
        }
        if (this.businessSettingCase_ == 8) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)((BusinessContext)this.businessSetting_));
        }
        if (this.businessSettingCase_ == 9) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.businessSetting_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SmartCampaignSuggestionInfo)) {
            return super.equals(obj);
        }
        SmartCampaignSuggestionInfo other = (SmartCampaignSuggestionInfo)obj;
        if (!this.getFinalUrl().equals(other.getFinalUrl())) {
            return false;
        }
        if (!this.getLanguageCode().equals(other.getLanguageCode())) {
            return false;
        }
        if (!this.getAdSchedulesList().equals(other.getAdSchedulesList())) {
            return false;
        }
        if (!this.getKeywordThemesList().equals(other.getKeywordThemesList())) {
            return false;
        }
        if (!this.getBusinessSettingCase().equals((Object)other.getBusinessSettingCase())) {
            return false;
        }
        switch (this.businessSettingCase_) {
            case 8: {
                if (this.getBusinessContext().equals(other.getBusinessContext())) break;
                return false;
            }
            case 9: {
                if (this.getBusinessProfileLocation().equals(other.getBusinessProfileLocation())) break;
                return false;
            }
        }
        if (!this.getGeoTargetCase().equals((Object)other.getGeoTargetCase())) {
            return false;
        }
        switch (this.geoTargetCase_) {
            case 4: {
                if (this.getLocationList().equals(other.getLocationList())) break;
                return false;
            }
            case 5: {
                if (this.getProximity().equals(other.getProximity())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + SmartCampaignSuggestionInfo.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getFinalUrl().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getLanguageCode().hashCode();
        if (this.getAdSchedulesCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getAdSchedulesList().hashCode();
        }
        if (this.getKeywordThemesCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getKeywordThemesList().hashCode();
        }
        switch (this.businessSettingCase_) {
            case 8: {
                hash = 37 * hash + 8;
                hash = 53 * hash + this.getBusinessContext().hashCode();
                break;
            }
            case 9: {
                hash = 37 * hash + 9;
                hash = 53 * hash + this.getBusinessProfileLocation().hashCode();
                break;
            }
        }
        switch (this.geoTargetCase_) {
            case 4: {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getLocationList().hashCode();
                break;
            }
            case 5: {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getProximity().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static SmartCampaignSuggestionInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (SmartCampaignSuggestionInfo)PARSER.parseFrom(data);
    }

    public static SmartCampaignSuggestionInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SmartCampaignSuggestionInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SmartCampaignSuggestionInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (SmartCampaignSuggestionInfo)PARSER.parseFrom(data);
    }

    public static SmartCampaignSuggestionInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SmartCampaignSuggestionInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SmartCampaignSuggestionInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (SmartCampaignSuggestionInfo)PARSER.parseFrom(data);
    }

    public static SmartCampaignSuggestionInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SmartCampaignSuggestionInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SmartCampaignSuggestionInfo parseFrom(InputStream input) throws IOException {
        return (SmartCampaignSuggestionInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static SmartCampaignSuggestionInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SmartCampaignSuggestionInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static SmartCampaignSuggestionInfo parseDelimitedFrom(InputStream input) throws IOException {
        return (SmartCampaignSuggestionInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static SmartCampaignSuggestionInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SmartCampaignSuggestionInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static SmartCampaignSuggestionInfo parseFrom(CodedInputStream input) throws IOException {
        return (SmartCampaignSuggestionInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static SmartCampaignSuggestionInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SmartCampaignSuggestionInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return SmartCampaignSuggestionInfo.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SmartCampaignSuggestionInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static SmartCampaignSuggestionInfo getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<SmartCampaignSuggestionInfo> parser() {
        return PARSER;
    }

    public Parser<SmartCampaignSuggestionInfo> getParserForType() {
        return PARSER;
    }

    public SmartCampaignSuggestionInfo getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements SmartCampaignSuggestionInfoOrBuilder {
        private int businessSettingCase_ = 0;
        private Object businessSetting_;
        private int geoTargetCase_ = 0;
        private Object geoTarget_;
        private int bitField0_;
        private Object finalUrl_ = "";
        private Object languageCode_ = "";
        private List<AdScheduleInfo> adSchedules_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AdScheduleInfo, AdScheduleInfo.Builder, AdScheduleInfoOrBuilder> adSchedulesBuilder_;
        private List<KeywordThemeInfo> keywordThemes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<KeywordThemeInfo, KeywordThemeInfo.Builder, KeywordThemeInfoOrBuilder> keywordThemesBuilder_;
        private SingleFieldBuilderV3<BusinessContext, BusinessContext.Builder, BusinessContextOrBuilder> businessContextBuilder_;
        private SingleFieldBuilderV3<LocationList, LocationList.Builder, LocationListOrBuilder> locationListBuilder_;
        private SingleFieldBuilderV3<ProximityInfo, ProximityInfo.Builder, ProximityInfoOrBuilder> proximityBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(SmartCampaignSuggestionInfo.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.finalUrl_ = "";
            this.languageCode_ = "";
            if (this.adSchedulesBuilder_ == null) {
                this.adSchedules_ = Collections.emptyList();
            } else {
                this.adSchedules_ = null;
                this.adSchedulesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            if (this.keywordThemesBuilder_ == null) {
                this.keywordThemes_ = Collections.emptyList();
            } else {
                this.keywordThemes_ = null;
                this.keywordThemesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFF7;
            if (this.businessContextBuilder_ != null) {
                this.businessContextBuilder_.clear();
            }
            if (this.locationListBuilder_ != null) {
                this.locationListBuilder_.clear();
            }
            if (this.proximityBuilder_ != null) {
                this.proximityBuilder_.clear();
            }
            this.businessSettingCase_ = 0;
            this.businessSetting_ = null;
            this.geoTargetCase_ = 0;
            this.geoTarget_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_descriptor;
        }

        public SmartCampaignSuggestionInfo getDefaultInstanceForType() {
            return SmartCampaignSuggestionInfo.getDefaultInstance();
        }

        public SmartCampaignSuggestionInfo build() {
            SmartCampaignSuggestionInfo result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public SmartCampaignSuggestionInfo buildPartial() {
            SmartCampaignSuggestionInfo result = new SmartCampaignSuggestionInfo(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.buildPartialOneofs(result);
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(SmartCampaignSuggestionInfo result) {
            if (this.adSchedulesBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.adSchedules_ = Collections.unmodifiableList(this.adSchedules_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.adSchedules_ = this.adSchedules_;
            } else {
                result.adSchedules_ = this.adSchedulesBuilder_.build();
            }
            if (this.keywordThemesBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.keywordThemes_ = Collections.unmodifiableList(this.keywordThemes_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result.keywordThemes_ = this.keywordThemes_;
            } else {
                result.keywordThemes_ = this.keywordThemesBuilder_.build();
            }
        }

        private void buildPartial0(SmartCampaignSuggestionInfo result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.finalUrl_ = this.finalUrl_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.languageCode_ = this.languageCode_;
            }
        }

        private void buildPartialOneofs(SmartCampaignSuggestionInfo result) {
            result.businessSettingCase_ = this.businessSettingCase_;
            result.businessSetting_ = this.businessSetting_;
            if (this.businessSettingCase_ == 8 && this.businessContextBuilder_ != null) {
                result.businessSetting_ = this.businessContextBuilder_.build();
            }
            result.geoTargetCase_ = this.geoTargetCase_;
            result.geoTarget_ = this.geoTarget_;
            if (this.geoTargetCase_ == 4 && this.locationListBuilder_ != null) {
                result.geoTarget_ = this.locationListBuilder_.build();
            }
            if (this.geoTargetCase_ == 5 && this.proximityBuilder_ != null) {
                result.geoTarget_ = this.proximityBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof SmartCampaignSuggestionInfo) {
                return this.mergeFrom((SmartCampaignSuggestionInfo)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(SmartCampaignSuggestionInfo other) {
            if (other == SmartCampaignSuggestionInfo.getDefaultInstance()) {
                return this;
            }
            if (!other.getFinalUrl().isEmpty()) {
                this.finalUrl_ = other.finalUrl_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getLanguageCode().isEmpty()) {
                this.languageCode_ = other.languageCode_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (this.adSchedulesBuilder_ == null) {
                if (!other.adSchedules_.isEmpty()) {
                    if (this.adSchedules_.isEmpty()) {
                        this.adSchedules_ = other.adSchedules_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureAdSchedulesIsMutable();
                        this.adSchedules_.addAll(other.adSchedules_);
                    }
                    this.onChanged();
                }
            } else if (!other.adSchedules_.isEmpty()) {
                if (this.adSchedulesBuilder_.isEmpty()) {
                    this.adSchedulesBuilder_.dispose();
                    this.adSchedulesBuilder_ = null;
                    this.adSchedules_ = other.adSchedules_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.adSchedulesBuilder_ = alwaysUseFieldBuilders ? this.getAdSchedulesFieldBuilder() : null;
                } else {
                    this.adSchedulesBuilder_.addAllMessages((Iterable)other.adSchedules_);
                }
            }
            if (this.keywordThemesBuilder_ == null) {
                if (!other.keywordThemes_.isEmpty()) {
                    if (this.keywordThemes_.isEmpty()) {
                        this.keywordThemes_ = other.keywordThemes_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensureKeywordThemesIsMutable();
                        this.keywordThemes_.addAll(other.keywordThemes_);
                    }
                    this.onChanged();
                }
            } else if (!other.keywordThemes_.isEmpty()) {
                if (this.keywordThemesBuilder_.isEmpty()) {
                    this.keywordThemesBuilder_.dispose();
                    this.keywordThemesBuilder_ = null;
                    this.keywordThemes_ = other.keywordThemes_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.keywordThemesBuilder_ = alwaysUseFieldBuilders ? this.getKeywordThemesFieldBuilder() : null;
                } else {
                    this.keywordThemesBuilder_.addAllMessages((Iterable)other.keywordThemes_);
                }
            }
            switch (other.getBusinessSettingCase()) {
                case BUSINESS_CONTEXT: {
                    this.mergeBusinessContext(other.getBusinessContext());
                    break;
                }
                case BUSINESS_PROFILE_LOCATION: {
                    this.businessSettingCase_ = 9;
                    this.businessSetting_ = other.businessSetting_;
                    this.onChanged();
                    break;
                }
            }
            switch (other.getGeoTargetCase()) {
                case LOCATION_LIST: {
                    this.mergeLocationList(other.getLocationList());
                    break;
                }
                case PROXIMITY: {
                    this.mergeProximity(other.getProximity());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block16: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block16;
                        }
                        case 10: {
                            this.finalUrl_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block16;
                        }
                        case 26: {
                            this.languageCode_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block16;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getLocationListFieldBuilder().getBuilder(), extensionRegistry);
                            this.geoTargetCase_ = 4;
                            continue block16;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getProximityFieldBuilder().getBuilder(), extensionRegistry);
                            this.geoTargetCase_ = 5;
                            continue block16;
                        }
                        case 50: {
                            GeneratedMessageV3 m = (AdScheduleInfo)input.readMessage(AdScheduleInfo.parser(), extensionRegistry);
                            if (this.adSchedulesBuilder_ == null) {
                                this.ensureAdSchedulesIsMutable();
                                this.adSchedules_.add((AdScheduleInfo)m);
                                continue block16;
                            }
                            this.adSchedulesBuilder_.addMessage((AbstractMessage)m);
                            continue block16;
                        }
                        case 58: {
                            GeneratedMessageV3 m = (KeywordThemeInfo)input.readMessage(KeywordThemeInfo.parser(), extensionRegistry);
                            if (this.keywordThemesBuilder_ == null) {
                                this.ensureKeywordThemesIsMutable();
                                this.keywordThemes_.add((KeywordThemeInfo)m);
                                continue block16;
                            }
                            this.keywordThemesBuilder_.addMessage((AbstractMessage)m);
                            continue block16;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getBusinessContextFieldBuilder().getBuilder(), extensionRegistry);
                            this.businessSettingCase_ = 8;
                            continue block16;
                        }
                        case 74: {
                            String s = input.readStringRequireUtf8();
                            this.businessSettingCase_ = 9;
                            this.businessSetting_ = s;
                            continue block16;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public BusinessSettingCase getBusinessSettingCase() {
            return BusinessSettingCase.forNumber(this.businessSettingCase_);
        }

        public Builder clearBusinessSetting() {
            this.businessSettingCase_ = 0;
            this.businessSetting_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public GeoTargetCase getGeoTargetCase() {
            return GeoTargetCase.forNumber(this.geoTargetCase_);
        }

        public Builder clearGeoTarget() {
            this.geoTargetCase_ = 0;
            this.geoTarget_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public String getFinalUrl() {
            Object ref = this.finalUrl_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.finalUrl_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFinalUrlBytes() {
            Object ref = this.finalUrl_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.finalUrl_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFinalUrl(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.finalUrl_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearFinalUrl() {
            this.finalUrl_ = SmartCampaignSuggestionInfo.getDefaultInstance().getFinalUrl();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setFinalUrlBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SmartCampaignSuggestionInfo.checkByteStringIsUtf8((ByteString)value);
            this.finalUrl_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getLanguageCode() {
            Object ref = this.languageCode_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.languageCode_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLanguageCodeBytes() {
            Object ref = this.languageCode_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.languageCode_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLanguageCode(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.languageCode_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearLanguageCode() {
            this.languageCode_ = SmartCampaignSuggestionInfo.getDefaultInstance().getLanguageCode();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setLanguageCodeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SmartCampaignSuggestionInfo.checkByteStringIsUtf8((ByteString)value);
            this.languageCode_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        private void ensureAdSchedulesIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.adSchedules_ = new ArrayList<AdScheduleInfo>(this.adSchedules_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<AdScheduleInfo> getAdSchedulesList() {
            if (this.adSchedulesBuilder_ == null) {
                return Collections.unmodifiableList(this.adSchedules_);
            }
            return this.adSchedulesBuilder_.getMessageList();
        }

        @Override
        public int getAdSchedulesCount() {
            if (this.adSchedulesBuilder_ == null) {
                return this.adSchedules_.size();
            }
            return this.adSchedulesBuilder_.getCount();
        }

        @Override
        public AdScheduleInfo getAdSchedules(int index) {
            if (this.adSchedulesBuilder_ == null) {
                return this.adSchedules_.get(index);
            }
            return (AdScheduleInfo)this.adSchedulesBuilder_.getMessage(index);
        }

        public Builder setAdSchedules(int index, AdScheduleInfo value) {
            if (this.adSchedulesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdSchedulesIsMutable();
                this.adSchedules_.set(index, value);
                this.onChanged();
            } else {
                this.adSchedulesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAdSchedules(int index, AdScheduleInfo.Builder builderForValue) {
            if (this.adSchedulesBuilder_ == null) {
                this.ensureAdSchedulesIsMutable();
                this.adSchedules_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.adSchedulesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdSchedules(AdScheduleInfo value) {
            if (this.adSchedulesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdSchedulesIsMutable();
                this.adSchedules_.add(value);
                this.onChanged();
            } else {
                this.adSchedulesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdSchedules(int index, AdScheduleInfo value) {
            if (this.adSchedulesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdSchedulesIsMutable();
                this.adSchedules_.add(index, value);
                this.onChanged();
            } else {
                this.adSchedulesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdSchedules(AdScheduleInfo.Builder builderForValue) {
            if (this.adSchedulesBuilder_ == null) {
                this.ensureAdSchedulesIsMutable();
                this.adSchedules_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.adSchedulesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdSchedules(int index, AdScheduleInfo.Builder builderForValue) {
            if (this.adSchedulesBuilder_ == null) {
                this.ensureAdSchedulesIsMutable();
                this.adSchedules_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.adSchedulesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAdSchedules(Iterable<? extends AdScheduleInfo> values) {
            if (this.adSchedulesBuilder_ == null) {
                this.ensureAdSchedulesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.adSchedules_);
                this.onChanged();
            } else {
                this.adSchedulesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAdSchedules() {
            if (this.adSchedulesBuilder_ == null) {
                this.adSchedules_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.adSchedulesBuilder_.clear();
            }
            return this;
        }

        public Builder removeAdSchedules(int index) {
            if (this.adSchedulesBuilder_ == null) {
                this.ensureAdSchedulesIsMutable();
                this.adSchedules_.remove(index);
                this.onChanged();
            } else {
                this.adSchedulesBuilder_.remove(index);
            }
            return this;
        }

        public AdScheduleInfo.Builder getAdSchedulesBuilder(int index) {
            return (AdScheduleInfo.Builder)this.getAdSchedulesFieldBuilder().getBuilder(index);
        }

        @Override
        public AdScheduleInfoOrBuilder getAdSchedulesOrBuilder(int index) {
            if (this.adSchedulesBuilder_ == null) {
                return this.adSchedules_.get(index);
            }
            return (AdScheduleInfoOrBuilder)this.adSchedulesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AdScheduleInfoOrBuilder> getAdSchedulesOrBuilderList() {
            if (this.adSchedulesBuilder_ != null) {
                return this.adSchedulesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.adSchedules_);
        }

        public AdScheduleInfo.Builder addAdSchedulesBuilder() {
            return (AdScheduleInfo.Builder)this.getAdSchedulesFieldBuilder().addBuilder((AbstractMessage)AdScheduleInfo.getDefaultInstance());
        }

        public AdScheduleInfo.Builder addAdSchedulesBuilder(int index) {
            return (AdScheduleInfo.Builder)this.getAdSchedulesFieldBuilder().addBuilder(index, (AbstractMessage)AdScheduleInfo.getDefaultInstance());
        }

        public List<AdScheduleInfo.Builder> getAdSchedulesBuilderList() {
            return this.getAdSchedulesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AdScheduleInfo, AdScheduleInfo.Builder, AdScheduleInfoOrBuilder> getAdSchedulesFieldBuilder() {
            if (this.adSchedulesBuilder_ == null) {
                this.adSchedulesBuilder_ = new RepeatedFieldBuilderV3(this.adSchedules_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.adSchedules_ = null;
            }
            return this.adSchedulesBuilder_;
        }

        private void ensureKeywordThemesIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.keywordThemes_ = new ArrayList<KeywordThemeInfo>(this.keywordThemes_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<KeywordThemeInfo> getKeywordThemesList() {
            if (this.keywordThemesBuilder_ == null) {
                return Collections.unmodifiableList(this.keywordThemes_);
            }
            return this.keywordThemesBuilder_.getMessageList();
        }

        @Override
        public int getKeywordThemesCount() {
            if (this.keywordThemesBuilder_ == null) {
                return this.keywordThemes_.size();
            }
            return this.keywordThemesBuilder_.getCount();
        }

        @Override
        public KeywordThemeInfo getKeywordThemes(int index) {
            if (this.keywordThemesBuilder_ == null) {
                return this.keywordThemes_.get(index);
            }
            return (KeywordThemeInfo)this.keywordThemesBuilder_.getMessage(index);
        }

        public Builder setKeywordThemes(int index, KeywordThemeInfo value) {
            if (this.keywordThemesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureKeywordThemesIsMutable();
                this.keywordThemes_.set(index, value);
                this.onChanged();
            } else {
                this.keywordThemesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setKeywordThemes(int index, KeywordThemeInfo.Builder builderForValue) {
            if (this.keywordThemesBuilder_ == null) {
                this.ensureKeywordThemesIsMutable();
                this.keywordThemes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.keywordThemesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addKeywordThemes(KeywordThemeInfo value) {
            if (this.keywordThemesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureKeywordThemesIsMutable();
                this.keywordThemes_.add(value);
                this.onChanged();
            } else {
                this.keywordThemesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addKeywordThemes(int index, KeywordThemeInfo value) {
            if (this.keywordThemesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureKeywordThemesIsMutable();
                this.keywordThemes_.add(index, value);
                this.onChanged();
            } else {
                this.keywordThemesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addKeywordThemes(KeywordThemeInfo.Builder builderForValue) {
            if (this.keywordThemesBuilder_ == null) {
                this.ensureKeywordThemesIsMutable();
                this.keywordThemes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.keywordThemesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addKeywordThemes(int index, KeywordThemeInfo.Builder builderForValue) {
            if (this.keywordThemesBuilder_ == null) {
                this.ensureKeywordThemesIsMutable();
                this.keywordThemes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.keywordThemesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllKeywordThemes(Iterable<? extends KeywordThemeInfo> values) {
            if (this.keywordThemesBuilder_ == null) {
                this.ensureKeywordThemesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.keywordThemes_);
                this.onChanged();
            } else {
                this.keywordThemesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearKeywordThemes() {
            if (this.keywordThemesBuilder_ == null) {
                this.keywordThemes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.keywordThemesBuilder_.clear();
            }
            return this;
        }

        public Builder removeKeywordThemes(int index) {
            if (this.keywordThemesBuilder_ == null) {
                this.ensureKeywordThemesIsMutable();
                this.keywordThemes_.remove(index);
                this.onChanged();
            } else {
                this.keywordThemesBuilder_.remove(index);
            }
            return this;
        }

        public KeywordThemeInfo.Builder getKeywordThemesBuilder(int index) {
            return (KeywordThemeInfo.Builder)this.getKeywordThemesFieldBuilder().getBuilder(index);
        }

        @Override
        public KeywordThemeInfoOrBuilder getKeywordThemesOrBuilder(int index) {
            if (this.keywordThemesBuilder_ == null) {
                return this.keywordThemes_.get(index);
            }
            return (KeywordThemeInfoOrBuilder)this.keywordThemesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends KeywordThemeInfoOrBuilder> getKeywordThemesOrBuilderList() {
            if (this.keywordThemesBuilder_ != null) {
                return this.keywordThemesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.keywordThemes_);
        }

        public KeywordThemeInfo.Builder addKeywordThemesBuilder() {
            return (KeywordThemeInfo.Builder)this.getKeywordThemesFieldBuilder().addBuilder((AbstractMessage)KeywordThemeInfo.getDefaultInstance());
        }

        public KeywordThemeInfo.Builder addKeywordThemesBuilder(int index) {
            return (KeywordThemeInfo.Builder)this.getKeywordThemesFieldBuilder().addBuilder(index, (AbstractMessage)KeywordThemeInfo.getDefaultInstance());
        }

        public List<KeywordThemeInfo.Builder> getKeywordThemesBuilderList() {
            return this.getKeywordThemesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<KeywordThemeInfo, KeywordThemeInfo.Builder, KeywordThemeInfoOrBuilder> getKeywordThemesFieldBuilder() {
            if (this.keywordThemesBuilder_ == null) {
                this.keywordThemesBuilder_ = new RepeatedFieldBuilderV3(this.keywordThemes_, (this.bitField0_ & 8) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.keywordThemes_ = null;
            }
            return this.keywordThemesBuilder_;
        }

        @Override
        public boolean hasBusinessContext() {
            return this.businessSettingCase_ == 8;
        }

        @Override
        public BusinessContext getBusinessContext() {
            if (this.businessContextBuilder_ == null) {
                if (this.businessSettingCase_ == 8) {
                    return (BusinessContext)this.businessSetting_;
                }
                return BusinessContext.getDefaultInstance();
            }
            if (this.businessSettingCase_ == 8) {
                return (BusinessContext)this.businessContextBuilder_.getMessage();
            }
            return BusinessContext.getDefaultInstance();
        }

        public Builder setBusinessContext(BusinessContext value) {
            if (this.businessContextBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.businessSetting_ = value;
                this.onChanged();
            } else {
                this.businessContextBuilder_.setMessage((AbstractMessage)value);
            }
            this.businessSettingCase_ = 8;
            return this;
        }

        public Builder setBusinessContext(BusinessContext.Builder builderForValue) {
            if (this.businessContextBuilder_ == null) {
                this.businessSetting_ = builderForValue.build();
                this.onChanged();
            } else {
                this.businessContextBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.businessSettingCase_ = 8;
            return this;
        }

        public Builder mergeBusinessContext(BusinessContext value) {
            if (this.businessContextBuilder_ == null) {
                this.businessSetting_ = this.businessSettingCase_ == 8 && this.businessSetting_ != BusinessContext.getDefaultInstance() ? BusinessContext.newBuilder((BusinessContext)this.businessSetting_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.businessSettingCase_ == 8) {
                this.businessContextBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.businessContextBuilder_.setMessage((AbstractMessage)value);
            }
            this.businessSettingCase_ = 8;
            return this;
        }

        public Builder clearBusinessContext() {
            if (this.businessContextBuilder_ == null) {
                if (this.businessSettingCase_ == 8) {
                    this.businessSettingCase_ = 0;
                    this.businessSetting_ = null;
                    this.onChanged();
                }
            } else {
                if (this.businessSettingCase_ == 8) {
                    this.businessSettingCase_ = 0;
                    this.businessSetting_ = null;
                }
                this.businessContextBuilder_.clear();
            }
            return this;
        }

        public BusinessContext.Builder getBusinessContextBuilder() {
            return (BusinessContext.Builder)this.getBusinessContextFieldBuilder().getBuilder();
        }

        @Override
        public BusinessContextOrBuilder getBusinessContextOrBuilder() {
            if (this.businessSettingCase_ == 8 && this.businessContextBuilder_ != null) {
                return (BusinessContextOrBuilder)this.businessContextBuilder_.getMessageOrBuilder();
            }
            if (this.businessSettingCase_ == 8) {
                return (BusinessContext)this.businessSetting_;
            }
            return BusinessContext.getDefaultInstance();
        }

        private SingleFieldBuilderV3<BusinessContext, BusinessContext.Builder, BusinessContextOrBuilder> getBusinessContextFieldBuilder() {
            if (this.businessContextBuilder_ == null) {
                if (this.businessSettingCase_ != 8) {
                    this.businessSetting_ = BusinessContext.getDefaultInstance();
                }
                this.businessContextBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((BusinessContext)this.businessSetting_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.businessSetting_ = null;
            }
            this.businessSettingCase_ = 8;
            this.onChanged();
            return this.businessContextBuilder_;
        }

        @Override
        public boolean hasBusinessProfileLocation() {
            return this.businessSettingCase_ == 9;
        }

        @Override
        public String getBusinessProfileLocation() {
            Object ref = "";
            if (this.businessSettingCase_ == 9) {
                ref = this.businessSetting_;
            }
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                if (this.businessSettingCase_ == 9) {
                    this.businessSetting_ = s;
                }
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getBusinessProfileLocationBytes() {
            Object ref = "";
            if (this.businessSettingCase_ == 9) {
                ref = this.businessSetting_;
            }
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                if (this.businessSettingCase_ == 9) {
                    this.businessSetting_ = b;
                }
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setBusinessProfileLocation(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.businessSettingCase_ = 9;
            this.businessSetting_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearBusinessProfileLocation() {
            if (this.businessSettingCase_ == 9) {
                this.businessSettingCase_ = 0;
                this.businessSetting_ = null;
                this.onChanged();
            }
            return this;
        }

        public Builder setBusinessProfileLocationBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SmartCampaignSuggestionInfo.checkByteStringIsUtf8((ByteString)value);
            this.businessSettingCase_ = 9;
            this.businessSetting_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLocationList() {
            return this.geoTargetCase_ == 4;
        }

        @Override
        public LocationList getLocationList() {
            if (this.locationListBuilder_ == null) {
                if (this.geoTargetCase_ == 4) {
                    return (LocationList)this.geoTarget_;
                }
                return LocationList.getDefaultInstance();
            }
            if (this.geoTargetCase_ == 4) {
                return (LocationList)this.locationListBuilder_.getMessage();
            }
            return LocationList.getDefaultInstance();
        }

        public Builder setLocationList(LocationList value) {
            if (this.locationListBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.geoTarget_ = value;
                this.onChanged();
            } else {
                this.locationListBuilder_.setMessage((AbstractMessage)value);
            }
            this.geoTargetCase_ = 4;
            return this;
        }

        public Builder setLocationList(LocationList.Builder builderForValue) {
            if (this.locationListBuilder_ == null) {
                this.geoTarget_ = builderForValue.build();
                this.onChanged();
            } else {
                this.locationListBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.geoTargetCase_ = 4;
            return this;
        }

        public Builder mergeLocationList(LocationList value) {
            if (this.locationListBuilder_ == null) {
                this.geoTarget_ = this.geoTargetCase_ == 4 && this.geoTarget_ != LocationList.getDefaultInstance() ? LocationList.newBuilder((LocationList)this.geoTarget_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.geoTargetCase_ == 4) {
                this.locationListBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.locationListBuilder_.setMessage((AbstractMessage)value);
            }
            this.geoTargetCase_ = 4;
            return this;
        }

        public Builder clearLocationList() {
            if (this.locationListBuilder_ == null) {
                if (this.geoTargetCase_ == 4) {
                    this.geoTargetCase_ = 0;
                    this.geoTarget_ = null;
                    this.onChanged();
                }
            } else {
                if (this.geoTargetCase_ == 4) {
                    this.geoTargetCase_ = 0;
                    this.geoTarget_ = null;
                }
                this.locationListBuilder_.clear();
            }
            return this;
        }

        public LocationList.Builder getLocationListBuilder() {
            return (LocationList.Builder)this.getLocationListFieldBuilder().getBuilder();
        }

        @Override
        public LocationListOrBuilder getLocationListOrBuilder() {
            if (this.geoTargetCase_ == 4 && this.locationListBuilder_ != null) {
                return (LocationListOrBuilder)this.locationListBuilder_.getMessageOrBuilder();
            }
            if (this.geoTargetCase_ == 4) {
                return (LocationList)this.geoTarget_;
            }
            return LocationList.getDefaultInstance();
        }

        private SingleFieldBuilderV3<LocationList, LocationList.Builder, LocationListOrBuilder> getLocationListFieldBuilder() {
            if (this.locationListBuilder_ == null) {
                if (this.geoTargetCase_ != 4) {
                    this.geoTarget_ = LocationList.getDefaultInstance();
                }
                this.locationListBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((LocationList)this.geoTarget_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.geoTarget_ = null;
            }
            this.geoTargetCase_ = 4;
            this.onChanged();
            return this.locationListBuilder_;
        }

        @Override
        public boolean hasProximity() {
            return this.geoTargetCase_ == 5;
        }

        @Override
        public ProximityInfo getProximity() {
            if (this.proximityBuilder_ == null) {
                if (this.geoTargetCase_ == 5) {
                    return (ProximityInfo)this.geoTarget_;
                }
                return ProximityInfo.getDefaultInstance();
            }
            if (this.geoTargetCase_ == 5) {
                return (ProximityInfo)this.proximityBuilder_.getMessage();
            }
            return ProximityInfo.getDefaultInstance();
        }

        public Builder setProximity(ProximityInfo value) {
            if (this.proximityBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.geoTarget_ = value;
                this.onChanged();
            } else {
                this.proximityBuilder_.setMessage((AbstractMessage)value);
            }
            this.geoTargetCase_ = 5;
            return this;
        }

        public Builder setProximity(ProximityInfo.Builder builderForValue) {
            if (this.proximityBuilder_ == null) {
                this.geoTarget_ = builderForValue.build();
                this.onChanged();
            } else {
                this.proximityBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.geoTargetCase_ = 5;
            return this;
        }

        public Builder mergeProximity(ProximityInfo value) {
            if (this.proximityBuilder_ == null) {
                this.geoTarget_ = this.geoTargetCase_ == 5 && this.geoTarget_ != ProximityInfo.getDefaultInstance() ? ProximityInfo.newBuilder((ProximityInfo)this.geoTarget_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.geoTargetCase_ == 5) {
                this.proximityBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.proximityBuilder_.setMessage((AbstractMessage)value);
            }
            this.geoTargetCase_ = 5;
            return this;
        }

        public Builder clearProximity() {
            if (this.proximityBuilder_ == null) {
                if (this.geoTargetCase_ == 5) {
                    this.geoTargetCase_ = 0;
                    this.geoTarget_ = null;
                    this.onChanged();
                }
            } else {
                if (this.geoTargetCase_ == 5) {
                    this.geoTargetCase_ = 0;
                    this.geoTarget_ = null;
                }
                this.proximityBuilder_.clear();
            }
            return this;
        }

        public ProximityInfo.Builder getProximityBuilder() {
            return (ProximityInfo.Builder)this.getProximityFieldBuilder().getBuilder();
        }

        @Override
        public ProximityInfoOrBuilder getProximityOrBuilder() {
            if (this.geoTargetCase_ == 5 && this.proximityBuilder_ != null) {
                return (ProximityInfoOrBuilder)this.proximityBuilder_.getMessageOrBuilder();
            }
            if (this.geoTargetCase_ == 5) {
                return (ProximityInfo)this.geoTarget_;
            }
            return ProximityInfo.getDefaultInstance();
        }

        private SingleFieldBuilderV3<ProximityInfo, ProximityInfo.Builder, ProximityInfoOrBuilder> getProximityFieldBuilder() {
            if (this.proximityBuilder_ == null) {
                if (this.geoTargetCase_ != 5) {
                    this.geoTarget_ = ProximityInfo.getDefaultInstance();
                }
                this.proximityBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((ProximityInfo)this.geoTarget_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.geoTarget_ = null;
            }
            this.geoTargetCase_ = 5;
            this.onChanged();
            return this.proximityBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum BusinessSettingCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        BUSINESS_CONTEXT(8),
        BUSINESS_PROFILE_LOCATION(9),
        BUSINESSSETTING_NOT_SET(0);

        private final int value;

        private BusinessSettingCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static BusinessSettingCase valueOf(int value) {
            return BusinessSettingCase.forNumber(value);
        }

        public static BusinessSettingCase forNumber(int value) {
            switch (value) {
                case 8: {
                    return BUSINESS_CONTEXT;
                }
                case 9: {
                    return BUSINESS_PROFILE_LOCATION;
                }
                case 0: {
                    return BUSINESSSETTING_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }

    public static enum GeoTargetCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        LOCATION_LIST(4),
        PROXIMITY(5),
        GEOTARGET_NOT_SET(0);

        private final int value;

        private GeoTargetCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static GeoTargetCase valueOf(int value) {
            return GeoTargetCase.forNumber(value);
        }

        public static GeoTargetCase forNumber(int value) {
            switch (value) {
                case 4: {
                    return LOCATION_LIST;
                }
                case 5: {
                    return PROXIMITY;
                }
                case 0: {
                    return GEOTARGET_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }

    public static final class BusinessContext
    extends GeneratedMessageV3
    implements BusinessContextOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int BUSINESS_NAME_FIELD_NUMBER = 1;
        private volatile Object businessName_ = "";
        private byte memoizedIsInitialized = (byte)-1;
        private static final BusinessContext DEFAULT_INSTANCE = new BusinessContext();
        private static final Parser<BusinessContext> PARSER = new AbstractParser<BusinessContext>(){

            public BusinessContext parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = BusinessContext.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private BusinessContext(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private BusinessContext() {
            this.businessName_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new BusinessContext();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_BusinessContext_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_BusinessContext_fieldAccessorTable.ensureFieldAccessorsInitialized(BusinessContext.class, Builder.class);
        }

        @Override
        public String getBusinessName() {
            Object ref = this.businessName_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.businessName_ = s;
            return s;
        }

        @Override
        public ByteString getBusinessNameBytes() {
            Object ref = this.businessName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.businessName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.businessName_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.businessName_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.businessName_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.businessName_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BusinessContext)) {
                return super.equals(obj);
            }
            BusinessContext other = (BusinessContext)obj;
            if (!this.getBusinessName().equals(other.getBusinessName())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + BusinessContext.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getBusinessName().hashCode();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static BusinessContext parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (BusinessContext)PARSER.parseFrom(data);
        }

        public static BusinessContext parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BusinessContext)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BusinessContext parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (BusinessContext)PARSER.parseFrom(data);
        }

        public static BusinessContext parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BusinessContext)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BusinessContext parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (BusinessContext)PARSER.parseFrom(data);
        }

        public static BusinessContext parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BusinessContext)PARSER.parseFrom(data, extensionRegistry);
        }

        public static BusinessContext parseFrom(InputStream input) throws IOException {
            return (BusinessContext)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static BusinessContext parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BusinessContext)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static BusinessContext parseDelimitedFrom(InputStream input) throws IOException {
            return (BusinessContext)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static BusinessContext parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BusinessContext)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static BusinessContext parseFrom(CodedInputStream input) throws IOException {
            return (BusinessContext)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static BusinessContext parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BusinessContext)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return BusinessContext.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(BusinessContext prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static BusinessContext getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<BusinessContext> parser() {
            return PARSER;
        }

        public Parser<BusinessContext> getParserForType() {
            return PARSER;
        }

        public BusinessContext getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements BusinessContextOrBuilder {
            private int bitField0_;
            private Object businessName_ = "";

            public static final Descriptors.Descriptor getDescriptor() {
                return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_BusinessContext_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_BusinessContext_fieldAccessorTable.ensureFieldAccessorsInitialized(BusinessContext.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.businessName_ = "";
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_BusinessContext_descriptor;
            }

            public BusinessContext getDefaultInstanceForType() {
                return BusinessContext.getDefaultInstance();
            }

            public BusinessContext build() {
                BusinessContext result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public BusinessContext buildPartial() {
                BusinessContext result = new BusinessContext(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(BusinessContext result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.businessName_ = this.businessName_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof BusinessContext) {
                    return this.mergeFrom((BusinessContext)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(BusinessContext other) {
                if (other == BusinessContext.getDefaultInstance()) {
                    return this;
                }
                if (!other.getBusinessName().isEmpty()) {
                    this.businessName_ = other.businessName_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 10: {
                                this.businessName_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getBusinessName() {
                Object ref = this.businessName_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.businessName_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getBusinessNameBytes() {
                Object ref = this.businessName_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.businessName_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setBusinessName(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.businessName_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearBusinessName() {
                this.businessName_ = BusinessContext.getDefaultInstance().getBusinessName();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setBusinessNameBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                BusinessContext.checkByteStringIsUtf8((ByteString)value);
                this.businessName_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static final class LocationList
    extends GeneratedMessageV3
    implements LocationListOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int LOCATIONS_FIELD_NUMBER = 1;
        private List<LocationInfo> locations_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final LocationList DEFAULT_INSTANCE = new LocationList();
        private static final Parser<LocationList> PARSER = new AbstractParser<LocationList>(){

            public LocationList parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = LocationList.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private LocationList(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private LocationList() {
            this.locations_ = Collections.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new LocationList();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_LocationList_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_LocationList_fieldAccessorTable.ensureFieldAccessorsInitialized(LocationList.class, Builder.class);
        }

        @Override
        public List<LocationInfo> getLocationsList() {
            return this.locations_;
        }

        @Override
        public List<? extends LocationInfoOrBuilder> getLocationsOrBuilderList() {
            return this.locations_;
        }

        @Override
        public int getLocationsCount() {
            return this.locations_.size();
        }

        @Override
        public LocationInfo getLocations(int index) {
            return this.locations_.get(index);
        }

        @Override
        public LocationInfoOrBuilder getLocationsOrBuilder(int index) {
            return this.locations_.get(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            for (int i = 0; i < this.locations_.size(); ++i) {
                output.writeMessage(1, (MessageLite)this.locations_.get(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            for (int i = 0; i < this.locations_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.locations_.get(i)));
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LocationList)) {
                return super.equals(obj);
            }
            LocationList other = (LocationList)obj;
            if (!this.getLocationsList().equals(other.getLocationsList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + LocationList.getDescriptor().hashCode();
            if (this.getLocationsCount() > 0) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getLocationsList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static LocationList parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (LocationList)PARSER.parseFrom(data);
        }

        public static LocationList parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (LocationList)PARSER.parseFrom(data, extensionRegistry);
        }

        public static LocationList parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (LocationList)PARSER.parseFrom(data);
        }

        public static LocationList parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (LocationList)PARSER.parseFrom(data, extensionRegistry);
        }

        public static LocationList parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (LocationList)PARSER.parseFrom(data);
        }

        public static LocationList parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (LocationList)PARSER.parseFrom(data, extensionRegistry);
        }

        public static LocationList parseFrom(InputStream input) throws IOException {
            return (LocationList)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static LocationList parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (LocationList)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static LocationList parseDelimitedFrom(InputStream input) throws IOException {
            return (LocationList)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static LocationList parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (LocationList)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static LocationList parseFrom(CodedInputStream input) throws IOException {
            return (LocationList)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static LocationList parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (LocationList)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return LocationList.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(LocationList prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static LocationList getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<LocationList> parser() {
            return PARSER;
        }

        public Parser<LocationList> getParserForType() {
            return PARSER;
        }

        public LocationList getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements LocationListOrBuilder {
            private int bitField0_;
            private List<LocationInfo> locations_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<LocationInfo, LocationInfo.Builder, LocationInfoOrBuilder> locationsBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_LocationList_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_LocationList_fieldAccessorTable.ensureFieldAccessorsInitialized(LocationList.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                if (this.locationsBuilder_ == null) {
                    this.locations_ = Collections.emptyList();
                } else {
                    this.locations_ = null;
                    this.locationsBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFFFFE;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return SmartCampaignSuggestServiceProto.internal_static_google_ads_googleads_v20_services_SmartCampaignSuggestionInfo_LocationList_descriptor;
            }

            public LocationList getDefaultInstanceForType() {
                return LocationList.getDefaultInstance();
            }

            public LocationList build() {
                LocationList result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public LocationList buildPartial() {
                LocationList result = new LocationList(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(LocationList result) {
                if (this.locationsBuilder_ == null) {
                    if ((this.bitField0_ & 1) != 0) {
                        this.locations_ = Collections.unmodifiableList(this.locations_);
                        this.bitField0_ &= 0xFFFFFFFE;
                    }
                    result.locations_ = this.locations_;
                } else {
                    result.locations_ = this.locationsBuilder_.build();
                }
            }

            private void buildPartial0(LocationList result) {
                int from_bitField0_ = this.bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof LocationList) {
                    return this.mergeFrom((LocationList)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(LocationList other) {
                if (other == LocationList.getDefaultInstance()) {
                    return this;
                }
                if (this.locationsBuilder_ == null) {
                    if (!other.locations_.isEmpty()) {
                        if (this.locations_.isEmpty()) {
                            this.locations_ = other.locations_;
                            this.bitField0_ &= 0xFFFFFFFE;
                        } else {
                            this.ensureLocationsIsMutable();
                            this.locations_.addAll(other.locations_);
                        }
                        this.onChanged();
                    }
                } else if (!other.locations_.isEmpty()) {
                    if (this.locationsBuilder_.isEmpty()) {
                        this.locationsBuilder_.dispose();
                        this.locationsBuilder_ = null;
                        this.locations_ = other.locations_;
                        this.bitField0_ &= 0xFFFFFFFE;
                        this.locationsBuilder_ = alwaysUseFieldBuilders ? this.getLocationsFieldBuilder() : null;
                    } else {
                        this.locationsBuilder_.addAllMessages((Iterable)other.locations_);
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 10: {
                                LocationInfo m = (LocationInfo)input.readMessage(LocationInfo.parser(), extensionRegistry);
                                if (this.locationsBuilder_ == null) {
                                    this.ensureLocationsIsMutable();
                                    this.locations_.add(m);
                                    continue block9;
                                }
                                this.locationsBuilder_.addMessage((AbstractMessage)m);
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            private void ensureLocationsIsMutable() {
                if ((this.bitField0_ & 1) == 0) {
                    this.locations_ = new ArrayList<LocationInfo>(this.locations_);
                    this.bitField0_ |= 1;
                }
            }

            @Override
            public List<LocationInfo> getLocationsList() {
                if (this.locationsBuilder_ == null) {
                    return Collections.unmodifiableList(this.locations_);
                }
                return this.locationsBuilder_.getMessageList();
            }

            @Override
            public int getLocationsCount() {
                if (this.locationsBuilder_ == null) {
                    return this.locations_.size();
                }
                return this.locationsBuilder_.getCount();
            }

            @Override
            public LocationInfo getLocations(int index) {
                if (this.locationsBuilder_ == null) {
                    return this.locations_.get(index);
                }
                return (LocationInfo)this.locationsBuilder_.getMessage(index);
            }

            public Builder setLocations(int index, LocationInfo value) {
                if (this.locationsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureLocationsIsMutable();
                    this.locations_.set(index, value);
                    this.onChanged();
                } else {
                    this.locationsBuilder_.setMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder setLocations(int index, LocationInfo.Builder builderForValue) {
                if (this.locationsBuilder_ == null) {
                    this.ensureLocationsIsMutable();
                    this.locations_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.locationsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addLocations(LocationInfo value) {
                if (this.locationsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureLocationsIsMutable();
                    this.locations_.add(value);
                    this.onChanged();
                } else {
                    this.locationsBuilder_.addMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder addLocations(int index, LocationInfo value) {
                if (this.locationsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureLocationsIsMutable();
                    this.locations_.add(index, value);
                    this.onChanged();
                } else {
                    this.locationsBuilder_.addMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder addLocations(LocationInfo.Builder builderForValue) {
                if (this.locationsBuilder_ == null) {
                    this.ensureLocationsIsMutable();
                    this.locations_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.locationsBuilder_.addMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addLocations(int index, LocationInfo.Builder builderForValue) {
                if (this.locationsBuilder_ == null) {
                    this.ensureLocationsIsMutable();
                    this.locations_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.locationsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllLocations(Iterable<? extends LocationInfo> values) {
                if (this.locationsBuilder_ == null) {
                    this.ensureLocationsIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.locations_);
                    this.onChanged();
                } else {
                    this.locationsBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearLocations() {
                if (this.locationsBuilder_ == null) {
                    this.locations_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.onChanged();
                } else {
                    this.locationsBuilder_.clear();
                }
                return this;
            }

            public Builder removeLocations(int index) {
                if (this.locationsBuilder_ == null) {
                    this.ensureLocationsIsMutable();
                    this.locations_.remove(index);
                    this.onChanged();
                } else {
                    this.locationsBuilder_.remove(index);
                }
                return this;
            }

            public LocationInfo.Builder getLocationsBuilder(int index) {
                return (LocationInfo.Builder)this.getLocationsFieldBuilder().getBuilder(index);
            }

            @Override
            public LocationInfoOrBuilder getLocationsOrBuilder(int index) {
                if (this.locationsBuilder_ == null) {
                    return this.locations_.get(index);
                }
                return (LocationInfoOrBuilder)this.locationsBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends LocationInfoOrBuilder> getLocationsOrBuilderList() {
                if (this.locationsBuilder_ != null) {
                    return this.locationsBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.locations_);
            }

            public LocationInfo.Builder addLocationsBuilder() {
                return (LocationInfo.Builder)this.getLocationsFieldBuilder().addBuilder((AbstractMessage)LocationInfo.getDefaultInstance());
            }

            public LocationInfo.Builder addLocationsBuilder(int index) {
                return (LocationInfo.Builder)this.getLocationsFieldBuilder().addBuilder(index, (AbstractMessage)LocationInfo.getDefaultInstance());
            }

            public List<LocationInfo.Builder> getLocationsBuilderList() {
                return this.getLocationsFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<LocationInfo, LocationInfo.Builder, LocationInfoOrBuilder> getLocationsFieldBuilder() {
                if (this.locationsBuilder_ == null) {
                    this.locationsBuilder_ = new RepeatedFieldBuilderV3(this.locations_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.locations_ = null;
                }
                return this.locationsBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface BusinessContextOrBuilder
    extends MessageOrBuilder {
        public String getBusinessName();

        public ByteString getBusinessNameBytes();
    }

    public static interface LocationListOrBuilder
    extends MessageOrBuilder {
        public List<LocationInfo> getLocationsList();

        public LocationInfo getLocations(int var1);

        public int getLocationsCount();

        public List<? extends LocationInfoOrBuilder> getLocationsOrBuilderList();

        public LocationInfoOrBuilder getLocationsOrBuilder(int var1);
    }
}

