/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.services.stub;

import com.google.ads.googleads.v20.services.MutateAdGroupCriteriaRequest;
import com.google.ads.googleads.v20.services.MutateAdGroupCriteriaResponse;
import com.google.ads.googleads.v20.services.stub.AdGroupCriterionServiceStub;
import com.google.ads.googleads.v20.services.stub.GrpcAdGroupCriterionServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class AdGroupCriterionServiceStubSettings
extends StubSettings<AdGroupCriterionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final UnaryCallSettings<MutateAdGroupCriteriaRequest, MutateAdGroupCriteriaResponse> mutateAdGroupCriteriaSettings;

    public UnaryCallSettings<MutateAdGroupCriteriaRequest, MutateAdGroupCriteriaResponse> mutateAdGroupCriteriaSettings() {
        return this.mutateAdGroupCriteriaSettings;
    }

    public AdGroupCriterionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAdGroupCriterionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "googleads";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "googleads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AdGroupCriterionServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AdGroupCriterionServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AdGroupCriterionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.mutateAdGroupCriteriaSettings = settingsBuilder.mutateAdGroupCriteriaSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AdGroupCriterionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<MutateAdGroupCriteriaRequest, MutateAdGroupCriteriaResponse> mutateAdGroupCriteriaSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.mutateAdGroupCriteriaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.mutateAdGroupCriteriaSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AdGroupCriterionServiceStubSettings settings) {
            super((StubSettings)settings);
            this.mutateAdGroupCriteriaSettings = settings.mutateAdGroupCriteriaSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.mutateAdGroupCriteriaSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AdGroupCriterionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AdGroupCriterionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AdGroupCriterionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AdGroupCriterionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.mutateAdGroupCriteriaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<MutateAdGroupCriteriaRequest, MutateAdGroupCriteriaResponse> mutateAdGroupCriteriaSettings() {
            return this.mutateAdGroupCriteriaSettings;
        }

        public AdGroupCriterionServiceStubSettings build() throws IOException {
            return new AdGroupCriterionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(14400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(14400000L)).setTotalTimeoutDuration(Duration.ofMillis(14400000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

