/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.resources;

import com.google.ads.googleads.v20.common.PolicyTopicEntry;
import com.google.ads.googleads.v20.common.PolicyTopicEntryOrBuilder;
import com.google.ads.googleads.v20.enums.PolicyApprovalStatusEnum;
import com.google.ads.googleads.v20.enums.PolicyReviewStatusEnum;
import com.google.ads.googleads.v20.resources.AssetPolicySummaryOrBuilder;
import com.google.ads.googleads.v20.resources.AssetProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AssetPolicySummary
extends GeneratedMessageV3
implements AssetPolicySummaryOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int POLICY_TOPIC_ENTRIES_FIELD_NUMBER = 1;
    private List<PolicyTopicEntry> policyTopicEntries_;
    public static final int REVIEW_STATUS_FIELD_NUMBER = 2;
    private int reviewStatus_ = 0;
    public static final int APPROVAL_STATUS_FIELD_NUMBER = 3;
    private int approvalStatus_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final AssetPolicySummary DEFAULT_INSTANCE = new AssetPolicySummary();
    private static final Parser<AssetPolicySummary> PARSER = new AbstractParser<AssetPolicySummary>(){

        public AssetPolicySummary parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = AssetPolicySummary.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private AssetPolicySummary(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private AssetPolicySummary() {
        this.policyTopicEntries_ = Collections.emptyList();
        this.reviewStatus_ = 0;
        this.approvalStatus_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new AssetPolicySummary();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AssetProto.internal_static_google_ads_googleads_v20_resources_AssetPolicySummary_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AssetProto.internal_static_google_ads_googleads_v20_resources_AssetPolicySummary_fieldAccessorTable.ensureFieldAccessorsInitialized(AssetPolicySummary.class, Builder.class);
    }

    @Override
    public List<PolicyTopicEntry> getPolicyTopicEntriesList() {
        return this.policyTopicEntries_;
    }

    @Override
    public List<? extends PolicyTopicEntryOrBuilder> getPolicyTopicEntriesOrBuilderList() {
        return this.policyTopicEntries_;
    }

    @Override
    public int getPolicyTopicEntriesCount() {
        return this.policyTopicEntries_.size();
    }

    @Override
    public PolicyTopicEntry getPolicyTopicEntries(int index) {
        return this.policyTopicEntries_.get(index);
    }

    @Override
    public PolicyTopicEntryOrBuilder getPolicyTopicEntriesOrBuilder(int index) {
        return this.policyTopicEntries_.get(index);
    }

    @Override
    public int getReviewStatusValue() {
        return this.reviewStatus_;
    }

    @Override
    public PolicyReviewStatusEnum.PolicyReviewStatus getReviewStatus() {
        PolicyReviewStatusEnum.PolicyReviewStatus result = PolicyReviewStatusEnum.PolicyReviewStatus.forNumber(this.reviewStatus_);
        return result == null ? PolicyReviewStatusEnum.PolicyReviewStatus.UNRECOGNIZED : result;
    }

    @Override
    public int getApprovalStatusValue() {
        return this.approvalStatus_;
    }

    @Override
    public PolicyApprovalStatusEnum.PolicyApprovalStatus getApprovalStatus() {
        PolicyApprovalStatusEnum.PolicyApprovalStatus result = PolicyApprovalStatusEnum.PolicyApprovalStatus.forNumber(this.approvalStatus_);
        return result == null ? PolicyApprovalStatusEnum.PolicyApprovalStatus.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.policyTopicEntries_.size(); ++i) {
            output.writeMessage(1, (MessageLite)this.policyTopicEntries_.get(i));
        }
        if (this.reviewStatus_ != PolicyReviewStatusEnum.PolicyReviewStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.reviewStatus_);
        }
        if (this.approvalStatus_ != PolicyApprovalStatusEnum.PolicyApprovalStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.approvalStatus_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (int i = 0; i < this.policyTopicEntries_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.policyTopicEntries_.get(i)));
        }
        if (this.reviewStatus_ != PolicyReviewStatusEnum.PolicyReviewStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.reviewStatus_);
        }
        if (this.approvalStatus_ != PolicyApprovalStatusEnum.PolicyApprovalStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.approvalStatus_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AssetPolicySummary)) {
            return super.equals(obj);
        }
        AssetPolicySummary other = (AssetPolicySummary)obj;
        if (!this.getPolicyTopicEntriesList().equals(other.getPolicyTopicEntriesList())) {
            return false;
        }
        if (this.reviewStatus_ != other.reviewStatus_) {
            return false;
        }
        if (this.approvalStatus_ != other.approvalStatus_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + AssetPolicySummary.getDescriptor().hashCode();
        if (this.getPolicyTopicEntriesCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getPolicyTopicEntriesList().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.reviewStatus_;
        hash = 37 * hash + 3;
        hash = 53 * hash + this.approvalStatus_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static AssetPolicySummary parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (AssetPolicySummary)PARSER.parseFrom(data);
    }

    public static AssetPolicySummary parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AssetPolicySummary)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AssetPolicySummary parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (AssetPolicySummary)PARSER.parseFrom(data);
    }

    public static AssetPolicySummary parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AssetPolicySummary)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AssetPolicySummary parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (AssetPolicySummary)PARSER.parseFrom(data);
    }

    public static AssetPolicySummary parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AssetPolicySummary)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AssetPolicySummary parseFrom(InputStream input) throws IOException {
        return (AssetPolicySummary)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static AssetPolicySummary parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AssetPolicySummary)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AssetPolicySummary parseDelimitedFrom(InputStream input) throws IOException {
        return (AssetPolicySummary)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static AssetPolicySummary parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AssetPolicySummary)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AssetPolicySummary parseFrom(CodedInputStream input) throws IOException {
        return (AssetPolicySummary)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static AssetPolicySummary parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AssetPolicySummary)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return AssetPolicySummary.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AssetPolicySummary prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static AssetPolicySummary getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<AssetPolicySummary> parser() {
        return PARSER;
    }

    public Parser<AssetPolicySummary> getParserForType() {
        return PARSER;
    }

    public AssetPolicySummary getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AssetPolicySummaryOrBuilder {
        private int bitField0_;
        private List<PolicyTopicEntry> policyTopicEntries_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<PolicyTopicEntry, PolicyTopicEntry.Builder, PolicyTopicEntryOrBuilder> policyTopicEntriesBuilder_;
        private int reviewStatus_ = 0;
        private int approvalStatus_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return AssetProto.internal_static_google_ads_googleads_v20_resources_AssetPolicySummary_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AssetProto.internal_static_google_ads_googleads_v20_resources_AssetPolicySummary_fieldAccessorTable.ensureFieldAccessorsInitialized(AssetPolicySummary.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            if (this.policyTopicEntriesBuilder_ == null) {
                this.policyTopicEntries_ = Collections.emptyList();
            } else {
                this.policyTopicEntries_ = null;
                this.policyTopicEntriesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFE;
            this.reviewStatus_ = 0;
            this.approvalStatus_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AssetProto.internal_static_google_ads_googleads_v20_resources_AssetPolicySummary_descriptor;
        }

        public AssetPolicySummary getDefaultInstanceForType() {
            return AssetPolicySummary.getDefaultInstance();
        }

        public AssetPolicySummary build() {
            AssetPolicySummary result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public AssetPolicySummary buildPartial() {
            AssetPolicySummary result = new AssetPolicySummary(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(AssetPolicySummary result) {
            if (this.policyTopicEntriesBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.policyTopicEntries_ = Collections.unmodifiableList(this.policyTopicEntries_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.policyTopicEntries_ = this.policyTopicEntries_;
            } else {
                result.policyTopicEntries_ = this.policyTopicEntriesBuilder_.build();
            }
        }

        private void buildPartial0(AssetPolicySummary result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 2) != 0) {
                result.reviewStatus_ = this.reviewStatus_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.approvalStatus_ = this.approvalStatus_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof AssetPolicySummary) {
                return this.mergeFrom((AssetPolicySummary)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(AssetPolicySummary other) {
            if (other == AssetPolicySummary.getDefaultInstance()) {
                return this;
            }
            if (this.policyTopicEntriesBuilder_ == null) {
                if (!other.policyTopicEntries_.isEmpty()) {
                    if (this.policyTopicEntries_.isEmpty()) {
                        this.policyTopicEntries_ = other.policyTopicEntries_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensurePolicyTopicEntriesIsMutable();
                        this.policyTopicEntries_.addAll(other.policyTopicEntries_);
                    }
                    this.onChanged();
                }
            } else if (!other.policyTopicEntries_.isEmpty()) {
                if (this.policyTopicEntriesBuilder_.isEmpty()) {
                    this.policyTopicEntriesBuilder_.dispose();
                    this.policyTopicEntriesBuilder_ = null;
                    this.policyTopicEntries_ = other.policyTopicEntries_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.policyTopicEntriesBuilder_ = alwaysUseFieldBuilders ? this.getPolicyTopicEntriesFieldBuilder() : null;
                } else {
                    this.policyTopicEntriesBuilder_.addAllMessages((Iterable)other.policyTopicEntries_);
                }
            }
            if (other.reviewStatus_ != 0) {
                this.setReviewStatusValue(other.getReviewStatusValue());
            }
            if (other.approvalStatus_ != 0) {
                this.setApprovalStatusValue(other.getApprovalStatusValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 10: {
                            PolicyTopicEntry m = (PolicyTopicEntry)input.readMessage(PolicyTopicEntry.parser(), extensionRegistry);
                            if (this.policyTopicEntriesBuilder_ == null) {
                                this.ensurePolicyTopicEntriesIsMutable();
                                this.policyTopicEntries_.add(m);
                                continue block11;
                            }
                            this.policyTopicEntriesBuilder_.addMessage((AbstractMessage)m);
                            continue block11;
                        }
                        case 16: {
                            this.reviewStatus_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block11;
                        }
                        case 24: {
                            this.approvalStatus_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block11;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        private void ensurePolicyTopicEntriesIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.policyTopicEntries_ = new ArrayList<PolicyTopicEntry>(this.policyTopicEntries_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<PolicyTopicEntry> getPolicyTopicEntriesList() {
            if (this.policyTopicEntriesBuilder_ == null) {
                return Collections.unmodifiableList(this.policyTopicEntries_);
            }
            return this.policyTopicEntriesBuilder_.getMessageList();
        }

        @Override
        public int getPolicyTopicEntriesCount() {
            if (this.policyTopicEntriesBuilder_ == null) {
                return this.policyTopicEntries_.size();
            }
            return this.policyTopicEntriesBuilder_.getCount();
        }

        @Override
        public PolicyTopicEntry getPolicyTopicEntries(int index) {
            if (this.policyTopicEntriesBuilder_ == null) {
                return this.policyTopicEntries_.get(index);
            }
            return (PolicyTopicEntry)this.policyTopicEntriesBuilder_.getMessage(index);
        }

        public Builder setPolicyTopicEntries(int index, PolicyTopicEntry value) {
            if (this.policyTopicEntriesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.set(index, value);
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPolicyTopicEntries(int index, PolicyTopicEntry.Builder builderForValue) {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPolicyTopicEntries(PolicyTopicEntry value) {
            if (this.policyTopicEntriesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.add(value);
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPolicyTopicEntries(int index, PolicyTopicEntry value) {
            if (this.policyTopicEntriesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.add(index, value);
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPolicyTopicEntries(PolicyTopicEntry.Builder builderForValue) {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPolicyTopicEntries(int index, PolicyTopicEntry.Builder builderForValue) {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPolicyTopicEntries(Iterable<? extends PolicyTopicEntry> values) {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.ensurePolicyTopicEntriesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.policyTopicEntries_);
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPolicyTopicEntries() {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.policyTopicEntries_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.clear();
            }
            return this;
        }

        public Builder removePolicyTopicEntries(int index) {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.ensurePolicyTopicEntriesIsMutable();
                this.policyTopicEntries_.remove(index);
                this.onChanged();
            } else {
                this.policyTopicEntriesBuilder_.remove(index);
            }
            return this;
        }

        public PolicyTopicEntry.Builder getPolicyTopicEntriesBuilder(int index) {
            return (PolicyTopicEntry.Builder)this.getPolicyTopicEntriesFieldBuilder().getBuilder(index);
        }

        @Override
        public PolicyTopicEntryOrBuilder getPolicyTopicEntriesOrBuilder(int index) {
            if (this.policyTopicEntriesBuilder_ == null) {
                return this.policyTopicEntries_.get(index);
            }
            return (PolicyTopicEntryOrBuilder)this.policyTopicEntriesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends PolicyTopicEntryOrBuilder> getPolicyTopicEntriesOrBuilderList() {
            if (this.policyTopicEntriesBuilder_ != null) {
                return this.policyTopicEntriesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.policyTopicEntries_);
        }

        public PolicyTopicEntry.Builder addPolicyTopicEntriesBuilder() {
            return (PolicyTopicEntry.Builder)this.getPolicyTopicEntriesFieldBuilder().addBuilder((AbstractMessage)PolicyTopicEntry.getDefaultInstance());
        }

        public PolicyTopicEntry.Builder addPolicyTopicEntriesBuilder(int index) {
            return (PolicyTopicEntry.Builder)this.getPolicyTopicEntriesFieldBuilder().addBuilder(index, (AbstractMessage)PolicyTopicEntry.getDefaultInstance());
        }

        public List<PolicyTopicEntry.Builder> getPolicyTopicEntriesBuilderList() {
            return this.getPolicyTopicEntriesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<PolicyTopicEntry, PolicyTopicEntry.Builder, PolicyTopicEntryOrBuilder> getPolicyTopicEntriesFieldBuilder() {
            if (this.policyTopicEntriesBuilder_ == null) {
                this.policyTopicEntriesBuilder_ = new RepeatedFieldBuilderV3(this.policyTopicEntries_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.policyTopicEntries_ = null;
            }
            return this.policyTopicEntriesBuilder_;
        }

        @Override
        public int getReviewStatusValue() {
            return this.reviewStatus_;
        }

        public Builder setReviewStatusValue(int value) {
            this.reviewStatus_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public PolicyReviewStatusEnum.PolicyReviewStatus getReviewStatus() {
            PolicyReviewStatusEnum.PolicyReviewStatus result = PolicyReviewStatusEnum.PolicyReviewStatus.forNumber(this.reviewStatus_);
            return result == null ? PolicyReviewStatusEnum.PolicyReviewStatus.UNRECOGNIZED : result;
        }

        public Builder setReviewStatus(PolicyReviewStatusEnum.PolicyReviewStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.reviewStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearReviewStatus() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.reviewStatus_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getApprovalStatusValue() {
            return this.approvalStatus_;
        }

        public Builder setApprovalStatusValue(int value) {
            this.approvalStatus_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public PolicyApprovalStatusEnum.PolicyApprovalStatus getApprovalStatus() {
            PolicyApprovalStatusEnum.PolicyApprovalStatus result = PolicyApprovalStatusEnum.PolicyApprovalStatus.forNumber(this.approvalStatus_);
            return result == null ? PolicyApprovalStatusEnum.PolicyApprovalStatus.UNRECOGNIZED : result;
        }

        public Builder setApprovalStatus(PolicyApprovalStatusEnum.PolicyApprovalStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.approvalStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearApprovalStatus() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.approvalStatus_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

