/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversionValueRuleName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CONVERSION_VALUE_RULE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/conversionValueRules/{conversion_value_rule_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String conversionValueRuleId;

    @Deprecated
    protected ConversionValueRuleName() {
        this.customerId = null;
        this.conversionValueRuleId = null;
    }

    private ConversionValueRuleName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.conversionValueRuleId = (String)Preconditions.checkNotNull((Object)builder.getConversionValueRuleId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getConversionValueRuleId() {
        return this.conversionValueRuleId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversionValueRuleName of(String customerId, String conversionValueRuleId) {
        return ConversionValueRuleName.newBuilder().setCustomerId(customerId).setConversionValueRuleId(conversionValueRuleId).build();
    }

    public static String format(String customerId, String conversionValueRuleId) {
        return ConversionValueRuleName.newBuilder().setCustomerId(customerId).setConversionValueRuleId(conversionValueRuleId).build().toString();
    }

    public static ConversionValueRuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CONVERSION_VALUE_RULE_ID.validatedMatch(formattedString, "ConversionValueRuleName.parse: formattedString not in valid format");
        return ConversionValueRuleName.of((String)matchMap.get("customer_id"), (String)matchMap.get("conversion_value_rule_id"));
    }

    public static List<ConversionValueRuleName> parseList(List<String> formattedStrings) {
        ArrayList<ConversionValueRuleName> list = new ArrayList<ConversionValueRuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversionValueRuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversionValueRuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversionValueRuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CONVERSION_VALUE_RULE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversionValueRuleName conversionValueRuleName = this;
            synchronized (conversionValueRuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.conversionValueRuleId != null) {
                        fieldMapBuilder.put((Object)"conversion_value_rule_id", (Object)this.conversionValueRuleId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CONVERSION_VALUE_RULE_ID.instantiate(new String[]{"customer_id", this.customerId, "conversion_value_rule_id", this.conversionValueRuleId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConversionValueRuleName that = (ConversionValueRuleName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.conversionValueRuleId, that.conversionValueRuleId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.conversionValueRuleId);
    }

    public static class Builder {
        private String customerId;
        private String conversionValueRuleId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getConversionValueRuleId() {
            return this.conversionValueRuleId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setConversionValueRuleId(String conversionValueRuleId) {
            this.conversionValueRuleId = conversionValueRuleId;
            return this;
        }

        private Builder(ConversionValueRuleName conversionValueRuleName) {
            this.customerId = conversionValueRuleName.customerId;
            this.conversionValueRuleId = conversionValueRuleName.conversionValueRuleId;
        }

        public ConversionValueRuleName build() {
            return new ConversionValueRuleName(this);
        }
    }
}

