/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.services;

import com.google.ads.googleads.v20.services.CampaignToForecast;
import com.google.ads.googleads.v20.services.GenerateAdGroupThemesRequest;
import com.google.ads.googleads.v20.services.GenerateAdGroupThemesResponse;
import com.google.ads.googleads.v20.services.GenerateKeywordForecastMetricsRequest;
import com.google.ads.googleads.v20.services.GenerateKeywordForecastMetricsResponse;
import com.google.ads.googleads.v20.services.GenerateKeywordHistoricalMetricsRequest;
import com.google.ads.googleads.v20.services.GenerateKeywordHistoricalMetricsResponse;
import com.google.ads.googleads.v20.services.GenerateKeywordIdeaResponse;
import com.google.ads.googleads.v20.services.GenerateKeywordIdeaResult;
import com.google.ads.googleads.v20.services.GenerateKeywordIdeasRequest;
import com.google.ads.googleads.v20.services.KeywordPlanIdeaServiceSettings;
import com.google.ads.googleads.v20.services.stub.KeywordPlanIdeaServiceStub;
import com.google.ads.googleads.v20.services.stub.KeywordPlanIdeaServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class KeywordPlanIdeaServiceClient
implements BackgroundResource {
    private final KeywordPlanIdeaServiceSettings settings;
    private final KeywordPlanIdeaServiceStub stub;

    public static final KeywordPlanIdeaServiceClient create() throws IOException {
        return KeywordPlanIdeaServiceClient.create(KeywordPlanIdeaServiceSettings.newBuilder().build());
    }

    public static final KeywordPlanIdeaServiceClient create(KeywordPlanIdeaServiceSettings settings) throws IOException {
        return new KeywordPlanIdeaServiceClient(settings);
    }

    public static final KeywordPlanIdeaServiceClient create(KeywordPlanIdeaServiceStub stub) {
        return new KeywordPlanIdeaServiceClient(stub);
    }

    protected KeywordPlanIdeaServiceClient(KeywordPlanIdeaServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((KeywordPlanIdeaServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected KeywordPlanIdeaServiceClient(KeywordPlanIdeaServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final KeywordPlanIdeaServiceSettings getSettings() {
        return this.settings;
    }

    public KeywordPlanIdeaServiceStub getStub() {
        return this.stub;
    }

    public final GenerateKeywordIdeasPagedResponse generateKeywordIdeas(GenerateKeywordIdeasRequest request) {
        return (GenerateKeywordIdeasPagedResponse)((Object)this.generateKeywordIdeasPagedCallable().call((Object)request));
    }

    public final UnaryCallable<GenerateKeywordIdeasRequest, GenerateKeywordIdeasPagedResponse> generateKeywordIdeasPagedCallable() {
        return this.stub.generateKeywordIdeasPagedCallable();
    }

    public final UnaryCallable<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse> generateKeywordIdeasCallable() {
        return this.stub.generateKeywordIdeasCallable();
    }

    public final GenerateKeywordHistoricalMetricsResponse generateKeywordHistoricalMetrics(GenerateKeywordHistoricalMetricsRequest request) {
        return (GenerateKeywordHistoricalMetricsResponse)this.generateKeywordHistoricalMetricsCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateKeywordHistoricalMetricsRequest, GenerateKeywordHistoricalMetricsResponse> generateKeywordHistoricalMetricsCallable() {
        return this.stub.generateKeywordHistoricalMetricsCallable();
    }

    public final GenerateAdGroupThemesResponse generateAdGroupThemes(String customerId, List<String> keywords, List<String> adGroups) {
        GenerateAdGroupThemesRequest request = GenerateAdGroupThemesRequest.newBuilder().setCustomerId(customerId).addAllKeywords(keywords).addAllAdGroups(adGroups).build();
        return this.generateAdGroupThemes(request);
    }

    public final GenerateAdGroupThemesResponse generateAdGroupThemes(GenerateAdGroupThemesRequest request) {
        return (GenerateAdGroupThemesResponse)this.generateAdGroupThemesCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateAdGroupThemesRequest, GenerateAdGroupThemesResponse> generateAdGroupThemesCallable() {
        return this.stub.generateAdGroupThemesCallable();
    }

    public final GenerateKeywordForecastMetricsResponse generateKeywordForecastMetrics(CampaignToForecast campaign) {
        GenerateKeywordForecastMetricsRequest request = GenerateKeywordForecastMetricsRequest.newBuilder().setCampaign(campaign).build();
        return this.generateKeywordForecastMetrics(request);
    }

    public final GenerateKeywordForecastMetricsResponse generateKeywordForecastMetrics(GenerateKeywordForecastMetricsRequest request) {
        return (GenerateKeywordForecastMetricsResponse)this.generateKeywordForecastMetricsCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateKeywordForecastMetricsRequest, GenerateKeywordForecastMetricsResponse> generateKeywordForecastMetricsCallable() {
        return this.stub.generateKeywordForecastMetricsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class GenerateKeywordIdeasPagedResponse
    extends AbstractPagedListResponse<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, GenerateKeywordIdeaResult, GenerateKeywordIdeasPage, GenerateKeywordIdeasFixedSizeCollection> {
        public static ApiFuture<GenerateKeywordIdeasPagedResponse> createAsync(PageContext<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, GenerateKeywordIdeaResult> context, ApiFuture<GenerateKeywordIdeaResponse> futureResponse) {
            ApiFuture<GenerateKeywordIdeasPage> futurePage = GenerateKeywordIdeasPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new GenerateKeywordIdeasPagedResponse((GenerateKeywordIdeasPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private GenerateKeywordIdeasPagedResponse(GenerateKeywordIdeasPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)GenerateKeywordIdeasFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class GenerateKeywordIdeasFixedSizeCollection
    extends AbstractFixedSizeCollection<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, GenerateKeywordIdeaResult, GenerateKeywordIdeasPage, GenerateKeywordIdeasFixedSizeCollection> {
        private GenerateKeywordIdeasFixedSizeCollection(List<GenerateKeywordIdeasPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static GenerateKeywordIdeasFixedSizeCollection createEmptyCollection() {
            return new GenerateKeywordIdeasFixedSizeCollection(null, 0);
        }

        protected GenerateKeywordIdeasFixedSizeCollection createCollection(List<GenerateKeywordIdeasPage> pages, int collectionSize) {
            return new GenerateKeywordIdeasFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class GenerateKeywordIdeasPage
    extends AbstractPage<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, GenerateKeywordIdeaResult, GenerateKeywordIdeasPage> {
        private GenerateKeywordIdeasPage(PageContext<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, GenerateKeywordIdeaResult> context, GenerateKeywordIdeaResponse response) {
            super(context, (Object)response);
        }

        private static GenerateKeywordIdeasPage createEmptyPage() {
            return new GenerateKeywordIdeasPage(null, null);
        }

        protected GenerateKeywordIdeasPage createPage(PageContext<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, GenerateKeywordIdeaResult> context, GenerateKeywordIdeaResponse response) {
            return new GenerateKeywordIdeasPage(context, response);
        }

        public ApiFuture<GenerateKeywordIdeasPage> createPageAsync(PageContext<GenerateKeywordIdeasRequest, GenerateKeywordIdeaResponse, GenerateKeywordIdeaResult> context, ApiFuture<GenerateKeywordIdeaResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }
}

