/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.services;

import com.google.ads.googleads.v20.enums.AdvertisingChannelTypeEnum;
import com.google.ads.googleads.v20.enums.RecommendationTypeEnum;
import com.google.ads.googleads.v20.services.ApplyRecommendationOperation;
import com.google.ads.googleads.v20.services.ApplyRecommendationRequest;
import com.google.ads.googleads.v20.services.ApplyRecommendationResponse;
import com.google.ads.googleads.v20.services.DismissRecommendationRequest;
import com.google.ads.googleads.v20.services.DismissRecommendationResponse;
import com.google.ads.googleads.v20.services.GenerateRecommendationsRequest;
import com.google.ads.googleads.v20.services.GenerateRecommendationsResponse;
import com.google.ads.googleads.v20.services.RecommendationServiceSettings;
import com.google.ads.googleads.v20.services.stub.RecommendationServiceStub;
import com.google.ads.googleads.v20.services.stub.RecommendationServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class RecommendationServiceClient
implements BackgroundResource {
    private final RecommendationServiceSettings settings;
    private final RecommendationServiceStub stub;

    public static final RecommendationServiceClient create() throws IOException {
        return RecommendationServiceClient.create(RecommendationServiceSettings.newBuilder().build());
    }

    public static final RecommendationServiceClient create(RecommendationServiceSettings settings) throws IOException {
        return new RecommendationServiceClient(settings);
    }

    public static final RecommendationServiceClient create(RecommendationServiceStub stub) {
        return new RecommendationServiceClient(stub);
    }

    protected RecommendationServiceClient(RecommendationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RecommendationServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected RecommendationServiceClient(RecommendationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RecommendationServiceSettings getSettings() {
        return this.settings;
    }

    public RecommendationServiceStub getStub() {
        return this.stub;
    }

    public final ApplyRecommendationResponse applyRecommendation(String customerId, List<ApplyRecommendationOperation> operations) {
        ApplyRecommendationRequest request = ApplyRecommendationRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.applyRecommendation(request);
    }

    public final ApplyRecommendationResponse applyRecommendation(ApplyRecommendationRequest request) {
        return (ApplyRecommendationResponse)this.applyRecommendationCallable().call((Object)request);
    }

    public final UnaryCallable<ApplyRecommendationRequest, ApplyRecommendationResponse> applyRecommendationCallable() {
        return this.stub.applyRecommendationCallable();
    }

    public final DismissRecommendationResponse dismissRecommendation(String customerId, List<DismissRecommendationRequest.DismissRecommendationOperation> operations) {
        DismissRecommendationRequest request = DismissRecommendationRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.dismissRecommendation(request);
    }

    public final DismissRecommendationResponse dismissRecommendation(DismissRecommendationRequest request) {
        return (DismissRecommendationResponse)this.dismissRecommendationCallable().call((Object)request);
    }

    public final UnaryCallable<DismissRecommendationRequest, DismissRecommendationResponse> dismissRecommendationCallable() {
        return this.stub.dismissRecommendationCallable();
    }

    public final GenerateRecommendationsResponse generateRecommendations(String customerId, List<RecommendationTypeEnum.RecommendationType> recommendationTypes, AdvertisingChannelTypeEnum.AdvertisingChannelType advertisingChannelType) {
        GenerateRecommendationsRequest request = GenerateRecommendationsRequest.newBuilder().setCustomerId(customerId).addAllRecommendationTypes(recommendationTypes).setAdvertisingChannelType(advertisingChannelType).build();
        return this.generateRecommendations(request);
    }

    public final GenerateRecommendationsResponse generateRecommendations(GenerateRecommendationsRequest request) {
        return (GenerateRecommendationsResponse)this.generateRecommendationsCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateRecommendationsRequest, GenerateRecommendationsResponse> generateRecommendationsCallable() {
        return this.stub.generateRecommendationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

