/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetSetAssetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ASSET_SET_ID_ASSET_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/assetSetAssets/{asset_set_id}~{asset_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String assetSetId;
    private final String assetId;

    @Deprecated
    protected AssetSetAssetName() {
        this.customerId = null;
        this.assetSetId = null;
        this.assetId = null;
    }

    private AssetSetAssetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.assetSetId = (String)Preconditions.checkNotNull((Object)builder.getAssetSetId());
        this.assetId = (String)Preconditions.checkNotNull((Object)builder.getAssetId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAssetSetId() {
        return this.assetSetId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetSetAssetName of(String customerId, String assetSetId, String assetId) {
        return AssetSetAssetName.newBuilder().setCustomerId(customerId).setAssetSetId(assetSetId).setAssetId(assetId).build();
    }

    public static String format(String customerId, String assetSetId, String assetId) {
        return AssetSetAssetName.newBuilder().setCustomerId(customerId).setAssetSetId(assetSetId).setAssetId(assetId).build().toString();
    }

    public static AssetSetAssetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ASSET_SET_ID_ASSET_ID.validatedMatch(formattedString, "AssetSetAssetName.parse: formattedString not in valid format");
        return AssetSetAssetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("asset_set_id"), (String)matchMap.get("asset_id"));
    }

    public static List<AssetSetAssetName> parseList(List<String> formattedStrings) {
        ArrayList<AssetSetAssetName> list = new ArrayList<AssetSetAssetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetSetAssetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetSetAssetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetSetAssetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ASSET_SET_ID_ASSET_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetSetAssetName assetSetAssetName = this;
            synchronized (assetSetAssetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.assetSetId != null) {
                        fieldMapBuilder.put((Object)"asset_set_id", (Object)this.assetSetId);
                    }
                    if (this.assetId != null) {
                        fieldMapBuilder.put((Object)"asset_id", (Object)this.assetId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ASSET_SET_ID_ASSET_ID.instantiate(new String[]{"customer_id", this.customerId, "asset_set_id", this.assetSetId, "asset_id", this.assetId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AssetSetAssetName that = (AssetSetAssetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.assetSetId, that.assetSetId) && Objects.equals(this.assetId, that.assetId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetSetId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assetId);
    }

    public static class Builder {
        private String customerId;
        private String assetSetId;
        private String assetId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAssetSetId() {
            return this.assetSetId;
        }

        public String getAssetId() {
            return this.assetId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAssetSetId(String assetSetId) {
            this.assetSetId = assetSetId;
            return this;
        }

        public Builder setAssetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        private Builder(AssetSetAssetName assetSetAssetName) {
            this.customerId = assetSetAssetName.customerId;
            this.assetSetId = assetSetAssetName.assetSetId;
            this.assetId = assetSetAssetName.assetId;
        }

        public AssetSetAssetName build() {
            return new AssetSetAssetName(this);
        }
    }
}

