/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BillingSetupName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_BILLING_SETUP_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/billingSetups/{billing_setup_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String billingSetupId;

    @Deprecated
    protected BillingSetupName() {
        this.customerId = null;
        this.billingSetupId = null;
    }

    private BillingSetupName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.billingSetupId = (String)Preconditions.checkNotNull((Object)builder.getBillingSetupId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getBillingSetupId() {
        return this.billingSetupId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BillingSetupName of(String customerId, String billingSetupId) {
        return BillingSetupName.newBuilder().setCustomerId(customerId).setBillingSetupId(billingSetupId).build();
    }

    public static String format(String customerId, String billingSetupId) {
        return BillingSetupName.newBuilder().setCustomerId(customerId).setBillingSetupId(billingSetupId).build().toString();
    }

    public static BillingSetupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_BILLING_SETUP_ID.validatedMatch(formattedString, "BillingSetupName.parse: formattedString not in valid format");
        return BillingSetupName.of((String)matchMap.get("customer_id"), (String)matchMap.get("billing_setup_id"));
    }

    public static List<BillingSetupName> parseList(List<String> formattedStrings) {
        ArrayList<BillingSetupName> list = new ArrayList<BillingSetupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BillingSetupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BillingSetupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BillingSetupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_BILLING_SETUP_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BillingSetupName billingSetupName = this;
            synchronized (billingSetupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.billingSetupId != null) {
                        fieldMapBuilder.put((Object)"billing_setup_id", (Object)this.billingSetupId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_BILLING_SETUP_ID.instantiate(new String[]{"customer_id", this.customerId, "billing_setup_id", this.billingSetupId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BillingSetupName that = (BillingSetupName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.billingSetupId, that.billingSetupId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingSetupId);
    }

    public static class Builder {
        private String customerId;
        private String billingSetupId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getBillingSetupId() {
            return this.billingSetupId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setBillingSetupId(String billingSetupId) {
            this.billingSetupId = billingSetupId;
            return this;
        }

        private Builder(BillingSetupName billingSetupName) {
            this.customerId = billingSetupName.customerId;
            this.billingSetupId = billingSetupName.billingSetupId;
        }

        public BillingSetupName build() {
            return new BillingSetupName(this);
        }
    }
}

