/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerClientLinkName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CLIENT_CUSTOMER_ID_MANAGER_LINK_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customerClientLinks/{client_customer_id}~{manager_link_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String clientCustomerId;
    private final String managerLinkId;

    @Deprecated
    protected CustomerClientLinkName() {
        this.customerId = null;
        this.clientCustomerId = null;
        this.managerLinkId = null;
    }

    private CustomerClientLinkName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.clientCustomerId = (String)Preconditions.checkNotNull((Object)builder.getClientCustomerId());
        this.managerLinkId = (String)Preconditions.checkNotNull((Object)builder.getManagerLinkId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getClientCustomerId() {
        return this.clientCustomerId;
    }

    public String getManagerLinkId() {
        return this.managerLinkId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerClientLinkName of(String customerId, String clientCustomerId, String managerLinkId) {
        return CustomerClientLinkName.newBuilder().setCustomerId(customerId).setClientCustomerId(clientCustomerId).setManagerLinkId(managerLinkId).build();
    }

    public static String format(String customerId, String clientCustomerId, String managerLinkId) {
        return CustomerClientLinkName.newBuilder().setCustomerId(customerId).setClientCustomerId(clientCustomerId).setManagerLinkId(managerLinkId).build().toString();
    }

    public static CustomerClientLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CLIENT_CUSTOMER_ID_MANAGER_LINK_ID.validatedMatch(formattedString, "CustomerClientLinkName.parse: formattedString not in valid format");
        return CustomerClientLinkName.of((String)matchMap.get("customer_id"), (String)matchMap.get("client_customer_id"), (String)matchMap.get("manager_link_id"));
    }

    public static List<CustomerClientLinkName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerClientLinkName> list = new ArrayList<CustomerClientLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerClientLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerClientLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerClientLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CLIENT_CUSTOMER_ID_MANAGER_LINK_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerClientLinkName customerClientLinkName = this;
            synchronized (customerClientLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.clientCustomerId != null) {
                        fieldMapBuilder.put((Object)"client_customer_id", (Object)this.clientCustomerId);
                    }
                    if (this.managerLinkId != null) {
                        fieldMapBuilder.put((Object)"manager_link_id", (Object)this.managerLinkId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CLIENT_CUSTOMER_ID_MANAGER_LINK_ID.instantiate(new String[]{"customer_id", this.customerId, "client_customer_id", this.clientCustomerId, "manager_link_id", this.managerLinkId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomerClientLinkName that = (CustomerClientLinkName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.clientCustomerId, that.clientCustomerId) && Objects.equals(this.managerLinkId, that.managerLinkId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.clientCustomerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.managerLinkId);
    }

    public static class Builder {
        private String customerId;
        private String clientCustomerId;
        private String managerLinkId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getClientCustomerId() {
            return this.clientCustomerId;
        }

        public String getManagerLinkId() {
            return this.managerLinkId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setClientCustomerId(String clientCustomerId) {
            this.clientCustomerId = clientCustomerId;
            return this;
        }

        public Builder setManagerLinkId(String managerLinkId) {
            this.managerLinkId = managerLinkId;
            return this;
        }

        private Builder(CustomerClientLinkName customerClientLinkName) {
            this.customerId = customerClientLinkName.customerId;
            this.clientCustomerId = customerClientLinkName.clientCustomerId;
            this.managerLinkId = customerClientLinkName.managerLinkId;
        }

        public CustomerClientLinkName build() {
            return new CustomerClientLinkName(this);
        }
    }
}

